<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

if (!defined('AMAZON_MARKETPLACE_VERSION'))
    define('AMAZON_MARKETPLACE_VERSION', '3.9.104');

require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.tools.class.php');
require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.product.class.php');

// Developement Purposes
@define('AMAZON_EXPERIMENTAL_FEATURES', in_array($_SERVER['SERVER_ADDR'], array('91.121.46.68', '127.0.0.1')));
 
class Amazon extends Module
{
    const marketplace = 'amazon';
    
    const Add = 'a';
    const Remove = 'd';
    const Update = 'u';
    
    const FormatTitle = 1;
    const FormatManufacturerTitle = 2;
    const FormatManufacturerTitleReference = 3;
    
    const FieldDescriptionShort = 'description_short';
    const FieldDescriptionLong = 'description';
    const FieldDescriptionBoth = 'both';
    
    const AccounTypeGlobal = 1;
    const AccounTypeIndividual = 2;
    
    const PaymentMethodTitle = 'Amazon MarketPlace';
    const enableExperimentalFeatures = AMAZON_EXPERIMENTAL_FEATURES;
    
    const EXEMPTION_NONE            = 0 ;
    const EXEMPTION_COMPATIBILITY   = 1 ; // For backward compatibility
    const EXEMPTION_MODEL_NUMBER    = 2 ;
    const EXEMPTION_MODEL_NAME      = 3 ;
    const EXEMPTION_MFR_PART_NUMBER = 4 ;
    const EXEMPTION_CATALOG_NUMBER  = 5 ;    
    const EXEMPTION_GENERIC         = 10 ;    
    
    const AFN = 'AFN';
    const MFN = 'MFN';
    
    const LENGTH_TITLE              = 500 ;
    const LENGTH_BULLET_POINT       = 500 ;
    const LENGTH_DESCRIPTION        = 2000 ;
    
    const LF = "\n";
    
    public $id_lang;
    private $_html = '';
    private $_postErrors = array();
    protected $strategies = false;
    private $config = array();
    private $profiles = null;
    public $name = 'amazon';
    private $_config = array(
        'AMAZON_CURRENT_VERSION' => null,
        'AMAZON_ACTIVE' => null,
        'AMAZON_EMPLOYEE' => null,
        'AMAZON_MERCHANT_ID' => null,
        'AMAZON_MARKETPLACE_ID' => null,
        'AMAZON_AWS_KEY_ID' => null,
        'AMAZON_SECRET_KEY' => null,
        'AMAZON_ADV_KEY' => null,
        'AMAZON_ADV_SECRET_KEY' => null,
        'AMAZON_CURRENCY' => null,
        'AMAZON_REGION' => null,
        // Parametres G n raux
        'AMAZON_CATEGORIES' => null,
        'AMAZON_PROFILES' => null,
        'AMAZON_PROFILES_CATEGORIES' => null,
        'AMAZON_OUT_OF_STOCK' => null,
        'AMAZON_PRICE_FORMULA' => null,
        'AMAZON_PRICE_RULE' => null,
        'AMAZON_PRICE_CALLBACK' => null,
        'AMAZON_CUSTOMER_ID' => null,
        // Imports / Exports
        'AMAZON_LAST_IMPORTED' => null,
        'AMAZON_LAST_UPDATED' => null,
        'AMAZON_ORDERS_RETRIEVED' => null,
        // Carrier
        'AMAZON_CARRIER' => null, // Prestashop Side Carrier
        'AMAZON_AMAZON_CARRIER' => null, // Amazon Side Carrier
        // Orders Statuses
        'AMAZON_ORDER_STATE' => null,
        'AMAZON_PREPARATION_STATE' => null,
        'AMAZON_SENT_STATE' => null,
        'AMAZON_BULK_MODE' => null,
        'AMAZON_CARRIER_DEFAULT' => null,
        // Amazon Europe
        'AMAZON_EUROPE' => null,
        'AMAZON_MASTER' => null,
        // Options
        'AMAZON_EMAIL' => true,
        'AMAZON_DEBUG' => null,
        'AMAZON_FIELD' => null,
        'AMAZON_USE_ASIN' => null,
        'AMAZON_STOCK_ONLY' => null,
        'AMAZON_PRICES_ONLY' => null,
        'AMAZON_PRICE_ROUNDING' => null,
        'AMAZON_SAFE_ENCODING' => null,
        // Generic Parameters
        'AMAZON_SPECIALS' => null,
        'AMAZON_SPECIALS_APPLY_RULES' => null, // 2014-06-28
        'AMAZON_TAXES' => null,
        'AMAZON_DELETE_PRODUCTS' => null,
        'AMAZON_UPDATE_PRODUCTS' => null,
        'AMAZON_FORCE_IMPORT' => null,
        'AMAZON_HTML_DESCRIPTIONS' => null,
        // Reports
        'AMAZON_REPORT_ID' => null,
        // Hidden Settings
        'AMAZON_HIDDEN_SETTINGS' => false,
        // Shipping Rules for trader module
        'AMAZON_SHIPPING_RULES' => null,
        // Condition
        'AMAZON_CONDITION_MAP' => null,
        // Account Type
        'AMAZON_ACCOUNT_TYPE' => false,
        'AMAZON_TITLE_FORMAT' => null,
        //
        'AMAZON_DUMMY' => null,
        'AMAZON_DUMMY_PRODUCT' => null,
        'AMAZON_IMAGE_TYPE' => null,
        //
        'AMAZON_DESCRIPTION_FIELD' => self::FieldDescriptionLong,
        // Shipping Overrides
        'AMAZON_SHIPPING_OVERRIDES_STD' => null,
        'AMAZON_SHIPPING_OVERRIDES_EXP' => null,
        // Crazy Features
        'AMAZON_BRUTE_FORCE' => false,
        // Module Environment
        'AMAZON_LAST_SUBMISSIONS' => false, // use to store submissions ids
        'AMAZON_API_TIMER' => null, // use to store the antithrottling timer
        // Mappings
        'AMAZON_ATTRIBUTES_MAPPING_L' => null,
        'AMAZON_ATTRIBUTES_MAPPING_R' => null,
        'AMAZON_FEATURES_MAPPING_L' => null,
        'AMAZON_FEATURES_MAPPING_R' => null,
        // Cron Variables
        'AMAZON_CRON_TOKEN' => null,
        // FBA Settings
        'AMAZON_FBA' => null,
        'AMAZON_FBA_ORDER_STATE' => null,
        'AMAZON_FBA_PREPARATION_STATE' => null,
        'AMAZON_FBA_SENT_STATE' => null,
        'AMAZON_FBA_MULTICHANNEL_STATE' => null,
        'AMAZON_FBA_MULTICHANNEL_SENT' => null,
        'AMAZON_FBA_PRICE_FORMULA' => null,
        'AMAZON_FBA_MULTICHANNEL' => null,
        'AMAZON_FBA_MULTICHANNEL_AUTO' => null,
        'AMAZON_CARRIER_MULTICHANNEL' => null,
        // Wozapi
        'AMAZON_WOZAPI' => null,
        'AMAZON_WOZAPI_TOKEN' => null,
        'AMAZON_WOZAPI_UPDATED' => null,
        'AMAZON_WOZAPI_PING' => null,
        'AMAZON_WOZAPI_ACKNOWLEDGE' => null,
        // Enhanced 1.5 settings
        'AMAZON_WAREHOUSE' => null,
        'AMAZON_SHOP' => null,
        // 2013-08-17
        'AMAZON_EXCLUDED_MANUFACTURERS' => null,
        'AMAZON_EXCLUDED_SUPPLIERS' => null,
        // 2014-06-17
        'AMAZON_PRICE_FILTER' => null,
        // 2013-09-15 
        'AMAZON_MAIL_INVOICE' => null,
        'AMAZON_MAIL_REVIEW' => null,
        // 2013-11-29
        'AMAZON_ASIN_SYNCHRONIZATION' => null,
        // 2014-06-16
        'AMAZON_WIZARD_CREATION_STATE' => null,
        'AMAZON_CONTEXT' => null,
        'AMAZON_SHIPPING' => null,
        'AMAZON_SHIPPING_METHODS' => null,
        'AMAZON_PRODUCTS_CREATION' => null        
    );
    private $_platforms = array(
        'ca' => 'Canada',
        'cn' => 'China',
        'de' => 'Germany',
        'es' => 'Spain',
        'fr' => 'France',
        'it' => 'Italy',
        'in' => 'India',
        'jp' => 'Japan',
        'uk' => 'United Kingdom',
        'us' => 'United States'
    );
    private $_conditions = array(
        'New',
        'UsedLikeNew',
        'UsedVeryGood',
        'UsedGood',
        'UsedAcceptable',
        'CollectibleLikeNew',
        'CollectibleVeryGood',
        'CollectibleGood',
        'CollectibleAcceptable',
        'Refurbished',
        'Club');
    public $shipping_overrides_std = array(
        'Std FR Dom',
        'Std FR Domestic',
        'Std DE Dom',
        'Std DE Dom 2',
        'Std DE Domestic',
        'Std DE Europe 1',
        'Std DE Europe 2',
        'Std DE Europe 3',
        'Std DE Europe 4',
        'Std DE Europe 5',
        'Std DE ROW',
        'Std DE JP',
        'Std DE NA',
        'Std DE POBox',
        'Std UK Dom',
        'Std UK Domestic',
        'Std UK Europe',
        'Std UK Europe 1',
        'Std UK Europe 2',
        'Std UK Europe 3',
        'Std UK Asia 1',
        'Std UK Asia 2',
        'Std UK BFPO',
        'Std UK PO Box',
        'Std UK ROW',
        'Std UK-ROW',
        'Std UK NA',
        'Std UK NorthAmerica',
        'Std IT Dom',
        'Std IT Domestic',
        'Std JP Chugoku',
        'Std JP Hokkaido',
        'Std JP Kita Tohoku',
        'Std JP Minami Tohoku',
        'Std JP Kanto8',
        'Std JP Shinetsu',
        'Std JP Chubu',
        'Std JP Hokuriku',
        'Std JP Kansai',
        'Std JP Shikoku',
        'Std JP Kyusyu',
        'Std JP Okinawa',
        'Std JP Ritou',         
        'IT Std Domestic',
        'IT Std EFTA',
        'IT Std EU27',
        'IT Std EU10',
        'IT PS Std Domestic',
        'IT PS Std Europe',
        'IT PS Std Intl ROW',
        'IT Std Intl latinamerica',
        'IT Std Intl ROW',
        'Std ES Dom',
        'ES Std Intl Latinamerica',
        'ES Std Domestic',
        'ES Std Europe1',
        'ES Std Europe2',
        'ES Std Europe3',
        'ES Std Intl NA',
        'ES PS Std Domestic',
        'Std BE Dom',
        'Std FR Dom Tom',
        'Std FR DOM-TOM',
        'Std FR DOM-COM et Nouvelle Calédonie',
        'Std FR Europe',
        'Std FR Europe 1',
        'Std FR Europe 2',
        'Std FR NA',
        'Std FR NorthAmerica',
        'Std FR ROW',
        'Std FR-ROW',
        'Std APO/FPO PO Box',
        'Std APO/FPO Street Addr',
        'Std Alaska Hawaii PO Box',
        'Std Alaska Hawaii Street Addr',
        'Std Asia',
        'Std Canada',
        'Std CA Dom',
        'Std CA Domestic',
        'Std Cont US PO Box',
        'Std Cont US Street Addr',
        'Std Europe',
        'Std Outside US, EU, CA, Asia',
        'Std US Prot PO Box',
        'Std US Prot Street Addr',
        'Std US Dom',
        'IN Std Domestic',
        'IN Std Domestic Econ',
        'Expedited',
        'Standard',
        'NextDay',
        'SecondDay',
        'Second'
    );
    public $shipping_overrides_exp = array(
        'Exp FR Dom',
        'Exp FR Domestic',
        'Exp DE Dom',
        'Exp DE Dom 2',
        'Exp DE Domestic',
        'Exp UK Dom',
        'Exp UK Domestic',
        'Exp IT Dom',
        'Exp IT Domestic',
        'Exp Domestic IT',
        'IT Exp Domestic',
        'IT PS Exp Domestic',
        'IT Exp Sun',
        'Exp ES Dom',
        'ES Exp Domestic',
        'Exp BE Dom',
        'Exp FR Dom Tom',
        'Exp APO/FPO PO Box',
        'Exp APO/FPO Street Addr',
        'Exp Alaska Hawaii PO Box',
        'Exp Alaska Hawaii Street Addr',
        'Exp Asia',
        'Exp Canada',
        'Std CA Exp',
        'Exp CA Dom',
        'Exp Cont US PO Box',
        'Exp Cont US Street Addr',
        'Exp Europe',
        'Exp Outside US, EU, CA, Asia',
        'Exp US Prot PO Box',
        'Exp US Prot Street Addr',
        'IN Exp Domestic'
    );
    // As defined in Amazon MWS Fulfillment Outbound Shipment API Section Reference (Version 2010-10-01)
    // ShippingSpeedCategory
    public $carrier_fba = array(
        'Standard',
        'Expedited',
        'Priority'
            );

    const TEMPLATE_HEADER = 1;
    const TEMPLATE_FOOTER = 2;
    const TEMPLATE_LICENSE = 3;
    const TEMPLATE_VALIDATE = 4;
    const TEMPLATE_TABS = 10;
    const TEMPLATE_TAB_SETTINGS = 19;
    const TEMPLATE_TAB_TOOLS = 20;
    const TEMPLATE_TAB_CRON = 21;
    const TEMPLATE_TAB_FILTERS = 22;
    const TEMPLATE_TAB_PARAMETERS = 23;
    const TEMPLATE_TAB_PROFILES = 24;
    const TEMPLATE_TAB_MAPPING = 25;
    const TEMPLATE_TAB_INFO = 26;
    const TEMPLATE_TAB_MESSAGING = 27;
    const TEMPLATE_TAB_FBA = 30;

    private static $templates = array(
        self::TEMPLATE_TABS => 'views/configure/tabs.tpl',
        self::TEMPLATE_HEADER => 'views/configure/header.tpl',
        self::TEMPLATE_FOOTER => 'views/configure/footer.tpl',
        self::TEMPLATE_VALIDATE => 'views/configure/validate.tpl',
        self::TEMPLATE_LICENSE => 'views/configure/license.tpl',
        self::TEMPLATE_TAB_SETTINGS => 'views/configure/settings.tab.tpl',
        self::TEMPLATE_TAB_TOOLS => 'views/configure/tools.tab.tpl',
        self::TEMPLATE_TAB_CRON => 'views/configure/cron.tab.tpl',
        self::TEMPLATE_TAB_FILTERS => 'views/configure/filters.tab.tpl',
        self::TEMPLATE_TAB_PARAMETERS => 'views/configure/parameters.tab.tpl',
        self::TEMPLATE_TAB_PROFILES => 'views/configure/profiles.tab.tpl',
        self::TEMPLATE_TAB_MAPPING => 'views/configure/mapping.tab.tpl',
        self::TEMPLATE_TAB_INFO => 'views/configure/informations.tab.tpl',
        self::TEMPLATE_TAB_MESSAGING => 'views/configure/messaging.tab.tpl',
        self::TEMPLATE_TAB_FBA => 'views/configure/fba.tab.tpl'
            );
    
    public $url;
    public $base;
    public $images;

    function __construct()
    {
        $this->page = basename(__FILE__, '.php');
        $this->tab = 'market_place';
        $this->version = AMAZON_MARKETPLACE_VERSION;
        $this->author = 'Common-Services';
        $this->module_key = 'bd88475a00b7e8a2c2c3c8b89680922d';
        $this->bootstrap = true;
        
        parent::__construct();

        $this->initContext();
        
        $this->displayName = $this->l('Amazon');
        $this->description = $this->l('This extension allow to sell products and retrieve orders from the Amazon MarketPlace');

        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/';
        $this->images = $this->url . 'images/';
        $this->path = _PS_MODULE_DIR_ . $this->name . '/';


        $this->strategies = self::configurationGet('AMAZON_WOZAPI') ? true : false;

        if ((defined('PS_ADMIN_DIR') || defined('_PS_ADMIN_DIR_')) && Amazon_Tools::moduleIsInstalled($this->name))
        {
            $this->path_pdf = $this->path . 'pdf/';
            $this->path_mail = $this->path . 'mail/';

            require_once(_PS_MODULE_DIR_ . 'amazon/validate/AmazonXSD.php'); //gets code for Amazon XML Schemas
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.tools.class.php');
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.specificfield.class.php');
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.csv.references.class.php');
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.carrier.class.php');

            if (!$this->active)
            {
                $this->warning = $this->l('Be carefull, your module is inactive, this mode stops all pending operations for this module, please change the status to active in your module list');
                return;
            }
            $warnings = null;

            //
            // Warnings for well known issues
            //
            if (version_compare(_PS_VERSION_, '1.3', '<'))
                if (!Hook::get('backOfficeHeader'))
                    $warnings .= $this->l('Old Prestashop release: Hook "backOfficeHeader" need to be installed ; please contact us !') . "\n";

            if (!function_exists('curl_init'))
                $warnings .= $this->l('PHP cURL must be installed for this module working...') . "\n";

            if (!(int) Configuration::Get('PS_SHOP_ENABLE'))
                $warnings .= $this->l('Be carefull, your shop is in maintenance mode, the module might not work in that mode') . "\n";

            if (!is_writable(_PS_MODULE_DIR_ . 'amazon/validate/xsd'))
                $warnings .= sprintf($this->l('You have to set write permissions to the %s directory'), _PS_MODULE_DIR_ . 'amazon/validate/xsd') . "\n";

            $this->warning = nl2br($warnings);
        }
    }

    // Retrocompatibility 1.4/1.5
    private function initContext()
    {
        if (version_compare(_PS_VERSION_, '1.6', '>='))
            $this->psIs16x = true;
        else
            $this->psIs16x = false;
        
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $this->context = Context::getContext();

            // Skip Front Office
            if (!$this->context->controller instanceOf AdminModulesController &&
                    !$this->context->controller instanceOf AdminOrdersController && !strstr($_SERVER['REQUEST_URI'], '/' . $this->name))
                return;

            $this->context->currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));

            if (!$this->context->employee instanceOf Employee)
            {
                $id_employee = self::configurationGet('AMAZON_EMPLOYEE');
                $employee = new Employee($id_employee ? $id_employee : 1);

                // Force context for F/O scripts (ie: products options, import orders)
                $this->context->employee = $employee;
                $this->context->language = new Language($employee->id_lang);

                $this->id_lang = (int) $employee->id_lang;
            }
            else
            {
                $this->id_lang = (int) $this->context->employee->id_lang;
            }
         
        }
        else
        {
            global $cookie, $smarty, $cart;

            if ($cart instanceOf Cart)
                $cart->id_currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));

            $this->context = new StdClass();
            $this->context->smarty = $smarty;
            $this->context->cookie = $cookie;

            if (!isset($cookie->id_lang) || !$cookie->id_lang)
                $this->id_lang = (int) self::configurationGet('PS_LANG_DEFAULT');
            else
                $this->id_lang = (int) $cookie->id_lang;
        }
    }

    public function install()
    {
        $pass = true;

        foreach ($this->_config as $key => $value)
        {
            if (is_null($value))
                $value = '';
            if (is_array($value))
                $value = base64_encode(serialize($value));
            if (!self::configurationUpdateValue($key, $value))
            {
                $this->_errors[] = sprintf('%s - key: %s, value: %s', $this->l('Unable to install : Some configuration values'), $key, nl2br(print_r($value, true)));
                $pass = false;
            }
        }
        if (!$pass)
            $this->_errors[] = $this->l('Unable to install : Some configuration values');

        if (!parent::install())
            $this->_errors[] = $this->l('Unable to install: parent()') && $pass = false;

        $this->_tabSetup(Amazon::Add);

        if (!$this->_createCustomer())
        {
            $this->_errors[] = $this->l('Unable to install: _createCustomer()');
            $pass = false;
        }
        if (!$this->_addMarketPlaceTables())
        {
            $this->_errors[] = $this->l('Unable to install: _addMarketPlaceTables()');
            $pass = false;
        }
        if (!$this->_addMarketPlaceField())
        {
            $this->_errors[] = $this->l('Unable to install: _addMarketPlaceField()');
            $pass = false;
        }
        if (!$this->_addBackwardCompatibilityFields())
        {
            $this->_errors[] = $this->l('Unable to install: _addBackwardCompatibilityFields()');
            $pass = false;
        }
        @copy(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'a32.gif', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'logo.gif');

        // Hooks
        $this->_hookSetup(self::Add);

        return($pass);
    }

    public function uninstall()
    {
        $pass = true;

        // Remove Hooks
        //
        $this->_hookSetup(self::Remove);

        // Remove Tabs
        //
        $this->_tabSetup(self::Remove);

        if (!parent::uninstall())
            $this->_errors[] = $this->l('Unable to uninstall: parent()') && $pass = false;
        if (!$this->_deleteCustomer())
            $this->_errors[] = $this->l('Unable to uninstall: Amazon Customer') && $pass = false;
        if (!$this->_removeMarketPlaceField())
            $this->_errors[] = $this->l('Unable to uninstall: MarketPlace Fields') && $pass = false;
        if (!$this->_removeMarketPlaceTables())
            $this->_errors[] = $this->l('Unable to uninstall: MarketPlace Tables') && $pass = false;

        foreach ($this->_config as $key => $value)
            if (!Configuration::deleteByName($key))
                $pass = $pass && false;

        // Remove cron statuses for each Amazon countries
        //    
        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'];

            foreach (array('AMAZON_LAST_CRON_UPDATED', 'AMAZON_LAST_UPDATED') as $config)
            {
                Configuration::deleteByName($config . '_' . $id_lang);
            }
        }

        if (!$pass)
            $this->_errors[] = $this->l('Unable to uninstall : Some configuration values');

        return($pass);
    }
    
    
    private function _checkPriceRules($price_rules)
    {
        if (!is_array($price_rules))
            return ($this->l('An error occured with price rules, not an array.'));
        
        $error = '';
        $actives = Tools::getValue('actives');
        
        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'];
            $rule = isset($price_rules[$id_lang]['rule']) ? $price_rules[$id_lang]['rule'] : null;
            $type = isset($price_rules[$id_lang]['type']) ? $price_rules[$id_lang]['type'] : null;

            if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                continue;
            
            if (!isset($rule) || !is_array($rule))
                continue;
            
            if (!is_array($rule['from']) || !count($rule['from']) || !is_array($rule['to']) || !count($rule['to']))
                continue;
            
            if (!reset($rule['from']) && !reset($rule['to']))
                continue;
            
            if ((reset($rule['from']) && !reset($rule['to'])) || (!reset($rule['from']) && reset($rule['from']) != '0' && reset($rule['to'])))
            {
                $error .= sprintf('%s %s => %s<br>', $this->l('Price rule incomplete for'), $language['name'], $this->l('Missing range element'));
                continue;
            }
            
            if (($type == 'percent' && !reset($rule['percent'])) || ($type == 'value' && !reset($rule['value'])))
            {
                $error .= sprintf('%s %s => %s<br>', $this->l('Price rule incomplete for'), $language['name'], $this->l('Missing value'));
                continue;
            }
            
            $prev_from = -1 ;
            $prev_to = -1 ;
            
            foreach ($rule['from'] as $key => $val)
            {
                
                if (max($prev_from, $val) == $prev_from)
                {
                    $error .= sprintf('%s (%s) => %s %d<br>', $this->l('Your range FROM is lower than the previous one'), $language['name'], $this->l('Rule ligne'), $key + 1);
                    break;
                }
                else if ($rule['to'][$key] && max($prev_to, $rule['to'][$key]) == $prev_to)
                {
                    $error .= sprintf('%s (%s) => %s %d<br>', $this->l('Your range TO is lower than the previous one'), $language['name'], $this->l('Rule ligne'), $key + 1);
                    break;
                }
                else if ($rule['to'][$key] && max($rule['to'][$key], $val) == $val)
                {
                    $error .= sprintf('%s (%s) => %s %d<br>', $this->l('Your range TO is lower than your range FROM'), $language['name'], $this->l('Rule ligne'), $key + 1);
                    break;
                }
                
                $prev_from = $val;
                $prev_to = $rule['to'][$key];
            }
        }
        
        if ( ! $error )
        {
            Configuration::deleteByName('AMAZON_PRICE_FORMULA') ;
        }
        
        return ($error);
    }
    

    private function _postValidation()
    {
        $actives = Tools::getValue('actives');

        $merchantIds = Tools::getValue('merchantId');
        $marketPlaceIds = Tools::getValue('marketPlaceId');
        $awsKeyIds = Tools::getValue('awsKeyId');
        $awsSecretKeys = Tools::getValue('awsSecretKey');

        $currencies = Tools::getValue('marketPlaceCurrency');
        $regions = Tools::getValue('marketPlaceRegion');

        $formulas = Tools::getValue('formula');
        $callbacks = Tools::getValue('pcallback');
        $roundings = Tools::getValue('rounding');
        $carriers = Tools::getValue('carrier');
        $amazon_carriers = Tools::getValue('amazon_carrier');
        $carrier_default = Tools::getValue('carrier_default');

        $categories = Tools::getValue('categoryBox');

        $order_state = Tools::getValue('order_state');
        $send_state = Tools::getValue('sent_state');

        $amazonEurope = Tools::getValue('amazonEurope');
        $marketPlaceMaster = Tools::getValue('marketPlaceMaster');

        $condition_map = Tools::getValue('condition_map');
        $shipping_rules = Tools::getValue('shipping_rules');
        $profiles = Tools::getValue('profiles');

        $merchantId = array();
        $marketPlaceId = array();
        $awsKeyId = array();
        $awsSecretKey = array();

        $currency = array();
        $region = array();

        $callback = array();
        $formula = array();
        $carrier = array();

        $error = null;
        
        $price_rules = Tools::getValue('price_rule');

        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'];

            if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                continue;

            $merchantId[$id_lang] = isset($merchantIds[$id_lang]) ? trim($merchantIds[$id_lang]) : '';
            $marketPlaceId[$id_lang] = isset($marketPlaceIds[$id_lang]) ? trim($marketPlaceIds[$id_lang]) : '';
            $awsKeyId[$id_lang] = isset($awsKeyIds[$id_lang]) ? trim($awsKeyIds[$id_lang]) : '';
            $awsSecretKey[$id_lang] = isset($awsSecretKeys[$id_lang]) ? trim($awsSecretKeys[$id_lang]) : '';

            $callback[$id_lang] = isset($callbacks[$id_lang]) ? str_replace('\\', '', trim($callbacks[$id_lang])) : '';

            $formula[$id_lang] = isset($formulas[$id_lang]) ? trim($formulas[$id_lang]) : '';
            $carrier[$id_lang] = isset($carriers[$id_lang]) ? $carriers[$id_lang] : '';

            $currency[$id_lang] = isset($currencies[$id_lang]) ? $currencies[$id_lang] : '';
            $region[$id_lang] = isset($regions[$id_lang]) ? $regions[$id_lang] : '';

            $tokenEurope = 1;

            if ( ! (int)$amazonEurope )
            {
                if (empty($awsKeyId[$id_lang]) && $id_lang == $language['id_lang'])
                    $error .= $this->l('You must fill your Amazon Web Service ID') . ' - (' . $language['name'] . ')' . '<br />';
                if (empty($awsSecretKey[$id_lang]))
                    $error .= $this->l('You must fill your Amazon Secret Key') . ' - (' . $language['name'] . ')' . '<br />';

                $tokenEurope = 1;
            }

            if (empty($marketPlaceId[$id_lang]) && $id_lang == $language['id_lang'])
                $error .= $this->l('You must fill your MarketPlace ID') . ' - (' . $language['name'] . ')' . '<br />';

            if (empty($region[$id_lang]))
                $error .= $this->l('Region must be selected') . ' - (' . $language['name'] . ')' . '<br />';
            
            if (empty($currency[$id_lang]))
                $error .= $this->l('Currency must be selected') . ' - (' . $language['name'] . ')' . '<br />';

            if (!isset($roundings[$id_lang]) || !$roundings[$id_lang])
            {
                if (empty($callback[$id_lang]))
                    $error .= $this->l('PHP CallBack must be set') . ' - (' . $language['name'] . ')' . '<br />';

                // Validate CallBack
                //
                $test_callback = str_replace('@', '1', $callback[$id_lang]);
                $test_callback = str_replace('\\', '', $test_callback);

                if (@eval($test_callback) === false)
                    $error .= $this->l('PHP CallBack is wrong, that will cause module malfunction !') . ' - (' . $language['name'] . ')' . '<br />';
            }

            $check_price_rules = $this->_checkPriceRules($price_rules);
            if (strlen($check_price_rules))
                $error .= $check_price_rules; 

            if (!max($carrier[$id_lang]) || !isset($carrier_default[$id_lang]['prestashop']) || !max($carrier_default[$id_lang]['prestashop']))
                $error .= $this->l('You must choose a Carrier') . ' - (' . $language['name'] . ')' . '<br />';

            if (!max($amazon_carriers[$id_lang]) || !isset($carrier_default[$id_lang]['amazon']) || !max($carrier_default[$id_lang]['amazon']))
                $error .= $this->l('You must choose an Amazon Carrier') . ' - (' . $language['name'] . ')' . '<br />';
        }

        if ( ! max($categories) )
            $error .= $this->l('Categories Tab must be configured !') . '<br />';

        if ( is_array($order_state) && ! max($order_state) || ! is_array($order_state) && ! (int)$order_state )
            $error .= $this->l('Incoming order status must be set in the parameters tab !') . '<br />';

        if ( is_array($send_state) && ! max($send_state) || ! is_array($send_state) && ! (int)$send_state )
            $error .= $this->l('Sent order status must be set in the parameters tab !') . '<br />';

        if (!isset($condition_map['New']) || empty($condition_map['New']))
            $error .= $this->l('The condition map must be filled') . '<br />';

        if (isset($amazonEurope) && intval($amazonEurope) && isset($marketPlaceMaster) && empty($marketPlaceMaster))
            $error .= $this->l('Amazon Europe is set, you must define a Master Platform !') . '<br />';

        if ($profiles && isset($profiles['name']) && is_array($profiles['name']))
            foreach ($profiles['name'] as $id => $profile)
            {
                if (empty($profiles['name'][$id]))
                    continue;

                $name = $profiles['name'][$id];

                if (!isset($profiles['universe'][$id]) || empty($profiles['universe'][$id]))
                {
                    $error .= sprintf($this->l('The "Category Name" for Profile "%s" is not selected.'), $profiles['name'][$id]) . '<br />';
                }
                if (!isset($profiles['product_type'][$id]) || empty($profiles['product_type'][$id]))
                {
                    $error .= sprintf($this->l('The "Product Type" for Profile "%s" is not selected.'), $profiles['name'][$id]) . '<br />';
                }
                if (isset($profiles['extra'][$name]) && is_array($profiles['extra'][$name]) && count($profiles['extra'][$name]))
                {
                    foreach ($profiles['extra'][$name]['field'] as $field_name => $value)
                    {
                        if (!isset($profiles['extra'][$name]['required']))
                            continue;

                        $pass = false;

                        if (isset($profiles['extra'][$name]['characteristic'][$field_name]) && !empty($profiles['extra'][$name]['characteristic'][$field_name]))
                            $pass = true;
                        elseif (isset($profiles['extra'][$name]['characteristic'][$field_name]) && !empty($value))
                            $pass = true;
                        elseif (isset($profiles['extra'][$name]['field'][$field_name]) && !empty($value))
                            $pass = true;

                        if (!$pass)
                            $error .= sprintf($this->l('The "%s" value for Profile "%s" is required.'), $field_name, $profiles['name'][$id]) . '<br />';
                    }
                }
                foreach (Amazon_Tools::languages() as $language)
                {
                    if ($language['iso_code'] == 'us')
                        continue; // not needed for U.S.

                    $id_lang = $language['id_lang'];

                    $pass = true;

                    if (isset($profiles['browsenode_' . $id_lang][$id]) && preg_match('/[,; ]/', $profiles['browsenode_' . $id_lang][$id]))
                    {
                        $result = preg_split('/[,; ]/', $profiles['browsenode_' . $id_lang][$id]);

                        if (is_array($result))
                        {
                            foreach ($result as $browsenode)
                            {
                                if (empty($browsenode))
                                    continue;
                                if (!is_numeric(trim($browsenode)))
                                    $pass = false;
                            }
                        }
                        else
                        {
                            $pass = false;
                        }
                    }
                    elseif (isset($profiles['browsenode_' . $id_lang][$id]) && !empty($profiles['browsenode_' . $id_lang][$id]))
                    {
                        if (!is_numeric(trim($profiles['browsenode_' . $id_lang][$id])))
                            $pass = false;
                    }

                    if (!$pass)
                        $error .= sprintf($this->l('Incorrect value for Browsenode(%s) for Profile "%s" - The value can be only numeric or a list of numerics'), strtoupper($language['iso_code']), $profiles['name'][$id]) . '<br />';
                }
            }
        if (!empty($error))
            $this->_postErrors[] = $error;

        if (unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG'))))
        {
            $this->_html .= sprintf('<div class="conf confirm ' . ($this->psIs16x ? 'alert alert-success' : '') . '">Memory Peak: %.02f MB - Post Count: %s</div>', memory_get_peak_usage() / 1024 / 1024, count($_POST, COUNT_RECURSIVE));
        }
    }

    private function _postProcess()
    {
        // Prestashop bug fixes
        //
        $this->_fixPrestashopIssues();

        // Tables Updates
        //
        if (!$this->_addMarketPlaceTables())
            $this->_postErrors[] = 'install tables failed';

        if (!$this->_addMarketPlaceField())
            $this->_postErrors[] = 'install marketplace fields failed';

        if (!$this->_addBackwardCompatibilityFields())
            $this->_postErrors[] = 'install marketplace compatibility fields failed';

        // Hooks
        $this->_hookSetup(self::Add);

        // Update Tabs
        //
        $this->_tabSetup(self::Update);

        $actives = Tools::getValue('actives');

        $merchantIds = Tools::getValue('merchantId');
        $marketPlaceIds = Tools::getValue('marketPlaceId');
        $awsKeyIds = Tools::getValue('awsKeyId');
        $awsSecretKeys = Tools::getValue('awsSecretKey');

        $currencies = Tools::getValue('marketPlaceCurrency');
        $regions = Tools::getValue('marketPlaceRegion');

        $formulas = Tools::getValue('formula');
        $price_rules = Tools::getValue('price_rule');
        $outofstocks = Tools::getValue('outofstock');
        $callbacks = Tools::getValue('pcallback');
        $roundings = Tools::getValue('rounding');
        $carriers = Tools::getValue('carrier');
        $amazon_carrier = Tools::getValue('amazon_carrier');
        $synch_fields = Tools::getValue('synch_field');
        $use_asins = Tools::getValue('use_asin');

        $categories = Tools::getValue('categoryBox');

        $order_state = Tools::getValue('order_state');
        $send_state = Tools::getValue('sent_state');
        $preparation_state = Tools::getValue('preparation_state');

        $fba_order_state = Tools::getValue('fba_order_state');
        $fba_send_state = Tools::getValue('fba_sent_state');
        $fba_preparation_state = Tools::getValue('fba_preparation_state');
        $fba_multichannel_state = Tools::getValue('fba_multichannel_state');
        $fba_multichannel_sent_state = Tools::getValue('fba_multichannel_sent_state');

        $warehouse = Tools::getValue('warehouse');
        $shop = Tools::getValue('shop');
        $employee = Tools::getValue('employee');

        $carrier_default = Tools::getValue('carrier_default');
        $carrier_multichannel = Tools::getValue('carrier_multichannel');

        $amazonEurope = Tools::getValue('amazonEurope');
        $marketPlaceMaster = Tools::getValue('marketPlaceMaster');

        $debugMode = (bool) Tools::getValue('debug');
        $email = (bool) Tools::getValue('email');
        $fba = (bool) Tools::getValue('fba');

        $fba_price_formula = Tools::getValue('fba_formula');
        $fba_multichannel = (bool) Tools::getValue('fba_multichannel');
        $fba_multichannel_auto = (bool) Tools::getValue('fba_multichannel_auto');

        $wozapi = (bool) Tools::getValue('wozapi');
        $specials = (bool) Tools::getValue('specials');
        $specials_apply_rules = (bool) Tools::getValue('specials_apply_rules');
        $taxes = (int) Tools::getValue('taxes');
        $delete_products = (bool) Tools::getValue('delete_products');
        $stock_only = (bool) Tools::getValue('stock_only');
        $html_descriptions = (bool) Tools::getValue('html_descriptions');
        $prices_only = (bool) Tools::getValue('prices_only');
        $payment_region = (bool) Tools::getValue('payment_region');

        $description_field = Tools::getValue('description_field');

        $image_type = Tools::getValue('image_type');
        $safe_encoding = Tools::getValue('safe_encoding');

        $dummy = (bool) Tools::getValue('dummy');
        $dummy_product = Tools::getValue('dummy_product');

        $force_import = (bool) Tools::getValue('force_import');

        $condition_map = Tools::getValue('condition_map');

        $account_type = Tools::getValue('account_type');
        $title_format = Tools::getValue('title_format');

        $override_stds = Tools::getValue('overrides_std');
        $override_exps = Tools::getValue('overrides_exp');

        $brute_force = (bool) Tools::getValue('brute_force');
        $mapping = Tools::getValue('mapping');
        $features_mapping = Tools::getValue('features_mapping');

        $bulk_mode = (bool) Tools::getValue('bulk_mode');

        $excluded_manufacturers = Tools::getValue('selected-manufacturers');
        $excluded_suppliers = Tools::getValue('selected-suppliers');
        $price_filter = Tools::getValue('price_filter');

        $expert_mode = (bool) Tools::getValue('expert_mode');

        /*
         * Save Profiles 
         */
        $profiles = Tools::getValue('profiles');
        $profile2category = Tools::getValue('profile2category');

        $active = array();

        $merchantId = array();
        $marketPlaceId = array();
        $awsKeyId = array();
        $awsSecretKey = array();

        $currency = array();
        $region = array();

        $outofstock = array();
        $callback = array();
        $rounding = array();
        $formula = array();

        $carrier = array();
        $synch_field = array();
        $use_asin = array();

        $shipping_rule = array();

        $override_exp = array();
        $override_std = array();

        $amazonTokens = array();

        // For post treatments ....
        //
        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'];

            if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                continue;

            $active[$id_lang] = isset($actives[$id_lang]) ? intval($actives[$id_lang]) : '';

            $merchantId[$id_lang] = isset($merchantIds[$id_lang]) ? trim($merchantIds[$id_lang]) : '';
            $marketPlaceId[$id_lang] = isset($marketPlaceIds[$id_lang]) ? trim($marketPlaceIds[$id_lang]) : '';
            $awsKeyId[$id_lang] = isset($awsKeyIds[$id_lang]) ? trim($awsKeyIds[$id_lang]) : '';
            $awsSecretKey[$id_lang] = isset($awsSecretKeys[$id_lang]) ? trim($awsSecretKeys[$id_lang]) : '';

            $currency[$id_lang] = isset($currencies[$id_lang]) ? $currencies[$id_lang] : '';
            $region[$id_lang] = isset($regions[$id_lang]) ? $regions[$id_lang] : '';

            $outofstock[$id_lang] = isset($outofstocks[$id_lang]) ? trim($outofstocks[$id_lang]) : '';

            $rounding[$id_lang] = isset($roundings[$id_lang]) ? (int) $roundings[$id_lang] : '1';
            $callback[$id_lang] = isset($callbacks[$id_lang]) ? str_replace('\\', '', trim($callbacks[$id_lang])) : '';

            if (empty($callback[$id_lang]))
            {
                if ($rounding[$id_lang] == 1)
                    $callback[$id_lang] = 'number_format(round(@,1), 2, ".",  "");';
                else
                    $callback[$id_lang] = 'number_format(round(@,2), 2, ".",  "");';
            }

            $formula[$id_lang] = isset($formulas[$id_lang]) ? trim($formulas[$id_lang]) : '';

            $carrier[$id_lang] = isset($carriers[$id_lang]) ? $carriers[$id_lang] : '';
            $amazon_carrier[$id_lang] = isset($amazon_carrier[$id_lang]) ? $amazon_carrier[$id_lang] : '';

            $synch_field[$id_lang] = isset($synch_fields[$id_lang]) ? $synch_fields[$id_lang] : '';

            $use_asin[$id_lang] = isset($use_asins[$id_lang]) ? $use_asins[$id_lang] : '';

            $override_std[$id_lang] = isset($override_stds[$id_lang]) ? $override_stds[$id_lang] : '';
            $override_exp[$id_lang] = isset($override_exps[$id_lang]) ? $override_exps[$id_lang] : '';

            if ( isset($price_rules[$id_lang]) && is_array($price_rules[$id_lang]) && isset($price_rules[$id_lang]['rule']['from']) && is_array($price_rules[$id_lang]['rule']['from']) && is_array($price_rules[$id_lang]['rule']['to']) )
            {
                foreach( $price_rules[$id_lang]['rule']['from'] as $index => $val )
                {
                    if ( ! is_numeric($val) )
                    {
                        unset($price_rules[$id_lang]['rule']['from'][$index]) ;
                        unset($price_rules[$id_lang]['rule']['to'][$index]) ;
                        unset($price_rules[$id_lang]['rule']['percent'][$index]) ;
                        unset($price_rules[$id_lang]['rule']['value'][$index]) ;
                    }
                }
                $price_rules[$id_lang]['rule']['from'] = array_values($price_rules[$id_lang]['rule']['from']) ;
                $price_rules[$id_lang]['rule']['to'] = array_values($price_rules[$id_lang]['rule']['to']) ;
                $price_rules[$id_lang]['rule']['percent'] = array_values($price_rules[$id_lang]['rule']['percent']) ;
                $price_rules[$id_lang]['rule']['value'] = array_values($price_rules[$id_lang]['rule']['value']);
            }
            
            // Cron Token
            //
            $amazonTokens[$id_lang] = md5($awsSecretKeys[$id_lang]);
        }
        if (!($wozapi_token = self::configurationGet('AMAZON_WOZAPI_TOKEN')))
        {
            $wozapi_token = uniqid();
            self::configurationUpdateValue('AMAZON_WOZAPI_TOKEN', $wozapi_token);
        }
        self::configurationUpdateValue('AMAZON_ACTIVE', base64_encode(serialize($active)));
        self::configurationUpdateValue('AMAZON_MERCHANT_ID', base64_encode(serialize($merchantId)));
        self::configurationUpdateValue('AMAZON_MARKETPLACE_ID', base64_encode(serialize($marketPlaceId)));
        self::configurationUpdateValue('AMAZON_AWS_KEY_ID', base64_encode(serialize($awsKeyId)));
        self::configurationUpdateValue('AMAZON_SECRET_KEY', base64_encode(serialize($awsSecretKey)));

        self::configurationUpdateValue('AMAZON_CURRENCY', base64_encode(serialize($currency)));
        self::configurationUpdateValue('AMAZON_REGION', base64_encode(serialize($region)));

        self::configurationUpdateValue('AMAZON_OUT_OF_STOCK', base64_encode(serialize($outofstock)));
        self::configurationUpdateValue('AMAZON_PRICE_FORMULA', base64_encode(serialize($formula)));
        self::configurationUpdateValue('AMAZON_PRICE_RULE', base64_encode(serialize($price_rules)));
        self::configurationUpdateValue('AMAZON_PRICE_CALLBACK', base64_encode(serialize($callback)));
        self::configurationUpdateValue('AMAZON_PRICE_ROUNDING', base64_encode(serialize($rounding)));
        self::configurationUpdateValue('AMAZON_CARRIER', base64_encode(serialize($carrier)));
        self::configurationUpdateValue('AMAZON_AMAZON_CARRIER', base64_encode(serialize($amazon_carrier)));

        self::configurationUpdateValue('AMAZON_FIELD', base64_encode(serialize($synch_field)));
        self::configurationUpdateValue('AMAZON_USE_ASIN', base64_encode(serialize($use_asin)));

        self::configurationUpdateValue('AMAZON_CATEGORIES', base64_encode(serialize($categories)));
        self::configurationUpdateValue('AMAZON_PROFILES_CATEGORIES', base64_encode(serialize($profile2category)));

        self::configurationUpdateValue('AMAZON_ORDER_STATE', base64_encode(serialize($order_state)));
        self::configurationUpdateValue('AMAZON_PREPARATION_STATE', base64_encode(serialize($preparation_state)));
        self::configurationUpdateValue('AMAZON_SENT_STATE', base64_encode(serialize($send_state)));

        self::configurationUpdateValue('AMAZON_FBA_ORDER_STATE', (int) $fba_order_state);
        self::configurationUpdateValue('AMAZON_FBA_PREPARATION_STATE', (int) $fba_preparation_state);
        self::configurationUpdateValue('AMAZON_FBA_SENT_STATE', (int) $fba_send_state);
        self::configurationUpdateValue('AMAZON_FBA_MULTICHANNEL_STATE', (int) $fba_multichannel_state);
        self::configurationUpdateValue('AMAZON_FBA_MULTICHANNEL_SENT', (int) $fba_multichannel_sent_state);

        self::configurationUpdateValue('AMAZON_WAREHOUSE', (int) $warehouse);
        self::configurationUpdateValue('AMAZON_SHOP', (int) $shop);
        self::configurationUpdateValue('AMAZON_EMPLOYEE', (int) $employee);

        self::configurationUpdateValue('AMAZON_CARRIER_DEFAULT', base64_encode(serialize($carrier_default)));
        self::configurationUpdateValue('AMAZON_CARRIER_MULTICHANNEL', base64_encode(serialize($carrier_multichannel)));

        self::configurationUpdateValue('AMAZON_EUROPE', base64_encode(serialize($amazonEurope)));
        self::configurationUpdateValue('AMAZON_MASTER', base64_encode(serialize($marketPlaceMaster)));

        self::configurationUpdateValue('AMAZON_EMAIL', (bool) $email);
        self::configurationUpdateValue('AMAZON_DEBUG', base64_encode(serialize($debugMode)));

        self::configurationUpdateValue('AMAZON_FBA', $fba);
        self::configurationUpdateValue('AMAZON_FBA_PRICE_FORMULA', base64_encode(serialize($fba_price_formula)));
        self::configurationUpdateValue('AMAZON_FBA_MULTICHANNEL', $fba_multichannel);
        self::configurationUpdateValue('AMAZON_FBA_MULTICHANNEL_AUTO', $fba_multichannel_auto);
        self::configurationUpdateValue('AMAZON_WOZAPI', $wozapi);
        self::configurationUpdateValue('AMAZON_WOZAPI_TOKEN', $wozapi_token);

        self::configurationUpdateValue('AMAZON_SPECIALS', base64_encode(serialize($specials)));
        self::configurationUpdateValue('AMAZON_SPECIALS_APPLY_RULES', (bool)$specials_apply_rules);
        self::configurationUpdateValue('AMAZON_TAXES', base64_encode(serialize($taxes)));

        self::configurationUpdateValue('AMAZON_CONDITION_MAP', base64_encode(serialize($condition_map)));

        self::configurationUpdateValue('AMAZON_ACCOUNT_TYPE', base64_encode(serialize($account_type)));
        self::configurationUpdateValue('AMAZON_TITLE_FORMAT', base64_encode(serialize($title_format)));

        self::configurationUpdateValue('AMAZON_SHIPPING_OVERRIDES_STD', base64_encode(serialize($override_std)));
        self::configurationUpdateValue('AMAZON_SHIPPING_OVERRIDES_EXP', base64_encode(serialize($override_exp)));

        self::configurationUpdateValue('AMAZON_CRON_TOKEN', base64_encode(serialize($amazonTokens)));

        self::configurationUpdateValue('AMAZON_DELETE_PRODUCTS', base64_encode(serialize($delete_products)));
        self::configurationUpdateValue('AMAZON_STOCK_ONLY', base64_encode(serialize($stock_only)));
        self::configurationUpdateValue('AMAZON_PRICES_ONLY', $prices_only);
        self::configurationUpdateValue('AMAZON_BULK_MODE', $bulk_mode);
        self::configurationUpdateValue('AMAZON_FORCE_IMPORT', base64_encode(serialize($force_import)));
        self::configurationUpdateValue('AMAZON_PAYMENT_REGION', $payment_region);

        self::configurationUpdateValue('AMAZON_BRUTE_FORCE', base64_encode(serialize($brute_force)));

        self::configurationUpdateValue('AMAZON_HTML_DESCRIPTIONS', $html_descriptions);
        self::configurationUpdateValue('AMAZON_DESCRIPTION_FIELD', $description_field);

        self::configurationUpdateValue('AMAZON_DUMMY', (int) $dummy);
        self::configurationUpdateValue('AMAZON_DUMMY_PRODUCT', $dummy_product);

        self::configurationUpdateValue('AMAZON_IMAGE_TYPE', $image_type);
        self::configurationUpdateValue('AMAZON_SAFE_ENCODING', $safe_encoding);

        self::configurationUpdateValue('AMAZON_ATTRIBUTES_MAPPING_L', base64_encode(serialize($mapping['prestashop'])));
        self::configurationUpdateValue('AMAZON_ATTRIBUTES_MAPPING_R', base64_encode(serialize($mapping['amazon'])));

        self::configurationUpdateValue('AMAZON_FEATURES_MAPPING_L', base64_encode(serialize($features_mapping['prestashop'])));
        self::configurationUpdateValue('AMAZON_FEATURES_MAPPING_R', base64_encode(serialize($features_mapping['amazon'])));

        self::configurationUpdateValue('AMAZON_EXCLUDED_MANUFACTURERS', base64_encode(serialize($excluded_manufacturers)));
        self::configurationUpdateValue('AMAZON_EXCLUDED_SUPPLIERS', base64_encode(serialize($excluded_suppliers)));
        self::configurationUpdateValue('AMAZON_PRICE_FILTER', base64_encode(serialize($price_filter)));

        // Configure Hidden Settings - Expert Mode
        self::configurationUpdateValue('AMAZON_HIDDEN_SETTINGS', $expert_mode);
        self::configurationUpdateValue('AMAZON_MAIL_INVOICE', base64_encode(serialize(Tools::getValue('mail_invoice'))));
        self::configurationUpdateValue('AMAZON_MAIL_REVIEW', base64_encode(serialize(Tools::getValue('mail_review'))));

        if (isset($profiles) && count($profiles))
        {
            $this->_saveProfiles($profiles);
        }

        self::configurationUpdateValue('AMAZON_CURRENT_VERSION', $this->version);

        if (!$this->_postErrors)
            $this->_html .= '<div class="conf confirm ' . ($this->psIs16x ? 'alert alert-success' : '') . '">' . $this->l('Configuration updated') . '</div>';
    }

    private function _saveProfiles($profiles)
    {
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/Node.php');
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/XmlDataType.php');
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/XmlRestriction.php');
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/AmazonXSD.php'); //gets code for Amazon XML Schemas
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/AmazonValidator.php');
        require_once(_PS_MODULE_DIR_ . 'amazon/validate/Tools.php');

        $profiles['parameters'] = array();
        $profiles['attributes'] = array();

        if (isset($profiles['name']) && is_array($profiles['name']))
            foreach ($profiles['name'] as $id => $profile)
            {
                if (!isset($profiles['name'][$id]) || empty($profiles['name'][$id]))
                    continue;
                if (!isset($profiles['universe'][$id]) || empty($profiles['universe'][$id]))
                    continue;
                #if ( ! isset($profiles['product_type'][$id]) || empty($profiles['product_type'][$id]) ) continue ;

                $category = $profiles['universe'][$id];

                # Here is saved the configuration
                try
                {
                    $productFactory = new AmazonXSD($category . '.xsd');
                    $productInstance = $productFactory->getInstance();
                    $xsdStructure = array();

                    $referenceElement = $profiles['product_type'][$id] ? $profiles['product_type'][$id] : null;

                    if ($category != "CE"):
                        foreach (array('ProductType', 'ClothingType', 'VariationData',
                    'Parentage', 'VariationTheme', 'Color', 'ColorMap',
                    'Size', 'SizeMap', 'ColorName', 'SizeName') as $searchedElement):
                            if (($path = AmazonXSD_Tools::searchPath($productInstance, $searchedElement, $referenceElement))):
                                $profiles['parameters'][$id][$searchedElement] = $path;
                            endif;
                        endforeach;

                    else:
                        foreach (array('ProductType', 'ProductSubtype') as $searchedElement):
                            if (($path = AmazonXSD_Tools::searchPath($productInstance, $searchedElement, $referenceElement))):
                                $profiles['parameters'][$id][$searchedElement] = $path;
                            endif;
                        endforeach;
                        foreach (array('VariationData', 'Parentage', 'VariationTheme', 'Color', 'ColorMap',
                    'Size', 'SizeMap', 'ColorName', 'SizeName') as $searchedElement):
                            if (($path = AmazonXSD_Tools::searchPath($productInstance, $searchedElement, $referenceElement))):
                                $profiles['parameters'][$id][$searchedElement] = $path;
                            endif;
                        endforeach;
                    endif;

                    // Add to the path the mandatory fields 
                    //
                    if (isset($profiles['extra'][$profile]['field']) && $profiles['extra'][$profile]['field'])
                        foreach ($profiles['extra'][$profile]['field'] as $field => $value)
                        {
                            $path = AmazonXSD_Tools::searchPath($productInstance, $field, $referenceElement);

                            if ($path)
                                $profiles['parameters'][$id][$field] = $path;
                        }
                    // Add path for specifics variants (eg: Jewelry) - Added: 2013-03-18
                    //   
                    if (isset($profiles['extra'][$profile]['field']['variant']) && isset($profiles['extra'][$profile]['variant']) && isset($profiles['extra'][$profile]['variant'][$profiles['extra'][$profile]['field']['variant']]))
                    {
                        foreach ($profiles['extra'][$profile]['variant'][$profiles['extra'][$profile]['field']['variant']] as $tagName => $value)
                        {
                            $path = AmazonXSD_Tools::searchPath($productInstance, $tagName, $referenceElement);

                            if ($path)
                                $profiles['parameters'][$id][$tagName] = $path;
                        }
                    }

                    $price_rule = $profiles['price_rule'][$id] ; 
                    
                    if ( isset($price_rule) && is_array($price_rule) && isset($price_rule['rule']['from']) && is_array($price_rule['rule']['from']) && is_array($price_rule['rule']['to']) )
                    {
                        foreach( $price_rule['rule']['from'] as $index => $val )
                        {
                            if ( ! is_numeric($val) )
                            {
                                unset($price_rule['rule']['from'][$index]) ;
                                unset($price_rule['rule']['to'][$index]) ;
                                unset($price_rule['rule']['percent'][$index]) ;
                                unset($price_rule['rule']['value'][$index]) ;
                            }
                        }
                        
                        if ( count($price_rule['rule']['from']) )
                        {
                            $price_rule['rule']['from'] = array_values($price_rule['rule']['from']) ;
                            $price_rule['rule']['to'] = array_values($price_rule['rule']['to']) ;
                            $price_rule['rule']['percent'] = array_values($price_rule['rule']['percent']) ;
                            $price_rule['rule']['value'] = array_values($price_rule['rule']['value']);
                        }
                        
                        $profiles['price_rule'][$id] = null ;
                        
                        if ( isset($price_rule['rule']['from']) && is_array($price_rule['rule']['from']) && count($price_rule['rule']['from']) && is_numeric(max($price_rule['rule']['from'])) )
                            $profiles['price_rule'][$id] = $price_rule ;
                    }                    
                    
                    $profiles['category'][$id] = $category;
                }
                catch (Exception $e)
                {
                    $this->_postErrors[] = $this->l('Amazon XSD Exception :') . $e->getMessage();
                }
            }

        if ($profiles && is_array($profiles) && count($profiles))
        {
            Db::getInstance()->Execute('REPLACE INTO `' . _DB_PREFIX_ . 'marketplace_configuration`
                    (`marketplace`, `configuration`, `value`) VALUES ("' . pSQL(self::marketplace) . '", "profiles", "' . pSQL(base64_encode(serialize($profiles))) . '"); ');
        }
    }

    public static function loadProfiles()
    {
        $tables = array();
        $result = Db::getInstance()->ExecuteS('SHOW TABLES LIKE "' . _DB_PREFIX_ . 'marketplace_configuration"');

        if (is_array($result) && count($result))
            $result = Db::getInstance()->getRow('SELECT `value` FROM `' . _DB_PREFIX_ . 'marketplace_configuration` WHERE `marketplace` = "' . pSQL(self::marketplace) . '" AND `configuration`="profiles"');
        else
            $result = null;

        // New Method
        if (isset($result['value']))
        {
            return( unserialize(base64_decode($result['value'])) );
        }
        else // Old Method
        {
            return( unserialize(base64_decode(self::configurationGet('AMAZON_PROFILES'))) );
        }
    }

    // New function (2013-03) to handle the configuration content
    //
    private function _loadSettings()
    {
        // General Settings
        //
        if (($taxconf = unserialize(base64_decode(self::configurationGet('AMAZON_TAXES')))) === false)
            $this->config['taxes'] = true;
        elseif ($taxconf == true)
            $this->config['taxes'] = true;
        else
            $this->config['taxes'] = 0 ;

        // Price Formula and Callback
        //
        $this->config['out_of_stock'] = unserialize(base64_decode(self::configurationGet('AMAZON_OUT_OF_STOCK')));
        $this->config['formula'] = unserialize(base64_decode(self::configurationGet('AMAZON_PRICE_FORMULA')));
        $this->config['price_rule'] = unserialize(base64_decode(self::configurationGet('AMAZON_PRICE_RULE')));
        $this->config['callback'] = unserialize(base64_decode(self::configurationGet('AMAZON_PRICE_CALLBACK')));
        $this->config['rounding'] = unserialize(base64_decode(self::configurationGet('AMAZON_PRICE_ROUNDING')));
        $this->config['asin_has_priority'] = unserialize(base64_decode(self::configurationGet('AMAZON_USE_ASIN')));

        // Carrier configuration table
        //
        $this->config['incoming_carrier_amazon'] = unserialize(base64_decode(self::configurationGet('AMAZON_AMAZON_CARRIER')));
        $this->config['incoming_carrier_prestashop'] = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER')));
        $this->config['outgoing_carrier'] = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER_DEFAULT')));
        $this->config['multichannel_carrier'] = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER_MULTICHANNEL')));

        // Shipping Overrides Settings
        //
        $this->config['shipping_override_std'] = unserialize(base64_decode(self::configurationGet('AMAZON_SHIPPING_OVERRIDES_STD')));
        $this->config['shipping_override_exp'] = unserialize(base64_decode(self::configurationGet('AMAZON_SHIPPING_OVERRIDES_EXP')));
        // Field for Synch
        //
        $this->config['synch_field'] = unserialize(base64_decode(self::configurationGet('AMAZON_FIELD')));


        $this->config['debug'] = unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG'))) ? true : false;
        $this->config['specials'] = unserialize(base64_decode(self::configurationGet('AMAZON_SPECIALS'))) ? true : false;
        $this->config['specials_apply_rules'] = (bool)self::configurationGet('AMAZON_SPECIALS_APPLY_RULES') ;
        $this->config['delete_products'] = unserialize(base64_decode(self::configurationGet('AMAZON_DELETE_PRODUCTS'))) ? true : false;
        $this->config['stocks_only'] = unserialize(base64_decode(self::configurationGet('AMAZON_STOCK_ONLY'))) ? true : false;
        $this->config['prices_only'] = self::configurationGet('AMAZON_PRICES_ONLY') ? true : false;
        $this->config['force_import'] = unserialize(base64_decode(self::configurationGet('AMAZON_FORCE_IMPORT'))) ? true : false;

        $this->config['title_format'] = unserialize(base64_decode(self::configurationGet('AMAZON_TITLE_FORMAT')));
        $this->config['account_type'] = unserialize(base64_decode(self::configurationGet('AMAZON_ACCOUNT_TYPE')));

        if (!$this->config['title_format'])
            $this->config['title_format'] = self::FormatTitle;

        if (!$this->config['account_type'])
            $this->config['account_type'] = self::AccounTypeIndividual;

        $this->config['condition_map'] = unserialize(base64_decode(self::configurationGet('AMAZON_CONDITION_MAP')));

        // Marketplace Settings
        //
        $this->config['actives'] = unserialize(base64_decode(self::configurationGet('AMAZON_ACTIVE')));
        $this->config['amazon_merchant_ids'] = unserialize(base64_decode(self::configurationGet('AMAZON_MERCHANT_ID')));
        $this->config['amazon_marketplace_ids'] = unserialize(base64_decode(self::configurationGet('AMAZON_MARKETPLACE_ID')));
        $this->config['amazon_key_ids'] = unserialize(base64_decode(self::configurationGet('AMAZON_AWS_KEY_ID')));
        $this->config['amazon_secret_ids'] = unserialize(base64_decode(self::configurationGet('AMAZON_SECRET_KEY')));

        $this->config['amazon_europe'] = (bool) unserialize(base64_decode(self::configurationGet('AMAZON_EUROPE')));
        $this->config['marketplace_master'] = unserialize(base64_decode(self::configurationGet('AMAZON_MASTER')));

        $this->config['regions'] = unserialize(base64_decode(self::configurationGet('AMAZON_REGION')));
        $this->config['currencies'] = unserialize(base64_decode(self::configurationGet('AMAZON_CURRENCY')));

        if ( is_array($this->config['regions']) && in_array('us', $this->config['regions']) )
                $this->config['amazon_us'] = true ;
        else    $this->config['amazon_us'] = false ;
        
        if ( is_array($this->config['regions']) && in_array('in', $this->config['regions']) )
                $this->config['amazon_in'] = true ;
        else    $this->config['amazon_in'] = false ;
        
        // Security
        //
        $this->config['tokens'] = unserialize(base64_decode(self::configurationGet('AMAZON_CRON_TOKEN')));

        // Mappings
        //
        $attributes_mapping_left = unserialize(base64_decode(self::configurationGet('AMAZON_ATTRIBUTES_MAPPING_L')));
        $attributes_mapping_right = unserialize(base64_decode(self::configurationGet('AMAZON_ATTRIBUTES_MAPPING_R')));

        $features_mapping_left = unserialize(base64_decode(self::configurationGet('AMAZON_FEATURES_MAPPING_L')));
        $features_mapping_right = unserialize(base64_decode(self::configurationGet('AMAZON_FEATURES_MAPPING_R')));
        
        if ( is_array($attributes_mapping_left) && is_array($attributes_mapping_right) )
        {
            $this->config['attributes_mapping_left'] = $attributes_mapping_left ;
            $this->config['attributes_mapping_right'] = $attributes_mapping_right ;
        }
        else
        {
            $this->config['attributes_mapping_left'] = null ;
            $this->config['attributes_mapping_right'] = null ;
        }
        
        if ( is_array($features_mapping_left) && is_array($features_mapping_right) )
        {
            $this->config['features_mapping_left'] = $features_mapping_left ;
            $this->config['features_mapping_right'] = $features_mapping_right ;
        }
        else
        {
            $this->config['features_mapping_left'] = null ;
            $this->config['features_mapping_right'] = null ;
        }   

        // Orders States
        //
        $this->config['order_state'] = unserialize(base64_decode(self::configurationGet('AMAZON_ORDER_STATE')));
        $this->config['preparation_state'] = unserialize(base64_decode(self::configurationGet('AMAZON_PREPARATION_STATE')));
        $this->config['send_state'] = unserialize(base64_decode(self::configurationGet('AMAZON_SENT_STATE')));

        if ($this->config['order_state'] === false)
            $this->config['order_state'] = defined('_PS_OS_PAYMENT_') ? _PS_OS_PREPARATION_ : (int) Configuration::get('PS_OS_PAYMENT');
        if ($this->config['preparation_state'] === false)
            $this->config['preparation_state'] = defined('_PS_OS_PREPARATION_') ? _PS_OS_PREPARATION_ : (int) Configuration::get('PS_OS_PREPARATION');
        if ($this->config['send_state'] === false)
            $this->config['send_state'] = defined('_PS_OS_SHIPPING_') ? _PS_OS_SHIPPING_ : (int) Configuration::get('PS_OS_SHIPPING');

        // FBA Settings
        //
        $this->config['fba_order_state'] = self::configurationGet('AMAZON_FBA_ORDER_STATE');
        $this->config['fba_preparation_state'] = self::configurationGet('AMAZON_FBA_PREPARATION_STATE');
        $this->config['fba_send_state'] = self::configurationGet('AMAZON_FBA_SENT_STATE');
        $this->config['fba_multichannel_state'] = self::configurationGet('AMAZON_FBA_MULTICHANNEL_STATE');
        $this->config['fba_multichannel_sent_state'] = self::configurationGet('AMAZON_FBA_MULTICHANNEL_SENT');

        $this->config['fba_formula'] = unserialize(base64_decode(self::configurationGet('AMAZON_FBA_PRICE_FORMULA')));
        $this->config['fba_multichannel'] = (bool) self::configurationGet('AMAZON_FBA_MULTICHANNEL');
        $this->config['fba_multichannel_auto'] = (bool) self::configurationGet('AMAZON_FBA_MULTICHANNEL_AUTO');

        if ($this->config['order_state'] === false)
            $this->config['fba_order_state'] = $this->config['order_state'];
        if ($this->config['fba_preparation_state'] === false)
            $this->config['fba_preparation_state'] = $this->config['preparation_state'];
        if ($this->config['fba_send_state'] === false)
            $this->config['fba_send_state'] = $this->config['send_state'];

        // PS 1.5 - Warehouse for Advanced stock management
        //
        $this->config['warehouse'] = self::configurationGet('AMAZON_WAREHOUSE');

        // Shop
        //
        $this->config['shop'] = self::configurationGet('AMAZON_SHOP');

        if (!$this->config['shop'])
            $this->config['shop'] = 1;

        $this->config['employee'] = self::configurationGet('AMAZON_EMPLOYEE');

        if (!$this->config['employee'])
            $this->config['employee'] = 1;

        if (version_compare(_PS_VERSION_, '1.5', '>='))
            Shop::setContext(Shop::CONTEXT_SHOP, (int) $this->config['shop']);

        $this->config['dummy'] = self::configurationGet('AMAZON_DUMMY');
        $this->config['dummy_product'] = self::configurationGet('AMAZON_DUMMY_PRODUCT');
        $this->config['image_type'] = self::configurationGet('AMAZON_IMAGE_TYPE');
        $this->config['safe_encoding'] = self::configurationGet('AMAZON_SAFE_ENCODING');

        $this->config['description_field'] = self::configurationGet('AMAZON_DESCRIPTION_FIELD');
        $this->config['FBA'] = (bool) self::configurationGet('AMAZON_FBA');
        $this->config['wozapi'] = (bool) self::configurationGet('AMAZON_WOZAPI');
        $this->config['bulk_mode'] = (bool) self::configurationGet('AMAZON_BULK_MODE');
        $this->config['html_descriptions'] = (bool) self::configurationGet('AMAZON_HTML_DESCRIPTIONS');

        // Hidden Settings
        $this->config['expert_mode'] = (bool) self::configurationGet('AMAZON_HIDDEN_SETTINGS');
        $this->config['payment_region'] = self::configurationGet('AMAZON_PAYMENT_REGION');

        // Filters
        $this->config['excluded_manufacturers'] = unserialize(base64_decode(self::configurationGet('AMAZON_EXCLUDED_MANUFACTURERS')));
        $this->config['excluded_suppliers'] = unserialize(base64_decode(self::configurationGet('AMAZON_EXCLUDED_SUPPLIERS')));
        $this->config['price_filter'] = unserialize(base64_decode(self::configurationGet('AMAZON_PRICE_FILTER')));
        
        // Email Notification
        $this->config['email'] = (bool) self::configurationGet('AMAZON_EMAIL');

        $this->config['mail_invoice'] = unserialize(base64_decode(self::configurationGet('AMAZON_MAIL_INVOICE')));
        $this->config['mail_review'] = unserialize(base64_decode(self::configurationGet('AMAZON_MAIL_REVIEW')));

        $this->profiles = $this->loadProfiles();
    }

    public function geoFlag($id_lang)
    {
        if (isset($this->config) && isset($this->config['regions'][$id_lang]) && $this->config['regions'][$id_lang])
        {
            $region = $this->config['regions'][$id_lang];
        }
        elseif ($id_lang)
        {
            $region = Language::getIsoById($id_lang);
        }

        if (!$region)
            $region = 'na';

        return($region);
    }

    public function versionCheck()
    {
        $currentVersion = self::configurationGet('AMAZON_CURRENT_VERSION');

        if ((int) $currentVersion)
        {
            if (version_compare($this->version, $currentVersion, '>'))
            {
                $this->_html .= sprintf('<div class="conf confirm ' . ($this->psIs16x ? 'alert alert-success' : '') . '" style="font-weight:bold">'
                        . $this->l('Module Update: Your version will be auto-updated from %s to %s after configuration changes') . '<br />'
                        . $this->l('Please verify again your settings. Please clear your Smarty and Browser caches...') .
                        '</div>', $currentVersion, $this->version);

                return(true); // changes 
            }
        }
        elseif ($currentVersion == null)
        {
            $this->_html .= '
                    <div style="display:block;font-size:1.2em;position:relative;" class="hint ' . ($this->psIs16x ? 'alert alert-info' : '') . '">
                    <ul>
                        <li>' . $this->l('Be effective, do not waste your time :') . '</li>
                        <li>' . $this->l('For beginning, Supposing you have basis knowledge on it, please use basis functions') . '</li>
                        <li>' . $this->l('Do not try to hard tune the module. Almost all parameters are correctly configured by default.') . '</li>
                      </ul>
                    </div>
                    <br />';
        }
        return(false);
    }

    public function getContent()
    {
        $this->context->smarty->caching = false;
        $this->context->smarty->force_compile = true;

        $this->_html .= $this->_autoAddJS($this->url . 'js/amazon-001.js');
        $this->_html .= $this->_autoAddJS($this->url . 'js/amazon-profile-001.js');
        if ($this->psIs16x)
            $this->_html .= $this->_autoAddCSS($this->url . 'css/amazon16.css');
        else
            $this->_html .= $this->_autoAddCSS($this->url . 'css/amazon.css');

        $this->versionCheck();

        // Actions from Tools Menu
        //
        if (Tools::isSubmit('tools_code_import_submit'))
        {
            $this->_tools_code_import();
        }

        // Action from Configuration
        //
        if (Tools::isSubmit('submit'))
        {
            $this->_postValidation();

            $this->_postProcess();
        }

        $this->_displayForm();

        return $this->_html;
    }

    private function _displayForm()
    {
        $this->_loadSettings();

        if ( $this->config['debug'] )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);               
        }
        
        $view_params = array();
        $view_params['header']['description'] = $this->description;
        $view_params['header']['documentation'] = Amazon_Tools::documentation($this->id_lang);
        $view_params['header']['faq'] = Amazon_Tools::documentation($this->id_lang, 'faq');
        $view_params['header']['images_url'] = $this->images;
        $view_params['header']['version'] = $this->version;

        $view_params['header']['debug'] = unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG')));
        $view_params['header']['debug_content'] = sprintf('Memory Peak: %.02f MB', memory_get_peak_usage() / 1024 / 1024);

        $view_params['header']['error'] = false;
        $view_params['header']['warning'] = false;

        if (sizeof($this->_postErrors))
        {
            $view_params['header']['error'] = true;
            $view_params['header']['error_content'] = null;

            foreach ($this->_postErrors AS $err)
                $view_params['header']['error_content'] .= $err . '<br />';
        }

        if ($this->warning)
        {
            $view_params['header']['warning'] = true;
            $view_params['header']['warning_content'] = $this->warning;
        }

        $this->context->smarty->assign($view_params);
        $this->context->smarty->assign('psIs16', $this->psIs16x);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_HEADER]);

        $this->_tabs();

        $this->_content();

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_LICENSE]);
    }

    private function _selected_tab()
    {
        return( ($selected_tab = Tools::getValue('selected_tab')) ? $selected_tab : 'informations' );
    }

    // Tabs
    //
    private function _tabs()
    {
        $selected_tab = $this->_selected_tab();

        $view_params = array();
        $view_params['tabs'] = array();
        $view_params['tabs']['images_url'] = $this->images;
        $view_params['tabs']['informations'] = $this->l('Informations');
        $view_params['tabs']['informations_selected'] = ($selected_tab == 'informations' ? 'selected' : '');

        $view_params['tabs']['platforms'] = array();

        foreach (Amazon_Tools::languages() as $language)
        {
            $index = $language['iso_code'];
            $view_params['tabs']['platforms'][$index]['iso_code'] = $index;
            $view_params['tabs']['platforms'][$index]['name_short'] = preg_replace('/ .*/', '', $language['name']);
            $view_params['tabs']['platforms'][$index]['name_long'] = $language['name'];
            $view_params['tabs']['platforms'][$index]['selected'] = ($selected_tab == $language['iso_code'] ? 'selected' : '');
            $view_params['tabs']['platforms'][$index]['geo_flag'] = $this->geoFlag($language['id_lang']);
        }

        $view_params['tabs']['parameters'] = $this->l('Parameters');
        $view_params['tabs']['parameters_selected'] = ($selected_tab == 'parameters' ? 'selected' : '');

        $view_params['tabs']['categories'] = $this->l('Categories');
        $view_params['tabs']['categories_selected'] = ($selected_tab == 'categories' ? 'selected' : '');

        $view_params['tabs']['profiles'] = $this->l('Profiles');
        $view_params['tabs']['profiles_selected'] = ($selected_tab == 'profiles' ? 'selected' : '');

        $view_params['tabs']['mapping'] = $this->l('Mappings');
        $view_params['tabs']['mapping_selected'] = ($selected_tab == 'mapping' ? 'selected' : '');

        $view_params['tabs']['filters'] = $this->l('Filters');
        $view_params['tabs']['filters_selected'] = ($selected_tab == 'filters' ? 'selected' : '');

        $view_params['tabs']['messaging'] = $this->l('Messaging');
        $view_params['tabs']['messaging_selected'] = ($selected_tab == 'messaging' ? 'selected' : '');

        if ($this->config['FBA'])
        {
            $view_params['tabs']['fba'] = $this->l('Amazon FBA');
            $view_params['tabs']['fba_selected'] = ($selected_tab == 'fba' ? 'selected' : '');
        }

        $view_params['tabs']['tools'] = $this->l('Tools');
        $view_params['tabs']['tools_selected'] = ($selected_tab == 'tools' ? 'selected' : '');

        $view_params['tabs']['cron'] = $this->l('Scheduled Tasks');
        $view_params['tabs']['cron_selected'] = ($selected_tab == 'cron' ? 'selected' : '');

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TABS]);
    }

    // Tabs content
    //
    private function _content()
    {
        $selected_tab = $this->_selected_tab();
        $view_params = array();

        // Langue Active
        //
        $actives = $this->config['actives'];


        $this->_html .= '
        <fieldset>
        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post" autocomplete="off" id="amazon_form">
        <input type="hidden" name="selected_tab" value="' . $selected_tab . '" />
        <input type="hidden" id="id_lang" value="' . $this->id_lang . '" />
        <input type="hidden" id="check_url" value="' . $this->url . 'functions/check.php' . '" />
        <input type="hidden" id="check_msg_region" value="' . $this->l('You must select a platform before') . '" />
        <input type="hidden" id="check_msg_currency" value="' . $this->l('You must select a currency before') . '" />
        ';

        $this->_html .= '
        <div class="cleaner"></div>
        <!-- div tabList -->
        <div id="tabList">';

        // Informations Tab Content
        //
        $this->_informations($view_params);

        // Marketplaces Tabs Content
        //
        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'];

            $this->_marketplace_tab($view_params, $id_lang);
        }
        
        // echo '<pre>' . print_r($view_params['settings']['general']['config'], true) . '</pre>';

        // Parameters Tab Content
        //
        $this->_parameters($view_params);


        // Categories Tab
        //
        $default_categories = unserialize(base64_decode(self::configurationGet('AMAZON_CATEGORIES')));
        $brute_force = unserialize(base64_decode(self::configurationGet('AMAZON_BRUTE_FORCE')));
        $default_profiles2categories = unserialize(base64_decode(self::configurationGet('AMAZON_PROFILES_CATEGORIES')));

        $this->_categories($default_categories, $default_profiles2categories, $brute_force);

        // Profiles
        //
        $this->_profiles($view_params);

        // Mappings
        //
        $this->_mapping($view_params);

        //
        // Render Smarty
        //
        
        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_INFO]);
        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_SETTINGS]);
        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_PARAMETERS]);
        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_MAPPING]);
        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_PROFILES]);
        
        // Filters
        //
        $this->_filters();

        // Messaging
        //
        $this->_messaging();

        // FBA if active
        //
        if ($this->config['FBA'])
        {
            $this->_fba();
        }

        // Terminate the configuration form
        //
        $this->_html .= '</form>';

        // Tools
        //
        $this->_tools();

        // Crons
        //
        $this->_cron();

        $this->_html .= '
             </div><!-- div tabList end -->
             </fieldset>';

        // Footer
        //
        $footer_params = array();
        $footer_params['footer']['text_footer'] = $this->l('These informations are provided by The Amazon Market Place please go to the following url to subscribe to these services');

        $this->context->smarty->assign($footer_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_FOOTER]);
    }
    
    //
    // Validation button
    //
    private function _validate($returnHTML = false)
    {
        static $validate = null;

        if ($validate === null)
            $validate = $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_VALIDATE]);

        if ($returnHTML)
            return($validate);

        $this->_html .= $validate;
    }

    // Marketplace Tab
    // 
    private function _marketplace_tab(&$view_params, $id_lang)
    {
        $selected_tab = $this->_selected_tab();

        // Langue Active
        //
        $actives = $this->config['actives'];

        // Locales
        //
        $regions = $this->config['regions'];
        $currencies = $this->config['currencies'];
        $selected_currency = isset($currencies[$id_lang]) ? $currencies[$id_lang] : null;
        
        $active = isset($actives[$id_lang]) ? intval($actives[$id_lang]) : '';
        $region = isset($regions[$id_lang]) ? $regions[$id_lang] : null;
        
        $currency_tab = Currency::getCurrencies() ;
        $current_currency = null ;
        
        if ( is_array($currency_tab) && count($currency_tab) && isset($this->config['currencies'][$id_lang]) )
            foreach($currency_tab as $currency)
                if ( $currency['iso_code'] == $this->config['currencies'][$id_lang] || $selected_currency == $currency['iso_code'] )
                    $current_currency = $currency ;

        $synch_field = null ;
        
        // Carriers
        $incoming_carrier_amazon = isset($this->config['incoming_carrier_amazon'][$id_lang]) ? $this->config['incoming_carrier_amazon'][$id_lang] : array(null);
        $incoming_carrier_prestashop = isset($this->config['incoming_carrier_prestashop'][$id_lang]) ? $this->config['incoming_carrier_prestashop'][$id_lang] : array(null);
        $outgoing_carriers = isset($this->config['outgoing_carrier'][$id_lang]['prestashop']) && is_array($this->config['outgoing_carrier'][$id_lang]['prestashop']) ? $this->config['outgoing_carrier'][$id_lang] : array('prestashop' => array(null));
        
        if ( $this->config['actives'] == null || ! isset($this->config['actives'][$id_lang]) || ! (int)$this->config['actives'][$id_lang] )
        {
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.preconfiguration.class.php');
            
            if ( ($preconfiguration = Amazon_Preconfiguration::data($id_lang)) )
            {
                $active = true ;
                $region = $preconfiguration['region'] ;
                $selected_currency = $preconfiguration['currency'] ;
                $incoming_carrier_amazon = $preconfiguration['amazon_incoming_carrier'] ;
                $incoming_carrier_prestashop = $preconfiguration['prestashop_incoming_carrier'] ;
                $outgoing_carriers = $preconfiguration['outgoing_carriers'] ;
                $synch_field = $preconfiguration['synchronization_field'] ;
            }
        }
        // First Initialization
        //
        if (!isset($view_params['settings']) || !is_array($view_params['settings']))
        {
            $view_params['settings'] = array();
            $view_params['settings']['images_url'] = $this->images;

            $view_params['settings']['validate'] = array();

            $view_params['settings']['locales'] = array();
            $view_params['settings']['locales']['config'] = array();
            $view_params['settings']['locales']['platforms'] = $this->_platforms;
            $view_params['settings']['locales']['currencies'] = $currency_tab ;
            $view_params['settings']['locales']['selected_tab'] = $selected_tab;

            $view_params['settings']['marketplace'] = array();
            $view_params['settings']['marketplace']['config'] = array();

            $view_params['settings']['general'] = array();
            $view_params['settings']['general']['config'] = array();
            $view_params['settings']['general']['expert_mode'] = (bool) $this->config['expert_mode'];

            $view_params['settings']['carriers'] = array();
            $view_params['settings']['carriers']['config'] = array();
            $view_params['settings']['carriers']['config']['incoming'] = array();
            $view_params['settings']['carriers']['config']['outgoing'] = array();
            $view_params['settings']['carriers']['config']['fba_multichannel'] = array();
            $view_params['settings']['carriers']['fba_multichannel'] = (bool) $this->config['fba_multichannel'];

            $view_params['settings']['overrides'] = array();
            $view_params['settings']['overrides']['standard'] = array();
            $view_params['settings']['overrides']['express'] = array();
        }

        $language = new Language($id_lang);

        if (!Validate::isLoadedObject($language))
            return($view_params);

        // Amazon API Configuration
        //
        $merchantId = isset($this->config['amazon_merchant_ids'][$id_lang]) ? trim($this->config['amazon_merchant_ids'][$id_lang]) : '';
        $awsKeyId = isset($this->config['amazon_key_ids'][$id_lang]) ? trim($this->config['amazon_key_ids'][$id_lang]) : '';
        $awsSecretKey = isset($this->config['amazon_secret_ids'][$id_lang]) ? trim($this->config['amazon_secret_ids'][$id_lang]) : '';

        $carriers = Carrier::getCarriers($id_lang);

        // Locales
        //
        $view_params['settings']['locales']['config'][$id_lang]['iso_code'] = $language->iso_code;
        $view_params['settings']['locales']['config'][$id_lang]['region'] = $region;
        $view_params['settings']['locales']['config'][$id_lang]['currency'] = $selected_currency ;
        $view_params['settings']['locales']['config'][$id_lang]['platform_selected'] = null;

        if (isset($this->_platforms[$region]))
            $view_params['settings']['locales']['config'][$id_lang]['platform_selected'] = $region;
        else
            $view_params['settings']['locales']['config'][$id_lang]['platform_selected'] = null;

        // Marketplace Settings
        //
        if ($this->config['amazon_europe'] && $this->config['marketplace_master'] == $region)
            $masterPlatform = true;
        else
            $masterPlatform = false;

        if ($this->config['amazon_europe'] && !$masterPlatform && (Amazon_Tools::isEurope($region) || $region == 'uk'))
        {
            $display = 'display:none;';
            $disabled = 'disabled';
        }
        else
        {
            $display = '';
            $disabled = '';
        }

        $view_params['settings']['marketplace']['config'][$id_lang]['region'] = $region;
        $view_params['settings']['marketplace']['config'][$id_lang]['merchantId'] = $merchantId ? $merchantId : ' ' ; // space to avoid form autocomplete
        $view_params['settings']['marketplace']['config'][$id_lang]['marketPlaceId'] = Amazon_Tools::lang2MarketplaceId($region);
        $view_params['settings']['marketplace']['config'][$id_lang]['awsKeyId'] = $awsKeyId ? $awsKeyId : ' ' ; // space to avoid form autocomplete
        $view_params['settings']['marketplace']['config'][$id_lang]['awsSecretKey'] = $awsSecretKey ;

        $view_params['settings']['marketplace']['config'][$id_lang]['active'] = $active;
        $view_params['settings']['marketplace']['config'][$id_lang]['display'] = $display;
        $view_params['settings']['marketplace']['config'][$id_lang]['disabled'] = $disabled;
        $view_params['settings']['marketplace']['config'][$id_lang]['domain'] = Amazon_Tools::idToDomain($id_lang);
        $view_params['settings']['marketplace']['config'][$id_lang]['flag'] = '<img src="' . $this->images . 'geo_flags/' . $this->geoFlag($id_lang) . '.gif" alt="' . $language->name . '" />';


        if (isset($this->config['out_of_stock'][$id_lang]) && is_array($this->config['out_of_stock']) && $this->config['out_of_stock'][$id_lang])
            $out_of_stock = $this->config['out_of_stock'][$id_lang];
        else
            $out_of_stock = '0';

        if (isset($this->config['formula'][$id_lang]) && is_array($this->config['formula']) && $this->config['formula'][$id_lang])
            $formula = $this->config['formula'][$id_lang];
        else
            $formula = '@';

        if (isset($this->config['callback'][$id_lang]) && is_array($this->config['callback']) && $this->config['callback'][$id_lang])
            $callback = $this->config['callback'][$id_lang];
        else
            $callback = '';

        if (isset($this->config['rounding']) && isset($this->config['rounding'][$id_lang]) && $this->config['rounding'][$id_lang])
            $rounding = $this->config['rounding'][$id_lang];
        else
            $rounding = '1';

        if (isset($this->config['synch_field'][$id_lang]) && is_array($this->config['synch_field']) && $this->config['synch_field'][$id_lang])
            $synch_field = $this->config['synch_field'][$id_lang];
        elseif ( ! $synch_field )
            $synch_field = 'ean13';

        if (isset($this->config['asin_has_priority'][$id_lang]) && is_array($this->config['asin_has_priority']) && $this->config['asin_has_priority'][$id_lang])
            $asin_has_priority = $this->config['synch_field'][$id_lang];
        else
            $asin_has_priority = true;

        $view_params['settings']['general']['config'][$id_lang] = array();
        $view_params['settings']['general']['config'][$id_lang]['out_of_stock'] = $out_of_stock;
        $view_params['settings']['general']['config'][$id_lang]['formula'] = $formula;
        $view_params['settings']['general']['config'][$id_lang]['callback'] = $callback;
        
        $view_params['settings']['general']['config'][$id_lang]['price_rule'] = array() ;
        $view_params['settings']['general']['config'][$id_lang]['price_rule']['currency_sign'] = isset($current_currency['sign']) ? $current_currency['sign'] : null ;

        $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['from'] = array(null) ;
        $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['to'] = array(null) ;
        $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['percent'] = array(null) ;
        $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['value'] = array(null) ;        
        $view_params['settings']['general']['config'][$id_lang]['price_rule']['type'] = 'percent' ;
        
        if (isset($this->config['price_rule'][$id_lang]) && isset($this->config['price_rule'][$id_lang]['type']) && $this->config['price_rule'][$id_lang]['type'])
        {
            $view_params['settings']['general']['config'][$id_lang]['price_rule']['type'] = $this->config['price_rule'][$id_lang]['type'] ;  

            if (isset($this->config['price_rule'][$id_lang]['rule']['from']) && is_array($this->config['price_rule'][$id_lang]['rule']['from']) && 
                    isset($this->config['price_rule'][$id_lang]['rule']['to']) && is_array($this->config['price_rule'][$id_lang]['rule']['to']) )
            {
                $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule'] = $this->config['price_rule'][$id_lang]['rule'];
                if (!count($this->config['price_rule'][$id_lang]['rule']['from']) && !count($this->config['price_rule'][$id_lang]['rule']['to']) && !count($this->config['price_rule'][$id_lang]['rule']['value']))
                {
                    $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['from'][0] = '';
                    $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['to'][0] = '';
                    $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['percent'][0] = '';
                    $view_params['settings']['general']['config'][$id_lang]['price_rule']['rule']['value'][0] = '';
                }
            }
        }

        $view_params['settings']['general']['config'][$id_lang]['rounding_1'] = ($rounding == 1 ? 'checked' : '');
        $view_params['settings']['general']['config'][$id_lang]['rounding_2'] = ($rounding == 2 ? 'checked' : '');

        $view_params['settings']['general']['config'][$id_lang]['synch_field_ean13'] = ($synch_field == 'ean13' ? 'selected' : '');
        $view_params['settings']['general']['config'][$id_lang]['synch_field_upc'] = ($synch_field == 'upc' ? 'selected' : '');
        $view_params['settings']['general']['config'][$id_lang]['synch_field_both'] = ($synch_field == 'both' ? 'selected' : '');
        $view_params['settings']['general']['config'][$id_lang]['synch_field_reference'] = ($synch_field == 'reference' ? 'selected' : '');

        $view_params['settings']['general']['config'][$id_lang]['asin_has_priority'] = $asin_has_priority;

        $amazon_carrier_list = array_merge($this->shipping_overrides_std, $this->shipping_overrides_exp);

        $view_params['settings']['carriers']['config']['incoming'][$id_lang] = array();

        for ($index = 0; $index < count($incoming_carrier_amazon); $index++)
        {
            if ($index && !$incoming_carrier_amazon[$index] && $incoming_carrier_amazon[$index] !== null)
                continue;

            $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index] = array();
            $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['display_add'] = ($index > 0 ? 'style="display:none"' : '');
            $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['display_del'] = ($index == 0 ? 'style="display:none"' : '');

            foreach ($amazon_carrier_list as $carrier)
            {
                $key = md5($carrier);
                $selected = isset($incoming_carrier_amazon[$index]) && $key == $incoming_carrier_amazon[$index] ? true : false;

                $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['amazon_carrier'][$key]['selected'] = $selected;
                $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['amazon_carrier'][$key]['name'] = $carrier;
            }

            foreach ($carriers as $carrier)
            {
                $id_carrier = (int) $carrier['id_carrier'];
                $selected = isset($incoming_carrier_prestashop[$index]) && (int) $incoming_carrier_prestashop[$index] == $id_carrier ? true : false;

                $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['selected'] = $selected;
                $view_params['settings']['carriers']['config']['incoming'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['name'] = $carrier['name'];
            }
        }

        // Carriers Associations for outgoing orders
        //
        $view_params['settings']['carriers']['config']['outgoing'][$id_lang] = array();

        $amazon_carriers = array_merge(Amazon_Carrier::$carrier_codes, Amazon_Carrier::$extra_carrier_codes);
        asort($amazon_carriers);

        

        for ($index = 0; $index < count($outgoing_carriers['prestashop']); $index++)
        {
            if ($index && !$outgoing_carriers['prestashop'][$index] && $outgoing_carriers['prestashop'][$index] !== null)
                continue;

            $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index] = array();
            $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['display_add'] = ($index > 0 ? 'style="display:none"' : '');
            $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['display_del'] = ($index == 0 ? 'style="display:none"' : '');

            foreach ($carriers as $carrier)
            {
                $id_carrier = (int) $carrier['id_carrier'];
                $selected = isset($outgoing_carriers['prestashop'][$index]) && intval($outgoing_carriers['prestashop'][$index] == $id_carrier) ? true : false;

                $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['selected'] = $selected;
                $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['name'] = $carrier['name'];
            }

            foreach ($amazon_carriers as $carrier)
            {
                if (isset($outgoing_carriers['amazon'][$index]) && $carrier == $outgoing_carriers['amazon'][$index])
                    $selected = true;
                else
                    $selected = false;

                $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['amazon_carrier'][$carrier]['selected'] = $selected;
                $view_params['settings']['carriers']['config']['outgoing'][$id_lang][$index]['amazon_carrier'][$carrier]['name'] = $carrier;
            }
        }

        // FBA Multi Channel Carriers Associations for outgoing orders
        //            
        $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang] = array();

        $carrier_multichannel = isset($this->config['multichannel_carrier'][$id_lang]['prestashop']) && is_array($this->config['multichannel_carrier'][$id_lang]['prestashop']) ? $this->config['multichannel_carrier'][$id_lang] : array('prestashop' => array(null));

        if ($this->config['fba_multichannel'])
        {
            for ($index = 0; $index < count($carrier_multichannel['prestashop']); $index++)
            {
                if ($index && !$carrier_multichannel['prestashop'][$index] && $carrier_multichannel['prestashop'][$index] !== null)
                    continue;

                $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index] = array();
                $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['display_add'] = ($index > 0 ? 'style="display:none"' : '');
                $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['display_del'] = ($index == 0 ? 'style="display:none"' : '');

                foreach ($carriers as $carrier)
                {
                    $id_carrier = (int) $carrier['id_carrier'];

                    $selected = isset($carrier_multichannel['prestashop'][$index]) && $carrier_multichannel['prestashop'][$index] == $id_carrier ? true : false;

                    $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['selected'] = $selected;
                    $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['prestashop_carrier'][$id_carrier]['name'] = $carrier['name'];
                }

                foreach ($this->carrier_fba as $carrier)
                {
                    $selected = isset($carrier_multichannel['amazon']) && isset($carrier_multichannel['amazon'][$index]) && $carrier == $carrier_multichannel['amazon'][$index] ? true : false;

                    $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['amazon_carrier'][$carrier]['selected'] = $selected;
                    $view_params['settings']['carriers']['config']['fba_multichannel'][$id_lang][$index]['amazon_carrier'][$carrier]['name'] = $carrier;
                }
            }
        } // End of FBA Multi Channel Carrier Mapping

        $selected_override_std = isset($this->config['shipping_override_std'][$id_lang]) ? $this->config['shipping_override_std'][$id_lang] : array(null);
        $selected_override_exp = isset($this->config['shipping_override_exp'][$id_lang]) ? $this->config['shipping_override_exp'][$id_lang] : array(null);

        $view_params['settings']['overrides']['standard'][$id_lang] = array();
        $view_params['settings']['overrides']['express'][$id_lang] = array();

        foreach ($this->shipping_overrides_std as $override)
        {
            $selected = ($override && $override == $selected_override_std) ? true : false;

            $view_params['settings']['overrides']['standard'][$id_lang][$override]['name'] = $override;
            $view_params['settings']['overrides']['standard'][$id_lang][$override]['selected'] = $selected;
        }

        foreach ($this->shipping_overrides_exp as $override)
        {
            $selected = ($override && $override == $selected_override_exp) ? true : false;

            $view_params['settings']['overrides']['express'][$id_lang][$override]['name'] = $override;
            $view_params['settings']['overrides']['express'][$id_lang][$override]['selected'] = $selected;
        }

        // Validate Button
        //
        $view_params['settings']['validate'][$id_lang] = $this->_validate(true);

        return($view_params);
    }


    private function _parameters(&$view_params)
    {
        $view_params['parameters'] = array();
        $view_params['parameters']['settings'] = array();

        $view_params['parameters']['images_url'] = $this->images;
        $view_params['parameters']['selected_tab'] = ($this->_selected_tab() == 'parameters' ? 'selected' : '');
        $view_params['parameters']['expert_mode'] = $this->config['expert_mode'];
        $view_params['parameters']['validation'] = $this->_validate(true);

        $view_params['parameters']['features'] = array();
        $view_params['parameters']['features']['fba'] = (bool) $this->config['FBA'];

        $view_params['parameters']['features']['wozapi'] = array();
        $view_params['parameters']['features']['wozapi']['active'] = (bool) $this->config['wozapi'];
        $view_params['parameters']['features']['wozapi']['documentation'] = null ;
        $view_params['parameters']['features']['wozapi']['token'] = null ;
        $view_params['parameters']['features']['wozapi']['url'] = null ;
        
        if ($this->config['wozapi'])
        {
            //
            // Wozapi Documentation
            //
            
            if (strtolower(Language::getIsoById(Configuration::get('PS_LANG_DEFAULT'))) == 'fr')
                $view_params['parameters']['features']['wozapi']['documentation'] = $this->url . 'documentation/wozapi-fr.pdf';
            else
                $view_params['parameters']['features']['wozapi']['documentation'] = null;

            //
            // Wozapi URL
            //
            
            $wozapi_token = self::configurationGet('AMAZON_WOZAPI_TOKEN');
            $wozapiUrl = 'http://' . Amazon_Tools::getHttpHost(false, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/functions/wozapi.php?action=export&wozapi_token=' . $wozapi_token;

            $view_params['parameters']['features']['wozapi']['token'] = $wozapi_token;
            $view_params['parameters']['features']['wozapi']['url'] = $wozapiUrl;
        }

        //
        // Options switches
        //
        
        $view_params['parameters']['settings']['discount'] = (bool) $this->config['specials'];
        $view_params['parameters']['settings']['specials_apply_rules'] = (bool) $this->config['specials_apply_rules'];
        $view_params['parameters']['settings']['taxes'] = (int) $this->config['taxes'];

        $view_params['parameters']['settings']['account_type_global_value'] = self::AccounTypeGlobal;
        $view_params['parameters']['settings']['account_type_individual_value'] = self::AccounTypeIndividual;

        $view_params['parameters']['settings']['account_type_global_selected'] = $this->config['account_type'] == self::AccounTypeGlobal ? true : false;
        $view_params['parameters']['settings']['account_type_individual_selected'] = $this->config['account_type'] == self::AccounTypeIndividual ? true : false;

        $view_params['parameters']['settings']['title_format_value_1'] = self::FormatTitle;
        $view_params['parameters']['settings']['title_format_value_2'] = self::FormatManufacturerTitle;
        $view_params['parameters']['settings']['title_format_value_3'] = self::FormatManufacturerTitleReference;

        $view_params['parameters']['settings']['title_format_selected_1'] = ($this->config['title_format'] == self::FormatTitle ? true : false);
        $view_params['parameters']['settings']['title_format_selected_2'] = ($this->config['title_format'] == self::FormatManufacturerTitle ? true : false);
        $view_params['parameters']['settings']['title_format_selected_3'] = ($this->config['title_format'] == self::FormatManufacturerTitleReference ? true : false);

        $view_params['parameters']['settings']['delete_products'] = (bool) $this->config['delete_products'];
        $view_params['parameters']['settings']['force_import'] = (bool) $this->config['force_import'];
        $view_params['parameters']['settings']['html_descriptions'] = (bool) $this->config['html_descriptions'];

        $view_params['parameters']['settings']['description_field_value_1'] = self::FieldDescriptionLong;
        $view_params['parameters']['settings']['description_field_value_2'] = self::FieldDescriptionShort;
        $view_params['parameters']['settings']['description_field_value_3'] = self::FieldDescriptionBoth;

        $view_params['parameters']['settings']['description_field_selected_1'] = ($this->config['description_field'] == self::FieldDescriptionLong ? true : false);
        $view_params['parameters']['settings']['description_field_selected_2'] = ($this->config['description_field'] == self::FieldDescriptionShort ? true : false);
        $view_params['parameters']['settings']['description_field_selected_3'] = ($this->config['description_field'] == self::FieldDescriptionBoth ? true : false);

        $view_params['parameters']['settings']['safe_encoding'] = (bool) $this->config['safe_encoding'];
        $view_params['parameters']['settings']['prices_only'] = (bool) $this->config['prices_only'];
        $view_params['parameters']['settings']['stock_only'] = (bool) $this->config['stocks_only'];
        $view_params['parameters']['settings']['payment_region'] = (bool) $this->config['payment_region'];

        $view_params['parameters']['settings']['dummy'] = (bool) $this->config['dummy'];
        $view_params['parameters']['settings']['dummy_display'] = (bool) $this->config['dummy'] ? 'block' : 'none';
        $view_params['parameters']['settings']['dummy_product'] = $this->config['dummy_product'];

        $view_params['parameters']['settings']['email'] = (bool) $this->config['email'];
        $view_params['parameters']['settings']['expert_mode'] = (bool) $this->config['expert_mode'];
        $view_params['parameters']['settings']['debug_mode'] = (bool) $this->config['debug'];

        //
        // Image Type since > 1.5.2
        //
        
        if (version_compare(_PS_VERSION_, '1.5.3', '>='))
        {
            if (!$this->config['image_type'])
                $selected = 'thickbox_default';
            else
                $selected = $this->config['image_type'];

            foreach (ImageType::getImagesTypes() as $imageType)
            {
                if (!(bool) $imageType['products'])
                    continue;

                $view_params['parameters']['settings']['image_type'][$imageType['name']] = ($selected == $imageType['name'] ? true : false);
            }
        }
        else
        {
            $view_params['parameters']['settings']['image_type'] = null;
        }

        //
        // Orders States
        //
        
        $view_params['parameters']['settings']['incoming_order_state'] = array();
        $view_params['parameters']['settings']['sent_order_state'] = array();

        $orderStates = OrderState::getOrderStates($this->id_lang);

        foreach ($orderStates as $orderState)
        {
            $id_order_state = (int)$orderState['id_order_state'];

            if ($id_order_state == $this->config['order_state'])
                $selected = true;
            else
                $selected = false;

            $view_params['parameters']['settings']['incoming_order_state'][$id_order_state]['name'] = $orderState['name'];
            $view_params['parameters']['settings']['incoming_order_state'][$id_order_state]['selected'] = $selected;
        }

        foreach ($orderStates as $orderState)
        {
            $id_order_state = (int)$orderState['id_order_state'];

            if ($id_order_state == $this->config['send_state'])
                $selected = true;
            else
                $selected = false;

            $view_params['parameters']['settings']['sent_order_state'][$id_order_state]['name'] = $orderState['name'];
            $view_params['parameters']['settings']['sent_order_state'][$id_order_state]['selected'] = $selected;
        }

        $view_params['parameters']['settings']['bulk_mode'] = (bool) $this->config['bulk_mode'];

        //
        // Shop Configuration
        //
        
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {

            $view_params['parameters']['settings']['shop'] = array();

            foreach (Shop::getShops() as $shop)
            {
                $id_shop = (int)$shop['id_shop'];

                if ($id_shop == (int) $this->config['shop'])
                    $selected = true;
                else
                    $selected = false;

                $view_params['parameters']['settings']['shop'][$id_shop]['name'] = $shop['name'];
                $view_params['parameters']['settings']['shop'][$id_shop]['selected'] = $selected;
            }
        }
        else
        {
            $view_params['parameters']['settings']['shop'] = null;
        }

        $view_params['parameters']['settings']['employee'] = array() ;
        
        // Employee::getEmployees is displayed as deprecated in PS 1.4 ... but not in PS 1.5
        foreach (@Employee::getEmployees() as $employee)
        {
            $id_employee = (int)$employee['id_employee'] ;
                    
            if ($id_employee == $this->config['employee'])
                $selected = true ;
            else
                $selected = false ;
            
            $view_params['parameters']['settings']['employee'][$id_employee]['name'] = (isset($employee['name']) ? $employee['name'] : sprintf('%s %s', $employee['firstname'], $employee['lastname'])) ;
            $view_params['parameters']['settings']['employee'][$id_employee]['selected'] = $selected;
        }        
        
        //
        // Advanced Stock
        //
        
        if ( version_compare(_PS_VERSION_, '1.5', '>=') && Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') )
        {
            $view_params['parameters']['settings']['warehouse'] = array() ;
            
            foreach (Warehouse::getWarehouses(true) as $warehouse)
            {
                $id_warehouse = (int)$warehouse['id_warehouse'] ;
                
                if ( $id_warehouse == $this->config['warehouse'])
                    $selected = true ;
                else
                    $selected = false ;
                
                $view_params['parameters']['settings']['warehouse'][$id_warehouse]['name'] = $warehouse['name'] ;
                $view_params['parameters']['settings']['warehouse'][$id_warehouse]['selected'] = $selected ; 
            }
        }
        else
        {
            $view_params['parameters']['settings']['warehouse'] = null ;
        }
        
        //
        // Products State/Condition
        //
        // Check for the condition field (Prestashop < 1.4 doesn't have this field)
        if (($conditionFields = Amazon_Tools::getConditionField()))
        {
            $view_params['parameters']['settings']['product_condition'] = true ;
            
            // For i18n
            //
            $default_conditions = array($this->l('new'), $this->l('used'), $this->l('refurbished'));

            // Fetch columns names
            //
            preg_match_all("/'([\w ]*)'/", $conditionFields['Type'], $ps_conditions);

            $view_params['parameters']['settings']['product_conditions'] = array() ;

            $index = 1;
            foreach ($this->_conditions as $condition)
            {
                $view_params['parameters']['settings']['product_conditions'][$condition] = array() ;
                $view_params['parameters']['settings']['product_conditions'][$condition]['index'] = $index++ ;
                $view_params['parameters']['settings']['product_conditions'][$condition]['selector']= array() ;
                
                foreach ($ps_conditions[1] as $ps_condition)
                {
                    if (isset($this->config['condition_map'][$condition]) && !empty($this->config['condition_map'][$condition]) && $this->config['condition_map'][$condition] == $ps_condition)
                        $selected = true ;
                    elseif ($condition == 'New' && $ps_condition == 'new' && $this->config['condition_map'][$condition] === null) // default config
                        $selected = true ;
                    else
                        $selected = false ;  

                    $view_params['parameters']['settings']['product_conditions'][$condition]['selector'][$ps_condition] = array() ;
                    $view_params['parameters']['settings']['product_conditions'][$condition]['selector'][$ps_condition]['selected'] = $selected ;
                    $view_params['parameters']['settings']['product_conditions'][$condition]['selector'][$ps_condition]['name'] = ucfirst($this->l($ps_condition)) ;
                }
            }
        }
        else
        {
            $view_params['parameters']['settings']['product_condition'] = false ;
        }  
        
        //
        // Amazon Europe
        //
        
        $view_params['parameters']['settings']['europe'] = array() ;
        
        foreach ($this->_platforms as $iso_code => $platform)
        {
            $view_params['parameters']['settings']['europe']['selector'][$iso_code]['selected'] = ($iso_code == $this->config['marketplace_master'] ? true : false) ;
            $view_params['parameters']['settings']['europe']['selector'][$iso_code]['iso_code'] = $iso_code ;
            $view_params['parameters']['settings']['europe']['selector'][$iso_code]['name'] = $platform ;
        }
        
        if ($this->config['amazon_europe'])
        {
            $view_params['parameters']['settings']['europe']['active'] = true ;
            $view_params['parameters']['settings']['europe']['disabled'] = false ;
            $view_params['parameters']['settings']['europe']['class'] = 'master-enabled' ;
        }
        else
        {
            $view_params['parameters']['settings']['europe']['active'] = false ;
            $view_params['parameters']['settings']['europe']['disabled'] = true ;
            $view_params['parameters']['settings']['europe']['class'] = 'master-disabled' ;
        }
        
        return($view_params);
    }

  
    private function _categories($default_categories, $default_profiles2categories, $brute_force)
    {
        $index = array();
        $selected_tab = $this->_selected_tab();

        $categories = Category::getCategories(intval($this->id_lang), false);

        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $id_shop = (int) $this->config['shop'];
            $shop = new Shop($id_shop);

            $first = null;

            foreach ($categories as $categories1)
                foreach ($categories1 as $category)
                    if ($category['infos']['id_category'] == Category::getRootCategory(null, $shop)->id_category)
                        $first = $category;

            $default_category = $shop->id_category;
        }
        else
        {
            foreach ($categories as $first1 => $categories_array)
                break;
            foreach ($categories_array as $first2 => $categories_array2)
                break;
            $first = $categories[$first1][$first2];
            $default_category = 1;
        }

        $html_categories = self::recurseCategoryForInclude($index, $categories, $first, $default_category, null, $default_categories, $default_profiles2categories, true);

        $this->_html .= '
        <div id="menudiv-categories"  class="tabItem ' . ($selected_tab == 'categories' ? 'selected' : '') . ' panel form-horizontal" ' . ($selected_tab == 'categories' ? '' : 'style="display:none;"') . '>
            <br />
            <div class="margin-form">
                <div style="font-size:1.2em;position:relative;' . ($this->psIs16x ? '' : 'width:90%;') . '" class="hint alert alert-info col-lg-offset-3">
                    <ul>
                        <li>' . $this->l('The selected categories will be used when exporting products.') . '</li>
                        <li>' . $this->l('The products contained in those categories will be marked as eligibles.') . '</li>
                        <li>' . $this->l('If you select profiles, these profiles will be used for product creation process.') . '</li>
                        <li>' . $this->l('If you don\'t select profiles the products will be only synchronizables.') . '</li>
                    </ul>' .
                '</div>
            </div>';
        
        if ($this->psIs16x)
            $this->_html .= '<div class="form-group">';
        
        $this->_html .= '<label class="control-label col-lg-3">' . $this->l('Categories Settings') . '</label>
                        <div class="margin-form col-lg-9">
                            <table cellspacing="0" cellpadding="0" class="table">
                                <tr>
                                    <th style="margin:0"><input type="checkbox" name="checkme" /></th>
                                    <th style="width: 400px">' . $this->l('Name') . '</th>
                                    <th>' . $this->l('Profile') . '</th>
                                </tr>
                                ' . $html_categories . '
                            </table>
                        </div>' . 
                    ($this->psIs16x ? '</div>' : '') . '
        <hr class="amz-separator" />';

        if ($this->config['expert_mode'])
        {
            if (intval($brute_force))
                $checked = ' checked="checked"';
            else
                $checked = '';

            if ($this->psIs16x)
                $this->_html .= '<div class="form-group">';
            
            $this->_html .= '
                <label class="control-label col-lg-3">' . $this->l('Brute Force') . '</label>
                <div class="margin-form col-lg-9">
                    <input type="checkbox" name="brute_force" value="1" ' . $checked . ' /><span style="font-size:1.2em;color:black;position:relative;top:+2px;">&nbsp;&nbsp;' . $this->l('Active forcing updates') . '</span>
                    <p>' . 
                        $this->l('Force product update even it was not modified') . '<br />
                        <span style="color:red;font-weight:bold;">' . $this->l('This feature is not recommended !') . '</span>
                    </p>
                </div>';
            if ($this->psIs16x)
                $this->_html .= '</div>';
        }
        else
        {
            $this->_html .= '<input type="hidden" name="brute_force" value="0" />';
        }

        $this->_validate();

        $this->_html .= '</div>';
    }

    private function _profiles(&$view_params)
    {
        $view_params['profiles'] = array();
        $view_params['profiles']['config'] = array();

        $view_params['profiles']['images_url'] = $this->images;
        $view_params['profiles']['selected_tab'] = ($this->_selected_tab() == 'profiles' ? 'selected' : '');
        $view_params['profiles']['expert_mode'] = $this->config['expert_mode'];
        $view_params['profiles']['validation'] = $this->_validate(true);
        $view_params['profiles']['templates_url'] = 'https://sellercentral.amazon.' . Amazon_Tools::idToDomain($this->id_lang) . '/gp/help/help-popup.html?ie=UTF8&itemID=1641#tables' ;

        $view_params['profiles']['xsd_path'] = str_replace('\\', '/', realpath(dirname(__FILE__))) . '/xsd/' ;
        $view_params['profiles']['xsd_operations_url'] = $this->url . 'functions/xsd_operations.php?id_lang=' . $this->id_lang ;
        $view_params['profiles']['xsd_ajax_error'] = $this->l('An unexpected server side error occurs') . '<br />' . $this->l('In most cases, this is a permission problem. Please apply write permission (777) to amazon/validate/xsd directory.') ;
        
        $view_params['profiles']['amazon_us'] = $this->config['amazon_us'] ;
        $view_params['profiles']['amazon_in'] = $this->config['amazon_in'] ;        
        
        $html = null ;

            
        $exemptions = array() ;
        $exemptions['none'] = self::EXEMPTION_NONE ;
        $exemptions['compatibility'] = self::EXEMPTION_COMPATIBILITY ;
        $exemptions['model_number'] = self::EXEMPTION_MODEL_NUMBER ;
        $exemptions['model_name'] = self::EXEMPTION_MODEL_NAME ;
        $exemptions['mfr_part_number'] = self::EXEMPTION_MFR_PART_NUMBER ;
        $exemptions['catalog_number'] = self::EXEMPTION_CATALOG_NUMBER ;
        $exemptions['generic'] = self::EXEMPTION_GENERIC ;
        
        $view_params['profiles']['exemptions'] = $exemptions ;
        
        // Only Used to Fetch the XSD Files ;
        //
        AmazonXSD::getCategories();


        // Known categories
        // https://catalog-mapper-fr.amazon.fr/catm/classifier/ProductClassifier.amzn
        // https://sellercentral.amazon.fr/gp/help/help-page.html/ref=pt_200956770_cont_scsearch?ie=UTF8&itemID=200956770
        //
        $amazon_universes['ClothingAccessories'] = 'Clothing Accessories';
        $amazon_universes['ProductClothing'] = 'Product Clothing';
        $amazon_universes['Miscellaneous'] = 'Miscellaneous';
        $amazon_universes['CameraPhoto'] = 'Camera Photo';
        $amazon_universes['Home'] = 'Home';
        $amazon_universes['Sports'] = 'Sports';
        $amazon_universes['SportsMemorabilia'] = 'Sports Memorabilia';
        $amazon_universes['EntertainmentCollectibles'] = 'Entertainment Collectibles';
        $amazon_universes['HomeImprovement'] = 'Home Improvement';
        $amazon_universes['FoodAndBeverages'] = 'Food And Beverages';
        $amazon_universes['Gourmet'] = 'Gourmet';
        $amazon_universes['Jewelry'] = 'Jewelry';
        $amazon_universes['Health'] = 'Health';
        $amazon_universes['CE'] = 'Consumers Electronics';
        $amazon_universes['Computers'] = 'Computers';
        $amazon_universes['SWVG'] = 'Software and Video Games';
        $amazon_universes['Wireless'] = 'Wireless';
        $amazon_universes['Beauty'] = 'Beauty';
        $amazon_universes['Office'] = 'Office';
        $amazon_universes['MusicalInstruments'] = 'Musical Instruments';
        $amazon_universes['AutoAccessory'] = 'Auto Accessory';
        $amazon_universes['PetSupplies'] = 'Pet Supplies';
        $amazon_universes['Toys'] = 'Toys';
        $amazon_universes['Baby'] = 'Baby';
        $amazon_universes['TiresAndWheels'] = 'Tires And Wheels';
        $amazon_universes['Music'] = 'Music';
        $amazon_universes['Video'] = 'Video';
        $amazon_universes['Lighting'] = 'Lighting';
        $amazon_universes['LargeAppliances'] = 'Large Appliances';
        $amazon_universes['Toys'] = 'Toys';
        $amazon_universes['GiftCards'] = 'Gift Cards';
        $amazon_universes['LabSupplies'] = 'Lab Supplies';
        $amazon_universes['RawMaterials'] = 'Raw Materials';
        $amazon_universes['PowerTransmission'] = 'Power Transmission';
        $amazon_universes['Industrial'] = 'Industrial';
        $amazon_universes['Shoes'] = 'Shoes';
        $amazon_universes['Motorcycles'] = 'Motorcycles';
        $amazon_universes['MechanicalFasteners'] = 'Mechanical Fasteners';
        $amazon_universes['FoodServiceAndJanSan'] = 'Food Service And Jan San';
        $amazon_universes['WineAndAlcohol'] = 'Wine And Alcohol';
        $amazon_universes['EUCompliance'] = 'EU Compliance';
        $amazon_universes['Books'] = 'Books';
        $amazon_universes['Luggage'] = 'Luggage';
        $amazon_universes['Arts'] = 'Arts';

        $view_params['profiles']['categories_english'] = (strtolower(Language::getIsoById($this->id_lang)) == 'fr') ? true : false ;

        //
        // Attributes Group for Fields Associations 
        //
        $attributes_groups = AttributeGroup::getAttributesGroups((int)($this->id_lang));

        $languages = Amazon_Tools::languages();
        
        $current_currency = Currency::getDefaultCurrency();
        
        $profiles = is_array($this->profiles) && count($this->profiles) ? $this->profiles : array('name' => null) ;
        
        $profiles['name'][65535] = null ;
        $profiles['master'][65535] = true ;
        
        foreach ($profiles['name'] as $profile_id => $profile_name)
        {
            $profile_key = md5($profile_name) ;

            // Skip empty entries
            if ( empty($profile_name) && (! isset($profiles['master'][$profile_id]) || ! $profiles['master'][$profile_id]) )   continue ;

            if ( isset($profiles['master'][$profile_id]) && $profiles['master'][$profile_id] )
                $master = true ;
            else
                $master = false ;
            
            $view_params['profiles']['config'][$profile_key] = array() ;
            $view_params['profiles']['config'][$profile_key]['profile_id'] = $master ? 'master' : $profile_key; //$profile_id ;
            $view_params['profiles']['config'][$profile_key]['profile_div_id'] = $master ? 'master-profile' : 'profile-' . $profile_key; //$profile_id ;
            $view_params['profiles']['config'][$profile_key]['profile_class'] = $master ? 'profile-create master-profile' : 'profile-create profile' ;
            $view_params['profiles']['config'][$profile_key]['master'] = $master;


            $p_universe = isset($profiles['universe'][$profile_id]) ? $profiles['universe'][$profile_id] : '';
            $p_product_type = isset($profiles['product_type'][$profile_id]) ? $profiles['product_type'][$profile_id] : '';
            $p_extra = isset($profiles['extra'][$profile_name]) ? $profiles['extra'][$profile_name] : '';
            
            if ($p_universe && $p_product_type)
                $type = sprintf('%s&nbsp;&gt;&nbsp;%s', $p_universe, $p_product_type);
            else
                $type = $this->l('ERROR');
            
            $p_field_size = isset($profiles['field_size'][$profile_id]) ? $profiles['field_size'][$profile_id] : '';
            $p_field_color = isset($profiles['field_color'][$profile_id]) ? $profiles['field_color'][$profile_id] : '';
            
            $view_params['profiles']['config'][$profile_key]['universe'] = $p_universe ;            
            $view_params['profiles']['config'][$profile_key]['product_type'] = $p_product_type ;
            $view_params['profiles']['config'][$profile_key]['type'] = $type ;
            $view_params['profiles']['config'][$profile_key]['name'] = isset($profiles['name'][$profile_id]) ? $profiles['name'][$profile_id] : '';

            $view_params['profiles']['config'][$profile_key]['formula'] = isset($profiles['formula'][$profile_id]) ? $profiles['formula'][$profile_id] : '';
            $view_params['profiles']['config'][$profile_key]['latency'] = isset($profiles['latency'][$profile_id]) ? $profiles['latency'][$profile_id] : '';
            $view_params['profiles']['config'][$profile_key]['combinations'] = isset($profiles['combinations'][$profile_id]) ? $profiles['combinations'][$profile_id] : '';
            $view_params['profiles']['config'][$profile_key]['extra'] = $p_extra ;

            $view_params['profiles']['config'][$profile_key]['code_exemption'] = isset($profiles['code_exemption'][$profile_id]) ? $profiles['code_exemption'][$profile_id] : self::EXEMPTION_NONE ;
            
            if ( isset($profiles['code_exemption'][$profile_id]) && $profiles['code_exemption'][$profile_id] == self::EXEMPTION_COMPATIBILITY )
                $view_params['profiles']['config'][$profile_key]['code_exemption_options'] = array('private_label' => true) ;
            else
                $view_params['profiles']['config'][$profile_key]['code_exemption_options'] = isset($profiles['code_exemption_options'][$profile_id]) ? $profiles['code_exemption_options'][$profile_id] : null ;
                
            $view_params['profiles']['config'][$profile_key]['sku_as_supplier_reference'] = isset($profiles['sku_as_supplier_reference'][$profile_id]) ? $profiles['sku_as_supplier_reference'][$profile_id] : 0;
            $view_params['profiles']['config'][$profile_key]['sku_as_sup_ref_unconditionnaly'] = isset($profiles['sku_as_sup_ref_unconditionnaly'][$profile_id]) ? $profiles['sku_as_sup_ref_unconditionnaly'][$profile_id] : 0;
            $view_params['profiles']['config'][$profile_key]['item_type'] = isset($profiles['item_type'][$profile_id]) ? $profiles['item_type'][$profile_id] : '' ;
            
            $view_params['profiles']['config'][$profile_key]['universes'] = array() ;
            
            // debuss-a
            if (isset($profiles['price_rule'][$profile_id]) && is_array($profiles['price_rule'][$profile_id]) && isset($profiles['price_rule'][$profile_id]['rule']['from']) &&
                    is_array($profiles['price_rule'][$profile_id]['rule']['from']) && isset($profiles['price_rule'][$profile_id]['rule']['to']) && is_array($profiles['price_rule'][$profile_id]['rule']['to']))
            {
                $view_params['profiles']['config'][$profile_key]['price_rule']['currency_sign'] = isset($current_currency->sign) ? $current_currency->sign : null ;
                $view_params['profiles']['config'][$profile_key]['price_rule']['type'] = isset($profiles['price_rule'][$profile_id]['type']) ? $profiles['price_rule'][$profile_id]['type'] : 'percent';  

                if (isset($profiles['price_rule'][$profile_id]['rule']['from']) && is_array($profiles['price_rule'][$profile_id]['rule']['from']) && isset($profiles['price_rule'][$profile_id]['rule']['to']) && is_array($profiles['price_rule'][$profile_id]['rule']['to']) )
                {
                    $view_params['profiles']['config'][$profile_key]['price_rule']['rule'] = $profiles['price_rule'][$profile_id]['rule'];
                    if (!count($profiles['price_rule'][$profile_id]['rule']['from']) && !count($profiles['price_rule'][$profile_id]['rule']['to']) && !count($profiles['price_rule'][$profile_id]['rule']['value']))
                    {
                        $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['from'][0] = '';
                        $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['to'][0] = '';
                        $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['percent'][0] = '';
                        $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['value'][0] = '';
                    }
                }
            }
            else
            {
                // first use
                $view_params['profiles']['config'][$profile_key]['price_rule']['currency_sign'] = isset($current_currency->sign) ? $current_currency->sign : null ;
                $view_params['profiles']['config'][$profile_key]['price_rule']['type'] = 'percent';
                $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['from'][0] = '';
                $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['to'][0] = '';
                $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['percent'][0] = '';
                $view_params['profiles']['config'][$profile_key]['price_rule']['rule']['value'][0] = '';
            }
            
            foreach ($amazon_universes as $key => $universe)
            {
                $view_params['profiles']['config'][$profile_key]['universes'][$key]['name'] = $universe ;
                $view_params['profiles']['config'][$profile_key]['universes'][$key]['selected'] = ($p_universe == $key && $profile_name ? true : false) ;
            }
            
            $view_params['profiles']['config'][$profile_key]['specifics'] = Amazon_SpecificField::displayFields($profile_name, $p_extra) ;

            // Exception: Do not display field association for Jewelry
            //
            if ( is_array($attributes_groups) && count($attributes_groups) && $p_universe != 'Jewelry' )
            {
                $view_params['profiles']['config'][$profile_key]['associations'] = true ;
                $view_params['profiles']['config'][$profile_key]['field_size'] = array() ;
                $view_params['profiles']['config'][$profile_key]['field_color'] = array() ;
            
                foreach ($attributes_groups as $attribute_group)
                {
                    $id_attribute_group = (int)$attribute_group['id_attribute_group'] ;

                    if ( $p_field_size && (int)$p_field_size == $id_attribute_group )
                        $selected = true ;
                    else
                        $selected = false ;
                    
                    $view_params['profiles']['config'][$profile_key]['field_size'][$id_attribute_group]['name'] = $attribute_group['name'] ;
                    $view_params['profiles']['config'][$profile_key]['field_size'][$id_attribute_group]['selected'] = $selected ;
                }      
                
                foreach ($attributes_groups as $attribute_group)
                {
                    $id_attribute_group = (int)$attribute_group['id_attribute_group'] ;

                    if ( $p_field_color && (int)$p_field_color == $id_attribute_group )
                        $selected = true ;
                    else
                        $selected = false ;
                    
                    $view_params['profiles']['config'][$profile_key]['field_color'][$id_attribute_group]['name'] = $attribute_group['name'] ;
                    $view_params['profiles']['config'][$profile_key]['field_color'][$id_attribute_group]['selected'] = $selected ;
                }                     
            }
            else
            {
                $view_params['profiles']['config'][$profile_key]['associations'] = false ;
                $view_params['profiles']['config'][$profile_key]['field_size'] = null ;
                $view_params['profiles']['config'][$profile_key]['field_color'] = null ;
            }
            
            $view_params['profiles']['config'][$profile_key]['browse_nodes'] = array() ;
            
            foreach ($languages as $language)
            {
                if ( isset($language['language_code']) && $language['language_code'] == 'en-US' )    continue ; // Except for U.S.
                
                $id_lang = $language['id_lang'];
                
                $p_browsenode = isset($profiles['browsenode_' . $id_lang][$profile_id]) ? $profiles['browsenode_' . $id_lang][$profile_id] : '';
                
                $view_params['profiles']['config'][$profile_key]['browse_nodes'][$id_lang]['value'] = $p_browsenode ;
                $view_params['profiles']['config'][$profile_key]['browse_nodes'][$id_lang]['flag'] = $this->images . 'geo_flags/' . $this->geoFlag($language['id_lang']) . '.gif' ;
                $view_params['profiles']['config'][$profile_key]['browse_nodes'][$id_lang]['language'] = $language['name'] ;
            }
            $view_params['profiles']['config'][$profile_key]['classifier_url'] = Amazon_Tools::classifierURL($this->id_lang) ;
        }
        return($view_params); 
    }

    // Mapping (Colors, Size ...)
    //
    private function _mapping(&$view_params)
    {
        $selected_tab = $this->_selected_tab();

        $view_params['mapping']['selected_tab'] = $selected_tab == 'mapping' ? true : false ;
        $view_params['mapping']['validation'] =  $this->_validate(true) ;
        $view_params['mapping']['images_url'] = $this->images ;
        $view_params['mapping']['attributes'] = array() ;
        $view_params['mapping']['features'] = array() ;

        $languages = Amazon_Tools::languages();

        //
        // Attributes Mapping
        //
        
        foreach ($languages as $language)
        {
            $id_lang = $language['id_lang'];
            
            if (!(isset($this->config['actives']) || !(isset($this->config['actives'][$id_lang]) || ! intval($this->config['actives'][$id_lang]))))
                continue;        
            
            $view_params['mapping']['attributes']['lang'][$id_lang] = array() ;
            $view_params['mapping']['attributes']['lang'][$id_lang]['name'] = $language['name'];
            $view_params['mapping']['attributes']['lang'][$id_lang]['iso_code'] = $language['iso_code'] ;
            $view_params['mapping']['attributes']['lang'][$id_lang]['flag'] = $this->images . 'geo_flags/' . $this->geoFlag($language['id_lang']) . '.gif' ; ;
            $view_params['mapping']['attributes']['config'][$id_lang] = array() ;
            
            $attributes_groups = AttributeGroup::getAttributesGroups((int) $id_lang);
            
            $attributes = Attribute::getAttributes((int) $id_lang, true);
            
            if ( ! is_array($attributes) || ! count($attributes) || ! is_array($attributes_groups) || ! count($attributes_groups) )
                continue ;

            foreach($attributes_groups as $attribute_group)
            {
                    $id_attribute_group = (int)$attribute_group['id_attribute_group'] ;

                    $mapping_left = array_merge(array(0 => false), isset($this->config['attributes_mapping_left'][$id_lang]) && isset($this->config['attributes_mapping_left'][$id_lang][$id_attribute_group]) ? $this->config['attributes_mapping_left'][$id_lang][$id_attribute_group] : array());
                    $mapping_right = array_merge(array(0 => false), isset($this->config['attributes_mapping_right'][$id_lang]) && isset($this->config['attributes_mapping_right'][$id_lang][$id_attribute_group]) ? $this->config['attributes_mapping_right'][$id_lang][$id_attribute_group] : array());
                    $index = 0 ;
                    
                    $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ] = array() ;
                    $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['name'] = $attribute_group['name'] ;
                    $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['left'] = array() ;
                    $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['right'] = array() ;
                 
                    foreach($mapping_left as $left)
                    {             
                        $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['left'][$index] = array() ;
                        
                        foreach ($attributes AS $key2 => $attribute)
                        {
                            $id_attribute = (int)$attribute['id_attribute'] ;
                            
                            if ( $attribute['id_attribute_group'] !=  $id_attribute_group ) continue ;
                            
                            if ( in_array($id_attribute, array_values($mapping_left)) ) 
                                    $used = true ;
                            else    $used = false ;

                            $selected = ($index && $left == $id_attribute ? true : false) ;
                     
                            $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['left'][ $index ][ $id_attribute ]['name'] = $attribute['name'] ;
                            $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['left'][ $index ][ $id_attribute ]['selected'] = $selected ;
                            $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['left'][ $index ][ $id_attribute ]['used'] = $used ;
                        }
                        $right = isset($mapping_right[$index]) ? $mapping_right[$index] : null ;
                      
                        $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['right'][ $index ] = $right ;
                        
                        $index ++ ;
                    }
                    $view_params['mapping']['attributes']['config'][$id_lang][ $id_attribute_group ]['items'] = $index - 1 ;
            }
        }
      
        //
        // FeaturesMapping
        //        
        
        foreach ($languages as $language)
        {
            $id_lang = $language['id_lang'];
            
            if (!(isset($this->config['actives']) || !(isset($this->config['actives'][$id_lang]) || ! intval($this->config['actives'][$id_lang]))))
                continue;        
            
            $view_params['mapping']['feature']['lang'][$id_lang] = array() ;
            $view_params['mapping']['feature']['lang'][$id_lang]['name'] = $language['name'];
            $view_params['mapping']['feature']['lang'][$id_lang]['iso_code'] = $language['iso_code'] ;
            $view_params['mapping']['feature']['lang'][$id_lang]['flag'] = $this->images . 'geo_flags/' . $this->geoFlag($language['id_lang']) . '.gif' ; ;
            $view_params['mapping']['feature']['config'][$id_lang] = array() ;
            
  
            foreach (Feature::getFeatures($id_lang) AS $feature)
            {
                    $id_feature = (int)$feature['id_feature'] ;

                    $features_values = FeatureValue::getFeatureValuesWithLang($id_lang, $id_feature);
                    
                    // Hide empty feature sets
                    if ( ! count($features_values) )    continue ;
                    
                    $features_values = array_merge(array(0 => false), $features_values);
                    
                    $mapping_left = array_merge(array(0 => false), isset($this->config['features_mapping_left'][$id_lang]) && isset($this->config['features_mapping_left'][$id_lang][$id_feature]) ? $this->config['features_mapping_left'][$id_lang][$id_feature] : array());
                    $mapping_right = array_merge(array(0 => false), isset($this->config['features_mapping_right'][$id_lang]) && isset($this->config['features_mapping_right'][$id_lang][$id_feature]) ? $this->config['features_mapping_right'][$id_lang][$id_feature] : array());
                    $index = 0 ;

                    $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ] = array() ;
                    $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['name'] = $feature['name'] ;
                    $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['left'] = array() ;
                    $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['right'] = array() ;                        
                                            
                    foreach($mapping_left as $left)
                    {     
                        $right = isset($mapping_right[$index]) ? $mapping_right[$index] : null ;
                        
                        // remove empty entries
                        if ( empty($right) && $index)
                            continue ;;
                        
                        $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['left'][$index] = array() ;
                        
                        foreach ($features_values AS $key2 => $feature_value)
                        {
                            if ( ! $feature_value ) continue ;
                            if ( empty($feature_value['value']) )   continue ;
                            
                            $id_feature_value = (int)$feature_value['id_feature_value'] ;
                            
                            if ( in_array($id_feature_value, array_values($mapping_left)) ) 
                                    $used = true ;
                            else    $used = false ;

                            $selected = ($index && $left == $id_feature_value ? true : false) ;
                     
                            $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['left'][ $index ][ $id_feature_value ]['name'] = $feature_value['value'] ;
                            $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['left'][ $index ][ $id_feature_value ]['selected'] = $selected ;
                            $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['left'][ $index ][ $id_feature_value ]['used'] = $used ;
                        }
                        $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['right'][ $index ] = $right ;
                        $index ++ ;
                    }                    
                    $view_params['mapping']['feature']['config'][$id_lang][ $id_feature ]['items'] = $index - 1 ;
            }
        }
        
        return($view_params) ;
    }

    private function _filters()
    {
        $view_params = array();
        $view_params['selected_tab'] = $this->_selected_tab() == 'filters' ? true : false ;
        $view_params['images'] = $this->images;
        $view_params['url'] = $this->url;
        
        // Price Filtering
        //
        $price_filter = $this->config['price_filter'];
        
        $view_params['filters']['prices'] = array() ;
        $view_params['filters']['prices']['currency_sign'] = Currency::getDefaultCurrency()->sign ;
        $view_params['filters']['prices']['gt'] = null ;
        $view_params['filters']['prices']['lt'] = null ;
        
        if ( is_array($price_filter) && isset($price_filter['gt']) && (float)$price_filter['gt'] )
            $view_params['filters']['prices']['gt'] = sprintf('%.02f', $price_filter['gt']) ;
        
        if ( is_array($price_filter) && isset($price_filter['lt']) && (float)$price_filter['lt'] )
            $view_params['filters']['prices']['lt'] = sprintf('%.02f', $price_filter['lt']) ;
        
        // Manufacturers Filtering
        //
        $manufacturers = Manufacturer::getManufacturers(false, $this->id_lang);

        $selected_manufacturers = $this->config['excluded_manufacturers'];

        $filtered_manufacturers = array();
        $available_manufacturers = array();

        if (is_array($manufacturers) && count($manufacturers))
        {
            foreach ($manufacturers as $manufacturer)
            {
                if (is_array($selected_manufacturers) && in_array((string) $manufacturer['id_manufacturer'], $selected_manufacturers))
                    continue;

                $available_manufacturers[$manufacturer['id_manufacturer']] = $manufacturer['name'];
            }
            if (is_array($selected_manufacturers) && count($selected_manufacturers))
            {
                foreach ($manufacturers as $manufacturer)
                {
                    if (is_array($selected_manufacturers) && !in_array((string) $manufacturer['id_manufacturer'], $selected_manufacturers))
                        continue;

                    $filtered_manufacturers[$manufacturer['id_manufacturer']] = $manufacturer['name'];
                }
            }
        }
        $view_params['manufacturers'] = array();
        $view_params['manufacturers']['available'] = $available_manufacturers;
        $view_params['manufacturers']['filtered'] = $filtered_manufacturers;

        // Suppliers Filtering
        //
        $suppliers = Supplier::getSuppliers(false, $this->id_lang);

        $selected_suppliers = $this->config['excluded_suppliers'];
        $filtered_suppliers = array();
        $available_suppliers = array();

        if (is_array($suppliers) && count($suppliers))
        {
            foreach ($suppliers as $supplier)
            {
                if (is_array($selected_suppliers) && in_array((string) $supplier['id_supplier'], $selected_suppliers))
                    continue;

                $available_suppliers[$supplier['id_supplier']] = $supplier['name'];
            }
            if (is_array($selected_suppliers) && count($selected_suppliers))
            {
                foreach ($suppliers as $supplier)
                {
                    if (is_array($selected_suppliers) && !in_array((string) $supplier['id_supplier'], $selected_suppliers))
                        continue;

                    $filtered_suppliers[$supplier['id_supplier']] = $supplier['name'];
                }
            }
        }
        $view_params['suppliers'] = array();
        $view_params['suppliers']['available'] = $available_suppliers;
        $view_params['suppliers']['filtered'] = $filtered_suppliers;

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_FILTERS]);
    }

    // Tools
    //
    private function _tools()
    {
        $current_token = isset($this->config['tokens'][$this->id_lang]) ? $this->config['tokens'][$this->id_lang] : null;

        $view_params = array();
        $view_params['selected_tab'] = $this->_selected_tab();
        $view_params['request_uri'] = Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']);
        $view_params['selected_tab_tools'] = $view_params['selected_tab'] == 'tools' ? 'selected' : '';
        $view_params['images'] = $this->images;
        $view_params['url'] = $this->url;
        $view_params['tools_url'] = $this->url . 'functions/tools.php?amazon_token=' . $current_token;
        $view_params['csv_wiki'] = sprintf('http://%s.wikipedia.org/wiki/CSV', strtolower(Language::getIsoById($this->id_lang)));

        // Current Queue
        //
        $languages = Amazon_Tools::languages();
        $action_queues = Amazon_Product::getCurrentQueue();

        foreach ($action_queues as $key => $action_queue)
        {
            if (isset($languages[$action_queue['id_lang']]))
            {
                $action_queues[$key]['lang'] = $languages[$action_queue['id_lang']]['name'];
                $action_queues[$key]['lang_iso_code'] = $languages[$action_queue['id_lang']]['iso_code'];

                $action_queues[$key]['flag'] = $this->images . 'geo_flags/' . $this->geoFlag($action_queue['id_lang']) . '.gif';
            }
            else
            {
                $action_queues[$key]['lang'] = $this->l('Inactive');
                $action_queues[$key]['flag'] = null;
            }
            $action_queues[$key]['date_min'] = Amazon_Tools::displayDate($action_queue['date_min'], $this->id_lang, true);
            $action_queues[$key]['date_max'] = Amazon_Tools::displayDate($action_queue['date_max'], $this->id_lang, true);

            switch ($action_queue['action'])
            {
                case self::Add :
                    $action_queues[$key]['action_name'] = $this->l('Add');
                    break;
                case self::Remove :
                    $action_queues[$key]['action_name'] = $this->l('Delete');
                    break;
                case self::Update :
                    $action_queues[$key]['action_name'] = $this->l('Update');
                    break;
            }
        }

        $view_params['action_queue'] = $action_queues;

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_TOOLS]);
    }

    // Crons
    //
    private function _cron()
    {
        $current_token = isset($this->config['tokens'][$this->id_lang]) ? $this->config['tokens'][$this->id_lang] : null;
        $base_url = Amazon_Tools::getHttpHost(true, true) . __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name;
        $marketPlaceIds = $this->config['amazon_marketplace_ids'];
        $amazonEurope = $this->config['amazon_europe'];
        $marketPlaceMaster = $this->config['marketplace_master'];
        $actives = $this->config['actives'];
        $regions = $this->config['regions'];

        $cron_settings = array();

        $cron_settings['products'] = array();
        $cron_settings['products']['synch'] = array();

        $cron_settings['orders'] = array();
        $cron_settings['orders']['status'] = array();
        $cron_settings['orders']['import'] = array();

        $cron_settings['fba']['status'] = array();
        $cron_settings['fba']['stocks'] = array();

        $languages = Amazon_Tools::languages();

        // Parse cron for Amazon Europe
        //
        if ($amazonEurope && $marketPlaceMaster)
        {
            foreach ($languages as $langkey => $language)
            {
                $id_lang = $language['id_lang'];

                if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                    continue;
                if (!isset($marketPlaceIds[$id_lang]) || !Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$id_lang]))
                    continue;

                $flag = $this->images . 'geo_flags/' . $this->geoFlag($language['id_lang']) . '.gif';

                $cron_settings['products']['synch'][$id_lang]['id_lang'] = $id_lang;
                $cron_settings['products']['synch'][$id_lang]['lang'] = $regions[$id_lang];
                $cron_settings['products']['synch'][$id_lang]['flag'] = $flag;
                $cron_settings['products']['synch'][$id_lang]['url'] = $base_url . '/functions/products.php?cron=1&action=update&lang=' . $regions[$id_lang] . '&cron_token=' . $this->config['tokens'][$id_lang];

                if ( isset($regions[$id_lang]) && ($marketPlaceMaster == $regions[$id_lang] || $marketPlaceMaster == 'uk') )
                {
                    $cron_settings['orders']['import'][$id_lang]['id_lang'] = $id_lang;
                    $cron_settings['orders']['import'][$id_lang]['lang'] = $regions[$id_lang];
                    $cron_settings['orders']['import'][$id_lang]['flag'] = $flag;
                    $cron_settings['orders']['import'][$id_lang]['url'] = $base_url . '/functions/import.php?cron=1&lang=' . $regions[$id_lang] . '&europe=1&cron_token=' . $this->config['tokens'][$id_lang];

                    if ($this->config['bulk_mode'])
                    {
                        $cron_settings['orders']['status'][$id_lang]['id_lang'] = $id_lang;
                        $cron_settings['orders']['status'][$id_lang]['lang'] = $regions[$id_lang];
                        $cron_settings['orders']['status'][$id_lang]['flag'] = $flag;
                        $cron_settings['orders']['status'][$id_lang]['url'] = $base_url . '/functions/status.php?cron=1&lang=' . $regions[$id_lang] . '&europe=1&cron_token=' . $this->config['tokens'][$id_lang];
                    }

                    if ($this->config['fba_multichannel'])
                    {
                        $cron_settings['fba']['status'][$id_lang]['id_lang'] = $id_lang;
                        $cron_settings['fba']['status'][$id_lang]['lang'] = $regions[$id_lang];
                        $cron_settings['fba']['status'][$id_lang]['flag'] = $flag;
                        $cron_settings['fba']['status'][$id_lang]['url'] = $base_url . '/functions/fbaorder.php?cron=1&action=status&europe=1&cron_token=' . $this->config['tokens'][$id_lang];
                    }

                    if ($this->config['FBA'])
                    {
                        $cron_settings['fba']['stocks'][$id_lang]['id_lang'] = $id_lang;
                        $cron_settings['fba']['stocks'][$id_lang]['lang'] = $regions[$id_lang];
                        $cron_settings['fba']['stocks'][$id_lang]['flag'] = $flag;
                        $cron_settings['fba']['stocks'][$id_lang]['url'] = $base_url . '/functions/fbamanager.php?cron=1&action=stocks&europe=1&cron_token=' . $this->config['tokens'][$id_lang];
                    }
                }
                elseif ($regions[$id_lang] == 'uk') // UK exception
                {
                    $cron_settings['orders']['import'][$id_lang]['id_lang'] = $id_lang;
                    $cron_settings['orders']['import'][$id_lang]['lang'] = $regions[$id_lang];
                    $cron_settings['orders']['import'][$id_lang]['flag'] = $flag;
                    $cron_settings['orders']['import'][$id_lang]['url'] = $base_url . '/functions/import.php?cron=1&lang=' . $regions[$id_lang] . '&cron_token=' . $this->config['tokens'][$id_lang];
                }
                unset($languages[$langkey]);
            }
        }

        // Remaining platforms (excepted Europe)
        //
        foreach ($languages as $langkey => $language)
        {
            $id_lang = $language['id_lang'];

            if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                continue;

            $flag = $this->images . 'geo_flags/' . $this->geoFlag($language['id_lang']) . '.gif';

            $cron_settings['products']['synch'][$id_lang]['id_lang'] = $id_lang;
            $cron_settings['products']['synch'][$id_lang]['lang'] = $regions[$id_lang];
            $cron_settings['products']['synch'][$id_lang]['flag'] = $flag;
            $cron_settings['products']['synch'][$id_lang]['url'] = $base_url . '/functions/products.php?cron=1&action=update&lang=' . $regions[$id_lang] . '&cron_token=' . $this->config['tokens'][$id_lang];

            $cron_settings['orders']['import'][$id_lang]['id_lang'] = $id_lang;
            $cron_settings['orders']['import'][$id_lang]['lang'] = $regions[$id_lang];
            $cron_settings['orders']['import'][$id_lang]['flag'] = $flag;
            $cron_settings['orders']['import'][$id_lang]['url'] = $base_url . '/functions/import.php?cron=1&lang=' . $regions[$id_lang] . '&cron_token=' . $this->config['tokens'][$id_lang];

            if ($this->config['bulk_mode'])
            {
                $cron_settings['orders']['status'][$id_lang]['id_lang'] = $id_lang;
                $cron_settings['orders']['status'][$id_lang]['lang'] = $regions[$id_lang];
                $cron_settings['orders']['status'][$id_lang]['flag'] = $flag;
                $cron_settings['orders']['status'][$id_lang]['url'] = $base_url . '/functions/status.php?cron=1&lang=' . $regions[$id_lang] . '&cron_token=' . $this->config['tokens'][$id_lang];
            }
        }

        $view_params = array();
        $view_params['selected_tab'] = $this->_selected_tab();
        $view_params['request_uri'] = Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']);
        $view_params['selected_tab_cron'] = $view_params['selected_tab'] == 'cron' ? 'selected' : '';
        $view_params['images'] = $this->images;
        $view_params['url'] = $this->url;
        $view_params['cron_settings'] = $cron_settings;
        $view_params['tools_url'] = $this->url . 'functions/tools.php?amazon_token=' . $current_token;

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_CRON]);
    }

    //
    // Actions from Tools Menu
    //
    private function _tools_code_import()
    {
        /*
          $type       = (int)Tools::getValue('tools_code_import_type') ;
          $format     = (int)Tools::getValue('tools_code_import_format') ;
         * 
         * 
         */
        $replace = (int) Tools::getValue('tools_code_import_replace');

        if (isset($_FILES['tools_code_import']) && isset($_FILES['tools_code_import']['tmp_name']) && isset($_FILES['tools_code_import']['error']) && !$_FILES['tools_code_import']['error'])
        {
            $refImport = new Amazon_CSV_References($_FILES['tools_code_import']['tmp_name']);

            $result = $refImport->getData();

            if (!$result || !is_array($result) || !count($result))
            {
                $this->_postErrors[] = $this->l('Unable to process the file, please verify your file and read instructions');
                return(false);
            }

            if ($result)
            {
                $count = 0;
                $errors = null ;
                foreach ($result as $refitem)
                {
                    // Parent
                    //
                    if (!(int) $refitem->id_product_attribute)
                    {
                        $product = new Product($refitem->id_product);

                        if (!Validate::isLoadedObject($product))
                        {
                            continue;
                        }
                        $pass = false;
                        
                        foreach (array('ean13', 'upc', 'reference') as $field)
                        {
                            if (is_numeric($product->{$field}) && (int) $product->{$field} > 0 && $replace == false)
                                continue;
                            if (!is_numeric($product->{$field}) && !empty($product->{$field}) && $replace == false)
                                continue;

                            $pass = true;
                            $product->{$field} = $refitem->{$field};
                        }
                        if ($pass)
                        {
                            if ( method_exists('PrestaShopException', 'getMessage') )
                            {
                                try 
                                {
                                    $product->update();
                                }
                                catch(PrestaShopException $e)
                                {
                                    $errors .= $e->getMessage() . self::LF ;
                                }
                            }
                            else
                            {
                                $product->update();
                            }
                            if ( $errors )
                            {
                                $this->_postErrors[] = nl2br($errors) ;
                            }
                            $count++;                            
                        }
                    }
                    else // Children
                    {
                        foreach (array('ean13', 'upc', 'reference') as $field)
                        {
                            if ($replace)
                                $condition = "1";
                            else
                                $condition = $field == 'reference' ? 'NOT `' . $field . '` > ""' : ' NOT `' . $field . '` > 0';

                            // We have to use a query because the combinations functions are a messup between differents Prestashop versions (PS 1.3, 1.4, 1.5)
                            Db::getInstance()->Execute('UPDATE `' . _DB_PREFIX_ . 'product_attribute` SET `' . $field . '`="' . pSQL($refitem->{$field}) . '" WHERE `id_product`=' . (int) $refitem->id_product . ' AND `id_product_attribute`=' . (int) $refitem->id_product_attribute . ' AND ' . $condition);
                        }
                        // as we write directly into the db, trigger a hook
                        if (version_compare(_PS_VERSION_, '1.5', '<'))
                            Hook::updateProductAttribute((int) $refitem->id_product_attribute);
                        else
                            Hook::exec('actionProductAttributeUpdate', array('id_product_attribute' => (int) $refitem->id_product_attribute));

                        $count++;
                    }
                }
                if (!$this->_postErrors && $count)
                    $this->_html .= '<div class="conf confirm ' . ($this->psIs16x ? 'alert alert-success' : '') . '">' . sprintf($this->l('Products References File: %d products updated'), $count) . '</div>';
            }
        }
    }

    // Configuration & Information
    //
    private function _informations(&$view_params)
    {
        $lang = Language::getIsoById($this->id_lang);
        // Display only if the module seems to be configured
        //
        $display = true;
        foreach (array('actives', 'amazon_merchant_ids', 'amazon_marketplace_ids', 'amazon_key_ids', 'amazon_secret_ids') as $configuration_item)
            if (!is_array($this->config[$configuration_item]) || !count($this->config[$configuration_item]) || !max($this->config[$configuration_item]))
                $display = false;

        $php_infos = array();
        $prestashop_infos = array();
        $env_infos = array() ;

        // AJAX Checker
        //
        $env_infos['ajax'] = array();
        $env_infos['ajax']['message'] = $this->l('AJAX execution failed. Please first verify your module configuration. If the problem persists please send a screenshot of this page to the support.');
        $env_infos['ajax']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
        $env_infos['ajax']['display'] = false ;
        $env_infos['ajax']['script'] = array('name' => 'env_check_url', 'url' => $this->url . 'functions/check_env.php?action=ajax') ;
        
        // max_input_var Checker
        //
        if ( isset($_POST) && count($_POST) && ($max_input_vars = ini_get('max_input_vars')) && count($_POST, COUNT_RECURSIVE) >= $max_input_vars)
                $pass = false ;
        else 
                $pass = true ;
        
        $env_infos['miv'] = array();
        $env_infos['miv']['message'] = sprintf($this->l('Your PHP configuration limits the maximum number of fields to post in a form : %s for max_input_vars. Please ask your hosting provider to increase this limit.'), ini_get('max_input_vars'));
        $env_infos['miv']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
        $env_infos['miv']['display'] = ! $pass ;
        
        if ( $pass )
            $env_infos['miv']['script'] = array('name' => 'env_check_miv', 'url' => $this->url . 'functions/check_env.php?action=miv') ;
        else
            $env_infos['miv']['script'] = null ;
            
        // PHP Configuration Check
        //
        if (!function_exists('curl_init'))
        {
            $php_infos['curl'] = array();
            $php_infos['curl']['message'] = $this->l('PHP cURL must be installed on this server. The module require the cURL library and can\'t work without');
            $php_infos['curl']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
            $php_infos['curl']['link'] = 'http://php.net/manual/' . $lang . '/book.curl.php';
        }
        
        if (!method_exists('DOMDocument', 'createElement'))
        {
            $php_infos['domdocument'] = array();
            $php_infos['domdocument']['message'] = $this->l('PHP DOMDocument (XML Library) must be installed on this server. The module require this library and can\'t work without');
            $php_infos['domdocument']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
            $php_infos['domdocument']['link'] = 'http://php.net/manual/' . $lang . '/class.domdocument.php';
        }
        
        if (!is_writable(_PS_MODULE_DIR_ . 'amazon/validate/xsd') || !is_writable(_PS_MODULE_DIR_ . 'amazon/validate/xsd/amzn-base.xsd'))
        {
            $php_infos['xsd_permissions']['message'] = sprintf($this->l('You have to set write permissions to the %s directory and its subsequents files'), _PS_MODULE_DIR_ . 'amazon/validate/xsd');
            $php_infos['xsd_permissions']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
        }

        if (($max_execution_time = ini_get('max_execution_time')) && $max_execution_time < 120)
        {
            $php_infos['max_execution_time']['message'] = sprintf($this->l('PHP value: max_execution_time recommended value is at least 120. your limit is currently set to %d') . '<br />', $max_execution_time);
            $php_infos['max_execution_time']['level'] = $this->psIs16x ? 'alert alert-warning' : 'warn';
        }

        // Memory Limit
        $memory_limit = ini_get('memory_limit');
        $unit = strtolower(substr($memory_limit, -1));
        $val = preg_replace('[^0-9]', '', $memory_limit);
        switch ($unit)
        {
            case 'g' :
                $val = $val * 1024 * 1024 * 1024;
                break;
            case 'm' :
                $val = $val * 1024 * 1024;
                break;
            case 'k' :
                $val = $val * 1024;
                break;
            default :
                $val = false;
        }
        // Switch to MB
        $memory_limit = $val / (1024 * 1024);
        $recommended_memory_limit = 128;
        if ($memory_limit < $recommended_memory_limit)
        {
            $php_infos['memory']['message'] = sprintf($this->l('PHP value: memory_limit recommended value is at least %sMB. your limit is currently set to %sMB') . '<br />', $recommended_memory_limit, $memory_limit);
            $php_infos['memory']['level'] = $this->psIs16x ? 'alert alert-warning' : 'warn';
        }

        // Prestashop Configuration Check
        //
        if (!(int) Configuration::get('PS_SHOP_ENABLE'))
        {
            $prestashop_infos['maintenance']['message'] = $this->l('Be carefull, your shop is in maintenance mode, the module might not work in that mode');
            $prestashop_infos['maintenance']['level'] = $this->psIs16x ? 'alert alert-warning' : 'warn';
        }

        // URL issues
        //
        $pass = true;

        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            if (Shop::isFeatureActive())
            {
                $shop = Context::getContext()->shop;

                if ($_SERVER['HTTP_HOST'] != $shop->domain && $_SERVER['HTTP_HOST'] != $shop->domain_ssl)
                {
                    $pass = false;
                }
            }
            elseif ($_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN') && $_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN_SSL'))
            {
                $pass = false;
            }
        }
        elseif (version_compare(_PS_VERSION_, '1.4', '>='))
        {
            if ($_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN') && $_SERVER['HTTP_HOST'] != Configuration::get('PS_SHOP_DOMAIN_SSL'))
            {
                $pass = false;
            }
        }

        if (!$pass)
        {
            $prestashop_infos['wrong_domain']['message'] = $this->l('Your are currently connected with the following domain name:') . ' <span style="color:navy">' . $_SERVER['HTTP_HOST'] . '</span><br />' .
                    $this->l('This one is different from the main shop domain name set in "Preferences > SEO & URLs":') . ' <span style="color:green">' . Configuration::get('PS_SHOP_DOMAIN') . '</span>';
            $prestashop_infos['wrong_domain']['level'] = $this->psIs16x ? 'alert alert-danger' : 'error';
        }

        // Check Orders States
        // 
        $i = 0;
        $order_states = array('AMAZON_ORDER_STATE', 'AMAZON_PREPARATION_STATE', 'AMAZON_SENT_STATE');
        foreach ($order_states as $order_state_config)
        {
            $id_order_state = (int) unserialize(base64_decode(self::configurationGet($order_state_config)));

            if ($id_order_state)
            {
                $order_state = new OrderState($id_order_state, $this->id_lang);

                if (Validate::isLoadedObject($order_state))
                {
                    if ($order_state->send_email)
                    {
                        $prestashop_infos['mail' . $i]['message'] = sprintf($this->l('The order state: "%s" automatically send an email. This is not allowed by Amazon. Please configure an another order status.'), $order_state->name);
                        $prestashop_infos['mail' . $i]['level'] = $this->psIs16x ? 'alert alert-warning' : 'warn';
                    }
                }
            }
        }

        if (!count($prestashop_infos))
            $prestashop_info_ok = true;
        else
            $prestashop_info_ok = false;

        if (!count($php_infos))
            $php_info_ok = true;
        else
            $php_info_ok = false;

        $view_params['informations']['selected_tab'] = $this->_selected_tab() == 'informations' ? true : false ;
        $view_params['informations']['images'] = $this->images;
        $view_params['informations']['display'] = $display;
        $view_params['informations']['env_infos'] = $env_infos;
        $view_params['informations']['php_infos'] = $php_infos;
        $view_params['informations']['php_info_ok'] = $php_info_ok;
        $view_params['informations']['prestashop_infos'] = $prestashop_infos;
        $view_params['informations']['prestashop_info_ok'] = $prestashop_info_ok;

        return($view_params) ;
    }

    // Messaging
    //
    private function _messaging()
    {
        $mail_invoice = $this->config['mail_invoice'];
        $mail_review = $this->config['mail_review'];

        $pass = true;
        $lang = Language::getIsoById($this->id_lang);

        $mail_templates = null;
        $mail_add_files = null;

        $view_params = array();
        $view_params['selected_tab'] = $this->_selected_tab();
        $view_params['request_uri'] = Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']);
        $view_params['selected_tab_messaging'] = $view_params['selected_tab'] == 'messaging' ? 'selected' : '';
        $view_params['images'] = $this->images;
        $view_params['is_ps15'] = version_compare(_PS_VERSION_, '1.5', '>=');
        $view_params['url'] = $this->url;

        // Order State
        //
        $orderStates = OrderState::getOrderStates($this->id_lang);

        $view_params['order_states'] = array();

        $c = 0;
        foreach ($orderStates as $orderState)
        {
            if (!intval($orderState['id_order_state']))
                continue;

            if (!$orderState['invoice'] || $orderState['send_email'])
                continue;

            $view_params['order_states'][$c]['value'] = intval($orderState['id_order_state']);
            $view_params['order_states'][$c]['name'] = $orderState['name'];
            $c++;
        }

        $mailDir = sprintf('%s%s/*.html', $this->path_mail, $lang);

        // Mail Template 
        //
        if (is_dir($this->path_mail . $lang))
        {
            $files = glob($mailDir);

            if ($files)
            {
                $result = preg_replace('#.*/(\w*)\.html#', '$1', $files);

                if (is_array($result))
                    $mail_templates = array_unique($result);
                else
                    $pass = false;
            }
            else
                $pass = false;
        }
        else
            $pass = false;

        // Optionnal Additionnal File
        //
        if (is_dir($this->path_pdf))
        {
            $files = glob($this->path_pdf . "*.pdf");

            if ($files)
            {
                $result = preg_replace('#.*/(\w*)#', '$1', $files);

                if (is_array($result))
                    $mail_add_files = array_unique($result);
            }
        }

        if ($pass)
            $view_params['problem'] = false;
        else
            $view_params['problem'] = true;

        $view_params['mail_templates'] = $mail_templates;
        $view_params['mail_add_files'] = $mail_add_files;
        $view_params['experimental'] = self::enableExperimentalFeatures;

        $view_params['mail_invoice'] = array();
        $view_params['mail_invoice']['active'] = isset($mail_invoice['active']) ? $mail_invoice['active'] : false;
        $view_params['mail_invoice']['template'] = isset($mail_invoice['template']) ? $mail_invoice['template'] : null;
        $view_params['mail_invoice']['additionnal'] = isset($mail_invoice['additionnal']) ? $mail_invoice['additionnal'] : null;
        $view_params['mail_invoice']['order_state'] = isset($mail_invoice['order_state']) && $mail_invoice['order_state'] ? $mail_invoice['order_state'] : null;

        $view_params['mail_review'] = array();
        $view_params['mail_review']['active'] = isset($mail_review['active']) ? $mail_review['active'] : false;
        $view_params['mail_review']['template'] = isset($mail_review['template']) ? $mail_review['template'] : null;
        $view_params['mail_review']['delay'] = isset($mail_review['delay']) ? $mail_review['delay'] : null;
        $view_params['mail_review']['order_state'] = isset($mail_review['order_state']) && $mail_review['order_state'] ? $mail_review['order_state'] : null;

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_MESSAGING]);
    }

    // FBA
    //
    private function _fba()
    {
        $view_params = array();
        $view_params['selected_tab'] = $this->_selected_tab();
        $view_params['selected_tab_fba'] = $view_params['selected_tab'] == 'fba' ? 'selected' : '';
        $view_params['images'] = $this->images;
        $view_params['url'] = $this->url;

        // Order State
        //
        $orderStates = OrderState::getOrderStates($this->id_lang);

        $view_params['order_states'] = array();

        $c = 0;
        foreach ($orderStates as $orderState)
        {
            if (!intval($orderState['id_order_state']))
                continue;

            $view_params['order_states'][$c]['value'] = intval($orderState['id_order_state']);
            $view_params['order_states'][$c]['name'] = $orderState['name'];
            $c++;
        }

        $view_params['fba'] = array();
        $view_params['fba']['formula'] = $this->config['fba_formula'];
        $view_params['fba']['multichannel'] = $this->config['fba_multichannel'];
        $view_params['fba']['multichannel_auto'] = $this->config['fba_multichannel_auto'];
        $view_params['fba']['order_state'] = $this->config['fba_order_state'];
        $view_params['fba']['multichannel_state'] = $this->config['fba_multichannel_state'];
        $view_params['fba']['multichannel_sent_state'] = $this->config['fba_multichannel_sent_state'];

        $this->context->smarty->assign($view_params);

        $this->_html .= $this->context->smarty->fetch($this->path . self::$templates[self::TEMPLATE_TAB_FBA]);
    }

    // Display category tree
    //
    public function recurseCategoryForInclude($indexedCategories, $categories, $current, $id_category = 1, $id_category_default = NULL, $default_categories = array(), $default_profiles = array(), $init = false)
    {
        global $done;
        static $irow;
        global $chtml;
        $chtml = isset($chtml) ? $chtml : null;

        if (is_array($default_categories) && in_array($id_category, $default_categories))
            $checked = ' checked="checked"';
        else
            $checked = '';

        if (!isset($done[$current['infos']['id_parent']]))
            $done[$current['infos']['id_parent']] = 0;
        $done[$current['infos']['id_parent']] += 1;

        if ($index = $current['infos']['id_parent'])
            $todo = sizeof($categories[$index]);
        else
            $todo = null;

        $doneC = $done[$current['infos']['id_parent']];

        $level = $current['infos']['level_depth'] + 1;
        $img = $init == true ? 'lv1.gif' : 'lv' . $level . '_' . ($todo == $doneC ? 'f' : 'b') . '.gif';

        $saved_profiles = $this->profiles;

        $select = '
            <select rel="profile2category[' . $id_category . ']" style="width:180px;margin-right:10px;" />
             <option value="">' . $this->l('Please choose a profile') . '</option>';

        if ($saved_profiles['name'])
            foreach ($saved_profiles['name'] as $profile_id => $profile_name)
            {
                if ($profile_name == NULL)
                    continue;

                if (isset($default_profiles[$id_category]) && $default_profiles[$id_category] == $profile_name)
                    $selected = 'selected="selected"';
                else
                    $selected = '';

                $select .= '
                    <option value="' . $profile_name . '" ' . $selected . ' />' . $profile_name . '</option>';
            }
        $select .= '
            </select>';

        $chtml .= '
            <tr class="cat-line' . ($irow++ % 2 ? ' alt_row' : '') . '">
            <td>
                <input type="checkbox" rel="categoryBox[]" class="category' . ($id_category_default == $id_category ? ' id_category_default' : '') . '" id="category_' . $id_category . '" value="' . $id_category . '"' . $checked . ' />
            </td>
            <td style="cursor:pointer">
                <img src="' . $this->images . $img . '" alt="" /> &nbsp;<label for="category_' . $id_category . '" class="t">' . stripslashes($current['infos']['name']) . '</label>
            </td>
            <td align="right">
                ' . ($init == false ? $select : '') . '
            </td>
            </tr>';

        if (isset($categories[$id_category]))
        {
            foreach ($categories[$id_category] AS $key => $row)
                if ($key != 'infos')
                    self::recurseCategoryForInclude($indexedCategories, $categories, $categories[$id_category][$key], $key, $id_category_default, $default_categories, $default_profiles);
        }

        return($chtml);
    }

    //
    // Send Email to Customer with Attached Invoice
    //
    private function _manageInvoiceOrderState($params)
    {
        $id_order = (int) $params['id_order'];

        // Mail/Invoice is Active ?
        //
        $mail_invoice = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MAIL_INVOICE')));

        if (!isset($mail_invoice['active']) || !(int) $mail_invoice['active'] || !isset($mail_invoice['order_state']))
        {
            return(false);
        }
        if (!($order = new Order($id_order)))
            return(false);

        // Not an amazon order
        //
        if (strtolower($order->module) != strtolower($this->name))
            return;

        $debug = (bool) unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG')));

        // Matching Order Status
        //
        if ($params['newOrderStatus']->id != (int) $mail_invoice['order_state'])
            return(false);

        // Starting Mail/Invoice sending
        //
        require_once(dirname(__FILE__) . '/classes/amazon.messaging.class.php');

        $messaging = new Amazon_Messaging($debug);
        $result = $messaging->sendInvoice($id_order);

        if (!$result && $debug)
        {
            printf('%s:#%d Amazon_Messaging::sendInvoice(%d) failed' . "<br />\n", basename(__FILE__), __LINE__, $id_order);
            die;
        }
    }

    //
    // Send Email to Customer with Attached Invoice
    //
    private function _manageReviewIncentiveOrderState($params)
    {
        $id_order = (int) $params['id_order'];

        // Mail/Invoice is Active ?
        //
        $mail_review = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MAIL_REVIEW')));

        if (!isset($mail_review['active']) || !(int) $mail_review['active'] || !isset($mail_review['order_state']))
        {
            return(false);
        }

        if (!($order = new Order($id_order)))
            return(false);

        // Not an amazon order
        //
        if (strtolower($order->module) != strtolower($this->name))
            return;

        $debug = (bool) unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG')));

        // Matching Order Status
        //
        if ($params['newOrderStatus']->id != (int) $mail_review['order_state'])
            return(false);

        // Starting Mail/Invoice sending
        //
        require_once(dirname(__FILE__) . '/classes/amazon.messaging.class.php');

        $messaging = new Amazon_Messaging($debug);
        $result = $messaging->sendReviewIncentive($id_order);

        if (!$result && $debug)
        {
            printf('%s:#%d Amazon_Messaging::sendInvoice(%d) failed' . "<br />\n", basename(__FILE__), __LINE__, $id_order);
            die;
        }
    }

    //
    // Manage Orders Statuses 
    //
    private function _manageShippedOrderState($params)
    {
        $bulk_mode = (bool) self::configurationGet('AMAZON_BULK_MODE');

        // Bulk Mode, we don't update orders statuses
        //
        if ($bulk_mode)
            return;

        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/amazon.order.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/amazon.orderhistory.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/amazon.tools.class.php');
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/amazon.carrier.class.php');

        $id_order = intval($params['id_order']);

        if (!($order = new Amazon_Order($id_order)))
            return(false);

        $id_lang = $order->id_lang;

        // Not an amazon order
        //
        if (strtolower($order->module) != strtolower($this->name))
            return;

        $debug = (bool) unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG')));

        // Config
        //
        $sentstate = unserialize(base64_decode(self::configurationGet('AMAZON_SENT_STATE')));

        // Matching Order Status
        //
        if ($params['newOrderStatus']->id != ( isset($sentstate) ? $sentstate : 0))
        {
            if ( $debug )
                die(sprintf('%s(%d): Order state %d doesn\'t match the expected state: %d', basename(__FILE__), __LINE__, $params['newOrderStatus']->id, $sentstate)) ;
            return(false);
        }
        
        if (!($amazonCarrier = Amazon_Carrier::getAmazonCarrierById($order->id_carrier, $id_lang, $debug)))
        {
            if ( $debug )
                die(sprintf('%s(%d): Amazon_Carrier::getAmazonCarrierById(%d) didn\'t return any valid carrier', basename(__FILE__), __LINE__, $order->id_carrier)) ;            
            return(false);
        }

        $trackingNumber = null;

        if (isset($order->shipping_number) && !empty($order->shipping_number))
            $trackingNumber = $order->shipping_number;
        elseif (($shipping_number = Tools::getValue('shipping_number')) && !empty($shipping_number))
            $trackingNumber = $shipping_number;

        // Require W/S
        //
        require_once(dirname(__FILE__) . '/classes/amazon.webservice.class.php');

        // Init
        //
        $amazon = Amazon_Tools::selectPlatform($id_lang, $debug);

        if (!$amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug))
        {
            if ($debug)
                die($this->l('Unable to login'));
            return;
        }

        // Amazon Throtlling Management
        // 
        $amazonApi->setTimerReadHandler('Configuration', 'get', 'AMAZON_API_TIMER');
        $amazonApi->setTimerWriteHandler('Configuration', 'updateValue', 'AMAZON_API_TIMER');
        // Drop in this context
        $amazonApi->setTimerAction(Amazon_WebService::DROP_THROTLLED_QUERIES);

        // If it is a listed carrier, send carrier code, else, send carrier name
        //
        if (Amazon_Carrier::isCarrierCode($amazonCarrier))
        {
            $carrierCode = $amazonCarrier;
            $carrierName = null;
        }
        else
        {
            $carrierCode = null;
            $carrierName = $amazonCarrier;
        }
        // Set to sent on Amazon
        //
        $result = $amazonApi->confirmOrder($order->marketPlaceOrderId, $carrierCode, $carrierName, NULL, $trackingNumber);

        if ($debug)
        {
            echo nl2br(print_r($result, true));
            die;
        }
        return;
    }

    //
    // Gestion des relations avec la MarketPlace sur la commande
    //
    public function hookDisplayAdminOrder($params)
    {
        require_once(_PS_MODULE_DIR_ . $this->name . '/classes/amazon.admin_order.class.php');

        $adminOrder = new Amazon_AdminOrder() ;
        $this->_html = $adminOrder->marketplaceOrderDisplay($params); 
        return($this->_html);        
    }

    // Hook Update Order 
    //
    public function hookPostUpdateOrderStatus($params)
    {
        return($this->hookActionOrderStatusPostUpdate($params));
    }

    public function hookActionOrderStatusPostUpdate($params)
    {
        // Switch Orders to Shipped on Amazon
        //
        $this->_manageShippedOrderState($params);

        // Manage Messaging with customer (invoice)
        //
        $this->_manageInvoiceOrderState($params);

        // Manage Messaging with customer (Seller Review Incentive)
        //
        if (self::enableExperimentalFeatures)
            $this->_manageReviewIncentiveOrderState($params);
    }

    // Hook for the optional module :
    // Market Place Strategies - Strategies on the products price
    // displayed on the product tab
    //
    public function hookbackOfficeHeader($params)
    {
        return($this->hookDisplayBackOfficeHeader($params));
    }

    public function hookDisplayBackOfficeHeader($params)
    {
        $html = '';

        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $amazonTab = strtolower(Tools::getValue('tab')) == 'admincatalog';
        else
            $amazonTab = strtolower(Tools::getValue('controller')) == 'adminproducts';

        if ($amazonTab && Tools::getValue('id_product') && (Tools::getValue('addproduct') !== false || Tools::getValue('updateproduct') !== false))
        {
            $html .= '<meta name="amazon-options" content="' . $this->url . 'functions/product_options.php" />';
            $html .= $this->_autoAddJS($this->url . 'js/product_options.js');
            $html .= $this->_autoAddCSS($this->url . 'css/product_options.css');

            if ($this->strategies)
            {
                $html .= $this->_autoAddJS($this->url . 'js/product_bid.js');
                $html .= $this->_autoAddCSS($this->url . 'css/product_bid.css');
            }
        }

        if (version_compare(_PS_VERSION_, '1.4', '<'))
            print($html);
        else
            return($html);
    }

    private function _autoAddJS($url)
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            if (isset($this->context->controller) && method_exists($this->context->controller, 'addJquery'))
                $this->context->controller->addJquery();

            return ( $this->context->controller->addJS($url) && '');
        }
        else
        {
            return( sprintf('<script type="text/javascript" src="%s"></script>' . "\n", $url) );
        }
    }

    private function _autoAddCSS($url, $media = 'all')
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            return( $this->context->controller->addCSS($url, $media) && '' );
        }
        else
        {
            return(sprintf('<link rel="stylesheet" type="text/css" href="%s">' . "\n", $url));
        }
    }

    public function hookUpdateCarrier($params)
    {
        // Amazon Carrier Mapping
        $carriers = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER')));

        if ($carriers && is_array($carriers))
            foreach ($carriers as $id_lang => $ps_carriers)
                if ($ps_carriers && is_array($ps_carriers))
                    foreach ($ps_carriers as $index => $carrier)
                        if ($carriers[$id_lang][$index] == $params['id_carrier'])
                            $carriers[$id_lang][$index] = $params['carrier']->id;
        self::configurationUpdateValue('AMAZON_CARRIER', base64_encode(serialize($carriers)));

        // Amazon FBA MultiChannel Carrier Mapping
        $carriers_multichannel = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER_MULTICHANNEL')));

        if ($carriers_multichannel && is_array($carriers_multichannel))
            foreach ($carriers_multichannel as $id_lang => $mapping)
                if (isset($mapping['prestashop']) && is_array($mapping['prestashop']))
                    foreach ($mapping['prestashop'] as $key => $id_carrier)
                        if ($id_carrier == $params['id_carrier'])
                            $carriers_multichannel[$id_lang]['prestashop'][$key] = $params['carrier']->id;
        self::configurationUpdateValue('AMAZON_CARRIER_MULTICHANNEL', base64_encode(serialize($carriers_multichannel)));

        // Amazon Outgoing Orders Carrier Mapping
        $carriers_default = unserialize(base64_decode(self::configurationGet('AMAZON_CARRIER_DEFAULT')));

        if ($carriers_default && is_array($carriers_default))
            foreach ($carriers_default as $id_lang => $mapping)
                if (isset($mapping['prestashop']) && is_array($mapping['prestashop']))
                    foreach ($mapping['prestashop'] as $key => $id_carrier)
                        if ($id_carrier == $params['id_carrier'])
                            $carriers_default[$id_lang]['prestashop'][$key] = $params['carrier']->id;
        self::configurationUpdateValue('AMAZON_CARRIER_DEFAULT', base64_encode(serialize($carriers_default)));
    }

    public function hookActionProductAttributeDelete($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        return( Amazon_Product::marketplaceActionRemoveAllCombinations(self::Remove, $id_product) );
    }

    public function hookActionProductAdd($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        return( Amazon_Product::marketplaceActionSet(self::Add, $id_product) );
    }

    public function hookActionProductDelete($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        if (!isset($params['product']->reference))
            return(false);

        return( Amazon_Product::marketplaceActionSet(self::Remove, $id_product, null, $params['product']->reference) );
    }

    public function hookActionProductSave($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        return( Amazon_Product::marketplaceActionSet(self::Update, $id_product) );
    }

    public function hookActionUpdateQuantity($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        $id_product_attribute = isset($params['id_product_attribute']) ? $params['id_product_attribute'] : null;

        return( Amazon_Product::marketplaceActionSet(self::Update, $id_product, $id_product_attribute) );
    }

    public function hookActionProductUpdate($params)
    {
        if (isset($params['product']->id))
            $id_product = $params['product']->id;
        elseif (isset($params['id_product']))
            $id_product = $params['id_product'];
        elseif (isset($params['product']))
            $id_product = $params['product']['id_product'];
        else
            return(false);

        return( Amazon_Product::marketplaceActionSet(self::Update, $id_product) );
    }

    public function hookActionProductAttributeUpdate($params)
    {
        if (!isset($params['id_product_attribute']))
            return(false);

        return( Amazon_Product::marketplaceActionUpdateCombination($params['id_product_attribute']) );
    }

    public function hookActionPaymentConfirmation($params)
    {
        // Only if FBA MultiChannel is active
        if (!(bool) self::configurationGet('AMAZON_FBA_MULTICHANNEL'))
            return(false);
        if (!(bool) self::configurationGet('AMAZON_FBA_MULTICHANNEL_AUTO'))
            return(false);

        if (!isset($params['id_order']))
            return(false);

        $id_order = (int) $params['id_order'];

        require_once(dirname(__FILE__) . '/classes/amazon.multichannel.class.php');
        require_once(dirname(__FILE__) . '/classes/amazon.mail.logger.class.php');

        $debug = (bool) unserialize(base64_decode(self::configurationGet('AMAZON_DEBUG')));
        $send_email = (bool) self::configurationGet('AMAZON_EMAIL');
        $message = null;

        if ($debug && $send_email)
        {
            $caller = Amazon_Tools::CallingFunction();
            $message .= sprintf('%s : %s' . self::LF, $caller, 'Testing FBA Eligibility');
        }

        if (!($order = Amazon_MultiChannel::isEligible($id_order)))
        {
            if ($debug && $send_email)
            {
                $caller = Amazon_Tools::CallingFunction();
                $message .= sprintf('%s : %s' . self::LF, $caller, 'Order is not eligible');
                Amazon_MailLogger::message($message);
            }
            return(false);
        }
        $id_lang = $order->id_lang;

        // Eligibility Check passed, place a new FBA Order
        //
        $amazonMultiChannelOrder = new Amazon_MultiChannel($id_order);

        if (!Validate::isLoadedObject($amazonMultiChannelOrder))
        {
            if ($debug && $send_email)
            {
                $caller = Amazon_Tools::CallingFunction();
                $message .= sprintf('%s : %s' . self::LF, $caller, 'Unable to read object');
                Amazon_MailLogger::message($message);
            }
            // abnormal
            return(false);
        }
        // Module itself
        if (strtolower($amazonMultiChannelOrder->module) == $this->name)
            return(false);

        // Already ordered, shipped or canceled 
        //
        if (strlen($amazonMultiChannelOrder->marketPlaceChannelStatus))
            return(false);

        if (!($AmazonFBAOrder = $amazonMultiChannelOrder->CreateFulfillmentOrder($debug)))
        {
            if ($debug && $send_email)
            {
                $caller = Amazon_Tools::CallingFunction();
                $message .= sprintf('%s : %s' . self::LF, $caller, 'CreateFulfillmentOrder Failed');
                $message .= print_r($AmazonFBAOrder, true);
                Amazon_MailLogger::message($message);
            }
            elseif ($debug)
            {
                echo nl2br(print_r($AmazonFBAOrder, true));
                die;
            }
            return(false);
        }

        if ($send_email)
        {
            $mailtemplate['{order}'] = sprintf('%s : %s
                        %s : %s
                        %s : %s', $this->l('Order ID'), $id_order, $this->l('Date'), $AmazonFBAOrder['DisplayableOrderDateTime'], $this->l('Shipping'), $AmazonFBAOrder['ShippingSpeedCategory']);
            $mailtemplate['{order}'] = nl2br($mailtemplate['{order}']);

            $mailtemplate['{customer_address}'] = sprintf('
                %s
                %s
                %s
                %s
                %s %s (%s)
                %s', $AmazonFBAOrder['DestinationAddress']['Name'], $AmazonFBAOrder['DestinationAddress']['Line1'], $AmazonFBAOrder['DestinationAddress']['Line2'], $AmazonFBAOrder['DestinationAddress']['Line3'], $AmazonFBAOrder['DestinationAddress']['PostalCode'], $AmazonFBAOrder['DestinationAddress']['City'], $AmazonFBAOrder['DestinationAddress']['CountryCode'], $AmazonFBAOrder['DestinationAddress']['PhoneNumber']
                    );
            $mailtemplate['{customer_address}'] = nl2br($mailtemplate['{customer_address}']);

            $mailtemplate['{ordered_items}'] = null;

            foreach ($AmazonFBAOrder['Items'] as $Item)
                $mailtemplate['{ordered_items}'] .= sprintf('%d x %s - %s' . "\n", $Item['Quantity'], $Item['SKU'], $Item['DisplayableComment']);
            $mailtemplate['{ordered_items}'] = nl2br($mailtemplate['{ordered_items}']);

            $mailtemplate['{amazon_info}'] = sprintf($this->l('Order #%s submitted on %s Amazon response ID: %s'), $AmazonFBAOrder['DisplayableOrderId'], $AmazonFBAOrder['DisplayableOrderDateTime'], $AmazonFBAOrder['Response']
                    );

            $email_address = Configuration::get('PS_SHOP_EMAIL');

            if ($debug)
            {
                $caller = Amazon_Tools::CallingFunction();
                $message .= sprintf('%s : %s' . self::LF, $caller, 'Amazon FBA Order Complete');
                $message .= print_r($AmazonFBAOrder, true);
                Amazon_MailLogger::message($message);
            }
            Mail::Send(
                    $id_lang, // id_lang
                    'fba_multichannel', // template
                    $this->l('Amazon FBA: A new multichannel order has been processed'), // subject
                    $mailtemplate, // templateVars 
                    $email_address, // to
                    null, // To Name
                    null, // From
                    null, // From Name 
                    null, // Attachment
                    null, // SMTP
                    $this->path . 'mail/');
        }

        if ($debug && !$send_email)
        {
            echo nl2br(print_r($AmazonFBAOrder, true));
            die;
        }
    }

    /* HOOKS FOR BACKWARD COMPATIBILITY - PRESTASHOP 1.3 and 1.4 */

    public function hookUpdateQuantity($params)
    {
        return( $this->hookActionUpdateQuantity($params) );
    }

    public function hookUpdateProduct($params)
    {
        return( $this->hookActionProductUpdate($params) );
    }

    public function hookAfterSaveProduct($params)
    {
        return( $this->hookActionProductUpdate($params) );
    }
    
    public function hookActionObjectProductUpdateAfter($params)
    {
        if ( ! isset($params['object']) || ! $params['object']->id )   return ;

        $obj = new StdClass ;
        $obj->id = $params['object']->id ;
        
        return( $this->hookActionProductUpdate( array('product' => $obj) ) );
    }
    
    public function hookUpdateProductAttribute($params)
    {
        return( $this->hookActionProductAttributeUpdate($params) );
    }

    public function hookDeleteProduct($params)
    {
        return( $this->hookActionProductDelete($params) );
    }

    public function hookAddProduct($params)
    {
        return( $this->hookActionProductAdd($params) );
    }

    public function hookActionCarrierUpdate($params)
    {
        return( $this->hookUpdateCarrier($params) );
    }

    public function hookAdminOrder($params)
    {
        return( $this->hookDisplayAdminOrder($params) );
    }

    public function hookPaymentConfirm($params)
    {
        return( $this->hookActionPaymentConfirmation($params) );
    }

    //
    // HOOKs SETUP for all Prestashop releases
    //
    private function _hookSetup($action)
    {
        if (version_compare(_PS_VERSION_, '1.4.9', '<'))
        {
            $expectedHooks =
                    array('addproduct', 'deleteProduct', 'updateProductAttribute', 'updateQuantity', 'updateproduct', 'updateCarrier', 'adminOrder', 'backOfficeHeader', 'postUpdateOrderStatus', 'paymentConfirm');
        }
        elseif (version_compare(_PS_VERSION_, '1.5', '<'))
        {
            $expectedHooks =
                    array('addproduct', 'deleteProduct', 'updateProductAttribute', 'updateQuantity', 'updateproduct', 'updateCarrier', 'adminOrder', 'backOfficeHeader', 'postUpdateOrderStatus', 'paymentConfirm', 'afterSaveProduct');
        }
        else
        {
            $expectedHooks =
                    array('actionObjectProductUpdateAfter', 'displayAdminOrder', 'displayBackOfficeHeader', 'actionCarrierUpdate', 'actionUpdateQuantity', 'actionProductAttributeDelete', 'actionProductDelete', 'actionAttributeGroupDelete', 'actionProductAdd', 'actionAttributeGroupSave', 'actionOrderStatusPostUpdate', 'actionPaymentConfirmation');            
        }
        $pass = true;

        if ($action == Amazon::Add)
            foreach ($expectedHooks as $expectedHook)
                if (!$this->isRegisteredInHook($expectedHook))
                    if (!$this->registerHook($expectedHook))
                    {
                        $this->_postErrors[] = $this->l('Unable to Register Hook') . ':' . $expectedHook;
                        $pass = false;
                    }
        if ($action == Amazon::Remove)
            foreach ($expectedHooks as $expectedHook)
                if ($this->isRegisteredInHook($expectedHook))
                    if (!$this->unregisterHook($expectedHook))
                    {
                        $this->_postErrors[] = $this->l('Unable to Unregister Hook') . ':' . $expectedHook;
                        $pass = false;
                    }
        return($pass);
    }

    private function _fixPrestashopIssues()
    {
        // Create an empty mail translation file if it is empty to fix the issue :
        // http://forge.prestashop.com/browse/PSCFV-10380
        //
        $mail_invoice = unserialize(base64_decode(self::configurationGet('AMAZON_MAIL_INVOICE')));

        if (isset($mail_invoice['active']) && $mail_invoice['active'])
        {
            foreach (Amazon_Tools::languages() as $language)
            {
                $iso_code = $language['iso_code'];

                $dir = _PS_MAIL_DIR_ . $iso_code;
                $file = _PS_MAIL_DIR_ . $iso_code . '/lang.php';

                if (!is_dir($dir))
                    @mkdir($dir); // could be not allowed, do not display output

                if (!file_exists($file))
                    @file_put_contents($file, null);
            }
        }
    }

    // MarketPlace Strategies - Optionnal Module
    //
    private function _addMarketPlaceTables()
    {
        $pass = true;
        $errors = null;

        $currentVersion = self::configurationGet('AMAZON_CURRENT_VERSION');

        // Check if exists
        //
        $tables = array();
        $query = Db::getInstance()->ExecuteS('show tables');
        foreach ($query as $rows)
            foreach ($rows as $table)
                $tables[$table] = 1;

        if (isset($tables[_DB_PREFIX_ . 'marketplace_strategies']))
        {
            $sqls = array();
            $fields = array();

            // Amazon Update - Add new fields
            //
            $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'marketplace_strategies`');
            if ($query)
                foreach ($query as $row)
                    $fields[$row['Field']] = 1;

            if (version_compare($currentVersion, '3.8', '<'))
            {
                if (!isset($fields['id_product_attribute']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_strategies` ADD  `id_product_attribute` INT NULL DEFAULT NULL AFTER  `id_product`';

                if (!isset($fields['ASIN']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_strategies` ADD  `ASIN` VARCHAR( 16 ) NULL DEFAULT NULL AFTER `id_lang`';

                if (!isset($fields['gap']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_strategies` ADD  `gap` FLOAT NULL DEFAULT NULL AFTER  `target_price`';
            }

            foreach ($sqls as $sql)
            {
                if (!Db::getInstance()->Execute($sql))
                {
                    $errors .= 'ERROR: ' . $sql . "<br />\n";
                    $pass = false;
                }
            }
        }
        else
        {
            $sql =
                    'CREATE TABLE  `' . _DB_PREFIX_ . 'marketplace_strategies` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `id_product` int(11) NOT NULL,
                `id_product_attribute` INT NULL DEFAULT NULL,
                `id_lang` int(11) NOT NULL,
                `minimum_price` float NOT NULL,
                `actual_price` float NOT NULL,
                `target_price` float NOT NULL,
                `gap` float NOT NULL,
                PRIMARY KEY (`id`),
                KEY `id_product` (`id_product`),
                KEY `id_product_lang` (`id_product`,`id_lang`)
              ) ;';

            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql . "<br />\n";
                $pass = false;
            }
        }

        if (!isset($tables[_DB_PREFIX_ . 'marketplace_product_action']))
        {
            $sql = '
                    CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'marketplace_product_action` (
                    `id_product` int(11) NOT NULL,
                    `id_product_attribute` int(11) DEFAULT NULL,
                    `id_lang` int(11) NOT NULL,
                    `sku` varchar(64) DEFAULT NULL,
                    `marketplace` varchar(12) NOT NULL,
                    `action` char(1) NOT NULL,
                    `date_add` datetime DEFAULT NULL,
                    `date_upd` datetime DEFAULT NULL,
                    UNIQUE KEY `id_product` (`id_product`,`id_lang`,`marketplace`,`action`),
                    KEY `id_lang` (`id_lang`,`marketplace`)
                    ) ;';

            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql . "<br />\n";
                $pass = false;
            }
        }

        if (!isset($tables[_DB_PREFIX_ . 'marketplace_configuration']))
        {
            $sql = '
                    CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'marketplace_configuration` (
                    `marketplace` VARCHAR( 32 ) NULL DEFAULT NULL ,
                    `configuration` VARCHAR( 32 ) NULL DEFAULT NULL ,
                    `value` LONGTEXT NOT NULL,
                    UNIQUE KEY `configuration` (`marketplace` ,`configuration`)
                    ) ;';

            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql . "<br />\n";
                $pass = false;
            }
        }

        if (isset($tables[_DB_PREFIX_ . 'marketplace_product_option']))
        {
            $sqls = array();

            $fields = array();

            // Amazon Update - Add new fields
            //
            $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'marketplace_product_option`');
            if ($query)
                foreach ($query as $row)
                    $fields[$row['Field']] = 1;

            // For versions before 3.8 - Added on 2013-09-21
            //                     
            if (version_compare($currentVersion, '3.8', '<'))
            {
                if (!isset($fields['nopexport']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `nopexport` TINYINT NULL DEFAULT NULL AFTER `force`';
                if (!isset($fields['noqexport']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `noqexport` TINYINT NULL DEFAULT NULL AFTER `nopexport`';
                if (!isset($fields['latency']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `latency` TINYINT NULL DEFAULT NULL AFTER `noqexport`';
                if (!isset($fields['disable']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `disable` TINYINT NULL DEFAULT NULL AFTER `latency`';
                if (!isset($fields['price']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `price` FLOAT NULL DEFAULT NULL AFTER `disable`';
                if (!isset($fields['asin1']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `asin1` VARCHAR(16) NULL DEFAULT NULL AFTER `price`';
                if (!isset($fields['asin2']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `asin2` VARCHAR(16) NULL DEFAULT NULL AFTER `asin1`';
                if (!isset($fields['asin3']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `asin3` VARCHAR(16) NULL DEFAULT NULL AFTER `asin2`';
                if (!isset($fields['shipping']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `shipping` FLOAT NULL DEFAULT NULL AFTER `asin3`';
                if (!isset($fields['shipping_type']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `shipping_type` FLOAT NULL DEFAULT NULL AFTER `shipping`';
                if (!isset($fields['fba']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `fba` TINYINT NULL DEFAULT NULL AFTER `noqexport`';
                if (!isset($fields['fba_value']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `fba_value` FLOAT NULL DEFAULT NULL AFTER `fba`';
            }

            // For versions before 3.9 - Added on 2013-09-21
            //            
            if (version_compare($currentVersion, '3.9', '<'))
            {
                if (!isset($fields['bullet_point1']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `bullet_point1` VARCHAR(2000) NULL DEFAULT NULL AFTER `text`';
                if (!isset($fields['bullet_point2']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `bullet_point2` VARCHAR(2000) NULL DEFAULT NULL AFTER `bullet_point1`';
                if (!isset($fields['bullet_point3']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `bullet_point3` VARCHAR(2000) NULL DEFAULT NULL AFTER `bullet_point2`';
                if (!isset($fields['bullet_point4']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `bullet_point4` VARCHAR(2000) NULL DEFAULT NULL AFTER `bullet_point3`';
                if (!isset($fields['bullet_point5']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `bullet_point5` VARCHAR(2000) NULL DEFAULT NULL AFTER `bullet_point4`';
            }

            if (version_compare($currentVersion, '4', '<'))
            {
                $query = Db::getInstance()->ExecuteS('SHOW INDEX FROM `' . _DB_PREFIX_ . 'marketplace_product_option`');

                $ASIN_Index = false;
                $Product_Index = false;
                $Old_Product_Index1 = false;
                $Old_Product_Index2 = false;

                foreach ($query as $table_item)
                {
                    if ($table_item['Key_name'] == 'ASIN')
                        $ASIN_Index = true;
                    elseif ($table_item['Key_name'] == 'id_product')
                        $Old_Product_Index1 = true;
                    elseif ($table_item['Key_name'] == 'id_product_lang_attribute')
                        $Old_Product_Index2 = true;
                    elseif ($table_item['Key_name'] == 'PRIMARY')
                        $Product_Index = true;
                }

                if ($Old_Product_Index1)
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` DROP INDEX  `id_product` ';

                if ($Old_Product_Index2)
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` DROP INDEX  `id_product_lang_attribute`';

                if (!$ASIN_Index)
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD INDEX `ASIN` (  `asin1` )';

                if (!$Product_Index)
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD PRIMARY KEY `product_index` (`id_product`, `id_product_attribute`, `id_lang`)';
            }

            // For very oldest versions - Added on 2013-09-21
            //
            if (version_compare($currentVersion, '3.5', '<'))
            {
                // For Next updates - for old module installations - the scheme has changed
                //
                if (isset($fields['latency']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `latency`  `latency` TINYINT NULL DEFAULT NULL';
                if (isset($fields['nopexport']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `nopexport`  `nopexport` TINYINT NULL DEFAULT NULL';
                if (isset($fields['noqexport']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `noqexport`  `noqexport` TINYINT NULL DEFAULT NULL';
                if (isset($fields['price']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `price`  `price` FLOAT NULL DEFAULT NULL';
                if (isset($fields['asin1']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `asin1`  `asin1` VARCHAR(16) NULL DEFAULT NULL';
                if (isset($fields['asin2']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `asin2`  `asin2` VARCHAR(16) NULL DEFAULT NULL';
                if (isset($fields['asin3']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `asin3`  `asin3` VARCHAR(16) NULL DEFAULT NULL';
                if (isset($fields['disable']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `disable`  `disable` TINYINT NULL DEFAULT NULL';
                if (isset($fields['force']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `force`  `force` TINYINT NULL DEFAULT NULL';
                if (isset($fields['text']))
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` CHANGE  `text`  `text` VARCHAR(256) NULL DEFAULT NULL';

                // Added on 2012/11/26
                //
                if (!isset($fields['id_product_attribute']))
                {
                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` ADD  `id_product_attribute` INT NULL DEFAULT NULL AFTER `id_lang`';

                    $sqls[] = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'marketplace_product_option` 
                               ADD UNIQUE  `id_product_lang_attribute` (  `id_product` ,  `id_lang` ,  `id_product_attribute` )';
                }
            }

            foreach ($sqls as $sql)
            {
                if (!Db::getInstance()->Execute($sql))
                {
                    $errors .= 'ERROR: ' . $sql . "<br />\n";
                    $pass = false;
                }
            }
        }
        else
        {
            $sql = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'marketplace_product_option` (
                  `id_product` int(11) NOT NULL,
                  `id_lang` int(11) NOT NULL,
                  `id_product_attribute` int(11) DEFAULT NULL,
                  `force` tinyint(4) DEFAULT NULL,
                  `nopexport` tinyint(4) DEFAULT NULL,
                  `noqexport` tinyint(4) DEFAULT NULL,
                  `fba` tinyint(4) DEFAULT NULL,
                  `fba_value` float DEFAULT NULL,
                  `latency` tinyint(4) DEFAULT NULL,
                  `disable` tinyint(4) DEFAULT NULL,
                  `price` float DEFAULT NULL,
                  `asin1` varchar(16) DEFAULT NULL,
                  `asin2` varchar(16) DEFAULT NULL,
                  `asin3` varchar(16) DEFAULT NULL,
                  `text` varchar(256) DEFAULT NULL,
                  `bullet_point1` varchar(2000) DEFAULT NULL,
                  `bullet_point2` varchar(2000) DEFAULT NULL,
                  `bullet_point3` varchar(2000) DEFAULT NULL,
                  `bullet_point4` varchar(2000) DEFAULT NULL,
                  `bullet_point5` varchar(2000) DEFAULT NULL,
                  `shipping` float DEFAULT NULL,
                  `shipping_type` tinyint(4) DEFAULT NULL,
                  PRIMARY KEY `product_index` (`id_product`, `id_product_attribute`, `id_lang`),
                  KEY `ASIN` (`asin1`)
                ) ;';

            if (!Db::getInstance()->Execute($sql))
            {
                $errors .= 'ERROR: ' . $sql . "<br />\n";
                $pass = false;
            }
        }

        if ($errors)
            $this->_postErrors[] = $errors;

        return($pass);
    }

    private function _removeMarketPlaceTables()
    {
        $pass = true;
        //return(true);
        // Check if exists
        //
      $tables = array();
        $query = Db::getInstance()->ExecuteS('show tables');
        foreach ($query as $rows)
            foreach ($rows as $table)
                $tables[$table] = 1;

        foreach (array('marketplace_product_action', 'marketplace_configuration', 'marketplace_product_option', 'marketplace_strategies') as $marketplace_table)
        {
            if (isset($tables[_DB_PREFIX_ . $marketplace_table]))
            {
                $sql = 'DROP TABLE  `' . _DB_PREFIX_ . $marketplace_table . '` ; ';

                if (!Db::getInstance()->Execute($sql))
                    $pass = false;
            }
        }
        return($pass);
    }

    private function _addBackwardCompatibilityFields() // For PS < 1.4 releases
    {
        $pass = true;

        if (version_compare(_PS_VERSION_, '1.4', '<'))
        {
            $fields = array();
            $query = Db::getInstance()->ExecuteS('show columns from `' . _DB_PREFIX_ . 'carrier`');
            if ($query)
                foreach ($query as $row)
                    $fields[$row['Field']] = 1;

            if (!isset($fields['external_module_name']))
            {
                if (!Db::getInstance()->Execute('ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'carrier` ADD  `external_module_name` VARCHAR( 64 ) NULL DEFAULT NULL AFTER `is_module`'))
                    $pass = false;
            }
        }
        return($pass);
    }

    // Add MarketPlace OrderID in the order table
    //
    private function _addMarketPlaceField()
    {
        $pass = true;

        // Adding Marketplace fields - order
        //
        $fields = array();
        $query = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'orders`');
        if ($query)
            foreach ($query as $row)
                $fields[$row['Field']] = 1;

        if (!isset($fields['mp_order_id']))
        {
            if (!Db::getInstance()->Execute('ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_order_id` VARCHAR( 24 ) NULL, ADD INDEX (`mp_order_id` )'))
                $pass = false;
        }

        // Adding Marketplace fields - status
        //
        if (!isset($fields['mp_status']))
        {
            if (!Db::getInstance()->Execute('ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_status` VARCHAR( 24 ) NULL'))
                $pass = false;
        }

        // Adding Marketplace fields - channel
        //
        if (!isset($fields['mp_channel']))
        {
            if (!Db::getInstance()->Execute('ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_channel` VARCHAR( 16 ) NULL'))
                $pass = false;
        }
        if (!isset($fields['mp_channel_status']))
        {
            if (!Db::getInstance()->Execute('ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'orders` ADD  `mp_channel_status` VARCHAR( 32 ) NULL AFTER `mp_channel`'))
                $pass = false;
        }

        // For Updates : Set All Order to checked to avoid to send many orders statuses to Amazon
        //
        require_once(dirname(__FILE__) . '/classes/amazon.order.class.php');

        $fields = array();
        $query = Db::getInstance()->getRow('SELECT count(`id_order`) as `count` FROM `' . _DB_PREFIX_ . 'orders` WHERE `mp_status` = ' . Amazon_Order::Checked . ' AND (`module` = "amazon" OR `module` = "Amazon")');

        if (isset($query['count']) && $query['count'] == 0)
        {
            Db::getInstance()->Execute('UPDATE `' . _DB_PREFIX_ . 'orders` SET `mp_status` =  ' . Amazon_Order::Checked . '  WHERE `module` = "amazon" OR `module` = "Amazon"');
        }
        return($pass);
    }

    private function _removeMarketPlaceField()
    {
        $pass = true;

        return($pass);

        // Adding Marketplace fields - order
        //
        $fields = array();
        $query = Db::getInstance()->ExecuteS('SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'orders`');
        if ($query)
            foreach ($query as $row)
                $fields[$row['Field']] = 1;

        $pass = true;

        foreach (array('mp_order_id', 'mp_status', 'mp_channel', 'mp_channel_status') as $marketplace_field)
        {
            $sql = 'ALTER IGNORE TABLE  `' . _DB_PREFIX_ . 'orders` DROP `' . $marketplace_field . '` ;';

            if (isset($fields[$marketplace_field]))
                if (!Db::getInstance()->Execute($sql))
                    $pass = false;
        }

        return($pass);
    }

    // Add a customer / it will hold the market place orders
    //

    private function _createCustomer()
    {
        $pass = true;
        $existingCustomer = true;

        // Fakemail
        //
        $var = explode('@', self::configurationGet('PS_SHOP_EMAIL'));

        while ($existingCustomer)
        {
            $email = 'no-reply-' . rand(10000, 10000000) . '@' . $var[1];

            $customer = new Customer();
            $customer->firstname = 'Amazon';
            $customer->lastname = 'Amazon Market Place';
            $customer->email = $email;
            $customer->newsletter = false;
            $customer->optin = false;
            $customer->passwd = md5(rand(1111111111, 9999999999));
            $customer->active = true;
            $customer->date_add = date('Y-m-d H:i:s');
            $customer->date_upd = $customer->date_add;

            if (Customer::customerExists($customer->email))
                continue;

            $pass = $customer->add();
            $existingCustomer = false;
        }

        self::configurationUpdateValue('AMAZON_CUSTOMER_ID', $customer->id);

        return($pass);
    }

    private function _deleteCustomer()
    {
        $customer = new Customer(self::configurationGet('AMAZON_CUSTOMER_ID'));

        if (Customer::customerExists($customer->email))
            return( $customer->delete() );
        else
            return(true);
    }

    private function installModuleTab($tabClass = null, $tabName = null, $idTabParent = 0)
    {
        $pass = true;
        $tabNameLang = array();

        if (Tab::getIdFromClassName($tabClass))
            return(true);

        @copy(_PS_MODULE_DIR_ . $this->name . '/images/a16.gif', _PS_IMG_DIR_ . 't/' . $tabClass . '.gif');

        foreach (Language::getLanguages() as $language)
            $tabNameLang[$language['id_lang']] = $tabName;

        $tab = new Tab();
        $tab->name = $tabNameLang;
        $tab->class_name = $tabClass;
        $tab->module = $this->name;
        $tab->id_parent = (int) $idTabParent;

        // For Prestashop 1.2
        //
        if (version_compare(_PS_VERSION_, '1.3', '<'))
            $pass = $tab->add();
        else
            $pass = $tab->save();

        return($pass);
    }

    private function uninstallModuleTab($tabClass)
    {
        $pass = true;
        @unlink(_PS_IMG_DIR_ . 't/' . $tabClass . '.gif');
        $idTab = Tab::getIdFromClassName($tabClass);
        if ($idTab != 0)
        {
            $tab = new Tab($idTab);
            $pass = $tab->delete();
        }
        return($pass);
    }

    public function _tabSetup($action)
    {
        $pass = true;

        // Adding Tab
        switch ($action)
        {
            case Amazon::Add :
                // For PS 1.5+
                if (version_compare(_PS_VERSION_, '1.5', '>='))
                {
                    if (Tab::getIdFromClassName('AdminAmazonProducts') && Tab::getIdFromClassName('AdminAmazonOrders'))
                        return(true);

                    if (!$this->installModuleTab('AdminAmazonProducts', 'Amazon', Tab::getIdFromClassName('AdminCatalog')))
                    {
                        $this->_errors[] = $this->l('Unable to install: ProductsAmazon)');
                        $pass = false;
                    }
                    if (!$this->installModuleTab('AdminAmazonOrders', 'Amazon', Tab::getIdFromClassName('AdminOrders')))
                    {
                        $this->_errors[] = $this->l('Unable to install: OrdersAmazon');
                        $pass = false;
                    }
                }
                // For PS < 1.5
                else
                {
                    if (Tab::getIdFromClassName('ProductsAmazon') && Tab::getIdFromClassName('OrdersAmazon'))
                        return(true);

                    if (!$this->installModuleTab('ProductsAmazon', 'Amazon', Tab::getIdFromClassName('AdminCatalog')))
                    {
                        $this->_errors[] = $this->l('Unable to install: ProductsAmazon)');
                        $pass = false;
                    }
                    if (!$this->installModuleTab('OrdersAmazon', 'Amazon', Tab::getIdFromClassName('AdminOrders')))
                    {
                        $this->_errors[] = $this->l('Unable to install: OrdersAmazon');
                        $pass = false;
                    }
                }
                break;
            case Amazon::Update :
                if (version_compare(_PS_VERSION_, '1.5', '>='))
                {
                    // Removing Old AdminTabs
                    //
                    if (Tab::getIdFromClassName('ProductsAmazon') && Tab::getIdFromClassName('OrdersAmazon'))
                    {
                        if (!$this->uninstallModuleTab('ProductsAmazon'))
                        {
                            $this->_errors[] = $this->l('Unable to uninstall: ProductsAmazon Tab');
                            $pass = false;
                        }
                        if (!$this->uninstallModuleTab('OrdersAmazon'))
                        {
                            $this->_errors[] = $this->l('Unable to uninstall: OrdersAmazon Tab');
                            $pass = false;
                        }
                    }
                    // Adding New 
                    return( $this->_tabSetup(Amazon::Add) );
                }
                break;
            case Amazon::Remove :
                if (Tab::getIdFromClassName('AdminAmazonProducts'))
                {
                    if (!$this->uninstallModuleTab('AdminAmazonProducts'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: ProductsAmazon Tab');
                        $pass = false;
                    }
                }
                if (Tab::getIdFromClassName('AdminAmazonOrders'))
                {
                    if (!$this->uninstallModuleTab('AdminAmazonOrders'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: OrdersAmazon Tab');
                        $pass = false;
                    }        
                }
                if (Tab::getIdFromClassName('ProductsAmazon'))
                {
                    if (!$this->uninstallModuleTab('ProductsAmazon'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: ProductsAmazon Tab');
                        $pass = false;
                    }
                }
                if (Tab::getIdFromClassName('OrdersAmazon'))
                {
                    if (!$this->uninstallModuleTab('OrdersAmazon'))
                    {
                        $this->_errors[] = $this->l('Unable to uninstall: OrdersAmazon Tab');
                        $pass = false;
                    }
                }
                break;
        }
        return($pass);
    }

    // Marketplace module configuration is global
    //
    public static function configurationGet($param)
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
            return Configuration::getGlobalValue($param);
        else
            return Configuration::get($param);
    }

    public static function configurationUpdateValue($param, $value)
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
            return Configuration::updateGlobalValue($param, $value);
        else
            return Configuration::updateValue($param, $value);
    }
    
    // compatibility for PS 1.2 
    public function isRegisteredInHook($hook)
    {
            if ( method_exists('Module', 'isRegisteredInHook') )
                    return(parent::isRegisteredInHook($hook)) ;
            else
                    return Db::getInstance()->getValue('
                        SELECT COUNT(*)
                        FROM `'._DB_PREFIX_.'hook_module` hm
                        LEFT JOIN `'._DB_PREFIX_.'hook` h ON (h.`id_hook` = hm.`id_hook`)
                        WHERE h.`name` = \''.pSQL($hook).'\'
                        AND hm.`id_module` = '.(int)$this->id);
    }
    
}

?>