<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */


require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.order.class.php');
require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.tools.class.php');
require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.multichannel.class.php');

class Amazon_AdminOrder extends Amazon
{
    private $_tokens ;
    private $_debug ;
    private $_send_email ;
    
    public function marketplaceOrderDisplay($params)
    {
        $multichannel = (bool) Configuration::get('AMAZON_FBA_MULTICHANNEL');
        
        $id_order = (int) $params['id_order'];

        $amazonOrder = new Amazon_Order($id_order);

        if ( ! Validate::isLoadedObject($amazonOrder) )
        {
            if ( $this->_debug )
                die(Tools::displayError(sprintf('%s/%d: Unable to load order: %d', basename(__FILE__), __LINE__, $id_order))) ;            
            return(false);            
        }
        
        if (strtolower($amazonOrder->module) != 'amazon' && $amazonOrder->marketPlaceChannel != Amazon_MultiChannel::AMAZON_FBA_MULTICHANNEL && !$multichannel)
            return(false);    
        
        $this->_debug = (bool) unserialize(base64_decode(Configuration::get('AMAZON_DEBUG')));
        $this->_tokens = unserialize(base64_decode(Configuration::get('AMAZON_CRON_TOKEN')));
        $this->_send_email = (bool) Configuration::get('AMAZON_EMAIL');
        $this->_order_id_lang = $this->id_lang ;
        $this->_multichannel = $multichannel ;

        if ( $amazonOrder->id_lang )
            $this->_order_id_lang = $amazonOrder->id_lang ;

        $view_params = array() ;
        $view_params['context_key'] = null ;
        $view_params['debug'] = false ;
        $view_params['marketplace_order_id'] = null ;
        
        if ( isset($this->context) && $this->context instanceOf Context && file_exists(_PS_MODULE_DIR_ . 'amazon/classes/amazon.context.class.php') )
        {
            require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.context.class.php') ;            
            $view_params['context_key'] = Amazon_Context::getKey($this->context->shop) ;
        }
        else $view_params['context_key'] = null ;

        if ( $this->_debug )
            $view_params['debug'] = true ;

        if ( $amazonOrder->marketPlaceOrderId )
            $view_params['marketplace_order_id'] = $amazonOrder->marketPlaceOrderId ;
        
        $view_params['marketplace_channel'] = null ;
        
        if ( isset($amazonOrder->marketPlaceChannel) && $amazonOrder->marketPlaceChannel )
            switch ($amazonOrder->marketPlaceChannel)
            {
                case Amazon_MultiChannel::AMAZON_FBA_AMAZON :
                    $view_params['marketplace_channel'] = $this->l('Fullfilled By Amazon');
                    break;
                case Amazon_MultiChannel::AMAZON_FBA_MULTICHANNEL :
                    $view_params['marketplace_channel'] = $this->l('Multi-Channel Order / Fullfilled By Amazon');
                    break;
            }
        
        $token = $this->_tokens[$this->_order_id_lang] ? $this->_tokens[$this->_order_id_lang] : (isset($this->_tokens[$this->id_lang]) ? isset($this->_tokens[$this->id_lang]) : null) ;
        
        if ( ! $token )
        {
            if ( $this->_debug )
                die(Tools::displayError(sprintf('%s/%d: Unavailable Amazon token', basename(__FILE__), __LINE__))) ;            
            return(false);
        }
        
        $view_params['id_order'] = $amazonOrder->id ;
        $view_params['id_lang'] = $this->_order_id_lang ;
        
        $view_params['amazon_token'] = $token ;
        
        $view_params['marketplace_region'] = Amazon_Tools::idToDomain($this->_order_id_lang) ; 
        
        $view_params['images_url'] = $this->images ;           
        $view_params['css_url'] = $this->url . 'css/admin_order.css' ;
        
        $view_params['ps_version_is_16'] = version_compare(_PS_VERSION_, '1.6', '>=') ;
        $view_params['ps_version_is_15'] = version_compare(_PS_VERSION_, '1.5', '>=') && version_compare(_PS_VERSION_, '1.6', '<') ;


        // Normal Order - Possible to convert it to a multi-channel order 
        //
        if ( strtolower($amazonOrder->module) != 'amazon' && $amazonOrder->marketPlaceChannel != Amazon_MultiChannel::AMAZON_FBA_MULTICHANNEL && $this->_multichannel )
        {
            return( $this->marketplaceOrderDisplayFbaEligibleToMultichannel($view_params, $amazonOrder, $params) ) ;
        }
        // Multi-Channel Order
        //
        elseif ( $amazonOrder->marketPlaceChannel == Amazon_MultiChannel::AMAZON_FBA_MULTICHANNEL )
        {
            return( $this->marketplaceOrderDisplayFbaMultichannel($view_params, $amazonOrder, $params) ) ;
        }
        //
        // Standard Amazon Order
        //
        else 
        {
            return( $this->marketplaceOrderDisplayStandardOrder($view_params, $amazonOrder, $params) ) ;
        }
    }
    
    private function marketplaceOrderDisplayFbaMultichannel(&$view_params, &$order, &$params)
    {
        if (!Validate::isLoadedObject($order))
            return(false) ;
        
        $multiChannelOrder = new Amazon_MultiChannel($order->id);

        if (!Validate::isLoadedObject($multiChannelOrder))
        {
            if ( $this->_debug )
                Tools::displayError(sprintf('%s/%d: This order an invalid FBA Multichannel order: %d', basename(__FILE__), __LINE__, $order->id)) ;                             
            return(false);
        }
        
        switch (strtolower($multiChannelOrder->marketPlaceChannelStatus))
        {
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_SUBMITED : $currentStatus = $this->l('Submited');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_RECEIVED : $currentStatus = $this->l('Received');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_INVALID : $currentStatus = $this->l('Invalid');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_PLANNING : $currentStatus = $this->l('Planning');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_PROCESSING : $currentStatus = $this->l('Processing');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_CANCELLED : $currentStatus = $this->l('Cancelled');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_COMPLETE : $currentStatus = $this->l('Complete');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_COMPLETEPARTIALLED: $currentStatus = $this->l('Complete Partialled');
                break;
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_UNFULFILLABLE : $currentStatus = $this->l('Unfulfillable');
                break;
            default : $currentStatus = $this->l('Unknown');
        }

        switch (strtolower($multiChannelOrder->marketPlaceChannelStatus))
        {
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_CANCELLED :
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_UNFULFILLABLE :
            case Amazon_MultiChannel::AMAZON_FBA_STATUS_INVALID :
                $canceled = true ;
                break;
            default:
                $canceled = false ;
                break ;
        }
        
        $view_params['js_url'] = $this->url . 'js/adminorderfba.js' ;
        $view_params['fbaorder_url'] =  $this->url . 'functions/fbaorder.php?europe=1' ;
        
        $view_params['marketplace_flag'] = $this->images . 'geo_flags/eu.gif' ;
        $view_params['marketplace_status'] = $currentStatus ;
        $view_params['marketplace_canceled'] = $canceled ;

        $this->context->smarty->assign($view_params);
        $html = $this->context->smarty->fetch($this->path . 'views/admin_order/AdminOrderMultichannel.tpl');        
        return($html) ;        
    }
    
    private function marketplaceOrderDisplayFbaEligibleToMultichannel(&$view_params, &$order, &$params)
    {
        if (!($mc_order = Amazon_MultiChannel::isEligible($order->id)))
        {
            if ( $this->_debug )
                Tools::displayError(sprintf('%s/%d: This order is not eligible to FBA Multichannel: %d', basename(__FILE__), __LINE__, $order->id)) ;             
            return(false);
        } 
        else
        {
            $order = $mc_order ;
        }
        
        $view_params['js_url'] = $this->url . 'js/adminorderfba.js' ;
        $view_params['fbaorder_url'] =  $this->url . 'functions/fbaorder.php?europe=1' ;
        $view_params['marketplace_flag'] = $this->images . 'geo_flags/eu.gif' ;
        
        $this->context->smarty->assign($view_params);
        $html = $this->context->smarty->fetch($this->path . 'views/admin_order/AdminOrderMultichannelEligible.tpl');        
        return($html) ;        
    }
    
    private function marketplaceOrderDisplayStandardOrder(&$view_params, &$order, &$params)
    {
        if (isset($order->shipping_number) && !empty($order->shipping_number))
            $trackingNumber = $order->shipping_number;
        else
            $trackingNumber = null ;
    
        if ( $this->_debug )
            $view_params['bulk_mode'] = (bool) Configuration::get('AMAZON_BULK_MODE');
        else
            $view_params['bulk_mode'] = null ;

        $view_params['js_url'] = $this->url . 'js/adminorder.js' ;
        
        $view_params['marketplace_url'] = Amazon_Tools::SellerCentralURL($this->_order_id_lang, $order->marketPlaceOrderId) ;
        $view_params['marketplace_flag'] = $this->images . 'geo_flags/' . $view_params['marketplace_region'] . '.gif' ;
        $view_params['tracking_number'] = $trackingNumber ;
        
        $this->context->smarty->assign($view_params);
        $html = $this->context->smarty->fetch($this->path . 'views/admin_order/AdminOrderStandard.tpl');        
        return($html) ;
    }
}