<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

class Amazon_Carrier
{
    private static $amazon_carriers = null ;
    
    // https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/amzn-base.xsd
    //
    public static $carrier_codes = array(
        'La Poste',
        'Chronopost',
        'USPS',
        'UPS',
        'FedEx',
        'DHL',
        'Fastway',
        'GLS',
        'GO!',
        'Hermes Logistik Gruppe',
        'Royal Mail',
        'Parcelforce',
        'City Link',
        'TNT',
        'Target',
        'SagawaExpress',
        'NipponExpress',
        'YamatoTransport',
        'DHL Global Mail',
        'UPS Mail Innovations',
        'FedEx SmartPost',
        'OSM',
        'OnTrac',
        'Streamlite',
        'Newgistics',
        'Canada Post',
        'Blue Package',
        'Deutsche Post',
        'DPD',
        'Parcelnet',
        'Poste Italiane',
        'SDA',
        'Smartmail',
        'FEDEX_JP',
        'JP_EXPRESS',
        'NITTSU',
        'SAGAWA',
        'YAMATO',
        'BlueDart',
        'AFL/Fedex',
        'Aramex',
        'India Post',
        'Professional',
        'DTDC',
        'Overnite Express',
        'First Flight',
        'Delhivery',
        'Other'      
    ) ;
    
    public static $extra_carrier_codes = array(
        'Exapaq'
    ) ;

    private static $carrier_template = array(
            'name'                 => '', //So Colissimo
            'id_tax'               => 1,
            'id_tax_rules_group'   => 1,
            'url'                  => null,
            'active'               => true,
            'deleted'              => 0,
            'shipping_handling'    => false,
            'range_behavior'       => 0,
            'is_module'            => false,
            'id_zone'              => 1,
            'shipping_external'    => true,
            'external_module_name' => 'soliberte', 
            'need_range'           => true
        );
        
    public static function toPublicName($name)
    {
        return( html_entity_decode($name, ENT_NOQUOTES, 'UTF-8') ) ;
    }
    public static function toPrivateName($name)
    {
        $text = html_entity_decode($name, ENT_NOQUOTES, 'UTF-8');
        $text = mb_convert_encoding($text,'HTML-ENTITIES','UTF-8');
        $text = preg_replace( array('/&szlig;/','/&(..)lig;/','/&([aoueAOUE])uml;/','/&(.)[^;]*;/'),array('ss',"$1","$1".'e',"$1"),  $text);
        $text = preg_replace('/[!<>?=+@{}_$%]*$/u', '', $text); // remove non printable
        $text = preg_replace('/\s+/', '_', $text) ;
        return(strtolower($text)) ;
    }
    public static function FBACarrier($carrierName)
    {
      $privateName = 'amazon_' . self::toPrivateName($carrierName) ;

      $sql = 'SELECT `id_carrier` FROM `' . _DB_PREFIX_ . 'carrier` WHERE `external_module_name` = "' . pSQL($privateName) . '"' ;

      $row = Db::getInstance()->getRow($sql);

      if ( isset($row['id_carrier']) && (int)$row['id_carrier'] )
          return($row['id_carrier']) ;
      return (false);
    }    
    public static function FBACarrierCreate($carrierName, $state = false)
    {
        $privateName = 'amazon_' . self::toPrivateName($carrierName) ;

        $carrier = new Carrier();

        foreach (self::$carrier_template as $k => $v)
            $carrier->{$k} = $v;
        $carrier->name = self::toPublicName($carrierName);
        $carrier->active = (int)$state;
        $carrier->external_module_name = $privateName ;
        
        foreach (Language::getLanguages(false) as $language)
        {
            $carrier->delay[$language['id_lang']] = $carrier->name . ' via Amazon' ;
        }

        if ( ! $carrier->add() )
        { 
            echo Tools::displayError('Unable to create carrier') ;
            return(false);
        }
        if ( version_compare(_PS_VERSION_,'1.4','<') )
        {
            Db::getInstance()->Execute('UPDATE  `' . _DB_PREFIX_ . 'carrier` SET `external_module_name`="' . pSQL($carrier->external_module_name) . '" WHERE `id_carrier`=' . (int)$carrier->id ) ;
        }        
        return( (int)$carrier->id );
    }
    
    // Is a Carrier Code or Carrier Name ?
    //
    public static function isCarrierCode($CarrierCode)
    {
        return( in_array(trim($CarrierCode), self::$carrier_codes) ) ;
    }
    public static function getAmazonCarrierById($id_carrier, $id_lang, $debug = false)
    {
        if ( ! self::$amazon_carriers )
        {
            // Default Carrier selected in the module configuration
            //
            self::$amazon_carriers = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CARRIER_DEFAULT')));
        }
        
        if ( ! count(self::$amazon_carriers) )
        {
            if ( $debug )
                printf('%s:%d %s' . "\n<br>", basename(__FILE__), __LINE__, 'Empty carrier list') ;
            return(false) ;
        }
        
        $amazon_carrier = isset(self::$amazon_carriers[$id_lang]) ? self::$amazon_carriers[$id_lang] : false;
            
        if ( ! is_array($amazon_carrier) || ! isset($amazon_carrier['prestashop']) || ! count($amazon_carrier['prestashop']) )     
        {
            if ( $debug )
                printf('%s:%d %s' . "\n<br>", basename(__FILE__), __LINE__, 'Empty carrier list') ;            
            return(false) ;
        }

        $pass = false ;
        foreach($amazon_carrier['prestashop'] as $key => $amazon_id_carrier)
            if ( $amazon_id_carrier == $id_carrier )
            {
                $pass = true ;
                break ;
            }
        if ( ! $pass )  
        {
            if ( $debug )
                printf('%s:%d %s id_carrier: %d / id_lang: %d' . "\n<br>", basename(__FILE__), __LINE__, 'No matched entry for', $id_carrier, $id_lang) ;                 
            return(false) ;
        }
        return($amazon_carrier['amazon'][$key]) ;
    }
    
    public static function UpdateTrackingNumber($id_order, $id_carrier, $trackingNumber, $debug = false)
    {
        $order = new Order((int)$id_order) ;
        
        if ( ! Validate::isLoadedObject($order) )
        {
            if ( $debug )
                printf('%s:%d %s id_order: %d' . "\n<br>", basename(__FILE__), __LINE__, 'Unable to load Order', $id_order) ;          
            return(false) ;
        }
        if ( ! $trackingNumber )
        {
            if ( $debug )
                printf('%s:%d %s id_order: %d' . "\n<br>", basename(__FILE__), __LINE__, 'Empty tracking number', $id_order) ;                      
            return(false) ;
        }
        
        // New fashioned
        //
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            // Adding an entry in order_carrier table
            if ( $order->id_carrier != $id_carrier )
            {
                $order_carrier = new OrderCarrier();
                $order_carrier->id_order = (int)$order->id;
                $order_carrier->id_carrier = (int)$id_carrier;
                $order_carrier->weight = (float)$order->getTotalWeight();
                $order_carrier->shipping_cost_tax_excl = 0 ;
                $order_carrier->shipping_cost_tax_incl = 0 ;
                $order_carrier->tracking_number = $trackingNumber ;
                $order_carrier->add();
            } 
            else
            {
                // Update order_carrier
                $id_order_carrier = Db::getInstance()->getValue('
                        SELECT `id_order_carrier`
                        FROM `'._DB_PREFIX_.'order_carrier`
                        WHERE `id_order` = '.(int)$id_order.'
                        AND (`id_order_invoice` IS NULL OR `id_order_invoice` = 0)');

                if ($id_order_carrier)
                {
                        $order_carrier = new OrderCarrier($id_order_carrier);
                        $order_carrier->id_carrier = $id_carrier ;
                        $order_carrier->tracking_number = $trackingNumber ;
                        $order_carrier->update() ;
                }                
            }
        } 

        // PS 1.5 < compat 
        $order->id_carrier = (int)$id_carrier ;
        $order->shipping_number = $trackingNumber ;
        
        $order->id_carrier = (int)$id_carrier ;
        
        return( $order->update() ) ;
    }
    
}
