<?php 

require(dirname(__FILE__) . '/../validate/AmazonXmlParse.php') ;

class ConcurrentData
{
    public $ASIN ;
    public $SellerPositiveFeedbackRating ;
    public $SellerFeedbackCount ;
    public $FulfillmentChannel ;
    public $Condition ;
    public $Shipping ;
    public $ShippingTime ;
    public $Price ;
} 
class AmazonProductPricingInfo
{
    public $ASIN ;
    public $ListingCurrencyCode ;
    public $ListingPrice ;
    public $ShippingPrice ;
    public $ShippingCurrencyCode ;
    public $Fulfillment ;
}

class ConcurrentInfo
{
    private $amazon_marketplaces = array(
            'FR' => 'A13V1IB3VIYZZH', 
            'DE' => 'A1PA6795UKMFR9',
            'UK' => 'A1F83G8C2ARO7P',
            'IT' => 'APJ6JRA9NG5V4',
            'ES' => 'A1RKKUPIHCS9HS',
            'JP' => 'A1VC38T7YXB528',
            'US' => 'ATVPDKIKX0DER',
            'CN' => '',
            'IN' => 'A21TJRUUN4KGV',
            'CA' => 'A2EUQ1WTGCTBG2'
        ) ;        

    private $amazon_currencies = array
            (
            'FR' => 'EUR',
            'DE' => 'EUR',
            'UK' => 'GBP',
            'IT' => 'EUR',
            'ES' => 'EUR',
            'JP' => 'JPY',
            'US' => 'USD',
            'CN' => 'CNY',
            'CA' => 'CAD'
            ) ;
    private $country ;
    
    public $amazonHandle ;
    
    private $debug ;

    protected $xml = null ;
    public $concurrentInfoData = array() ;
    
    public function __construct($amazon_configuration, $country, $debug = false)
    {
        if ( $debug )
            $this->debug = true ;
      
        $this->amazonHandle = $this->_InitAmazon($amazon_configuration, $country) ;
    }

    private function _InitAmazon($amazon_configuration, $country) 
    {
        if ( ! isset($this->amazon_marketplaces[strtoupper($country)]) )
        {
            die('Configuration Error' . "\n") ;
        }
        if ( $amazon_configuration instanceof Amazon_WebService )
        {    
            $this->country         = strtoupper($country) ;
            $amazonApi             = $amazon_configuration ; 
        }
        else
        {
            $this->merchantId      = trim($amazon_configuration['merchant_id']) ;
            $this->awsKeyId        = trim($amazon_configuration['aws_id']) ;
            $this->awsSecretKey    = trim($amazon_configuration['secret_key']) ;
            $this->marketPlaceID   = $this->amazon_marketplaces[strtoupper($country)] ;
            $this->country         = strtoupper($country) ;

            $auth = array(
                'MerchantID'     => $this->merchantId,
                'AWSAccessKeyID' => $this->awsKeyId,
                'SecretKey'      => $this->awsSecretKey,
                'MarketplaceID'  => $this->marketPlaceID
            ) ;

            $params = array() ;
            $params['Country']  = strtolower($this->country) ;
            $params['Currency'] = $this->amazon_currencies[strtoupper($country)] ;

            $amazonApi = null ;

            if ( ! ($amazonApi = new Amazon_WebService($auth, $params, null, $this->debug)) )
            {
                printf('%s:%d - Unable to login - Parameters : %s - %s',basename(__FILE__), __LINE__, nl2br(print_r($auth, true)), nl2br(print_r($params, true))) ;
                die ;
            }
        }

        return($amazonApi) ;
    } 
    
    function GetASIN($xml)
    {
        $obj = AmazonXmlParse::getSingleTagValues($xml, array("ASIN"),"MarketplaceASIN") ;

        return( $obj ) ;
    }
    function GetProductWeight($asins)
    {
        $params = array() ;
        $params['Action'] = 'GetMatchingProduct' ;
        $params['MarketplaceId'] =  $this->amazon_marketplaces[strtoupper($this->country)] ;

        $i = 1 ;
        foreach($asins as $asin)
        {
            $params['ASINList.ASIN.' . $i] = $asin ;
            $i++ ;
        }                
        
        $xml = $this->amazonHandle->_callWSs('Products', $params, null, true) ;

        if ( isset($xml->GetMatchingProductResult->Error) )
        {
            if ( $this->debug )
                var_dump( $xml ) ;
            return(false) ;
        }

        
        if ( isset($xml->GetMatchingProductResult) )
        {
            $obj = AmazonXmlParse::getSingleTagValues($xml, array("ASIN","Weight"),"Product") ;

            return( $obj ) ;            
        }   
        if ( $this->debug )
            print('One or more errors occurs during the query' . "\n") ;
        return(false) ;        
    }
    function GetConcurrentInfo($sku_list)
    {
        $params = array() ;
        $params['Action'] = 'GetLowestOfferListingsForSKU' ;
        $params['MarketplaceId'] =  $this->amazon_marketplaces[strtoupper($this->country)] ;
        $params['ExcludeMe'] =  'True' ;

        $i = 1 ;
        foreach($sku_list as $sku)
        {
            $params['SellerSKUList.SellerSKU.' . $i] = $sku ;
            $i++ ;
        }

        $xml = $this->amazonHandle->_callWSs('Products', $params, null, true) ;
        #file_put_contents('xml.out', $xml->saveXML()) ; 
        #$xml = simplexml_load_file('xml.out') ;

        if ( isset($xml->GetLowestOfferListingsForSKUResult) )
        {
           $this->xml = $xml ;
           return(true) ;
        }
        if ( $this->debug )
        {
            print('One or more errors occurs during the query:' . "\n") ;
            var_dump($xml) ;
        }
        return(false) ;
    }
    
    function GetOurInfo($sku_list)
    {
        $params = array() ;
        $params['Action'] = 'GetMyPriceForSKU' ;
        $params['MarketplaceId'] =  $this->amazon_marketplaces[strtoupper($this->country)] ;

        $i = 1 ;
        foreach($sku_list as $sku)
        {
            $params['SellerSKUList.SellerSKU.' . $i] = $sku ;
            $i++ ;
        }

        $xml = $this->amazonHandle->_callWSs('Products', $params, null, true) ;
        #file_put_contents('xml2.out', $xml->saveXML()) ; 
        #$xml = simplexml_load_file('xml2.out') ;

        if ( isset($xml->GetMyPriceForSKUResult) )
        {
            $attributes = $xml->GetMyPriceForSKUResult->attributes() ;
            $attributes = (array)$attributes ;
            
            if ( $attributes['@attributes']['status'] == 'Success' )
            {
                if ( ! isset($xml->GetMyPriceForSKUResult->Product->Identifiers->MarketplaceASIN->ASIN) )
                    return(false) ;

                if ( ! isset($xml->GetMyPriceForSKUResult->Product->Offers->Offer) )
                    return(false) ;
                
                $pricingData = new AmazonProductPricingInfo ;
                $pricingData->ASIN                  = (string)$xml->GetMyPriceForSKUResult->Product->Identifiers->MarketplaceASIN->ASIN ;
                $pricingData->ListingCurrencyCode   = (string)$xml->GetMyPriceForSKUResult->Product->Offers->Offer->BuyingPrice->ListingPrice->CurrencyCode ;
                $pricingData->ListingPrice          = (float)$xml->GetMyPriceForSKUResult->Product->Offers->Offer->BuyingPrice->ListingPrice->Amount ;
                $pricingData->ShippingPrice         = (float)$xml->GetMyPriceForSKUResult->Product->Offers->Offer->BuyingPrice->Shipping->Amount ;
                $pricingData->ShippingCurrencyCode  = (string)$xml->GetMyPriceForSKUResult->Product->Offers->Offer->BuyingPrice->Shipping->CurrencyCode ;  
                $pricingData->Fulfillment           = (string)$xml->GetMyPriceForSKUResult->Product->Offers->Offer->FulfillmentChannel ;

                return($pricingData) ;
            }
            else
            {
                if ( $this->debug )
                {
                    echo "Unknown Error\n" ;
                    var_dump($xml) ;
                }
                return(false) ;
            }             
            return(true) ;
        }
        if ( $this->debug )
        {
            print('One or more errors occurs during the query:' . "\n") ;
            var_dump($xml) ;
        }
        return(false) ;
    }
    
    public function ParseConcurrentInfo()
    {
        $this->concurrentInfoData = array() ;
        $items = array() ;
        $count = 0 ;
        
        if ( ! isset($this->xml->GetLowestOfferListingsForSKUResult) )
            return(null) ;

        if ($this->xml->GetLowestOfferListingsForSKUResult)
        {    
            foreach($this->xml->GetLowestOfferListingsForSKUResult as $Offer)
            {
                $attributes = $Offer->attributes() ;
                $attributes = (array)$attributes ;                

                $SKU = (string)$attributes['@attributes']['SellerSKU'] ;
                
                if ( isset($Offer->Error) ) continue ;

                $i = array() ;

                if ( ! isset($Offer->Product->LowestOfferListings->LowestOfferListing) )
                    continue ;
                
                if ( isset($Offer->Product->Identifiers->MarketplaceASIN->ASIN) )
                    $ASIN = $Offer->Product->Identifiers->MarketplaceASIN->ASIN ;

                $Offers = $Offer->Product->LowestOfferListings->LowestOfferListing ;
                
                foreach($Offers as $Item)
                {
                    $Condition = (string)$Item->Qualifiers->ItemCondition ;

                    if (! isset($items[$SKU]) )
                        $items[$SKU] = array() ;
                    
                    if (! isset($items[$SKU][$Condition]) )
                    {
                        $items[$SKU][$Condition] = array() ;                    
                        $i[$Condition] = 0 ; 
                    }
                    $index = $i[$Condition] ;
                    
                    $items[$SKU][$Condition][$index] = new ConcurrentData ;
                    $items[$SKU][$Condition][$index]->ASIN                            = (string)$ASIN ;
                    $items[$SKU][$Condition][$index]->SellerFeedbackCount             = (int)$Item->SellerFeedbackCount ;
                    $items[$SKU][$Condition][$index]->SellerPositiveFeedbackRating    = (string)$Item->Qualifiers->SellerPositiveFeedbackRating ;
                    $items[$SKU][$Condition][$index]->FulfillmentChannel              = (string)$Item->Qualifiers->FulfillmentChannel ;
                    $items[$SKU][$Condition][$index]->ShippingTime                    = (string)$Item->Qualifiers->ShippingTime->Max ;
                    $items[$SKU][$Condition][$index]->Price                           = (float)$Item->Price->ListingPrice->Amount ;
                    $items[$SKU][$Condition][$index]->Shipping                        = (float)$Item->Price->Shipping->Amount ;
                    $items[$SKU][$Condition][$index]->Condition                       = $Condition ;
                    
                    $i[$Condition]++ ;
                    $count++ ;
                }

            }
        }
        $this->concurrentInfoData = $items ;

        if ( $count )       return($count) ;
        else                return(false) ;
    }  
}
?>