<?php 

class Amazon_CSV_Base 
{
  public function __set($property, $value) {
    if( property_exists($this, $property) ) {
      $this->{$property} = $value;
    }
    else {
      throw new Exception(get_class($this) .' Invalid property set ' . $property);
    }
  }
  
  public function __get($property) {
    if( property_exists($this, $property) ) {
      return $this->{$property};
    }
    else {
      throw new Exception(get_class($this).' Invalid property get ' . $property);
    }
  }
  
  public function toArray() {
    $properties = $this->getProperties();
    $data = array();
    foreach($properties as $prop) {
      $data[$prop] = $this->__get($prop);
    }                                                       
    return $data;
  }

  public function __call($method, $args) {
    if( preg_match("/^set_(.+)$/", $method, $match) ) {
      $property = $match[1];
      $this->__set($property, $args[0]);
    }
    else if( preg_match("/^get_(.+)$/", $method, $match) ) {
      $property = $match[1];
      return $this->__get($property);
    }
    else {
      throw new Exception(get_class($this)." Invalid method ".$method);
    }
  }
  
  public function getProperties() {
    $properties = get_object_vars($this);
    $props = array();
    foreach($properties as $k => $v) {
      $props[] = $k;
    }
    return $props;
  }
  
  public function hasProperty($property) {
    return property_exists($this, $property) ? true : false;
  }
  
}
?>