<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');

class Amazon_MailLogger extends Amazon
{
    private static $_initialized = false ;
    
    private static $_debug = false ;
    private static $_active = false ;
    private static $_mailto = null ;
    private static $_id_lang = null ;
    private static $_language = null ;

    static $email_subjects =
            array(
               'fr' => 'Vous avez un nouveau message du module Amazon',
               'en' => 'You got a new message from Amazon module'
            ) ;
    
    static $messages = array() ;
    
    public static function init($debug = false)
    {
        $id_employee = Amazon::configurationGet('AMAZON_EMPLOYEE') ;
        $employee = new Employee($id_employee ? $id_employee : 1) ;
        
        if ($debug)
            self::$_debug = true;
        else
            self::$_debug = false;

        if ( ! self::$_active )
        {
            register_shutdown_function( array('Amazon_MailLogger', 'send') ) ;
            self::$_active = true ;
        }
        if ( ! self::$_mailto )
        {
            self::$_mailto = Configuration::get('PS_SHOP_EMAIL') ;
        }        
        if ( ! self::$_id_lang )
        {
            self::$_id_lang = $employee->id_lang;
            self::$_language = Language::getIsoById(self::$_id_lang) ;
        }    
        self::$_initialized = true ;
    }

    static public function message($message)
    {   
        if ( ! self::$_initialized )
            self::init() ;

        if ( !empty($message) )
            self::$messages[] = $message ;
    }
    static public function send() 
    {
        if ( ! count(self::$messages) )
            return(false) ;
        
        if ( ! self::$_initialized )
            return(false) ;
        
        if  ( isset(self::$email_subjects[self::$_language]) )
                $subject = self::$email_subjects[self::$_language] ;
        else    $subject = self::$email_subjects['en'] ;
        
        $template = 'empty' ; // template file
        $template_vars = array() ;
        $template_vars['{message}'] = null ;
        
        foreach(self::$messages as $message)
        {
            $template_vars['{message}'] .= nl2br($message) ;
            $template_vars['{message}'] .= "\n<hr />\n" ;
        }
        try 
        {
            Mail::Send(
                self::$_id_lang, // id_lang
                $template, // template
                $subject, // subject
                $template_vars, // templateVars 
                self::$_mailto, // to
                null, // To Name
                null, // From
                null, // From Name 
                null, // Attachment
                null, // SMTP
                _PS_MODULE_DIR_ . 'amazon/mail/' 
               );        
            
        }
        catch(Exception $e) {} ;
    }
}
