<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
  class Amazon_Order extends Order
  {
    public $marketPlaceOrderId = null ;
    public $marketPlaceOrderStatus = null ;
    public $marketPlaceShipping = null ;
    public $marketPlaceChannel = null ;

    const Pending = 1 ;
    const Unshipped = 2 ;
    const PartiallyShipped = 3 ;
    const Shipped = 4 ;
    const Canceled = 5 ;
    const Checked = 6 ; // Checked by the module for "status.php" automaton

    public function __construct($id = NULL, $id_lang = NULL)
  	{
  	  parent::__construct($id, $id_lang) ;

  	  if ( $id )
        $this->_getMpFields() ;
  	}

  	public function add($autodate = true, $nullValues = true, $marketPlaceOrderId = false, $marketPlaceOrderStatus = false, $marketPlaceChannel = false)
  	{
        if ( ! parent::add($autodate, true) )   return(false) ;

	    $this->marketPlaceOrderId = $marketPlaceOrderId ;
	    $this->marketPlaceOrderStatus = $marketPlaceOrderStatus ;
	    $this->marketPlaceChannel = $marketPlaceChannel ;

        if ( ! $this->_updOrder() ) return(false);

	    return(true);
    }

    static public function getMarketplaceOrdersStatesByIdLang($id_lang_list, $id_order_state)
    {
        $sql = 'SELECT o.`id_order`, o.`id_lang`, o.`mp_order_id`, o.`id_carrier`, o.`shipping_number`  FROM `' . _DB_PREFIX_ . 'orders` o
                LEFT JOIN `' . _DB_PREFIX_ . 'order_history` oh ON (o.`id_order` = oh.`id_order`)
                WHERE (o.`module` = "amazon" OR o.`module` = "Amazon") AND oh.`id_order_state` = ' . (int)$id_order_state . ' AND o.`id_lang` IN (' . $id_lang_list . ') AND o.`mp_order_id` > "" AND o.`mp_status` != ' . (int)self::Checked . '
                AND o.`date_add` > DATE_ADD(NOW(), INTERVAL -7 DAY)
                GROUP by o.`id_order`, o.`mp_order_id`' ;

        if ( ! ($result = Db::getInstance()->ExecuteS($sql)) )
            return(false) ;
        
        return($result) ;
    }
  
    static public function checkByMpId($marketPlaceOrderId)
    {
        $sql = 'SELECT id_order, mp_order_id, mp_status FROM `' . _DB_PREFIX_ . 'orders`
          where `mp_order_id` = "' . pSQL($marketPlaceOrderId) . '" order by id_order desc ;' ;

        if ( ! $result = Db::getInstance()->ExecuteS($sql) )
            return(false) ;

        return( $result[0]['id_order'] );
    }
    
    public function updateMpStatus($marketPlaceStatus)
    {
        $this->marketPlaceOrderStatus = $marketPlaceStatus ;

        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          set mp_status = "' . pSQL($this->marketPlaceOrderStatus) .'"
          where `id_order` = "' . pSQL($this->id) . '" ;' ;

       if(!Db::getInstance()->Execute($sql))
  			return false;
      return(true) ;
    }

    public function updateMpChannel($marketPlaceChannel)
    {
        $this->marketPlaceChannel = $marketPlaceChannel ;

        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          set mp_channel = "' . pSQL($this->marketPlaceChannel) .'"
          where `id_order` = "' . pSQL($this->id) . '" ;' ;

       if(!Db::getInstance()->Execute($sql))
  			return false;
      return(true) ;
    }
    
    // Eq. to updateMpStatus but static
    public static function updateMarketplaceStatus($id_order, $marketPlaceStatus)
    {
        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          SET  `mp_status` = ' . intval($marketPlaceStatus) .'
          WHERE `id_order` = ' . intval($id_order)  ;

       if(!Db::getInstance()->Execute($sql))
  			return false;

      return(true) ;
    }
    
    private function _getMpFields()
    {
        $sql = 'SELECT mp_order_id, mp_status, mp_channel FROM `' . _DB_PREFIX_ . 'orders`
          where `id_order` = "' . $this->id . '" LIMIT 1 ;' ;

        if ( $result = Db::getInstance()->ExecuteS($sql) )
        {
          $result = array_shift($result) ;
          $this->marketPlaceOrderId = $result['mp_order_id'] ;
          $this->marketPlaceOrderStatus = $result['mp_status'] ;
          $this->marketPlaceChannel = $result['mp_channel'] ;

          return(true) ;
        }
        else return(false) ;
     }

    private function _updOrder()
    {
        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
          set mp_order_id = "' . pSQL($this->marketPlaceOrderId) . '",
              mp_status = "' . pSQL($this->marketPlaceOrderStatus) .'",
              mp_channel = "' . pSQL($this->marketPlaceChannel) .'"
          where `id_order` = "' . pSQL($this->id) . '" ;' ;

       if(!Db::getInstance()->Execute($sql))
  			return false;

      return(true) ;
    }
    
    


  }
?>
