<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

class Amazon_SpecificField extends Module
{
    private static $features = null ;    
    private static $attributes = null ;    
    
    static public function displayFields($profile_name, $extraFieldsArray)
    {
        if ( ! isset($extraFieldsArray['field']) || ! $extraFieldsArray['field'] )  return(null) ;

        // Load Features Once
        if ( self::$features === null )
        {
            $id_lang = (int)Configuration::get('PS_LANG_DEFAULT') ;
            self::$features = Feature::getFeatures($id_lang) ;
        }         
        if ( self::$attributes === null )
        {
            $id_lang = isset($id_lang) ? $id_lang : (int)Configuration::get('PS_LANG_DEFAULT') ;
            self::$attributes = AttributeGroup::getAttributesGroups((int)$id_lang) ;
        }          
         
        $html = '' ;
       
        foreach($extraFieldsArray['field'] as $field => $value)
        {
            /*
             * Field is a variant : eg: Size-Color, Length
             */
            if ( $field == 'variant' )
            {   
                $html .= '<span class="extra-span"><b>Variant</b></span>' ;
                
                // Current Selected Variant
                $selected = $value ;
                
                // Choose Name
                $html .= '<select name="profiles[extra][' . $profile_name . '][field][variant]" class="variant" >
                        <option></option>' . "\n" ;                    

                foreach($extraFieldsArray['variant'] as $variant)
                {
                    $variant_name = preg_replace('/([A-Z])/', ' \1', implode(' / ', array_keys($variant))) ;
                    $variant_key  = implode('-', array_keys($variant)) ;

                    $html .= '
                            <option value="' . $variant_key . '" ' .  ($variant_key == $selected ? 'selected="selected"' : '') . '>' . $variant_name . '</option>' . "\n" ;
                }    
                $html .= '</select>' . "\n" ;                        
            
                $html .= '<table style="margin-left:30px;">' ;   
                // Variant Tables
                foreach($extraFieldsArray['variant'] as $variant)
                {
                    $variant_name = preg_replace('/([A-Z])/', ' \1', implode(' / ', array_keys($variant))) ;
                    $variant_key  = implode('-', array_keys($variant)) ;
               
                    foreach($variant as $name => $value)
                    {
                        if ( $variant_key !== $selected )
                                $style='display:none';
                        else    $style='' ;
                        
                        $sub_variant_name = preg_replace('/([A-Z])/', ' \1', $name) ;
                        
                        $html .= '<tr class="variant-items" rel="' . $variant_key . '" style="' . $style . ';">' ;
                        $html .= '<td style="text-align:right;padding-right:10px;width:110px;">' . $sub_variant_name .  '</td>' ;  
                        $html .= '<td>' ;
                        $html .= '<select name="profiles[extra][' . $profile_name . '][variant][' . $variant_key . '][' . $name . ']" style="width:150px;">
                                <option></option>' . "\n" ;

                        /*
                         * Attributes Groups: Color, Capacity ...
                         */
                        foreach(self::$attributes as $attribute)
                        {
                            
                            $html .= '
                                    <option value="' . $attribute['id_attribute_group'] . '" ' .  ($attribute['id_attribute_group'] === $value ? 'selected="selected"' : '') . '>' . $attribute['name'] . '</option>' . "\n" ;
                        }
                        $html .= '</select>' . "\n" ;
                        
                        /*
                         *  XML tag will have attributes eg: Length value="5" unit="centimeters"
                         */
                        
                        if ( isset($extraFieldsArray['values'][$variant_key][$name]) )
                        {
                            $selected_value = 0 ;

                            if ( isset($extraFieldsArray['attributes'][$variant_key][$name]['unitOfMeasure']) )
                            {    
                                $selected_value = $extraFieldsArray['attributes'][$variant_key][$name]['unitOfMeasure'] ;
                                $kind = 'unitOfMeasure' ;
                            }
                            // Else ... what ? another attributes possibles...

                            if ( isset($extraFieldsArray['values'][$variant_key][$name]) )
                            {
                                $html .= '<input type="hidden" class="extra-input" name="profiles[extra][' . $profile_name . '][values][' . $variant_key . '][' . $name . ']" value="' . $extraFieldsArray['values'][$variant_key][$name] . '" />';
                                $allowedValues = unserialize(base64_decode($extraFieldsArray['values'][$variant_key][$name])) ;

                                $select = '<select name="profiles[extra][' . $profile_name . '][attributes][' . $variant_key . '][' . $name . '][' . $kind . ']">';
                                $select .= '<option value="">' . 'Choose' . '</option>';
                                foreach ($allowedValues as $value)
                                {
                                    $select .= '<option value="' . $value . '" ' . ($selected_value === $value ? 'selected="selected"' : '') . '>' . $value . '</option>';
                                }
                                $select .= '</select>';
                                $html .= $select ;
                            }                            
                        }
                        $html .= '</td><td></td></tr>' ;
                    }
                }
                $html .= '</table>' ;
                
            }            
            elseif ( isset($extraFieldsArray['characteristic'][$field]) && count(self::$features) && ! isset($extraFieldsArray['required'][$field]) )
            {    
                $html .= sprintf('<span class="extra-span">%s&nbsp;</span>', preg_replace('/([A-Z])/', ' \1', $field)) ;
                $html .= '<input type="hidden" class="extra-input" name="profiles[extra][' . $profile_name . '][characteristic][' . $field . ']" value="1" />';

                $html .= '<select name="profiles[extra][' . $profile_name . '][field][' . $field . ']" class="profile-feature-list">
                        <option></option>' . "\n" ;
                foreach(self::$features as $feature)
                {
                    if ( $feature['id_feature'] == $value )
                        $selected=' selected="selected"' ;
                    else
                        $selected='' ;

                    $html .= '
                            <option value="' . $feature['id_feature'] . '" ' .  $selected . '>' . $feature['name'] . '</option>' . "\n" ;
                }
                $html .= '</select>' . "\n" ;                                

            }
            elseif ( isset($extraFieldsArray['attributes'][$field]) )
            {
                $html .= '<span class="extra-span">' . preg_replace('/([A-Z])/', ' \1', $field)  . '&nbsp;</span>' ;
                $html .= '<input type="text" class="extra-input"  name="profiles[extra]['.$profile_name.'][field]['.$field.']" value="' . $value . '" />';
                $html .=  '&nbsp;&nbsp;' ;

                if ( isset($extraFieldsArray['attributes'][$field]) )
                {
                    // Selected Value
                    $selected_value = 0 ;
                    
                    if ( isset($extraFieldsArray['attributes'][$field]['unitOfMeasure']) )
                    {    
                        $selected_value = $extraFieldsArray['attributes'][$field]['unitOfMeasure'] ;
                        $kind = 'unitOfMeasure' ;
                    }
                    // Else ... what ?
                    
                    if ( isset($extraFieldsArray['values'][$field]) )
                    {
                        $html .= '<input type="hidden" class="extra-input" name="profiles[extra][' . $profile_name . '][values][' . $field . ']" value="' . $extraFieldsArray['values'][$field] . '" />';
                        $allowedValues = unserialize(base64_decode($extraFieldsArray['values'][$field])) ;
                        
                        $select = '<select name="profiles[extra][' . $profile_name . '][attributes][' . $field . '][' . $kind . ']">';
                        $select .= '<option value="">' . 'Choose' . '</option>';
                        foreach ($allowedValues as $value)
                        {
                            if ( $selected_value === $value )
                                    $selected='selected="selected"' ;
                            else    $selected='' ;
                            $select .= '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
                        }
                        $select .= '</select>';
                        $html .= $select ;
                    }
                }
            }
            else
            {
                $html .= '<span class="extra-span">' . preg_replace('/([A-Z])/', ' \1', $field)  . '&nbsp;</span>' ;
                $html .= '<input type="text" class="extra-input"  name="profiles[extra]['.$profile_name.'][field]['.$field.']" value="' . $value . '" />';
                
                // 2013-08-17
                $html .= '<span>&nbsp;&nbsp;' . '|' . '&nbsp;&nbsp;</span>' ;
                $html .= '<select name="profiles[extra][' . $profile_name . '][characteristic][' . $field . ']" class="profile-feature-list">
                        <option></option>' . "\n" ;
                foreach(self::$features as $feature)
                {
                    $value = isset($extraFieldsArray['characteristic'][$field]) ? $extraFieldsArray['characteristic'][$field] : '' ;
                    
                    if ( $feature['id_feature'] == $value )
                        $selected=' selected="selected"' ;
                    else
                        $selected='' ;

                    $html .= '
                            <option value="' . $feature['id_feature'] . '" ' .  $selected . '>' . $feature['name'] . '</option>' . "\n" ;
                }
                $html .= '</select>' . "\n" ; 
            }            
                
            if ( isset($extraFieldsArray['characteristic'][$field]) )
            {
                // Selected Value
                $selected_value = 0 ;

                if ( isset($extraFieldsArray['characteristic'][$field]['unitOfMeasure']) )
                {    
                    $selected_value = $extraFieldsArray['characteristic'][$field]['unitOfMeasure'] ;
                    $kind = 'unitOfMeasure' ;
                }
                // Else ... what ?

                if ( isset($extraFieldsArray['values'][$field]) )
                {
                    $html .= '<input type="hidden" class="extra-input" name="profiles[extra][' . $profile_name . '][values][' . $field . ']" value="' . $extraFieldsArray['values'][$field] . '" />';
                    $allowedValues = unserialize(base64_decode($extraFieldsArray['values'][$field])) ;

                    $select = '<select name="profiles[extra][' . $profile_name . '][characteristic][' . $field . '][' . $kind . ']" class="extra-option">';
                    $select .= '<option value="">' . 'Choose' . '</option>';
                    foreach ($allowedValues as $value)
                    {
                        if ( $selected_value === $value )
                                $selected='selected="selected"' ;
                        else    $selected='' ;
                        $select .= '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
                    }
                    $select .= '</select>';
                    $html .= $select ;
                }
            }             
            if ( isset($extraFieldsArray['required'][$field]) )
            {
                $html .= '<input type="hidden" class="extra-input" name="profiles[extra][' . $profile_name . '][required][' . $field . ']" value="1" />';
                $html .= '&nbsp;&nbsp;<span class="extra-required">*</span>';
            }
            $html .= '<br />' . "\n";
            
        }            
        return($html) ;
    }
}

?>