<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */


class Amazon_Tag extends Tag
{
        public static function getMarketplaceTags($product, $id_lang, $backward_compatibility = false)
        {
            if ( ! Validate::isLoadedObject($product) )
                return(null) ;
            
            if ( version_compare(_PS_VERSION_,'1.5','<') || $backward_compatibility )
            {
                return(Amazon_Tools::encodeText(self::friendlyKeywords(strip_tags($product->meta_keywords)))) ;
            }
            else
            {
                $tags = parent::getProductTags($product->id) ;
                
                if ( isset($tags[$id_lang]) && is_array($tags[$id_lang]) && count($tags[$id_lang]) )
                {
                    $items = array_unique($tags[$id_lang]) ;

                    $tagc = (int)count($items) ;
                    $tags_array = array() ;
                    
                    for($i = 0 ; $i < (int)ceil($tagc / 5) && $i < 5 ; $i++)
                    {
                        $tags = array_slice($items, $i * 5, 5) ;
                        $tags_array[] = mb_substr(Amazon_Tools::encodeText(implode(' ', $tags)), 0, 50) ;
                    }
                    return($tags_array) ;
                }
                else
                {
                    // Previously (v3.9 <=), we were using only meta_keywords
                    // returns like in previous versions for compatibility
                    return(self::getMarketplaceTags($product, $id_lang, true)) ;
                }
            }
            return(null) ;
        }

        /*
         * Old method / PS 1.3 and 1.4
         */
        public static function friendlyKeywords($text)
        {
            $text = html_entity_decode($text);
            $text = preg_replace(array('/&szlig;/', '/&(..)lig;/', '/&([aouAOU])uml;/', '/&(.)[^;]*;/'), array('ss', "$1", "$1" . 'e', "$1"), $text);
            $text = preg_replace('/[\x00-\x1F\x21-\x2B\x3A-\x3F\x5B-\x60\x7B-\x7F]/', '', $text); // remove non printable
            $text = preg_replace('/[ \t]+/', ' ', $text);
            $text = str_replace(array('_', ',', '.', '/', '+', '?', '&', '=', '-'), ' ', $text);
            $text = preg_replace('/\b[^\s]{1,3}\b/', '', $text);
            $text = preg_replace('/[ ,]+/', ',', $text);
            $text = preg_replace('/[ ,]$/', '', $text);

            $items = explode(',', $text) ;
            if ( $items )
            {
                $items = array_unique($items) ;
                array_splice($items, 5);
                $text = implode(',', $items) ;
            }
            $text = strtolower(trim(str_replace(',', ' ', $text)));

            return($text);
        }    
}