<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @author     Artem B.
 * @author     Erick Turcios  
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

if ( ! defined('AMAZON_MARKETPLACE_VERSION') )
    define('AMAZON_MARKETPLACE_VERSION', '3.7') ;
    
class Amazon_WebService {
    //put your code here
    private $_debug;
    private $_cr;
    private $_att;
    private $region;
    private $Currency;

    private $mid;
    private $mpid;
    private $awsak;
    private $sk;

    // Anti Throttling
    //
    private $last_api_request = array() ;
    private $minute_throttle = array() ;
   
    // Handler for database read/write throttling timer
    //
    private $timerReadHandler = null ;
    private $timerWriteHandler = null ;
    private $timerParam = null ;
    private $timerAction = null ;
    
    const DROP_THROTLLED_QUERIES = 1 ;
    
    const OPERATIONS_UPDATE = 1 ;
    const OPERATIONS_CREATE = 2 ;
    const OPERATIONS_DELETE = 3 ;
    
    const MWS_DO_NOT_SEND = 1 ;
    const MWS_SEND = 2 ;
    
    public $MWS_Action ;
    public $displayXML = false ;
    
    // Amazon Europe
    //
    private $MarketPlaces = array() ;

    /**
     *
     * @param <type> $auth - associative massive
     * auth['MerchantID'] - string, MerchantID
     * auth['MarketplaceID'] - string, MarketplaceID
     * auth['AWSAccessKeyID'] - string, AWSAccessKeyID
     * auth['SecretKey'] - string, SecretKey
     * @param <type> $from associative array
     * from['Country'] - country code, must be one of the following:
     * us, uk, de, fr, jp, cn, ca .
     * That codes means:
     * us - United States, uk - United Kingdom, de - Germany, fr - France, jp - Japan, cn - China, ca - Canada
     * from['Currency'] - must be one of the following:
     *
     * @param <bool> $debug
     */
    public function __construct($auth, $from, $marketPlaces = null, $debug = false, $cr = "<br/>\n", $configurationSetHandler = null) {
        $region = null ;
        
        if ($debug == true) $this->_debug = true;
        else $this->_debug = false;
        $this->_cr = $cr ; //new line symbol
        $this->_att = "<font color=\"red\">!!!</font>"; //this variable uses when debuging mode is on and error happened
                                                        //This is to draw attention to an error
        
        // Creation or Update
        //
        $this->_operationMode = self::OPERATIONS_UPDATE ;

        // Do not simulate
        $this->MWS_Action = self::MWS_SEND ; 
        
        $this->setAuth($auth) ;

        if ( $marketPlaces )
            $this->MarketPlaces = $marketPlaces ;
        else
            $this->MarketPlaces = null ;
        
        //get Region
        if ( isset($from['Country']) )
            $region = $this->retRegion($from['Country']);
        elseif (isset($from['Country']) && $region == false)
        {
          if ($this->_debug)  
            printf("retRegion() function returns false to constructor of the Service class.
                It means, which that function comleted incorrectly. Object of the Service class can not be created now. " . $this->_cr);
        }

        
        $this->region = $region;
        
        if ( isset($from['Currency']))
            if ($this->setCurrency($from['Currency']) == false)
            {
            if ($this->_debug)
                printf("setCurrency() function returns false to constructor of the Service class.
                    It means, which that function comleted incorrectly. Object of the Service class can not be created now. " . $this->_cr );
            }
        if ($this->_debug)
          printf ('Constructor Completed successfully%s', $this->_cr);


        if ($this->_debug) printf("$this->_cr Constructor. Object of the Service class created succesfully".  $this->_cr);
    }

    public function setOperationMode($operationMode)
    {
        switch( intval($operationMode) )
        {
            case self::OPERATIONS_UPDATE :
                $this->_operationMode = self::OPERATIONS_UPDATE ;
                break ;
            case self::OPERATIONS_CREATE ;
                $this->_operationMode = self::OPERATIONS_CREATE ;
                break ;  
            case self::OPERATIONS_DELETE ;
                $this->_operationMode = self::OPERATIONS_DELETE ;
                break ;                 
            default : 
                if ($this->_debug) printf("$this->_cr setOperationMode() unknown value".  $this->_cr);        
                return(false) ;
        }
        return(true) ;
    }
    
    
    // Function to read configuration from external function
    //
    public function setTimerReadHandler($targetClass, $targetFunction, $params)
    {
        $this->timerReadHandler = array($targetClass, $targetFunction) ;
        $this->timerParam = $params ;
    }   
    public function setTimerWriteHandler($targetClass, $targetFunction, $params)
    {
        $this->timerWriteHandler = array($targetClass, $targetFunction) ;
        $this->timerParam = $params ;
    }   
    private function _timerReadHandler()
    {
        return( call_user_func($this->timerReadHandler, $this->timerParam) ) ;
    }    
    private function _timerWriteHandler($value)
    {
        return( call_user_func($this->timerWriteHandler, $this->timerParam, $value) ) ;
    }
    
    public function setTimerAction($action)
    {
        if ( $action == self::DROP_THROTLLED_QUERIES )
            $this->timerAction = self::DROP_THROTLLED_QUERIES ;
    }
   
    private function _caller()
    {
      $trace=debug_backtrace();
      $caller=$trace[2];

      $ret = 'called by '.$caller['function'] . '() ';
      if (isset($caller['class']))
          $ret .= 'in '.$caller['class'];

      return($ret) ;
    }

    private function setAuth($auth)
    {
        if ($this->_debug)
                printf('setAuth() call - called by %s %s', $this->_caller(), $this->_cr);

        if ($auth['MerchantID'] != null) $this->mid = $auth['MerchantID'];
        else
        {
            if ($this->_debug)
             printf('setAuth function. %s Error %s == null . Invalid value.%s', $this->_att, $auth['MerchantID'], $this->_cr);
            return false;
        }

        if ( isset($auth['MarketplaceID']) )
	        if ($auth['MarketplaceID'] != null) $this->mpid = $auth['MarketplaceID'];
	        else
	        {
	            if ($this->_debug)
	              printf('setAuth function. %s Error %s == null . Invalid value.%s', $this->_att, $auth['MarketplaceID'], $this->_cr);
	            return false;
	        }
        if ($auth['AWSAccessKeyID'] != null) $this->awsak = $auth['AWSAccessKeyID'];
        else
        {
            if ($this->_debug) 
              printf('setAuth function. %s Error %s == null . Invalid value.%s', $this->_att, $auth['AWSAccessKeyID'], $this->_cr);
            return false;
        }
        if ($auth['SecretKey'] != null) $this->sk = $auth['SecretKey'];
        else
        {
            if ($this->_debug) 
              printf("setAuth function. %s Error %s == null . Invalid value.%s", $this->_att, $auth['SecretKey'], $this->_cr);
            return false;
        }
        return ;
        if ($this->_debug)
            printf('%ssetAuth - Function Sets Authentification Parameters :  
                    MerchantID : %s%s MarketplaceID : %s%s AWSAccessKeyID : %s%s AWSSecretKey : %s%s',
                    $this->_cr, $this->mid, $this->_cr, $this->mpid, $this->_cr,$this->awsak, $this->_cr,$this->sk, $this->_cr);
       return true;
    }

    private function setCurrency($curr)
    {
        if ($this->_debug) printf('setCurrency() call. curr = %s%s', $curr ,$this->_cr);

        if ( preg_match('/USD|GBP|EUR|JPY|CAD|INR/i', $curr) )
        {
            $this->Currency = strtoupper($curr) ;
            return true;
        }
        if ($this->_debug)
          printf('setCurrency() function. %sError. You sent invalid currency:
                  %s Please verify this and try again. %s', $this->_att, $curr, $this->_cr);
        return false;
    }

    /**
     *
     * @param <string> $countryFrom country code.
     * Must be one of the following: us, uk, de, fr, jp, cn, ca
     * @return <string> - Feeds Web Service Url of false if unsuccessful
     */
    private function retRegion ($countryFrom)
    {
        if ($this->_debug) printf('retRegion() call. countryFrom = %s%s', $countryFrom, $this->_cr);
        switch ($countryFrom)
        {
            case "us" : return "com";
            case "uk" : return "co.uk";
            case "de" : return "de";
            case "fr" : return "fr";
            case "it" : return "it";
            case "in" : return "in";
            case "es" : return "es";
            case "be" : return "be";
            case "jp" : return "jp";
            case "ja" : return "jp";
            case "cn" : return "com.cn";
            case "ca" : return "ca";
        }
        if ($this->_debug) printf('%sgenerateFeedServiceUrl() function. %sError. Incorrect Country Code "%s" . Please verify and try again.',
        $this->_cr, $this->_att, $countryFrom, $this->_cr);
        return false;
    }
    private function _endPointURL()
    {
        switch( strtolower(trim($this->region)) )
        {
            case 'com' : 
                return('mws.amazonservices.com') ;            
            case 'us' : 
                return('mws.amazonservices.com') ;
            case 'ca' :
                return('mws.amazonservices.ca') ;
            case 'jp' :
            case 'ja' :
                return('mws.amazonservices.jp') ;                
            case 'cn' :
                return('mws.amazonservices.cn') ;                
            case 'in' :
                return('mws.amazonservices.in') ;
            case 'co.uk' :
                return('mws-eu.amazonservices.com') ;
            case 'de' :
            case 'es' :
            case 'fr' :
            case 'it' :
            case 'uk' :
                return('mws-eu.amazonservices.com') ;
            default :
                if ($this->_debug) 
                {
                    printf('%s_endPointURL() function. Error. Incorrect Region Code "%s" . Please verify and try again.%s', $this->_att, $this->region, $this->_cr) ;
                    die ;
                }
                return(null) ;
        }
    }
   
    public function simpleCallWS($params, $API, $returnXML = true)
    {
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        $params["AWSAccessKeyId"] = $this->awsak;
        $params["Timestamp"] = gmdate("Y-m-d\TH:i:s\Z");
        
        if ( ! isset($params["Version"]))
            $params["Version"] = "2011-07-01" ;
        
        $uri = '/' . trim($API) ;
        
        switch( $API )
        {
            case 'Reports' :
            case 'ReportsDownload' :
                $uri = '/';
        }
        
        ksort($params);

        $method = "POST";
        $host = $this->_endPointURL() ;    
        
        // create the canonicalized query
        $canonicalized_query = array();

        foreach ($params as $param=>$value)
        {
            $param = str_replace("%7E", "~", rawurlencode($param));
            $value = str_replace("%7E", "~", rawurlencode($value));
            $canonicalized_query[] = $param."=".$value;
        }

        $canonicalized_query = implode("&", $canonicalized_query);

        // create the string to sign
        $string_to_sign = $method."\n".$host."\n".$uri."\n".$canonicalized_query;


        // calculate HMAC with SHA256 and base64-encoding
        $signature = base64_encode(hash_hmac("sha256", $string_to_sign, $this->sk, True));

        // encode the signature for the request
         $signature = str_replace("%7E", "~", rawurlencode($signature));


        //open connection
        $ch = curl_init();

        //working with headers
        $header = NULL;

        $curlOptions = array (
            CURLOPT_POST => true,
            CURLOPT_USERAGENT => 'Common-Services/Amazon Marketplace/' . AMAZON_MARKETPLACE_VERSION . ' (Language=PHP/' . phpversion() . ')',
            CURLOPT_RETURNTRANSFER => true,
            );

        $curlOptions[CURLOPT_URL] = "https://".$host.$uri;
        $curlOptions[CURLOPT_POSTFIELDS] = $canonicalized_query."&Signature=".$signature;
        $curlOptions[CURLOPT_SSL_VERIFYPEER] = false;
        $curlOptions[CURLOPT_VERBOSE] = false;

        $curlHandle = curl_init();
        curl_setopt_array($curlHandle, $curlOptions);
        
        if ( ($result = curl_exec($curlHandle)) == false )  $pass = false ;
        else $pass = true ;

        if ($this->_debug)
        {
            echo $this->_caller() ;
            echo "Params: $this->_cr" ;
            echo nl2br(print_r($curlOptions, true)) ;
            echo "CURL Data: $this->_cr" ;
            echo nl2br(print_r($params, true)) ;
            echo $this->_cr ;
            echo nl2br(print_r(curl_getinfo($curlHandle), true));  // get error info
            echo "cURL error number:" .curl_errno($curlHandle) . $this->_cr   ; // print error info
            echo "cURL error:" . curl_error($curlHandle) . $this->_cr   ;
        }
        if ( !$pass ) return(false);

        curl_close($curlHandle);

        if ( $returnXML )
        {
            try
            {
                $xml = new SimpleXMLElement($result);
                return($xml) ;

            } 
            catch (Exception $e) 
            {
                echo("Exception Caught: " . $e->getMessage() . "\n");
                return false;
            }
        }
        else
        {
            return($result) ;
        }
        
    }
    
    public function ServiceStatus($returnXML = false)
    {
        if ($this->_debug == true) printf("$this->_cr ConnectionCheck call. $this->_cr");

        $params = array();
        $params['Action'] = 'GetServiceStatus';
 
        $API = 'Sellers';

        $xml = $this->simpleCallWS($params, $API, $returnXML) ;   
        
        if ( isset($xml->GetServiceStatusResult) )
        {
            if ( $returnXML )   return($xml) ;
            else return(true) ;
        }
        else return($xml);
    }     
    
    public function ListMarketplaceParticipations($returnXML = true)
    {
        if ($this->_debug == true) printf("$this->_cr ConnectionCheck call. $this->_cr");

        $params = array();
        $params['Action'] = 'ListMarketplaceParticipations';
        
        $API = 'Sellers';

        $xml = $this->simpleCallWS($params, $API, $returnXML) ;   
        
        if ( isset($xml->ListMarketplaceParticipationsResult) )
        {
            if ( $returnXML )   return($xml) ;
            else return(true) ;
        }
        else return($xml);
    }
    
    /**
     *All parameters must be specified, except of conditionNote. You can use another functions (partiallyUpdateProducts(), updateQuantities(), updatePrices())
     * if you want to partially update products
     * You can also update (overwrite) exesting product information using this function (AddProducts) if you want to.
     *
     * @param <type> $products - massive format:
     * $products[$i]['SKU'] - string, unique product identifier in the seller account
     * $products[$i]['ProductIDType'] - (string) Product Identification type. Must be one of the fellowing:
     *                          "ISBN", "UPC", "EAN", "ASIN", "GTIN"
     * $products[$i]['ProductIDCode'] - Product Code, based on the ProductType
     *
     * $products[$i]['ConditionType'] - string, one of the following: "New",
     *      "UsedLikeNew", "UsedVeryGood", "UsedGood", "UsedAcceptable",
     *      "CollectibleLikeNew", "CollectibleVeryGood", "CollectibleGood", "CollectibleAcceptable"
     *      "Refurbished", "Club"
     *
     * $products[$i]['ConditionNote'] - any string, up to 2000 symbols
     * $products[$i]['Quantity'] - number of items. that available for selling
     * $products[$i]['Price'] - price of the product
     * @return <int[]> Web Service Submission identifiers (3), or false, if unsuccessful
     */
    public function addProducts($products)
    {
        //when we add products all fields must be not null, except of $products[$i]['ConditionNote']
        if ($this->_debug)
        {
         echo "addProducts() call. $this->_cr";
         echo "addProducts() function. Checking for arguments... $this->_cr";
        }

        for ($i=0; $i<count($products); $i++)
        {
           if ($this->_debug)
            echo "addProducts() function. Checking of the $i-th product $this->_cr";

            if ( isset($products[$i]['NoPriceExport']) && $products[$i]['NoPriceExport'] == true )
            {
                if ($this->_debug)
                    printf("$this->_cr addProducts() call, skipping product: %s (NoPriceExport is sets) $this->_cr", $products[$i]['SKU']);
                unset($products[$i]) ;
                continue ;
            }
           
            if ($products[$i]['SKU'] == null ||
                    $products[$i]['ConditionType'] == null || $products[$i]['Quantity'] == null || $products[$i]['Price'] == null)
            {
                if ($this->_debug)
                      echo "addProducts() function. $this->_att Warning. One of the fields is null (or not set) in the $i-th Product (SKU : $products[$i]['SKU']).
                            Function skips the product and continue execution. $this->_cr";

                $products[$i] = null;
                continue;
            }
            //check Quantity and Price in order to avoid partial data corruption
            if (!$this->checkQuantity($products[$i]['Quantity']))
            {
                if ($this->_debug)
                  printf('addProducts() function. %sQuantity Warning in the %d-th Product:
                         Function skips the product and continue execution (SKU : %s).%s',
                         $this->_att, $i, $products[$i]['SKU'], $this->_cr) ;

                $products[$i] = null;
                continue;
            }
            if (!$this->checkPrice($products[$i]['Price']))
            {
                 if ($this->_debug)
                   printf('addProducts() function. Warning. %s Invalid specified price, in the %d-th Product.
                          Function skips the product and continue execution  (SKU : %s). %s',
                          $this->_att, $i, $products[$i]['SKU'], $this->_cr) ;

                 $products[$i] = null;
                 continue;
            }
            // Modified on 2012/09/10 - Olivier
            // Replaced Update by PartialUpdate
            // Modified on 2012/12/21: 
            switch($this->_operationMode)
            {
                case self::OPERATIONS_CREATE :
                    $operationMode = 'Update' ;
                    break ;
                case self::OPERATIONS_UPDATE :
                    $operationMode = 'PartialUpdate' ;
                    break ;                    
                case self::OPERATIONS_DELETE :
                    $operationMode = 'Delete' ;
                    break ;                     
            }

            if (!$this->partiallyCheckProduct($products[$i], $operationMode))
            {
                if ($this->_debug)
                   printf('addProducts() function. %sWarning. %d-th product is partially incorrect. We skip it (SKU : %s). %s',
                           $this->_att, $i, $products[$i]['SKU'], $this->_cr);
                $products[$i] = null;
                continue;
            }
        }

        //if there is no products to add we terminate the function
        //we have to skip empty products
        $eproducts = array();
        if ($this->_debug)
        {
            $n = count($products);
            printf('addProducts() function. You sent $n products%s', $this->_cr);
        }

        for ($i=0; $i<count($products); $i++)
            if ($products[$i]!=null) $eproducts[] = $products[$i];

        if ($this->_debug)
        {
            $n = count($eproducts);
            printf('addProducts() function. %d products remaining after skippings%s', $n, $this->_cr);
        }

        if (count($eproducts) == 0)
        {
            if ($this->_debug)
              printf('addProducts() function. No products to add (or they are all skipped !). %sStop here with an Error.%s', $this->_att,  $this->_cr) ;
            return false;
        }

        $products = $eproducts;

        $Submissions = array();
        $Submissions[0] = $this->partiallyUpdateProducts($products, "Update", false);
        $Submissions[1] = $this->updateQuantities($products);
        $Submissions[2] = $this->updatePrices($products) ;
        $Submissions[3] = $this->overrideShipping($products) ;
        $Submissions[4] = $this->productImage($products) ;


        if ($Submissions[0] === false && $Submissions[1] === false && $Submissions[2] === false)
        {
            if ($this->_debug) printf("$this->_cr addProducts() function. $this->_att Error. There are no products to update. All products are skipped. Function terminated. $this->_cr");
            return false;
        }
        $SubmitIDs = array() ;

        if ( ! isset( $Submissions[0]->SubmitFeedResult->FeedSubmissionInfo ) )
        {
            if ($this->_debug)
                printf("$this->_cr addProducts() function. $this->_att Error. No submission feed data. Return is: %s $this->_cr", nl2br(print_r($Submissions[0], true)));
            return(false);
        }
        elseif ( ! isset( $Submissions[0]->SubmitFeedResult ) )
        {
            if ($this->_debug)
                printf("$this->_cr addProducts() function. $this->_att Error. No submission feed info. Return is: %s $this->_cr", nl2br(print_r($Submissions[0], true)));
            return(false);
        }

        if ( isset($Submissions[0]) && is_object($Submissions[0]) )
        {
            if ( $this->_debug )
                printf("$this->_cr addProducts() function. partiallyUpdateProducts returned : %s $this->_cr", nl2br(print_r($Submissions[0]->SubmitFeedResult, true))) ;
            $SubmitIDs['products'] = strval($Submissions[0]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[1]) && is_object($Submissions[1]) )
        {
            if ( $this->_debug )
                printf("$this->_cr addProducts() function. updateQuantities returned : %s $this->_cr", nl2br(print_r($Submissions[1]->SubmitFeedResult, true))) ;
            $SubmitIDs['inventory'] = strval($Submissions[1]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[2]) && is_object($Submissions[2]) )
        {
            if ( $this->_debug )
                printf("$this->_cr addProducts() function. updatePrices returned : %s $this->_cr", nl2br(print_r($Submissions[2]->SubmitFeedResult, true))) ;
            $SubmitIDs['prices'] = strval($Submissions[2]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[3]) && is_object($Submissions[3]) )
        {
            if ( $this->_debug )
                printf("$this->_cr addProducts() function. overrideShipping returned : %s $this->_cr", nl2br(print_r($Submissions[3]->SubmitFeedResult, true))) ;
            $SubmitIDs['overrides'] = strval($Submissions[3]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }

        if ($this->_debug)
            printf("$this->_cr addProducts() function. Returns: %s $this->_cr", nl2br(print_r($SubmitIDs,  true))) ;

        if ( isset($Submissions[4]) && is_object($Submissions[4]) )
        {
            if ( $this->_debug )
                printf("$this->_cr addProducts() function. productImage returned : %s $this->_cr", nl2br(print_r($Submissions[4]->SubmitFeedResult, true))) ;
            $SubmitIDs['images'] = strval($Submissions[4]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }

        if ($this->_debug)
            printf("$this->_cr addProducts() function. Returns: %s $this->_cr", nl2br(print_r($SubmitIDs,  true))) ;
        
        return($SubmitIDs);
    }

    private function partiallyCheckProduct($product, $updatingType=null)
    {
        if ($this->_debug)
          printf('partiallyCheckProduct() call. Checking product starts here.%s', $this->_cr);

        //updating or partial updating ?
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
                $updatingType = 'Update' ;
                break ;
            case self::OPERATIONS_UPDATE :
                $updatingType = 'PartialUpdate' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ;                 
            default:
                echo "$this->_cr partiallyCheckProduct() - Undefined value for updatingType . $this->_cr";
                return(false); 
        }        
        
        if (!$this->checkSKU($product['SKU']))
        {
            if ($this->_debug)
            printf('partiallyCheckProduct() function. %sWarning. product["SKU"] : "%s" invalid value. Skipping the product and continue.%s', $this->_att, $product['SKU'], $this->_cr);
            return false;
        }

        if ( isset($product['ProductIDType']) && $product['ProductIDType'] != null && $product['ProductIDCode'] !=null )
        {
            if ($product['ProductIDType'] == null || $product['ProductIDCode'] == null)
            {
                if ($this->_debug)
                {
                    $val1 = $product['ProductIDType'];
                    $val2 = $product['ProductIDCode'];
                    printf('partiallyCheckProduct() function.  %sWarning. You specify:%s
                              product["ProductIDType"] : %s %s
                              product["ProductIDCode"] : %s %s
                              If one of that fields specified the other one must be also specified.%s',
                              $this->_att, $this->_cr, $val1, $this->_cr, $val2, $this->_cr);
                }
                return false;
            }
            if (!$this->checkProductIDType($product['ProductIDType']))
            {
                if ($this->_debug)
                {
                    $pridt = $product['ProductIDType'];
                    printf('partiallyCheckProduct() function. %sWarning. product["ProductIDType"] = %s. Incorrect Value. Function skips the product and continue execution. %s',
                            $this->_att, $pridt, $this->_cr);
                }
                return false;
            }
        }
         if (isset($product['ConditionType']) && $product['ConditionType']!=null)
            if(!$this->checkConditionType($product['ConditionType']))
            {
                if ($this->_debug)
                {
                    $val1 = $product['ConditionType'];
                    printf('partiallyCheckProduct() function. %sWarning
                       products[$i]["ConditionType"] = %s . It is incorrect $this->_cr',
                       $this->_att, $val1, $this->_cr);
                }
                return false;
            }
        if (isset($product['ConditionNote']) && $product['ConditionNote']!=null)
        {
            if ($product['ConditionType']==null)
            {
                if ($this->_debug)
                {
                    $value = $product['ConditionNote'];
                    printf ('partiallyCheckProduct() function. %sWarning. You specify
                             products[$i]["ConditionNote"] = %s, but products[$i]["ConditionType"] is not specified. It is incorrect. Function skips the product and continue execution',
                             $this->_att, $value, $this->_cr);
                }
                return false;
            }
            if(!$this->checkConditionNote($product['ConditionNote']))
            {
                if ($this->_debug) printf('partiallyCheckProduct() function. %sError. product["ConditionNote"] : invalid value.%s', $this->_att,  $this->_cr);
                return false;
            }
        }
        if ($this->_debug) printf('partiallyCheckProduct() function successfully finished.', $this->_cr);
        return true;
    }


    /**
     *
     * @param <type> $products - object array:
     * $products[$i]['SKU'] - string, unique product identifier in the seller account. Must be specified.
     * $products[$i]['$ProductIDType'] - [optional] (string) Product Identification type. Must be one of the fellowing:
     *                          "ISBN", "UPC", "EAN", "ASIN", "GTIN"
     *               If $UpdatingType is equal to "Update", this field must be specified.
     * $products[$i]['$ProductIDCode'] - [optional] Product Code, based on the ProductType.
     *                    If specified, $products[$i]['$ProductIDType'] must be also specified
     *                    If null, $products[$i]['$ProductIDType'] must be also null
     *               If $UpdatingType is equal to "Update", this field must be specified.
     * $products[$i]['ConditionType'] - [optional] string, one of the following: "New",
     *      "UsedLikeNew", "UsedVeryGood", "UsedGood", "UsedAcceptable",
     *      "CollectibleLikeNew", "CollectibleVeryGood", "CollectibleGood", "CollectibleAcceptable"
     *      "Refurbished", "Club"
     *
     * $products[$i]['ConditionNote'] - [optional] any string, up to 2000 symbols
     *                if $products[$i]['ConditionNote'] specified, $products[$i]['ConditionType'] must be also specified
     *
     * @param <string> $UpdatingType - [optional] must be equal to "Update" or to "PartialUpdate".
     *         If you do not specify value of this field, this function uses "PartialUpdate" by default
     *
     *         If you use Update, all specified information overwrites any existing information.
     *         Any unspecified information is erased.
     *         If you use PartialUpdate, all specified information overwrites any existing information,
     *         but unspecified information is unaffected.
     *
     * @return <int> - FeedSubmissionID or false (if an error occurred)
     */
    public function partiallyUpdateProducts($products, $updatingType=null, $ch=true)
    {
        //checking input arguments
        if ($this->_debug) echo "$this->_cr partiallyUpdateProducts call. checking of the input arguments starts here. $this->_cr";

        //updating or partial updating ?
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
                $updatingType = 'Update' ;
                break ;
            case self::OPERATIONS_UPDATE :
                $updatingType = 'PartialUpdate' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ;                 
            default:
                echo "$this->_cr partiallyUpdateProducts call. undefined value for updatingType . $this->_cr";
                return(false); 
        }        
        if($ch==true)
        {
            for ($i=0; $i<count($products); $i++)
            {
                $r = $this->partiallyCheckProduct($products[$i], $updatingType);
                if($r == false) $products[$i] = null;
            }
        }

        if ($this->_debug)
          printf('partiallyUpdateProducts function. Checking input arguments is finished.%s', $this->_cr);

        //if there are no products to add, function will be terminated
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null) break;
            if ($i == count($products)-1)
            {
                if ($this->_debug)
                  printf('partiallyUpdateProducts function. We have no products to add (or they all are skipped). Function is finished with $this->_att an Error.%s', $this->_cr);
                return false;
            }
        }

        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug) printf("$this->_cr partiallyUpdateProducts function. Creating messages starts here. $this->_cr");
        $m = 0;
        for ($i=0; $i<count($products); $i++)
        {
            if ($this->_debug) printf("$this->_cr partiallyUpdateProducts function. Creating $i-th message starts here $this->_cr");
            if ($products[$i] != null)
            {
                $Messages[$m] = $this->createProductMessage ($Document, $products[$i]['SKU'],
                    isset($products[$i]['ProductIDType']) ? $products[$i]['ProductIDType'] : '', 
                    isset($products[$i]['ProductIDCode']) ? $products[$i]['ProductIDCode'] : '', 
                    isset($products[$i]['ConditionType']) ? $products[$i]['ConditionType'] : '',
                    isset($products[$i]['ConditionNote']) ? $products[$i]['ConditionNote'] : NULL, 
                    isset($products[$i]['ProductData']) ? $products[$i]['ProductData'] : '',                        
                    isset($products[$i]['ProductDescription']) ? $products[$i]['ProductDescription'] : '',                        
                        $m+1, $updatingType);
            
                $m++;
            }
            else
            {
                if ($this->_debug) printf("$this->_cr partiallyUpdateProducts function. $i-th product is incorrect. We skip it. $this->_cr");
            }
        }
        
        
        if ($this->_debug) printf("$this->_cr partiallyUpdateProducts function. Messages creating finished. $this->_cr");

         
        $feedDOM = $this->CreateFeed($Document, "Product", $Messages);
        
        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML($feedDOM);
        
        if ($this->_debug) 
        {
            printf("$this->_cr partiallyUpdateProducts function. Now function starts sending query to the WebService (this->processFeed function calling).$this->_cr");
            
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
        }
        $data = $this->processFeed("_POST_PRODUCT_DATA_", $feed);
        
        if ($this->_debug)
        {
            $state;
            if ($data === false || $data === null) $state = "with an $this->_att error";
            else $state = "succesfully";
                printf("$this->_cr partiallyUpdateProducts function. Function execution is completed $state $this->_cr");
        }
        return $data;
    }

    public function updateRelationships($relationShip)
    {
        if ($this->_debug) printf("$this->_cr updateRelationships() function. %s $this->_cr", $this->_caller());

        $Submissions = null ;
        $SubmitIDs = array() ;  

        $Submissions = $this->productRelationship($relationShip) ;
        
        if ( isset($Submissions) && is_object($Submissions) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateRelationships() function. productRelationship returned : %s $this->_cr", nl2br(print_r($Submissions->SubmitFeedResult, true))) ;
            $SubmitIDs['relations'] = strval($Submissions->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }        
        if ($this->_debug)
            printf("$this->_cr updateRelationships() function. Returns: %s $this->_cr", nl2br(print_r($SubmitIDs,  true))) ;

        return($SubmitIDs);

    }

    public function updateProducts($products, $relationShip = null)
    {
        if ($this->_debug) printf("$this->_cr updateProducts() function. %s $this->_cr", $this->_caller());

        $Submissions = array();
        $SubmitIDs = array() ;  
        
        $Submissions[0] = $this->partiallyUpdateProducts($products);
        $Submissions[1] = $this->updateQuantities($products);
        $Submissions[2] = $this->updatePrices($products);
        $Submissions[3] = $this->overrideShipping($products) ;
        $Submissions[4] = $this->productImage($products) ;

        if ( $relationShip )
            $Submissions[5] = $this->productRelationship($relationShip) ;
        
        if ($Submissions[0] === false && $Submissions[1] === false && $Submissions[2] === false)
        {
            if ($this->_debug) printf("$this->_cr updateProducts() function. $this->_att Error. There are no products to update. All products are skipped. Function terminated. $this->_cr");
            return false;
        }

        if ( ! isset( $Submissions[0]->SubmitFeedResult->FeedSubmissionInfo ) )
        {
            if ($this->_debug)
                printf("$this->_cr updateProducts() function. $this->_att Error. No submission feed data. Return is: %s $this->_cr", nl2br(print_r($Submissions[0], true)));
            return(false);
        }
        elseif ( ! isset( $Submissions[0]->SubmitFeedResult ) )
        {
            if ($this->_debug)
                printf("$this->_cr updateProducts() function. $this->_att Error. No submission feed info. Return is: %s $this->_cr", nl2br(print_r($Submissions[0], true)));
            return(false);
        }

        if ( isset($Submissions[0]) && is_object($Submissions[0]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. partiallyUpdateProducts returned : %s $this->_cr", nl2br(print_r($Submissions[0]->SubmitFeedResult, true))) ;
            $SubmitIDs['products'] = strval($Submissions[0]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[1]) && is_object($Submissions[1]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. updateQuantities returned : %s $this->_cr", nl2br(print_r($Submissions[1]->SubmitFeedResult, true))) ;
            $SubmitIDs['inventory'] = strval($Submissions[1]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[2]) && is_object($Submissions[2]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. updatePrices returned : %s $this->_cr", nl2br(print_r($Submissions[2]->SubmitFeedResult, true))) ;
            $SubmitIDs['prices'] = strval($Submissions[2]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[3]) && is_object($Submissions[3]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. overrideShipping returned : %s $this->_cr", nl2br(print_r($Submissions[3]->SubmitFeedResult, true))) ;
            $SubmitIDs['overrides'] = strval($Submissions[3]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[4]) && is_object($Submissions[4]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. productImage returned : %s $this->_cr", nl2br(print_r($Submissions[4]->SubmitFeedResult, true))) ;
            $SubmitIDs['images'] = strval($Submissions[4]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }
        if ( isset($Submissions[5]) && is_object($Submissions[5]) )
        {
            if ( $this->_debug )
                printf("$this->_cr updateProducts() function. productRelationship returned : %s $this->_cr", nl2br(print_r($Submissions[5]->SubmitFeedResult, true))) ;
            $SubmitIDs['relations'] = strval($Submissions[5]->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }        
        if ($this->_debug)
            printf("$this->_cr updateProducts() function. Returns: %s $this->_cr", nl2br(print_r($SubmitIDs,  true))) ;

        return($SubmitIDs);

    }

    
    /*
     * Update only price inventory
     */
    public function updatePriceOnly($products)
    {
        if ($this->_debug) printf("$this->_cr updatePriceOnly() function. %s $this->_cr", $this->_caller());

        $Submissions = array();
        $Submissions = $this->updatePrices($products);
        $SubmitID = 0 ;

        if ( isset($Submissions) && is_object($Submissions) )
        {
            if ( $this->_debug )
                printf("$this->_cr updatePriceOnly() function. updatePrices returned : %s $this->_cr", nl2br(print_r($Submissions->SubmitFeedResult, true))) ;
            $SubmitID = strval($Submissions->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId) ;
        }        
        
        if ($this->_debug)
            printf("$this->_cr updatePriceInventory() function. Returns: %s $this->_cr", $SubmitID) ;

        return($SubmitID);

    }
    
    
    public function partiallyUpdateProduct($SKU, $ProductIDType, $ProductIDCode, $ConditionType, $ConditionNote, $updatingType)
    {
        if ($this->_debug) printf("$this->_cr partiallyUpdateProduct() call. All checkings and operations will made in the partiallyUpdateProducts() function. Now an object array creation...  $this->_cr");
        $products = array();
        $products[0]['SKU'] = $SKU;
        $products[0]['ProductIDType'] = $ProductIDType;
        $products[0]['ProductIDCode'] = $ProductIDCode;
        $products[0]['ConditionType'] = $ConditionType;
        $products[0]['ConditionNote'] = $ConditionNote;
        if ($this->_debug) printf("$this->_cr partiallyUpdateProduct() function. Calling of the partiallyUpdateProducts() function... $this->_cr");
        $data = $this->partiallyUpdateProducts($products, $updatingType);
        if ($this->_debug)
        {
            if($data == false)
                printf("$this->_cr partiallyUpdateProduct() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr partiallyUpdateProduct() function is finished successfully here $this->_cr");
        }
        return $data;
    }


    //add single product
    //All parameters must be specified!!!
    /* It is not recommended to use this function if you want to add many products at once.
     * Amazon may limit the number of requests from each seller account.
     * you can read more about throttling at
     * Now we make 3 request to the SubmitFeed operation.
     * You can find information about how many requests to the SubmitFeed operation we can submit each time, in that pdf document (page #10),
     * but that information, unfortunatelly, can be not fully correct.
     * In case, if request is throttled, you get an
     * MarketplaceWebService_Exception
    */
    //will return an array with 3 (three) submission IDs (we make 3 requets to the Web Service, so we have 3 submission IDs)
    //or false (if an error occurred)
    public function addProduct($SKU, $ProductIDType, $ProductIDCode, $ConditionType, $ConditionNote, $Quantity, $Price)
    {
        if ($this->_debug) printf("$this->_cr addProduct call. It will construct an object massive and sends it to the addProducts() function. All verifications (checkings) and operations will be performed there. $this->_cr");
        if ($this->_debug) printf("$this->_cr addProduct function. Creation of the object array starts here. (\$products[0]['SKU'] = \$SKU , etc.)...$this->_cr");
        $products = array();
        $products[0]['SKU'] = $SKU;
        $products[0]['ProductIDType'] = $ProductIDType;
        $products[0]['ProductIDCode'] = $ProductIDCode;
        $products[0]['ConditionType'] = $ConditionType;
        $products[0]['ConditionNote'] = $ConditionNote;
        $products[0]['Quantity'] = $Quantity;
        $products[0]['Price'] = $Price;
        if ($this->_debug) printf("$this->_cr addProduct function. Creation of the object array is finished. Calling addProducts() function... $this->_cr");
        $data = $this->addProducts($products);
        if ($this->_debug)
        {
            $state;
            if ($data == false) $state = "$this->_att with an error";
            else $state = "successfully";
            printf("$this->_cr addProduct function. Function execution is completed $state $this->_cr");
        }
        return $data;
    }


    /**
     *
     * @param <type> $products - object array
     * $products[$i]['SKU'] - must be not null
     * $products[$i]['ShippingPrice'] - must be not null
     * @return <int> - FeedSubmissionID or false (if an error occurred)
     */
    public function overrideShipping($products)
    {
        if ($this->_debug) printf("$this->_cr overrideShipping() call, checking input arguments ...  $this->_cr");
        //checking input arguments
        for ($i=0; $i<count($products); $i++)
        {
            if ($this->_debug) printf("$this->_cr overrideShipping() function. \$products[$i] checking...  $this->_cr");
            if (!$this->checkSKU($products[$i]['SKU']))
            {
                $SKUValue = $products[$i]['SKU'];
                if ($this->_debug) printf("$this->_cr overrideShipping() function. $this->_att Warning. \$products[$i]['SKU'] = $SKUValue is incorrect. Please verify this... Function skips this product and continue excution.  $this->_cr");

                $products[$i] = null;
                continue;
            }
        }

        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null) break;
            if ($i == count($products)-1)
            {
                if ($this->_debug) printf("$this->_cr overrideShipping() function. We have no Shipping to update (or all the instances are skipped). Function is finished with $this->_att an Error. $this->_cr");
                return true;
            }
        }

        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug) printf("$this->_cr  overrideShipping() function. Creation of the QuantityMessages starts here  $this->_cr");
        $m = 0;
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null)
            {
                if ( ! isset($products[$i]['ShippingPrice']) ) continue ;
                if ( ! isset($products[$i]['ShippingType']) || ! $products[$i]['ShippingType'] ) continue ;
;
                $Messages[$m] = $this->createShippingOverrideMessage($Document, $products[$i]['SKU'], $products[$i]['ShippingPrice'], $products[$i]['ShippingType'], $m+1);
                $m++;
            }
            else
            {
                if ($this->_debug) printf("$this->_cr  overrideShipping() function. Incorrect product. Creation of the QuantityMessages skipped  $this->_cr");
            }
        }

        if ( ! count($Messages) )
        {
            if ($this->_debug)
                printf("$this->_cr overrideShipping() nothing to override $this->_cr");
            return(true);
        }
        
        $feedDOM = $this->CreateFeed($Document, "Override", $Messages);
        
        if ( $this->_debug )
                    $feedDOM->formatOutput = true ;

        $feed = $feedDOM->saveXML();
        $data = $this->processFeed("_POST_PRODUCT_OVERRIDES_DATA_", $feed);
        
        if ($this->_debug)
        {
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
            
            if($data === false || $data === null)
                printf("$this->_cr overrideShipping() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr overrideShipping() function is finished successfully here $this->_cr");
        }
        return $data;
    }

    
    /**
     *
     * @param <type> $products - object array
     * $products[$i]['SKU'] - must be not null
     * $products[$i]['ProductImage'] - must be not null
     * @return <int> - FeedSubmissionID or false (if an error occurred)
     */
    public function productImage($products)
    {
        if ($this->_debug) printf("$this->_cr productImage() call, checking input arguments ...  $this->_cr");
        //checking input arguments
        for ($i=0; $i<count($products); $i++)
        {
            if ($this->_debug) printf("$this->_cr productImage() function. \$products[$i] checking...  $this->_cr");
            if (!$this->checkSKU($products[$i]['SKU']))
            {
                $SKUValue = $products[$i]['SKU'];
                if ($this->_debug) printf("$this->_cr productImage() function. $this->_att Warning. \$products[$i]['SKU'] = $SKUValue is incorrect. Please verify this... Function skips this product and continue excution.  $this->_cr");

                $products[$i] = null;
                continue;
            }
        }

        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null) break;
            if ($i == count($products)-1)
            {
                if ($this->_debug) printf("$this->_cr productImage() function. We have no Shipping to update (or all the instances are skipped). Function is finished with $this->_att an Error. $this->_cr");
                return(false);
            }
        }

        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug) printf("$this->_cr  productImage() function. Creation of the Messages starts here  $this->_cr");
        $m = 0;
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null)
            {

                if ( ! isset($products[$i]['ProductData']['ProductImage']) ) continue ;
                
                $index = 0 ;
                foreach($products[$i]['ProductData']['ProductImage'] as $image)
                {
                    $Messages[$m] = $this->createProductImageMessage($Document, $products[$i]['SKU'], $image, $m+1, $index);
                    $m++;
                    $index++ ;
                }
            }
            else
            {
                if ($this->_debug) printf("$this->_cr  productImage() function. Incorrect product. Creation of the QuantityMessages skipped  $this->_cr");
            }
        }

        if ( ! count($Messages) )
        {
            if ($this->_debug)
                printf("$this->_cr productImage() no images $this->_cr");
            return(false);
        }

        $feedDOM = $this->CreateFeed($Document, "ProductImage", $Messages);
        
        if ( $this->_debug )
                    $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();
        $data = $this->processFeed("_POST_PRODUCT_IMAGE_DATA_", $feed);
        if ($this->_debug)
        {
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
            
            if($data === false || $data === null)
                printf("$this->_cr productImage() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr productImage() function is finished successfully here $this->_cr");
        }
        return $data;
    }

    /**
     *
     * @param <type> $relations - object array
     * $products[$i]['parent'] - must be not null
     * $products[$i]['children'] - must be not null
     * @return <int> - FeedSubmissionID or false (if an error occurred)
     */
    public function productRelationship($relations)
    {
        if ($this->_debug) printf("$this->_cr productRelationship() call, checking input arguments ...  $this->_cr");
        //checking input arguments
        $i = 0 ;
        if ( $relations )
        foreach($relations as $id_product => $Relationship)
        {
            if ($this->_debug) printf("$this->_cr productRelationship() function. \$products[$i] checking...  $this->_cr");
            if (!$this->checkSKU($Relationship['parent']))
            {
                $SKUValue = $Relationship['parent'];
                if ($this->_debug) printf("$this->_cr productRelationship() function. $this->_att Warning. \$products[$i]['SKU'] = $SKUValue is incorrect. Please verify this... Function skips this product and continue excution.  $this->_cr");

                $relations[$id_product] = null;
                continue;
            }
            $SKUValue = $Relationship['parent'];
            
            foreach($Relationship['children'] as $key => $ChildSKU)
            {
                if (!$this->checkSKU($ChildSKU))
                {
                    if ($this->_debug) 
                        printf("$this->_cr productRelationship() function. $this->_att Warning. \$ChildSKU = $ChildSKU is incorrect. Please verify this... Function skips this product and continue excution.  $this->_cr");

                    $relations[$id_product]['children'][$key] = null;
                    continue;
                }
            }
            $i++;
        }


        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug) printf("$this->_cr  productRelationship() function. Creation of the QuantityMessages starts here  $this->_cr");
        $m = 0;
        if ( $relations )
        foreach($relations as $id_product => $Relationship)
        {
            if ($Relationship===null)
            {
                if ($this->_debug) 
                    printf("$this->_cr  productRelationship() function. Incorrect product. Creation of the Messages skipped  $this->_cr");
                continue ;
            }
            $SKUValue = $Relationship['parent'];
            $ChildrenSKUs = array() ;
            
            foreach($Relationship['children'] as $key => $ChildSKU)
            {
                if ( ! $ChildSKU ) continue ;
                
                $ChildrenSKUs[] = $ChildSKU ;
            }
           
            if ( $ChildrenSKUs )
            {
                $Messages[$m] = $this->createProductRelationshipMessage($Document, $SKUValue, $ChildrenSKUs, $m+1);
                $m++;            
            }
        }

        if ( ! count($Messages) )
        {
            if ($this->_debug)
                printf("$this->_cr productRelationship() no relations $this->_cr");
            return(true);
        }

        $feedDOM = $this->CreateFeed($Document, "Relationship", $Messages);
        
        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();

        $data = $this->processFeed("_POST_PRODUCT_RELATIONSHIP_DATA_", $feed);
        
        if ($this->_debug)
        {
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
            
            if($data === false || $data === null)
                printf("$this->_cr productRelationship() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr productRelationship() function is finished successfully here $this->_cr");
        }
        return $data;
    }
        
    /**
     *Update condition of existing single product
     * @param <type> $cond - object massive
     * $cond[$i]['SKU']
     * $cond[$i]['ConditionType']
     * $cond[$i]['ConditionNote']
     *  @return <int> - SubmissionID or false if unsuccessful
     */
    public function updateCondition($SKU, $ConditionType, $ConditionNote)
    {
        if ($this->_debug) printf("$this->_cr updateCondition() function. starts here $this->_cr");
        $products = array();
        $products[0]['SKU'] = $SKU;
        $products[0]['ConditionType'] = $ConditionType;
        $products[0]['ConditionNote'] = $ConditionNote;
        if ($this->_debug) printf("$this->_cr  function. $this->_cr");

        $data = $this->partiallyUpdateProducts($products);

        if ($this->_debug)
        {
            if($data == false)
                printf("$this->_cr updateCondition() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr updateCondition() function is finished successfully here $this->_cr");
        }
        return $data;
    }




    /**
     *
     * @param <type> $products - object array
     * $products[$i]['SKU'] - must be not null
     * $products[$i]['Quantity'] - must be not null
     * @return <int> - FeedSubmissionID or false (if an error occurred)
     */
    public function updateQuantities($products)
    {
        if ($this->_debug) printf("$this->_cr updateQuantities() call, checking input arguments ...  $this->_cr");

        // Skip "Do not export quantity" products
        //
        for($i = 0 ; $i < count($products) ; $i++)
            if ( isset($products[$i]['NoQtyExport']) && $products[$i]['NoQtyExport'] === true )
            {
                if ($this->_debug)
                    printf("$this->_cr updateQuantities() call, skipping product[$i]: %s (NoQtyExport is sets) $this->_cr", $products[$i]['SKU']);
                unset($products[$i]) ;
            }

        $products = array_values($products) ;

        if ( ! count($products) )
            $products = null ;

        //checking input arguments
        for ($i=0; $i<count($products); $i++)
        {
            if ($this->_debug) printf("$this->_cr updateQuantities() function. \$products[$i] checking...  $this->_cr");
            if ( ! isset($products[$i]['SKU']) || ! $this->checkSKU($products[$i]['SKU']))
            {
                $SKUValue = trim($products[$i]['SKU']) ;
                if ($this->_debug) printf("$this->_cr updateQuantities() function. $this->_att Warning. \$products[$i]['SKU'] = $SKUValue is incorrect. Please verify this... Function skips this product and continue excution. %s  $this->_cr", $this->_caller());
                //return false;

                $products[$i] = null;
                continue;
            }
            if (!isset($products[$i]['Quantity']) || !$this->checkQuantity($products[$i]['Quantity']) /* ||
                    $products[$i]['Quantity']==null*/)
            {
                $QuantityValue = isset($products[$i]['Quantity']) ? $products[$i]['Quantity'] : null ;
                if ($this->_debug) printf("$this->_cr updateQuantities() function. $this->_att Warning. \$products[$i]['Quantity'] = $QuantityValue is incorrect. Please verify this... Function skips this product and continue excution. $this->_cr");
                //return false;
                $products[$i] = null;
                continue;
            }
        }


        //if there is no Quantities to update, function will be terminated
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null) break;
            if ($i == count($products)-1)
            {
                if ($this->_debug) printf("$this->_cr updateQuantities() function. \$products[$i] - We have no Quantities to update (or all the instances are skipped). Function is finished with $this->_att an Error. $this->_cr");
                return false;
            }
        }

        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug) printf("$this->_cr  updateQuantities() function. Creation of the QuantityMessages starts here  $this->_cr");
        $m = 0;
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null)
            {
                $Messages[$m] = $this->createQuantityMessage($Document, $products[$i]['SKU'], $products[$i]['Quantity'], $products[$i], $m+1);
                $m++;
            }
            else
            {
                if ($this->_debug) printf("$this->_cr  updateQuantities() function. \$products[$i] - Incorrect product. Creation of the QuantityMessages skipped  $this->_cr");
            }
        }
        
        if ( ! $m )
        {
            if ($this->_debug) 
                printf("$this->_cr updateQuantities() function. $this->_att No Quantity Messages to Send ... $this->_cr ");
            return(false) ;
        }        
        $feedDOM = $this->CreateFeed($Document, "Product", $Messages);
        
        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();
        $data = $this->processFeed("_POST_INVENTORY_AVAILABILITY_DATA_", $feed);
        if ($this->_debug)
        {
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
            
            if($data === false || $data === null)
                printf("$this->_cr updateQuantities() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr updateQuantities() result is: %s $this->_cr", nl2br(print_r($data, true)));
        }
        return $data;
    }


    public function updateQuantity($SKU, $Quantity)
    {
       if ($this->_debug) printf("$this->_cr updateQuantity() call, creating an object array... $this->_cr");
       $products = array();
       $products[0]['SKU'] = $SKU;
       $products[0]['Quantity'] = $Quantity;
       if ($this->_debug) printf("$this->_cr updateQuantity() function. Calling the updateQuantities() function. Product SKU: %s - Quantity: %d $this->_cr", $SKU, $Quantity);
       $data = $this->updateQuantities($products);
       if ($this->_debug)
            if ($data === false || $data === null)
            if ($this->_debug) printf("$this->_cr updateQuantity() function is finished with $this->_att an error. $this->_cr");
            else if ($this->_debug) printf("$this->_cr updateQuantity() function is finished successfully. $this->_cr");
       return $data;
    }

    public function updatePrices($products)
    {
        if ($this->_debug) printf("$this->_cr updatePrices() call, checking input arguments... $this->_cr");
        //checking input arguments

        $products = array_values($products) ;

        if ( ! count($products) )
            return ;

        for ($i=0; $i<count($products); $i++)
        {
            if ( isset($products[$i]['NoPriceExport']) && $products[$i]['NoPriceExport'] == true )
            {
                if ($this->_debug) printf("$this->_cr updatePrices() function. Skipping Price Update... $this->_cr");
                $products[$i] = null;
                continue ;
            } 
            if ($this->_debug) printf("$this->_cr updatePrices() function. Checking \$products[$i] $this->_cr");
            if ($this->checkSKU($products[$i]['SKU']) == false || ! isset($products[$i]['Price']) ||
                    ($products[$i]['Price'] = $this->checkPrice($products[$i]['Price'])) == false)
            {
                if ($this->_debug)
                {
                    $value1 = $products[$i]['SKU'];
                    $value2 = isset($products[$i]['Price']) ? $products[$i]['Price'] : 0 ;
                    printf("$this->_cr updatePrices() function. $this->_att an Warning occured during the test of the $i-th argument
                        There are values:$this->_cr
                        \$products[\$i]['SKU']: $value1 $this->_cr
                        \$products[\$i]['Price']: $value2 $this->_cr
                        Function skips this item and continue execution %s $this->_cr", $this->_caller());
                }
                //return false;
                $products[$i] = null;
                continue;
            }
        }

        if ($this->_debug) printf("$this->_cr updatePrices() function. Checking input arguments completed $this->_cr");


        //if there is no Prices to update, function will be terminated
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i]!=null) break;
            if ($i == count($products)-1)
            {
                if ($this->_debug) printf("$this->_cr updatePrices() function. We have no Prices to update (or all the instances are skipped). Function is finished with $this->_att an Error. $this->_cr");
                return false;
            }
        }

        $Document = new DOMDocument();
        $Messages = array();
        if ($this->_debug) printf("$this->_cr updatePrices() function. Creating messages here (based on the input arguments) $this->_cr");
        $m = 0;
        for ($i=0; $i<count($products); $i++)
        {
            if ($products[$i] != null)
            {
                if ($this->_debug) printf("$this->_cr updatePrices() function. The $i-th message creation... $this->_cr");
                $Messages[$m] = $this->createPriceMessage ($Document, $products[$i]['SKU'], $products[$i]['Price'], isset($products[$i]['Sales']) ? $products[$i]['Sales'] : null, $m+1);
                
                if ( ! $Messages[$m] )  continue ;
                $m++;
            }
            else
            {
                if ($this->_debug) printf("$this->_cr updatePrices() function. The $i-th message creation skipped $this->_cr");
            }
        }

        if ( ! $m )
        {
            if ($this->_debug) 
                printf("$this->_cr updatePrices() function. $this->_att No Price Messages to Send ... $this->_cr ");
            return(false) ;
        }    
        
        if ($this->_debug) printf("$this->_cr updatePrices() function. Calling the CreateFeed() function ... $this->_cr ");
        $feedDOM = $this->CreateFeed($Document, "Price", $Messages);

        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();

        if ($this->_debug) 
        {
            printf("$this->_cr updatePrices() function. Calling processFeed() function here $this->_cr");

            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
        }
        
        $data = $this->processFeed("_POST_PRODUCT_PRICING_DATA_", $feed);

        if ($this->_debug)
        {
            if ($data === false || $data === null)
                printf("$this->_cr updatePrices() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr updatePrices() function is finished successfully here $this->_cr");
        }

        return $data;
    }

    public function updatePrice($SKU, $Price)
    {
        if ($this->_debug) printf("$this->_cr updatePrice() call. $this->_cr");
        $products = array();
        $products[0]['SKU'] = $SKU;
        $products[0]['Price'] = $Price;
 
        if ($this->_debug) printf("$this->_cr updatePrice() function. updatePrices() function is calling here. SKU: %s Price: %s $this->_cr", $SKU, $Price);
        $data = $this->updatePrices($products);
        if ($this->_debug)
        {
            if ($data === false || $data === null)
                printf("$this->_cr updatePrice() function is finished $this->_att with an error %s $this->_cr", $this->_caller());
            else
                printf("$this->_cr updatePrice() function is finished successfully here $this->_cr");
        }
        return $data;
    }


       /**
     *Delete products from seller account
     * @param <type[]> $products - array of unique products
     * @return <int> - FeedSubmissionId or false if an error occured
     */
    public function deleteProducts($products)
    {
        if ($this->_debug) printf("$this->_cr deleteProducts() call. $this->_cr");
        //check input arguments
        for ($i=0; $i<count($products); $i++)
            if (!$this->checkSKU($products[$i]['SKU']))
            {
                if ($this->_debug) printf("$this->_cr deleteProducts() function. $this->_att Warning. You sent product with incorrect SKU. \$products[$i]['SKU'] . Please verify it. We skip this product $this->_cr");
                //return false;
                $products[$i] = null;
            }

        //existing SKUs
        $eSKUs = array();
        if ($this->_debug)
        {
            $n = count($products);
            printf("$this->_cr deleteProducts() function. You sent $n Products $this->_cr");
        }
        for ($i = 0; $i<count($products); $i++)
            if ($products[$i]['SKU'] != null) $eSKUs[] = $products[$i]['SKU'];

        if ($this->_debug)
        {
            $n = count($eSKUs);
            printf("$this->_cr deleteProducts() function. After skipping remains $n SKUs $this->_cr");
        }
        if (count($eSKUs)==0)
        {
            if ($this->_debug) printf("$this->_cr deleteProducts() function. $this->_att Error. There is no products to delete. Function terminated. $this->_cr");
            return false;
        }
        $SKUs = $eSKUs;

        $xml = new DOMDocument();
        $Messages = array();
        for ($i=0; $i<count($SKUs); $i++)
        {
            if ($this->_debug) printf("$this->_cr deleteProducts() function. Creation of the $i-th message. $this->_cr");
            $Messages[$i] = $this->createDelMessage ($xml, $i+1, $SKUs[$i]);
        }
        ////$message;
        if ($this->_debug) printf("$this->_cr deleteProducts() function. Calling the CreateFeed() function here $this->_cr");
        $feedDOM = $this->CreateFeed($xml, "Product", $Messages);
        
        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();

        if ($this->_debug)
        {
            printf("$this->_cr deleteProducts() function. Start processing feed here $this->_cr");
            
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
        }
        
        $data = $this->processFeed("_POST_PRODUCT_DATA_", $feed);
        
        if ($this->_debug)
        {
            if ($data === false || $data === null)
                printf("$this->_cr deleteProducts() function is finished $this->_att with an error $this->_cr");
            else
                printf("$this->_cr deleteProducts() function is finished successfully here $this->_cr");
        }
        return $data;
    }




    public function deleteProduct($product)
    {
        if ($this->_debug)
        {
            $skuu = $product[$i]['SKU'];
            printf("$this->_cr deleteProduct() call \$product['SKU'] = $skuu .All checks and operations will be performed after creation of the array $this->_cr");
        }
        if ($this->_debug) printf("$this->_cr deleteProduct() function. creates an array... $this->_cr");
        $products = array();
        $products[0] = $product;
        if ($this->_debug) printf("$this->_cr deleteProduct() function. finish to create array. Calling deleteProducts() function... $this->_cr");
        $State = $this->deleteProducts($products);
        if ($State == false)
            if ($this->_debug) printf("$this->_cr deleteProduct() function is finished with $this->_att an error. $this->_cr");
        else
            if ($this->_debug) printf("$this->_cr deleteProduct() function is completed successfully. $this->_cr");
       return $State;
    }

    public function  getOrderById ($amazonOrderId)
    {
        $params = array();
        $params['Action'] = 'GetOrder';
        $params['AmazonOrderId.Id.1'] = $amazonOrderId;
        $params['MarketplaceId.Id.1'] = $this->mpid ;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        // Amazon Europe
        //
        if ( isset($this->MarketPlaces) && count($this->MarketPlaces) )
        {
            $i = 1 ;
            foreach($this->MarketPlaces as $idx => $marketPlace)
            {
                if ( empty($marketPlace) ) continue ;
	        if ( $marketPlace == $this->mpid ) continue ;
                $i++ ;
                $params['MarketplaceId.Id.'.$i] = $marketPlace ;
            }
        }

        $data = $this->_callWSs('Orders', $params);

        if ($data === false || $data === null)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during GetOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            $d = $data->saveXML();
            printf("$this->_cr getOrderById function got following response from the Orders WebService: $this->_cr
             $d $this->_cr");
        }

        $data = $data->GetOrderResult->Orders;

        if ($data->Order[0] === null)
        {
            if ($this->_debug) printf("$this->_cr getOrderById function. $this->_att No orders available (It seems, that you sent incorrect OrderId). Function returns false $this->_cr");
            return false; // no orders available
        }

        $itemsXml = $this->getOrderItemsXml($data->Order[0]->AmazonOrderId);

        if ($itemsXml === false)
        {
            if ($this->_debug) printf ("$this->_cr $this->_att An error happened during items xml request $this->_cr");
            return false;
        }

        if ($this->_debug == true)
        {
            $d = $itemsXml->saveXML();
            printf("$this->_cr getOrderById function(). We get next Item xml from the order: $this->_cr $d $this->_cr");
        }

        $ItemsSimpleXMLElement = $itemsXml->ListOrderItemsResult->OrderItems;

        $Order = new PlacedOrder($data->Order[0], $ItemsSimpleXMLElement, $this->_debug);

        return $Order;
    }
    
    public function  getOrderItems($amazonOrderId)
    {

        $itemsXml = $this->getOrderItemsXml($amazonOrderId);

        if ($itemsXml === false)
        {
            if ($this->_debug) printf ("$this->_cr $this->_att $this->_cr getOrderItems function(). An error happened during items xml request $this->_cr");
            return false;
        }

        if ($this->_debug == true)
        {
            $d = $itemsXml->saveXML();
            printf("$this->_cr getOrderItems function(). We get next Item xml from the order: $this->_cr $d $this->_cr");
        }

        if ( ! isset($itemsXml->ListOrderItemsResult->OrderItems) )
        {
          if ($this->_debug == true)
              printf("$this->_cr getOrderItems function(). Unable to fetch items returned value is: %s$this->_cr $d $this->_cr", nl2br(print_r($itemsXml, true)));
          return(false) ;   
        }
        $ItemsSimpleXMLElement = $itemsXml->ListOrderItemsResult->OrderItems;

        if ($ItemsSimpleXMLElement !== null)
        {
            $Items = array();
            for ($i=0; ; $i++)
            {
            if ($ItemsSimpleXMLElement->OrderItem[$i] !== null)
                $Items[$i] = new OrderedItem($ItemsSimpleXMLElement->OrderItem[$i]);
            else
                break;
            }
        }
        else
            $Items = NULL;
        
        return($Items) ;
    }
    
    public function getOrders ($amazonOrderIds)
    {
        $params = array();
        $params['Action'] = 'GetOrder';
        $params['MarketplaceId.Id.1'] = $this->mpid ;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        // Amazon Europe
        //
        if ( isset($this->MarketPlaces) && count($this->MarketPlaces) )
        {
            $i = 1 ;
            foreach($this->MarketPlaces as $idx => $marketPlace)
            {
                if ( empty($marketPlace) ) continue ;
	        if ( $marketPlace == $this->mpid ) continue ;
                $i++ ;
                $params['MarketplaceId.Id.'.$i] = $marketPlace ;
            }
        }

        $i = 0 ;
        
        if ( is_array($amazonOrderIds) && count($amazonOrderIds) )
        {
            foreach($amazonOrderIds as $idx => $amazonOrderId)
            {
                if ( empty($amazonOrderId) ) continue ;
                $i++ ;
                $params['AmazonOrderId.Id.'.$i] = $amazonOrderId;
                if ( $i >= 50 ) break ;
            }
        }
        
        if ( ! $i )
        {
            if ($this->_debug)
              printf("%s/%s getOrders ERROR $this->_att count is null $this->_cr", basename(__FILE__), __LINE__) ;
            return false;            
        }

        $data = $this->_callWSs('Orders', $params);

        if ($data === false || $data === null)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during GetOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            $d = $data->saveXML();
            printf("$this->_cr getOrders function got following response from the Orders WebService: $this->_cr
             $d $this->_cr");
        }

        if ( isset($data->ListOrdersResult->NextToken) )
          $nextToken = $data->ListOrdersResult->NextToken ;
        else
          $nextToken = null ;

        if ( isset($data->GetOrderResult) )
        {
         $data = $data->GetOrderResult->Orders;
        }

        if ($data === null) 
        {   
            printf("$this->_cr getOrders : No order available $this->_cr");
            return false; // no orders available
        }

         $Orders = Array();
          if ($this->_debug == true) printf("$this->_cr getOrders function(). Start creating orders class instances. $this->_cr");
         for($i=0; ; $i++)
         {
             if ( ! isset($data->Order) )
             {
                if ($this->_debug == true)
                    printf("$this->_cr getOrders - Error or No Pending Order");
                break ;
             }
             if ($data->Order[$i] === null)
             {
                 if ($i == 0) 
                 {
                     printf("$this->_cr getOrders : No order available (2) $this->_cr");
                     return false; // no orders available
                 }
                 break; //orders ended
             }
             if ($this->_debug)
              printf('Order Fetched: %s' . $this->_cr, nl2br(print_r($data->Order[$i], true)));
             
             $Orders[$i] = new PlacedOrder($data->Order[$i], NULL, $this->_debug);
         }
         while ( $nextToken )
            $nextToken = $this->GetOrdersByNextToken($nextToken, $Orders) ;
         
        return $Orders;
    }    

    /*
     * Get result of data submission
     */

    public function getFeedSubmissionResult($SubmissionId)
    {
        if ($this->_debug == true) printf("$this->_cr getFeedSubmissionResult call. $this->_cr");

        $params['Action'] = 'GetFeedSubmissionResult';
        $params['Marketplace'] = $this->mpid;
        $params['Merchant'] = $this->mid;

        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        $params['FeedSubmissionId'] = $SubmissionId;


        $response = $this->_callWSs('Feeds', $params, NULL, $returnXML = true);

        if ( ! $response )
        {
            if ($this->_debug)
                printf("%s/%s getFeedSubmissionResult ERROR $this->_att response is false or null - response is: %s $this->_cr", basename(__FILE__), __LINE__, nl2br(print_r($response,true))) ;

            return(false) ;
        }

        if ( ! is_object($response) )
        {
            if ($this->_debug)
                printf("%s/%s getFeedSubmissionResult ERROR $this->_att response must be an object - response is: %s $this->_cr", basename(__FILE__), __LINE__, nl2br(print_r($response,true))) ;

            return(false) ;
        }

        return($response) ;
    }


    public function  getASIN($code)
    {
        $params = array();
        $params['Action'] = 'ListMatchingProducts';
        $params['MarketplaceId'] = $this->mpid ;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';
        $params['Query'] = $code;

        $ASINs = array() ;
        $data = $this->_callWSs('Products', $params);

        if ($data === false)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during getASIN request $this->_cr");
            return false;
        }

        if ( ! is_object($data) )
        {
            if ($this->_debug) printf("$this->_cr $this->_att getASIN - Unexpected data: %s $this->_cr", nl2br(print_r($data, true)) );
            return false;
        }

        if (  ! isset($data->ListMatchingProductsResult) || ! isset($data->ListMatchingProductsResult->Products) )
        {
            if ($this->_debug) printf("$this->_cr $this->_att getASIN - No Matching Products: %s $this->_cr", nl2br(print_r($data, true)) );
            return false;
        }

        if ( $data->ListMatchingProductsResult->Products )
        {
          foreach($data->ListMatchingProductsResult->Products as $product_list)
          {
              foreach($product_list->Product as $product)
              {
                if ($this->_debug )
                  echo nl2br(print_r($product->asXML(), true)) ;


                  if ( isset($product->Identifiers->MarketplaceASIN) )
                  foreach($product->Identifiers->MarketplaceASIN as $ASIN_Entity)
                  {
                      $ASINs[] = (string)$ASIN_Entity->ASIN ;
                  }
              }
          }
        }
        else
        {
            if ($this->_debug) printf("$this->_cr $this->_att getASIN - No Products: %s $this->_cr", nl2br(print_r($data, true)) );
            return false;
        }

        return $ASINs;
    }

    /*
     * FBA - Get information about a multichannel fulfilled order
     */
    public function ListAllFulfillmentOrders($Date, $maxQueries = 10)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['Version'] = "2010-10-01" ;
        
        $querytime = strtotime($Date) ;
        $now = time() ;
        $last_month = time() - (86400 * 30) ;
    
        if ( $querytime > $now || $querytime < $last_month )
        {
            if ($this->_debug)
                printf('ListAllFulfillmentOrders() function. %sWarning. Wrong Date.%s', $this->_att, $Date, $this->_cr);   
            return(false) ;
        }
   
        $params['QueryStartDateTime'] = gmdate("Y-m-d\TH:i:s\Z", $querytime) ;
  
        $dataset = array() ;
        $index = 0 ;
        $nextToken = 1 ;
        
        for($i = 0 ; $i < $maxQueries && $nextToken ; $i++)
        {
            if ( $index == 0 )
            {
                $params['Action'] = 'ListAllFulfillmentOrders' ;
                $data = $this->_callWSs('FulfillmentOutboundShipment', $params, null, true); 
                $responseItem = 'ListAllFulfillmentOrdersResult' ;
            }
            else
            {
                $params['Action'] = 'ListAllFulfillmentOrdersByNextToken' ;
                $params['NextToken'] = $nextToken ;
                $data = $this->_callWSs('FulfillmentInventory', $params);        
                $responseItem = 'ListAllFulfillmentOrdersByNextTokenResult' ;
            }
            if ($data === false)
            {
                if ($this->_debug) printf("$this->_cr $this->_att An error happened during ListAllFulfillmentOrders request $this->_cr");
                return false;
            }

            if ( isset($data->{$responseItem}->NextToken) && $data->{$responseItem}->NextToken )
                $nextToken = $data->{$responseItem}->NextToken ;
            else
                $nextToken = null ;
            
            if ( ! isset($data->{$responseItem}) )
            {
                if ($this->_debug) printf("ListAllFulfillmentOrders() function failed $this->_att An error happened during request... $this->_cr");
                return false;
            }

            if ($this->_debug)
            {
                if ( $data instanceOf SimpleXMLElement )
                {
                    echo "<pre>" ;
                    echo htmlentities(print_r($data->asXML(), true));
                    echo "</pre>" ;
                }
                else
                    echo nl2br(print_r($data, true));
            }

            if ( ! isset($data->{$responseItem}) )
                return false;

            if ( ! isset($data->{$responseItem}->FulfillmentOrders->member) )
            {
                if ($this->_debug) printf("ListAllFulfillmentOrders()  $this->_att empty inventory... $this->_cr");
                return false;            
            }
            $dataset[$index++] = $data->{$responseItem}->FulfillmentOrders ;
        }
        return($dataset) ;        
    } 
    
    /*
     * FBA - Get information about a multichannel fulfilled order
     */
    public function CancelFulfillmentOrder($orderId)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        $params['Action'] = 'CancelFulfillmentOrder' ;
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['Version'] = "2010-10-01" ;
        $params['SellerFulfillmentOrderId'] = $orderId ;
        
        $data = $this->_callWSs('FulfillmentOutboundShipment', $params, null, true); 
        
        if ($data === false)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during GetFulfillmentOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            if ( $data instanceOf SimpleXMLElement )
            {
                echo "<pre>" ;
                echo htmlentities(print_r($data->asXML(), true));
                echo "</pre>" ;
            }
            else
                echo nl2br(print_r($data, true));
        }
        
        if ( isset($data->Error->Code) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some error in the request answer... $this->_cr");
        }        
        elseif ( ! isset($data->ResponseMetadata->RequestId) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some other error in the request answer... $this->_cr");
            return false;            
        }        
        return( $data ) ;        
    }       
    /*
     * FBA - Get information about a multichannel fulfilled order
     */
    public function GetFulfillmentOrder($orderId)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        $params['Action'] = 'GetFulfillmentOrder' ;
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['Version'] = "2010-10-01" ;
        $params['SellerFulfillmentOrderId'] = $orderId ;
        
        $data = $this->_callWSs('FulfillmentOutboundShipment', $params, null, true); 
        
        if ($data === false)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during GetFulfillmentOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            if ( $data instanceOf SimpleXMLElement )
            {
                echo "<pre>" ;
                echo htmlentities(print_r($data->asXML(), true));
                echo "</pre>" ;
            }
            else
                echo nl2br(print_r($data, true));
        }
        
        if ( isset($data->Error->Code) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some error in the request answer... $this->_cr");
        }
        elseif ( ! isset($data->ResponseMetadata->RequestId) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some other error in the request answer... $this->_cr");
            return false;            
        }        
        return( $data ) ;        
    }    
    /*
     * FBA - Get information about a multichannel fulfilled order
     */
    public function GetPackageTrackingDetails($PackageNumber)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        $params['Action'] = 'GetPackageTrackingDetails' ;
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['Version'] = "2010-10-01" ;
        $params['PackageNumber'] = $PackageNumber ;
        
        $data = $this->_callWSs('FulfillmentOutboundShipment', $params, null, true); 
        
        if ($data === false)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during GetFulfillmentOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            if ( $data instanceOf SimpleXMLElement )
            {
                echo "<pre>" ;
                echo htmlentities(print_r($data->asXML(), true));
                echo "</pre>" ;
            }
            else
                echo nl2br(print_r($data, true));
        }
        
        if ( isset($data->Error->Code) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some error in the request answer... $this->_cr");
        }
        elseif ( ! isset($data->ResponseMetadata->RequestId) )
        {
            if ($this->_debug) printf("GetFulfillmentOrder()  $this->_att some other error in the request answer... $this->_cr");
            return false;            
        }        
        return( $data ) ;        
    }    
    /*
     * FBA - Place and outbound order from Amazon to the final customer
     */
    public function CreateFulfillmentOrder($order)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        $params['Action'] = 'CreateFulfillmentOrder' ;
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['Version'] = "2010-10-01" ;
        
        // Testing all required fields are present
        //
        $pass = true ;
        foreach( array('SellerFulfillmentOrderId', 'DisplayableOrderId', 'DisplayableOrderDateTime', 'DisplayableOrderComment', 'ShippingSpeedCategory', 'DestinationAddress', 'Items') as $field )
            if ( ! isset($order[$field]) || empty($order[$field]) ||  (is_array($order[$field]) && ! count($order[$field])) )  
            {
                $pass = false ;
                if ($this->_debug)
                    printf('CreateFulfillmentOrder() function. %sError. One of the required parameters is missing: %s.%s', $this->_att, $field, $this->_cr);   

            }
        if ( ! $pass )  return(false) ; 

        $params['SellerFulfillmentOrderId']                 = mb_substr($order['SellerFulfillmentOrderId'], 0, 40) ;
        $params['DisplayableOrderId']                       = trim(mb_substr($order['DisplayableOrderId'], 0, 40)) ;
        $params['DisplayableOrderDateTime']                 = $order['DisplayableOrderDateTime'] ;
        $params['DisplayableOrderComment']                  = mb_substr($order['DisplayableOrderComment'], 0, 1000) ;
        $params['ShippingSpeedCategory']                    = $order['ShippingSpeedCategory'] ;
                /* Enum:
                    • Standard
                    • Expedited
                    • Priority
                 */        

        // Emails
        if ( isset($order['NotificationEmailList']) && is_array($order['NotificationEmailList']) && count($order['NotificationEmailList']) )
        {
            $count = 1 ;
            foreach($order['NotificationEmailList'] as $key => $email)
            {
               if ( function_exists('filter_var') && ! filter_var($email, FILTER_VALIDATE_EMAIL) )  continue ;
               
               $params['NotificationEmailList.member.' . $count] = substr($email, 0, 64) ;
               $count++ ;
            }
        }
        
        // Format Address :
        //
        $pass = true ;
        foreach( array('Name', 'Line1', 'City', 'StateOrProvinceCode', 'CountryCode') as $field )
            if ( ! isset($order['DestinationAddress'][$field]) || empty($order['DestinationAddress'][$field]) )  
            {
                $pass = false ;
                if ($this->_debug)
                    printf('CreateFulfillmentOrder() function. %sError. One of the Address required parameters is missing: %s.%s', $this->_att, $field, $this->_cr);   

            }
        if ( ! $pass )  return(false) ;
        
        $params['DestinationAddress.Name']          = mb_substr($order['DestinationAddress']['Name'], 0, 50) ;
        $params['DestinationAddress.Line1']         = mb_substr($order['DestinationAddress']['Line1'], 0, 50) ;
        
        if ( isset($order['DestinationAddress']['Line2']) && ! empty($order['DestinationAddress']['Line2']) )
            $params['DestinationAddress.Line2']         = mb_substr($order['DestinationAddress']['Line2'], 0, 60) ;

        if ( isset($order['DestinationAddress']['Line3']) && ! empty($order['DestinationAddress']['Line3']) )
            $params['DestinationAddress.Line3']         = mb_substr($order['DestinationAddress']['Line3'], 0, 60) ;

        if ( isset($order['DestinationAddress']['DistrictOrCounty']) && ! empty($order['DestinationAddress']['DistrictOrCounty']) )
            $params['DestinationAddress.DistrictOrCounty'] = mb_substr($order['DestinationAddress']['DistrictOrCounty'], 0, 150) ;

        if ( isset($order['DestinationAddress']['City']) && ! empty($order['DestinationAddress']['City']) )
            $params['DestinationAddress.City']         = mb_substr($order['DestinationAddress']['City'], 0, 50) ;        

        if ( isset($order['DestinationAddress']['StateOrProvinceCode']) && ! empty($order['DestinationAddress']['StateOrProvinceCode']) )
            $params['DestinationAddress.StateOrProvinceCode'] = mb_substr($order['DestinationAddress']['StateOrProvinceCode'], 0, 50) ;        

        if ( isset($order['DestinationAddress']['CountryCode']) && ! empty($order['DestinationAddress']['CountryCode']) )
            $params['DestinationAddress.CountryCode'] = strtoupper(mb_substr($order['DestinationAddress']['CountryCode'], 0, 2)) ;
        
        if ( isset($order['DestinationAddress']['PostalCode']) && ! empty($order['DestinationAddress']['PostalCode']) )
            $params['DestinationAddress.PostalCode'] = mb_substr($order['DestinationAddress']['PostalCode'], 0, 20) ;           
        
        if ( isset($order['DestinationAddress']['PhoneNumber']) && ! empty($order['DestinationAddress']['PhoneNumber']) )
            $params['DestinationAddress.PhoneNumber'] = mb_substr($order['DestinationAddress']['PhoneNumber'], 0, 20) ;           

        if ( ! is_array($order['Items']) || ! count($order['Items']) )
        {
            if ($this->_debug)
                printf('CreateFulfillmentOrder() function. %sWarning. Items: empty list - nothing to do.%s', $this->_att, $this->_cr);   
            return(false) ;            
        }

        $itemCount = 0 ;
        foreach($order['Items'] as $Item)
        {
            if (!$this->checkSKU($Item['SKU']))
            {
                printf('CreateFulfillmentOrder() function. Warning. SKU: "%s" invalid value. Skipping the product and continue.%s', $SKU, $this->_cr);
                continue ;
            }  
            
            // Check for required field
            //
            $pass = true ;
            foreach( array('SellerFulfillmentOrderItemId', 'Quantity') as $field )
                if ( ! isset($Item[$field]) || empty($Item[$field]) )  
                {
                    $pass = false ;
                    printf('CreateFulfillmentOrder() function. %sError. One of the Item required parameters is missing: %s.%s', $this->_att, $field, $this->_cr);   

                }
            if ( ! $pass )  continue ;  
            
            $itemCount++ ;
            
            $params['Items.member.' . $itemCount . '.SellerSKU'] = $Item['SKU'] ;
            $params['Items.member.' . $itemCount . '.SellerFulfillmentOrderItemId'] = $Item['SellerFulfillmentOrderItemId'] ;
            $params['Items.member.' . $itemCount . '.Quantity']  = $Item['Quantity'] ;
            
            if ( isset($Item['PerUnitDeclaredValue.Value']) && ! empty($Item['PerUnitDeclaredValue.Value']) )
            {
                $params['Items.member.' . $itemCount . '.PerUnitDeclaredValue.Value'] = $Item['PerUnitDeclaredValue.Value'] ;
                $params['Items.member.' . $itemCount . '.PerUnitDeclaredValue.CurrencyCode'] = $Item['PerUnitDeclaredValue.CurrencyCode'] ;
            }   
            if ( isset($Item['GiftMessage']) && ! empty($Item['GiftMessage']) )
                $params['Items.member.' . $itemCount . '.GiftMessage'] = mb_substr($Item['GiftMessage'], 0, 512) ;
            
            if ( isset($Item['DisplayableComment']) && ! empty($Item['DisplayableComment']) )
                $params['Items.member.' . $itemCount . '.DisplayableComment'] = mb_substr($Item['DisplayableComment'], 0, 250) ;
            
            if ( isset($Item['FulfillmentNetworkSKU']) && ! empty($Item['FulfillmentNetworkSKU']) )
                $params['Items.member.' . $itemCount . '.FulfillmentNetworkSKU'] = $Item['FulfillmentNetworkSKU'] ;
            
            if ( isset($Item['OrderItemDisposition']) && ! empty($Item['OrderItemDisposition']) )
                $params['Items.member.' . $itemCount . '.OrderItemDisposition'] = $Item['OrderItemDisposition'] ;
            
        }
     
        if ( count($order['Items']) != $itemCount )
        {
            printf('CreateFulfillmentOrder() function. %sError. Items Count: Expected item count differ, order aborted.%s', $this->_att, $this->_cr);   
            return(false) ;                        
        } 
        
        $data = $this->_callWSs('FulfillmentOutboundShipment', $params); 
        
        if ($data === false)
        {
            if ($this->_debug) printf("$this->_cr $this->_att An error happened during CreateFulfillmentOrder request $this->_cr");
            return false;
        }

        if ($this->_debug)
        {
            if ( $data instanceOf SimpleXMLElement )
            {
                echo "<pre>" ;
                echo htmlentities(print_r($data->asXML(), true));
                echo "</pre>" ;
            }
            else
                echo nl2br(print_r($data, true));
        }
 
        if ( ! isset($data->ResponseMetadata->RequestId) )
        {
            if ($this->_debug) printf("CreateFulfillmentOrder()  $this->_att some error in the request answer... $this->_cr");
            return false;            
        }

        return( (string)$data->ResponseMetadata->RequestId ) ;
    }    
    
    /*
     * FBA Internal Function used to retrieve inventory
     */
    private function _ListInventorySupply($params, $maxQueries = 10)
    {
        $params['SellerId'] = $this->mid ;
        $params['SignatureVersion'] = '2' ;
        $params['SignatureMethod'] = 'HmacSHA256' ;
        $params['ResponseGroup'] = 'Basic' ;
        $params["Version"] = "2011-03-01" ;
        
        $dataset = array() ;
        $index = 0 ;
        $nextToken = 1 ;
        
        for($i = 0 ; $i < $maxQueries && $nextToken ; $i++)
        {
            if ( $index == 0 )
            {
                $params['Action'] = 'ListInventorySupply' ;
                $data = $this->_callWSs('FulfillmentInventory', $params);        
                $responseItem = 'ListInventorySupplyResult' ;
            }
            else
            {
                $params['Action'] = 'ListInventorySupplyByNextToken' ;
                $params['NextToken'] = $nextToken ;
                $data = $this->_callWSs('FulfillmentInventory', $params);        
                $responseItem = 'ListInventorySupplyByNextTokenResult' ;
            }
            if ($data === false)
            {
                if ($this->_debug) printf("$this->_cr $this->_att An error happened during ListInventorySupply request $this->_cr");
                return false;
            }

            if ( isset($data->{$responseItem}->NextToken) && $data->{$responseItem}->NextToken )
                $nextToken = $data->{$responseItem}->NextToken ;
            else
                $nextToken = null ;
            
            if ( ! isset($data->{$responseItem}) )
            {
                if ($this->_debug) printf("ListInventorySupply() function failed $this->_att An error happened during request... $this->_cr");
                return false;
            }

            if ($this->_debug)
            {
                if ( $data instanceOf SimpleXMLElement )
                {
                    echo "<pre>" ;
                    echo htmlentities(print_r($data->asXML(), true));
                    echo "</pre>" ;
                }
                else
                    echo nl2br(print_r($data, true));
            }

            if ( ! isset($data->{$responseItem}) )
                return false;

            if ( ! isset($data->{$responseItem}->InventorySupplyList->member) )
            {
                if ($this->_debug) printf("ListInventorySupply()  $this->_att empty inventory... $this->_cr");
                return false;            
            }
            $dataset[$index++] = $data->{$responseItem}->InventorySupplyList->member ;
        }
        return($dataset) ;
    }
    
    /*
     * Retrieve a FBA inventory for a list of SKUs
     */
    public function  ListInventoryBySKU($SKUs)
    {
        $data = null ;
        $params = array() ;
        
        if ( ! is_array($SKUs) || ! count($SKUs) )
        {
            if ($this->_debug)
                printf('ListInventorySKU() function. %sWarning. SKU: empty list - nothing to do.%s', $this->_att, $this->_cr);   
            return(false) ;
        }
        
        $count = 1 ;
        
        foreach($SKUs as $SKU)
        {
            if (!$this->checkSKU($SKU))
            {
                if ($this->_debug)
                    printf('ListInventorySKU() function. Warning. SKU: "%s" invalid value. Skipping the product and continue.%s', $SKU, $this->_cr);
                continue ;
            }   
            
            $params['SellerSkus.member.' . $count] = (string)$SKU ;
            $count++ ;
            
            if ( $count > 50 )
            {
                if ($this->_debug)
                    printf('ListInventorySKU() function. Warning. This function is restricted to 50 items.%s', $this->_cr);
                break ;
            }
        }

        if ( ! ($datasets = $this->_ListInventorySupply($params)) )
        {
            if ($this->_debug)
                printf('ListInventorySKU() function. _ListInventorySupply failed.%s', $this->_cr);
            
        }
        if ($this->_debug)
            printf('ListInventoryByDate() function. _ListInventorySupply returned %d dataset.%s', count($datasets), $this->_cr);
        
        $result = array() ;
        foreach($datasets as $dataset)
        {
            foreach($dataset as $inventoryItem)
            {
                $result[(string)$inventoryItem->SellerSKU] = array() ;
                $result[(string)$inventoryItem->SellerSKU]['SKU'] = (string)$inventoryItem->SellerSKU ;
                $result[(string)$inventoryItem->SellerSKU]['InStockSupplyQuantity'] = (int)$inventoryItem->InStockSupplyQuantity ;
                $result[(string)$inventoryItem->SellerSKU]['TotalSupplyQuantity'] = (int)$inventoryItem->TotalSupplyQuantity ;
            }
        }
        return($result);
    }

    /*
     * Retrieve a FBA stock move for a date range
     */
    public function  ListInventoryByDate($Date)
    {
        $data = null ;
        $params = array() ;
        
        $querytime = strtotime($Date) ;
        $now = time() ;
        $last_month = time() - (86400 * 30) ;
        
        if ( $querytime > $now || $querytime < $last_month )
        {
            if ($this->_debug)
                printf('ListInventoryByDate() function. %sWarning. Wrong Date.%s', $this->_att, $Date, $this->_cr);   
            return(false) ;
        }
       
        $params['QueryStartDateTime'] = gmdate("Y-m-d\T00:00:00\Z", $querytime) ;

        if ( ! ($datasets = $this->_ListInventorySupply($params)) )
        {
            if ($this->_debug)
                printf('ListInventoryByDate() function. _ListInventorySupply failed.%s', $this->_cr);
            
        }
        if ($this->_debug)
            printf('ListInventoryByDate() function. _ListInventorySupply returned %d dataset.%s', count($datasets), $this->_cr);
        
        $result = array() ;
        if ( is_array($datasets) )
        {
            foreach($datasets as $dataset)
            {
                foreach($dataset as $inventoryItem)
                {
                    $result[(string)$inventoryItem->SellerSKU] = array() ;
                    $result[(string)$inventoryItem->SellerSKU]['SKU'] = (string)$inventoryItem->SellerSKU ;
                    $result[(string)$inventoryItem->SellerSKU]['InStockSupplyQuantity'] = (int)$inventoryItem->InStockSupplyQuantity ;
                    $result[(string)$inventoryItem->SellerSKU]['TotalSupplyQuantity'] = (int)$inventoryItem->TotalSupplyQuantity ;
                }
            }
        }
        return($result);
    }
    
    // Anti Throttling 
    // http://www.amazonsellersupportblog.com/2011/01/understanding-throttling-in-amazon-mws.html
    // Anti Throttling Code Parts : http://stackoverflow.com/questions/1375501/how-do-i-throttle-my-sites-api-users
    //
    public function _antithrottling($maxQuota = 10, $restoreTime = 5, $action = 'SubmitFeed')
    {
        $timeRange = 1;
        if ($this->_debug):
            echo "*****************************************************<br/>";
            echo "*********************ANTI THROTTLING**********************<br/>";
            echo "*****************************************************<br/>";
        endif;
        // Database Timer Handling
        // 
        if ( $this->timerReadHandler ):
            $values = $this->_timerReadHandler() ;

            if ( $values ):
                $values = unserialize(base64_decode($values)) ;
            else: 
                $values = null ;            
            endif;

            if ( ! is_array($values) ):
                $this->last_request = array('last_api_request' => 0) ;
                $this->minute_throttle = array('minute_throttle' => 0) ;            
            else:
                $this->last_request = $values['last_api_request'] ;
                $this->minute_throttle = $values['minute_throttle'] ;
            endif;
        endif;    

        if ( ! isset($this->last_request[$action]) ):
            $this->last_request[$action] = 0 ;
        endif;
        
        if ( ! isset($this->minute_throttle[$action]) ):
            $this->minute_throttle[$action] = 0 ;
        endif;

        $lastDiff = time() - $this->last_request[$action]; # in seconds
        
        if ( is_null( $maxQuota ) ) :
            $usedQuota = 0;
        else:
            $usedQuota = $this->minute_throttle[$action] - $lastDiff ;
            
            if($usedQuota < 0):
                $usedQuota = 0;
            endif;
            
            $usedQuota += 1 / $maxQuota ;
            $availableQuota = floor( ( $timeRange - $usedQuota ) * $maxQuota  );
                        
            if($availableQuota < 0):
                $availableQuota = 0;
            endif;
        endif;
        
        if ( $this->_debug ):
            echo "Available Quota=$availableQuota, and used quota=$usedQuota \n<br />" ;
        endif;
        
        if ( $usedQuota > $timeRange ) :
            
            //$wait = ($restoreTime * $maxRequests) ;
            $wait = $restoreTime ;
            if ( $this->timerAction == self::DROP_THROTLLED_QUERIES ):
                print( 'Max Quota of ' . $maxQuota.
                       ' requests has been exceeded. Please wait ' . $wait . ' seconds before attempting again.' . "\n<br />") ;
                if ($this->_debug):
                    echo "*****************************************************<br/>";
                    return(false) ;
                endif;
            else:
                if ($this->_debug):
                    print("Throttling control : sleeping $wait seconds\n") ;
                endif;
                sleep($wait) ;
                return(true) ;
            endif;
        endif;
        
        $this->last_request[$action] = time() ;
        $this->minute_throttle[$action] = $usedQuota ;
        
        if ( $this->timerReadHandler ):
            $values = array(
                'last_api_request' => $this->last_request,
                'minute_throttle' => $this->minute_throttle
            ) ;

            $this->_timerWriteHandler(base64_encode(serialize($values))) ;
        endif;
        return(true) ;
    }
    
    function _callWSs($WSTR, $params, $feedContent = NULL, $returnXML = false)
    {
        if ($this->_debug) printf ("$this->_cr _callWSs() fonction starts here $this->_cr");
        $contentMD5 = NULL;
        $handle = NULL;

        if (!($feedContent === NULL))
        {
            if ($this->_debug) printf ("$this->_cr We have feed content. It seems, that this operation is to submit feed. Calculating MD5 for this feed... $this->_cr");
            $contentMD5 = $ContentMd5 = base64_encode(md5($feedContent, true));
            if ($this->_debug) printf ("$this->_cr Now we start to work we handle to upload data to the server $this->_cr");
            $handle = @fopen('php://temp', 'rw+');
            fwrite($handle, $feedContent);
            rewind ($handle);
        }

        $method = "POST";

        $host = $this->_endPointURL() ;
        $uri = NULL;


        switch ( $params['Action'] )
        {
          case 'GetMatchingProduct' : 
            $ret = $this->_antithrottling(20, 10, 'GetMatchingProducts') ;
            break ;            
            
          case 'ListMatchingProducts' :
            $ret = $this->_antithrottling(20, 5, 'ListMatchingProducts') ;
            break ;

          case 'GetCompetitivePricingForSKU' :
          case 'GetCompetitivePricingForASIN' :
          case 'GetLowestOfferListingsForSKU' :
          case 'GetLowestOfferListingsForASIN' :
            $ret = $this->_antithrottling(20, 2, $params['Action']) ;
            break ;
            
          case 'ListOrders ' :
          case 'ListOrdersByNextToken' :
            $ret = $this->_antithrottling(6, 60, $params['Action']) ;
            break ;

          case 'GetOrder' :
            $ret = $this->_antithrottling(6, 60, 'GetOrder') ;
            break ;

          case 'ListOrderItems' :
          case 'ListOrderItemsByNextToken ' :
            $ret = $this->_antithrottling(30, 2, $params['Action']) ;
            break ;

          case 'SubmitFeed' :
            $ret = $this->_antithrottling(15, 120, 'SubmitFeed') ;
            break ;
            
          case 'ListInventorySupply' :
          case 'ListInventorySupplyByNextToken' :
            $ret = $this->_antithrottling(30, 2, 'ListInventorySupply') ;
            break ;  

          case 'CreateFulfillmentOrder' :
            $ret = $this->_antithrottling(30, 2, 'CreateFulfillmentOrder') ;
            break ;             

          default:
            if ($this->_debug)
                printf("$this->_cr. Unknown action for antithrottling: %s $this->_cr", $params['Action']);

            $ret = $this->_antithrottling(10, 5, $params['Action']) ;
            break ;

        }
        if ( ! $ret )
        {
            printf("------------------------------------------------------ $this->_cr") ;
            printf("Amazon API: %s/s%s _callWSs called from %s $this->_cr", basename(__FILE__), __LINE__, $this->_caller()) ;
            printf('Throttling Limits: the query was dropped' . $this->_cr) ;
            printf('Please refer this message to your system administrator' . $this->_cr) ;
            printf("------------------------------------------------------ $this->_cr") ;
            return(false) ;
        }

        // additional parameters
        $params["AWSAccessKeyId"] = $this->awsak;

        // GMT timestamp
        $params["Timestamp"] = gmdate("Y-m-d\TH:i:s\Z");
        
        $header = NULL;
        
        switch($WSTR)
        {
            case 'Feeds' :
                $header = array (
                'Expect: ',
                'Accept: ',
                'Transfer-Encoding: chunked',
                'Content-Type: application/x-www-form-urlencoded; charset=utf-8',
                'Content-MD5: ' . $contentMD5 
                );                
            case 'Reports' :
            case 'ReportsDownload' :
                $params["Version"] = '2009-01-01';
                $uri = '/';
                break ;
            case 'Orders' :
                $params["Version"] = '2011-01-01';
                $uri = '/Orders/';
                break ;
            case 'Products' :
                $params["Version"] = '2011-10-01' ;
                $uri = '/Products/';
                break ;
            case 'FulfillmentInventory' :
                $params["Version"] = '2010-10-01' ;
                $uri = '/FulfillmentInventory/';
                break ;
            case 'FulfillmentOutboundShipment' :
                $params["Version"] = '2010-10-01' ;
                $uri = '/FulfillmentOutboundShipment/';
                break ;
            default :    
                if ($this->_debug) 
                    printf("ERROR! Wrong Service" . $this->_cr);
                return(false) ;
        }

        if ( ! isset($params['SignatureVersion']) )
            $params['SignatureVersion'] = '2';

        if ( ! isset($params['SignatureMethod']) )        
            $params['SignatureMethod'] = 'HmacSHA256';        

        if ( ! isset($params['SellerId']) )        
            $params['SellerId'] = $this->mid;     
        
        // sort the parameters
        ksort($params);

        // create the canonicalized query
        $canonicalized_query = array();

        foreach ($params as $param=>$value)
        {
            $param = str_replace("%7E", "~", rawurlencode($param));
            $value = str_replace("%7E", "~", rawurlencode($value));
            $canonicalized_query[] = $param."=".$value;
        }

        $canonicalized_query = implode("&", $canonicalized_query);

        // create the string to sign
        $string_to_sign = $method."\n".$host."\n".$uri."\n".$canonicalized_query;


        // calculate HMAC with SHA256 and base64-encoding
        $signature = base64_encode(hash_hmac("sha256", $string_to_sign, $this->sk, True));

        // encode the signature for the request
        $signature = str_replace("%7E", "~", rawurlencode($signature));

        $curlOptions = array (
            CURLOPT_POST => true,
            CURLOPT_USERAGENT => 'Common-Services/Amazon Marketplace/' . AMAZON_MARKETPLACE_VERSION . ' (Language=PHP/' . phpversion() . ')',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CONNECTTIMEOUT => 20,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_DNS_USE_GLOBAL_CACHE => false,
            CURLOPT_DNS_CACHE_TIMEOUT => 5,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2
            );


        if ($WSTR === 'Feeds')
        {
            $curlOptions[CURLOPT_HTTPHEADER] = $header;

            if ( $handle )
                $curlOptions[CURLOPT_INFILE] = $handle;
            else
                $curlOptions[CURLOPT_POSTFIELDS] = '' ;  // 2014-06-24 http://www.milk-hub.net/blog/2008/08/26/curl_error_26
            
            $curlOptions[CURLOPT_URL] = "https://".$host.$uri."?".$canonicalized_query."&Signature=".$signature;
        }
        else
        {
            $curlOptions[CURLOPT_URL] = "https://".$host.$uri;
            $curlOptions[CURLOPT_POSTFIELDS] = $canonicalized_query."&Signature=".$signature;

            if($WSTR === 'ReportsDownload')
            {
            	$this->responseBodyContents = @fopen('php://memory', 'rw+');
            	$this->headerContents = @fopen('php://memory', 'rw+');
    			$this->errorResponseBody = @fopen('php://memory', 'rw+');

            	$curlOptions[CURLOPT_WRITEFUNCTION] = array($this,'responseCallback');
              	$curlOptions[CURLOPT_HEADERFUNCTION] = array ($this, 'headerCallback');
            }
        }
        
        if ($this->_debug)
        {
            echo("$this->_cr Request is: ".$curlOptions[CURLOPT_URL]."$this->_cr");
        }
        $curlOptions[CURLOPT_SSL_VERIFYPEER] = false;

        if ($this->_debug)
            $curlOptions[CURLOPT_VERBOSE] = true;

        $this->curlHandle = curl_init();

        curl_setopt_array($this->curlHandle, $curlOptions);

        if ( $this->displayXML )
        {
            $XML = new DOMDocument() ;
            $XML->loadXML($feedContent) ;
            $XML->formatOutput = true ;
            
            echo '<b class="amazon-url">' . $curlOptions[CURLOPT_URL] . '</b>' ;
            echo '<pre class="amazon-xml">' . htmlentities($XML->saveXML()) . '</pre>' ;
        }        
                
        if ( $this->MWS_Action == self::MWS_SEND )
                $result = curl_exec($this->curlHandle);
        else    $result = true ;
        
        if ($this->_debug)
        {
            printf("%s/s%s _callWSs $this->_cr", basename(__FILE__), __LINE__) ;
            echo $this->_caller() ;
            echo "Params: $this->_cr" ;
            echo nl2br(print_r($params, true)) ;
            echo "CURL Data: $this->_cr" ;
            echo nl2br(print_r($result, true)) ;
            echo $this->_cr ;
            echo nl2br(print_r(curl_getinfo($this->curlHandle), true));  // get error info
            echo "cURL error number:" .curl_errno($this->curlHandle) . $this->_cr   ; // print error info
            echo "cURL error:" . curl_error($this->curlHandle) . $this->_cr   ;
        }

        if ($WSTR === 'Feeds' && $handle )
            fclose($handle);
        if($WSTR === 'ReportsDownload')
        {
        	rewind($this->headerContents);
    		$header = stream_get_contents($this->headerContents);
    		$parsedHeader = $this->parseHttpHeader($header);

    		rewind($this->responseBodyContents);
    		$content = stream_get_contents($this->responseBodyContents);

        	 @fclose($this->headerContents);
    		 @fclose($this->errorResponseBody);

	         if ($this->_debug)
	         {
	             printf ("$this->_cr Request completed successfully. Function returns Text element. Response is $this->_cr
	                   $content $this->_cr");
	         }

    		 return $content;
        }

        curl_close($this->curlHandle);

        if ( $this->MWS_Action == self::MWS_DO_NOT_SEND )   return(true) ;
        
        if ($result === false)
        {
            if ($this->_debug)
            {
                printf("%s/%s _callWSs ERROR $this->_att $this->_cr", basename(__FILE__), __LINE__) ;
                echo $this->_caller() ;
                echo "Params: $this->_cr" ;
                echo nl2br(print_r($params, true)) ;
                echo "CURL Data: $this->_cr" ;
                echo nl2br(print_r($result, true)) ;
                echo $this->_cr ;
                echo nl2br(print_r(curl_getinfo($this->curlHandle), true));  // get error info
                echo "cURL error number:" .curl_errno($this->curlHandle) . $this->_cr   ; // print error info
                echo "cURL error:" . curl_error($this->curlHandle) . $this->_cr   ;
            }
            return false;
        }

        // No XML data
        // 
        if ( $result && $params['Action'] == 'GetReport' )
        {
          if ($this->_debug) printf("Data is not XML");   
          return($result) ;       
        }

        try
        {
            $pxml = new SimpleXMLElement($result);
        } catch (Exception $e) {
	   		echo("Exception Caught: " . $e->getMessage() . "\n");
            return false;
        }

        if ($pxml === false)
        {
            if ($this->_debug) printf("ERROR! no xml (\$pxml === false)");
            return false; // no xml
        }

        if ( $returnXML )
        {
          return($pxml) ;
        }

        if ($pxml->getName() === 'ErrorResponse')
        {
            if ($this->_debug)
            {
                $r = $pxml->saveXML();
                printf("$this->_cr WebService returns error response. Function _callWSs() returns false. We have got following error response: $this->_cr
                   $r $this->_cr");
            }
            self::DisplayXMLError($pxml, $curlOptions[CURLOPT_URL]) ;
            return false;
        }

        if ($this->_debug)
        {
            $r = $pxml->saveXML();
            print("$this->_cr Request completed successfully. Function returns simpleXml element. Response is $this->_cr $r $this->_cr");
        }

        return $pxml;
    }

    static public function DisplayXMLError($xmle, $query = false)
    {
        if ( isset($xmle->Error) )
        {
            echo '<div style="border:1px solid red;margin:10px;padding:10px;">' ; 
            
            printf('<h1 style="color:red">Error</h1>') ;
            
            if ( $query )
                echo "Query: " . $query . "<br /><br />\n" ;
            foreach($xmle->Error->children() as $key => $val)
            {
                switch($key)
                {
                    case 'Type' : $color = 'navy' ; break ;
                    case 'Code' : $color = 'brown' ; break ;
                    case 'Message' : $color = 'red' ; break ;
                    default: $color = 'black' ; break ;
                }
                printf('<span>%s:</span>&nbsp;<span style="font-weight:bold;color:%s;">%s</span><br /><br />', $key, $color, $val) ;
            }
            
            if ( isset($xmle->RequestID) )
                printf('<span>Request ID: %s</span><br />', $xmle->RequestID) ;
           
            echo '</div>' ;
        }
        else
        {
            if ( $query )
                echo "Query: " . $query . "<br /><br />\n" ;
            
          echo nl2br(print_r($xmle->Error,true));  
        }
    }

     /**
     * Get all currently unshipped orders, that were placed by customer before specified date
     * @param <string> $createdAfterDate - Date in format "yyy-mm-dd" (including this date)
     * @param <string> $createdBeforeDate - [optional] Date in format "yyy-mm-dd" (excluding this date)
     * @return PlacedOrder[] Massive of instances of the PlecedOrder class,
     *                         that represents all unshipped orders
     */
    //Status can be All, Unshipped, Shipped, Canceled, PartiallyShipped, Pending (Order placed, but payment not authorized, not ready for shipment)
    //Unshipped orders include also PartiallyShipped Orders, because this two statuses must be used together in Orders API
    public function GetUnshippedOrdersList($createdAfterDate, $createdBeforeDate = null, $Status = 'All', $FBA = false, $returnXML = false)
    {
        if ($this->_debug == true) printf("$this->_cr GetUnshippedOrdersList call. $this->_cr");

        $params = array();
        $params['Action'] = 'ListOrders';
        $params['CreatedAfter'] = $createdAfterDate;
        if ($createdBeforeDate != null)
            $params['CreatedBefore'] = $createdBeforeDate;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';
        $params['MarketplaceId.Id.1'] = $this->mpid;

        // Amazon Europe
        //
        if ( isset($this->MarketPlaces) && count($this->MarketPlaces) )
        {
          $i = 1 ;
          foreach($this->MarketPlaces as $idx => $marketPlace)
          {
              if ( empty($marketPlace) ) continue ;
	      if ( $marketPlace == $this->mpid ) continue ;
              $i++ ;
              $params['MarketplaceId.Id.'.$i] = $marketPlace ;
          }
        }

        if ( $FBA )
        {
            $params['OrderStatus.Status.1'] = "Unshipped";
            $params['OrderStatus.Status.2'] = "PartiallyShipped";            
            $params['OrderStatus.Status.3'] = "Shipped";            
        }
        elseif ($Status == 'Unshipped' || $Status == 'PartiallyShipped')
        {
            $params['OrderStatus.Status.1'] = "Unshipped";
            $params['OrderStatus.Status.2'] = "PartiallyShipped";
        }
        else
        {
            if ($Status != 'All')
            {
                $params['OrderStatus.Status.1'] = $Status;
            }
        }

        $params['MaxResultsPerPage'] = 50 ;
        
        if ($this->_debug == true) printf("$this->_cr GetUnshippedOrdersList function. Start request $this->_cr");

        $data = $this->_callWSs('Orders', $params, null, $returnXML);

        if ($this->_debug)
        {
            if ( is_object($data) )
                echo nl2br(print_r($data->asXML(), true));
            else
                echo nl2br(print_r($data, true));
        }

        if ( isset($data->Error) && $returnXML )
            return($data) ;

        if ( isset($data->ListOrdersResult->NextToken) )
          $nextToken = $data->ListOrdersResult->NextToken ;
        else
          $nextToken = null ;

        if ( isset($data->ListOrdersResult) )
        {
         $data = $data->ListOrdersResult->Orders;
        }

         if ($data === null) return false; // no orders available

         $Orders = Array();
          if ($this->_debug == true) printf("$this->_cr GetUnshippedOrdersList function(). Start creating orders class instances. $this->_cr");
         for($i=0; ; $i++)
         {
             if ( ! isset($data->Order) )
             {
                if ($this->_debug == true)
                    printf("$this->_cr GetUnshippedOrdersList - Error or No Pending Order");
                break ;
             }
             if ($data->Order[$i] === null)
             {
                 if ($i == 0) return false; // no orders available
                 break; //orders ended
             }

             $Orders[$i] = new PlacedOrder($data->Order[$i], NULL, $this->_debug);
         }
         while ( $nextToken )
            $nextToken = $this->GetOrdersByNextToken($nextToken, $Orders) ;

         return $Orders;
    }

    public function GetOrdersByNextToken($token, &$Orders)
    {
        if ($this->_debug == true) printf("$this->_cr GetOrdersByNextToken call. $this->_cr");

        $params = array();
        $params['Action'] = 'ListOrdersByNextToken';
        $params['NextToken'] = $token;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';
        $params['MarketplaceId.Id.1'] = $this->mpid;

        if ($this->_debug == true) printf("$this->_cr GetOrdersByNextToken function. Start request - Token: %s $this->_cr", $token);

        $data = $this->_callWSs('Orders', $params);

        if ($this->_debug)
        {
            $d = $data->asXML() ;
            printf( "$this->_cr $d <$this->_cr");
        }

        if ( isset($data->ListOrdersByNextTokenResult->NextToken) )
          $nextToken = $data->ListOrdersByNextTokenResult->NextToken ;
        else
          $nextToken = null ;

        if ( isset($data->ListOrdersByNextTokenResult) )
        {
         $data = $data->ListOrdersByNextTokenResult->Orders;
        }

        if ($data === null) return false; // no orders available

         if ($this->_debug == true) printf("$this->_cr GetOrdersByNextToken function(). Start creating orders class instances. $this->_cr");

         for($i=sizeof($Orders), $j=0; ; $i++,$j++)
         {
             if (! isset($data->Order) || $data->Order[$j] === null)
             {
                 if ($j == 0) return false; // no orders available
                 break; //orders ended
             }

             $Orders[$i] = new PlacedOrder($data->Order[$j], NULL, $this->_debug);
         }
         return($nextToken) ;
    }

    /**
     *
     * !!!!Please Note, that this operation have to send time information to the WebService
     * !!!!Time represents moment, when order were shipped
     * !!!!This functions send time, that are on one and a half hour before current system date
     * !!!!If system time is incorrect and function sends date from the future,
     * !!!!Error will be occured and operation will be not completed correctly.
     *
     * @param <type> $Orders
     * @return <int> SumbissionId or false if unsuccessful
     */
    public function confirmOrderBase ($amazonOrderId)
    {
        return $this->confirmOrder($amazonOrderId, NULL, NULL, NULL);
    }

    public function confirmOrder ($amazonOrderId, $carrierCode, $carrierName, $shippingMethod, $shipperTrackingNumber)
    {

        if ($this->_debug == true) printf("$this->_cr confirmOrder call. $this->_cr");
        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug == true) printf("$this->_cr confirmOrder function. Create messages here $this->_cr");

        $Messages[0] = $this->createOrderFulfillmentMessage($Document, $amazonOrderId, $carrierCode, $carrierName, $shippingMethod, $shipperTrackingNumber, 1);

        $feedDOM = $this->CreateFeed($Document, "OrderFulfillment", $Messages);
        
        if ( $this->_debug )
            $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();

        if ($this->_debug == true) 
        {
            printf("$this->_cr confirmOrder function. Now we send following query to WebService:  $this->_cr $feed $this->_cr");
            
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
        }

        $data =  $this->processFeed("_POST_ORDER_FULFILLMENT_DATA_", $feed);
      
        if ($data === false && $this->_debug == true)
        {
            printf("$this->_cr confirmShipmentOrders function finished with an error because of the prblem with query sending.. $this->_cr");
        }
        else
        {
            if ($this->_debug == true) printf("$this->_cr confirmShipmentOrders function finished successfuly $this->_cr");
        }
        return $data;

    }

    public function confirmMultipleOrders($amazonOrderIds, $carrierCodes, $carrierNames, $shipperTrackingNumbers)
    {

        if ($this->_debug == true) printf("$this->_cr confirmMultipleOrders call. $this->_cr");
        $Document = new DOMDocument();
        $Messages = array();

        if ($this->_debug == true) printf("$this->_cr confirmMultipleOrders function. Create messages here $this->_cr");

        $m = 0 ;
        foreach($amazonOrderIds as $amazonOrderId)
        {
            $Messages[$m] = $this->createOrderFulfillmentMessage($Document, $amazonOrderId, $carrierCodes[$m], $carrierNames[$m], null, $shipperTrackingNumbers[$m], $m+1);
            $m++;
        }

        if ( ! $m )
        {
            if ($this->_debug == true) printf("$this->_cr confirmMultipleOrders function. No Message to Send, returning to main function $this->_cr");
            return ;
        }
        $feedDOM = $this->CreateFeed($Document, "OrderFulfillment", $Messages);
        
        if ( $this->_debug )
           $feedDOM->formatOutput = true ;
        
        $feed = $feedDOM->saveXML();
        
        if ( $this->_debug )
        {
            echo nl2br(str_replace(' ', '&nbsp;', htmlentities($feed))) ;
            
            printf('Complete Feed is: %s' . $this->_cr, $feed) ;
        }

        if ($this->_debug == true) printf("$this->_cr confirmMultipleOrders function. Now we send following query to WebService:  $this->_cr $feed $this->_cr");

        $data =  $this->processFeed("_POST_ORDER_FULFILLMENT_DATA_", $feed);
      
        if ($data === false && $this->_debug == true)
        {
            printf("$this->_cr confirmMultipleOrders function finished with an error because of the prblem with query sending.. $this->_cr");
        }
        else
        {
            if ($this->_debug == true) printf("$this->_cr confirmMultipleOrders function finished successfuly $this->_cr");
        }
        return $data;
    }

    
    //use this function for one order cancelation
    public function cancelOrder($Order)
    {
        $Orders = array();
        $Orders[0] = $Order;
        return $this->cancelOrders($Orders);
    }

    public function cancelOrderByID ($OrderID)
    {
        $OrderIDs = array();
        $OrderIDs[0] = $OrderID;
        return $this->cancelOrdersByIDs($OrderIDs);
    }


    /**
     *Orders Cancelation
     * @param <type> $OrderIDs
     * @return <type> - Feed Submission ID
     */
    public function cancelOrdersByIDs($OrderIDs)
    {
        if ($this->_debug == true) printf("$this->_cr cancelOrders() call. Creating Messages. $this->_cr");
        $Document = new DOMDocument();
        for ($i=0; $i<count($OrderIDs); $i++)
        {
            if ($this->_debug == true)
            {
                $m = $i+1;
                printf("$this->_cr cancelOrders() call. Creating Message $m for OrderID $OrderIDs[$i]. $this->_cr");
            }
            $mess = $this->createOrderAcknowledgementMessage($Document, $OrderIDs[$i], $i+1);
        }

        $Messages = array();
        $Messages[0] = $mess;
        $feedDOM = $this->CreateFeed($Document, "OrderAcknowledgement", $Messages);
        $feed = $feedDOM->saveXML();

         if ($this->_debug == true) printf("$this->_cr cancelOrders() function. Now function creates the following feed: $this->_cr $feed $this->_cr");

        $data =  $this->processFeed("_POST_ORDER_ACKNOWLEDGEMENT_DATA_", $feed);

        if ($data == false && $this->_debug == true)
        {
            printf("$this->_cr cancelOrders() function finished with an error because of the prblem with query sending.. $this->_cr");
        }
        else
        {
            if ($this->_debug == true) printf("$this->_cr cancelOrders() function finished successfuly $this->_cr");
        }
        return $data;
    }

    public function cancelOrders($Orders)
    {
        if ($this->_debug == true) printf("$this->_cr cancelOrders() call. Creating Messages. $this->_cr");
        $Document = new DOMDocument();
        for ($i=0; $i<count($Orders); $i++)
        {
            if ($this->_debug == true)
            {
                $m = $i+1;
                $oid = $Orders[$i]->AmazonOrderId;
                printf("$this->_cr cancelOrders() call. Creating Message $m for OrderID $oid. $this->_cr");
            }
            $mess = $this->createOrderAcknowledgementMessage($Document, $Orders[$i]->AmazonOrderId, $i+1);
        }

        $Messages = array();
        $Messages[0] = $mess;
        $feedDOM = $this->CreateFeed($Document, "OrderAcknowledgement", $Messages);
        $feed = $feedDOM->saveXML();

         if ($this->_debug == true) printf("$this->_cr cancelOrders() function. Now function creates the following feed: $this->_cr $feed $this->_cr");

        $data =  $this->processFeed("_POST_ORDER_ACKNOWLEDGEMENT_DATA_", $feed);

        if ($data == false && $this->_debug == true)
        {
            printf("$this->_cr cancelOrders() function finished with an error because of the prblem with query sending.. $this->_cr");
        }
        else
        {
            if ($this->_debug == true) printf("$this->_cr cancelOrders() function finished successfuly $this->_cr");
        }
        return $data;
    }

    /**(private)
     *Get ordered items (products) from the concrete order
     * @param <string> $AmazonOrderId
     * @return <string>Xml presented in the string
     */
    private function getOrderItemsXml($AmazonOrderId)
    {
        $params = array();
        $params['Action'] = 'ListOrderItems' ;
        $params['AmazonOrderId'] = $AmazonOrderId;
        $params['SellerId'] = $this->mid;
        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        $response = $this->_callWSs('Orders', $params);

        if ($this->_debug)
        {
            $d = NULL;
            if (!($response === false))
                $d = $response->saveXML();
            else
                $d = false;
            printf("$this->_cr getOrderItemsXml() function. WebService response is: $this->_cr
                    $d $this->_cr");
        }

        return $response;
    }

    private function CreateFeed (DOMDocument $Document, $MessageType, $Messages, $PurgeAndReplace = false)
    {
        if ($this->_debug) printf("$this->_cr CreateFeed() call $this->_cr");
        $FeedXmlDocument = $Document;
        $FeedXmlRootElement = $FeedXmlDocument->createElement("AmazonEnvelope");
        $FeedXmlRootElement->setAttribute("xsi:noNamespaceSchemaLocation", "amzn-envelope.xsd");
        $FeedXmlRootElement->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        $FeedXmlDocument->appendChild($FeedXmlRootElement);
        $header = $FeedXmlDocument->createElement("Header");
        $DocumentVersion = $FeedXmlDocument->createElement("DocumentVersion");
        $header->appendChild($DocumentVersion);
        $DocumentVersionText = $FeedXmlDocument->createTextNode("1.01");
        $DocumentVersion->appendChild($DocumentVersionText);
        $FeedXmlRootElement->appendChild($header);
        $MerchantIdentifier = $FeedXmlDocument->createElement("MerchantIdentifier");
        $header->appendChild($MerchantIdentifier);
        $MerchantIdentifierText = $FeedXmlDocument->createTextNode($this->mid);
        $MerchantIdentifier->appendChild($MerchantIdentifierText);
        $MessageTypeX = $FeedXmlDocument->createElement("MessageType");
        $FeedXmlRootElement->appendChild($MessageTypeX);
        $MessageTypeText = $FeedXmlDocument->createTextNode($MessageType);
        $MessageTypeX->appendChild($MessageTypeText);

        if ( $PurgeAndReplace )
        {
            $PurgeAndReplace = $FeedXmlDocument->createElement("PurgeAndReplace");
            $FeedXmlRootElement->appendChild($PurgeAndReplace);
            $PurgeAndReplace->appendChild( $FeedXmlDocument->createTextNode('true') );        
        }
        //adding messages
        for ($i=0; $i<count($Messages); $i++)
          $FeedXmlRootElement->appendChild ($Messages[$i]);

        return $FeedXmlDocument;
    }


    private function processFeed($feedType, $feedContent)
    {
        if ($this->_debug)
        {
            print("$this->_cr processFeed() function started.  $this->_cr
                Now we send following request to the WebService: $this->_cr
                \$feedType : $feedType $this->_cr
                \$feedContent:    $this->_cr
                   $feedContent  $this->_cr");
        }

        $feedHandle = @fopen('php://temp', 'rw+');
        fwrite($feedHandle, $feedContent);
        rewind ($feedHandle);

        $parameters = array (
            'Action' => 'SubmitFeed',
            'MarketplaceIdList.Id.1' => $this->mpid,
            //'Marketplace' => $this->mpid,
            'Merchant' => $this->mid,
            'FeedType' => $feedType,
            'SignatureVersion' => 2,
            'SignatureMethod' => 'HmacSHA256',

        );

        // Amazon Europe
        //
        if ( isset($this->MarketPlaces) && count($this->MarketPlaces) )
        {
          $i = 0 ;

          foreach($this->MarketPlaces as $idx => $marketPlace)
          {
            $i++ ;
            $parameters['MarketplaceIdList.Id.'.$i] = $marketPlace ;
          }
        }

        $response = $this->_callWSs("Feeds", $parameters, $feedContent);

        if ($response === false)
        {
            if ($this->_debug)
                printf ("response is false: %s $this->_cr", $this->_caller());
            return false;
        }
        else
        {
            if ($this->_debug)
                printf ("response is true: %s $this->_cr", nl2br(print_r($response,true)));
        }
        return($response);

    }


    private function createOrderFulfillmentMessage(DOMDocument $Document, $AmazonOrderIDI, $CarrierCodeI, $CarrierNameI, $ShippingMethodI, $ShipperTrackingNumberI, $messageID)
    {
        $message = $Document->createElement("Message");
        $messageIDX = $Document->createElement("MessageID");
        $message->appendChild($messageIDX);
        $messageIDText = $Document->createTextNode($messageID);
        $messageIDX->appendChild($messageIDText);
        $OrderFulfillment = $Document->createElement("OrderFulfillment");
        $message->appendChild($OrderFulfillment);
        $AmazonOrderID = $Document->createElement("AmazonOrderID");
        $OrderFulfillment->appendChild($AmazonOrderID);
        $AmazonOrderIDText = $Document->createTextNode($AmazonOrderIDI);
        $AmazonOrderID->appendChild($AmazonOrderIDText);
        $FulfillmentDate = $Document->createElement("FulfillmentDate");
        $OrderFulfillment->appendChild($FulfillmentDate);
        $t = time() - 5400;
        if ( ! date_default_timezone_get() )
            date_default_timezone_set("Europe/Helsinki");
        $date = date("c", $t);
        $FulfillmentDateText = $Document->createTextNode($date);
        $FulfillmentDate->appendChild($FulfillmentDateText);

        //FulfillmentData
        if ( $CarrierCodeI !== null || $CarrierNameI !== null )
        {
            $FulfillmentData = $Document->createElement("FulfillmentData");
            $OrderFulfillment->appendChild($FulfillmentData);
            if (!($CarrierCodeI === null) && $CarrierCodeI)
            {
                $CarrierCode = $Document->createElement("CarrierCode");
                $FulfillmentData->appendChild($CarrierCode);
                $CarrierCodeText = $Document->createTextNode($CarrierCodeI);
                $CarrierCode->appendChild($CarrierCodeText);                
            }
            elseif (!($CarrierNameI === null) && $CarrierNameI)
            {
                $CarrierName = $Document->createElement("CarrierName");
                $FulfillmentData->appendChild($CarrierName);
                $CarrierNameText = $Document->createTextNode($CarrierNameI);
                $CarrierName->appendChild($CarrierNameText);                
            }
            if (!($ShippingMethodI === null))
            {
                $ShippingMethod = $Document->createElement("ShippingMethod");
                $FulfillmentData->appendChild($ShippingMethod);
                $ShippingMethodText = $Document->createTextNode($ShippingMethodI);
                $ShippingMethod->appendChild($ShippingMethodText);
            }
            if(!($ShipperTrackingNumberI === null))
            {
                $ShipperTrackingNumber = $Document->createElement("ShipperTrackingNumber");
                $FulfillmentData->appendChild($ShipperTrackingNumber);
                $ShipperTrackingNumberText = $Document->createTextNode($ShipperTrackingNumberI);
                $ShipperTrackingNumber->appendChild($ShipperTrackingNumberText);
            }
        }
        return $message;
    }

    private function createOrderAcknowledgementMessage(DOMDocument $Document, $OrderID, $messageID)
    {
        $message = $Document->createElement("Message");
        $messageIDX = $Document->createElement("MessageID");
        $message->appendChild($messageIDX);
        $messageIDText = $Document->createTextNode($messageID);
        $messageIDX->appendChild($messageIDText);
        $OrderAcknowledgement = $Document->createElement("OrderAcknowledgement");
        $message->appendChild($OrderAcknowledgement);
        $AmazonOrderID = $Document->createElement("AmazonOrderID");
        $OrderAcknowledgement->appendChild($AmazonOrderID);
        $AmazonOrderIDText = $Document->createTextNode($OrderID);
        $AmazonOrderID->appendChild($AmazonOrderIDText);
        $StatusCode = $Document->createElement("StatusCode");
        $OrderAcknowledgement->appendChild($StatusCode);
        $StatusCodeText = $Document->createTextNode("Failure");
        $StatusCode->appendChild($StatusCodeText);
        return $message;
    }

    private function checkSKU($SKU)
    {
        return( $SKU != null && strlen($SKU) && preg_match('/[\x00-\xFF]{1,40}/', $SKU) && preg_match('/[^ ]$/', $SKU) ) ;
    }

    private function checkProductIDType($ProductIDType)
    {
      return(true) ;
        if ($this->_debug) printf("$this->_cr  checkProductIDType call \$ProductIDType = $ProductIDType $this->_cr");
        if ($ProductIDType == "ISBN" || $ProductIDType == "UPC" || $ProductIDType == "EAN"
               || $ProductIDType == "ASIN" || $ProductIDType == "GTIN")
        {
            if ($this->_debug) printf("$this->_cr  checkProductIDType function is finished successfully. $this->_cr");
            return true;
        }
        if ($this->_debug) printf("$this->_cr  checkProductIDType function is finished with $this->_att an error. You sent incorrect input argument.  \$ProductIDType = $ProductIDType . Please verify it $this->_cr");
        return false;
    }


    private function checkConditionType($ConditionType)
    {
        if ($this->_debug) printf("$this->_cr  checkConditionType call \$ConditionType = $ConditionType $this->_cr");
         if ($ConditionType == "New" ||$ConditionType == "UsedLikeNew" || $ConditionType == "UsedVeryGood" ||
                $ConditionType == "UsedGood" || $ConditionType == "UsedAcceptable" ||
                $ConditionType == "CollectibleLikeNew" || $ConditionType == "CollectibleVeryGood" ||
                $ConditionType == "CollectibleGood" || $ConditionType == "CollectibleAcceptable" ||
                $ConditionType == "Refurbished" || $ConditionType == "Club")
         {
             if ($this->_debug) printf("$this->_cr checkConditionType function is finished successfully. $this->_cr");
             return true;
         }
         if ($this->_debug) printf("$this->_cr checkConditionType function is finished with $this->_att an error. You sent incorrect input argument.  \$ConditionType = $ConditionType . Please verify this $this->_cr");
         return false;
    }

    private function checkConditionNote($ConditionNote)
    {
        if ($this->_debug) printf("$this->_cr checkConditionNote call.$this->_cr");
        if(strlen($ConditionNote) < 2000)
        {
            if ($this->_debug) printf("$this->_cr checkConditionNote function is finished successfully. $this->_cr");
            return true;
        }
        if ($this->_debug) printf("$this->_cr checkConditionNote function is finished $this->_att with an error. Input argument: \$ConditionNote = $ConditionNote $this->_cr");
        return false;
    }
    /**
     * 
     * @param DOMDocument $Document
     * @param type $arrayOfData Array containing "Elements" to be added and their corresponding path in "Parameters"
     * @param type $parentTagName the name of the tag where elements will be appended, for example:"ProductData"
     * @return boolean
     */
    private function convertToXmlNode(DOMDocument $Document, $arrayOfData, $parentTagName="ProductData")
    {  
        $details=0;
        $param = "Parameters";        
        $attributes = "Attributes";        
            
        if ( is_array($arrayOfData)):                        
            $parentElement = $Document->createElement($parentTagName);                    
        
             /*
             * if [Parameters] is not set in the array or has zero (0) elements, 
             * then no XML element is generated
             */        
            if(!isset($arrayOfData[$param]) || count($arrayOfData[$param])==0):                                
                return false;
            endif;
  
            foreach($arrayOfData as $key=>$value):                           
                if($key==$param || $key == $attributes):
                    continue;
                endif;
                if(!isset($arrayOfData[$param][$key])):                    
                    continue;
                endif;
                
                if(is_array($arrayOfData[$param][$key])):
                    
                    $xPrevQuery="";
                    $xQuery="";
                    $first = true;
                    $x = new DOMXPath($Document);
                    //Generates Nodes to be added
                    foreach($arrayOfData[$param][$key] as $tagName):                        
                        $xPrevQuery = $xQuery;
                        if($first):
                            $first=false;                                                       
                            $xQuery = $tagName; //assign
                        else:
                            $xQuery .= "/".$tagName; //concatenate
                        endif;
                        
                        $exists = $x->query($xQuery,$parentElement)->length;                        
                        
                        if($exists==0):                            
                            if($xPrevQuery!=""):                                
                                $result= $x->query($xPrevQuery, $parentElement);                                
                                /**
                                 * Before we check if it has text as child, and removes it
                                 */
                                foreach($result as $r):
                                    if($r->hasChildNodes()):
                                       foreach($r->childNodes as $child):
                                           if($child->nodeName=='#text'):                                               
                                               $child->parentNode->removeChild($child);
                                           endif;
                                       endforeach; 
                                    endif;
                                endforeach;                                
                                
                                foreach($result as $r):
                                    $node = $Document->createElement($tagName);
                                    $this->setElementAttributes($node,$arrayOfData);
                                    $r->appendChild($node);
                                    break; //only one time
                                endforeach;                                
                            else:
                                $node = $Document->createElement($tagName);
                                $this->setElementAttributes($node,$arrayOfData);
                                $parentElement->appendChild($node);
                            endif;
                        endif;
                    endforeach;
                    
                    $lastChild = $x->query($xQuery,$parentElement);
                    
                    if($lastChild):                                               
                        foreach($lastChild as $l):
                            if ( $tagName != 'ProductType' )
                                $l->appendChild($Document->createTextNode($value));
                            else
                                // If is not a complex type
                                if ( in_array($arrayOfData['Definition'],  array('ToysBaby', 'Sports', 'Miscellaneous')) )
                                    $l->appendChild($Document->createTextNode(trim($value)));
                                else
                                    $l->appendChild($Document->createElement(trim($value)));
                            break;
                        endforeach;
                        $details++;
                    endif;
                endif;
                
            endforeach;       
            
            if($details > 0):
                return $parentElement;
            endif;
        endif;
        
        return false;
    }
            
    
    private function clothingToXmlNode(DOMDocument $Document, $arrayOfData, $parentTagName="ProductData")
    {  
        
        $details=0;
        $param = "Parameters";        
        if ( is_array($arrayOfData)):
            
            $root = $Document->createElement("ProductData");
            $clothing = $root->appendChild($Document->createElement("Clothing"));
            
            if(isset($arrayOfData["Parentage"])):
                $clothing->appendChild($Document->createElement("VariationData"));
            endif;
            
            $element = $clothing->appendChild($Document->createElement($parentTagName));
            $parentElement = $root;
            
             /*
             * if [Parameters] is not set in the array or has zero (0) elements, 
             * then no XML element is generated
             */        
            if(!isset($arrayOfData[$param]) || count($arrayOfData[$param])==0):                                
                return false;
            endif;
  
            foreach($arrayOfData as $key=>$value):                           
                if($key==$param):
                    continue;
                endif;
                
                if(is_array($arrayOfData[$key])):
                    $this->convertArrayToXmlNode($Document, $arrayOfData[$key], $element);
                elseif(!isset($arrayOfData[$param][$key])):                    
                    continue;
                elseif(is_array($arrayOfData[$param][$key])):
                    $xPrevQuery="";
                    $xQuery="";
                    $first = true;
                    $x = new DOMXPath($Document);
                    
                    //Generates Nodes to be added
                    foreach($arrayOfData[$param][$key] as $tagName):                        
                        $xPrevQuery = $xQuery;
                        if($first):
                            $first=false;                                                       
                            $xQuery = $tagName; //assign
                        else:
                            $xQuery .= "/".$tagName; //concatenate
                        endif;
                        $exists = $x->query($xQuery,$parentElement)->length;                        
                        
                        if($exists==0):                            
                            if($xPrevQuery!=""):                                
                                $result= $x->query($xPrevQuery, $parentElement);                                
                                /**
                                 * Before we check if it has text as child, and removes it
                                 */
                                foreach($result as $r):
                                    if($r->hasChildNodes()):
                                       foreach($r->childNodes as $child):
                                           if($child->nodeName=='#text'):
                                               $child->parentNode->removeChild($child);
                                           endif;
                                       endforeach; 
                                    endif;
                                endforeach;                                
                                
                                foreach($result as $r):
                                    $node = $Document->createElement($tagName);
                                    $this->setElementAttributes($node,$arrayOfData);
                                    $r->appendChild($node);
                                    break; //only one time
                                endforeach;                                
                            else:
                                $node = $Document->createElement($tagName);
                                $this->setElementAttributes($node,$arrayOfData);
                                try {
                                   $parentElement->insertBefore($node,$element);
                                }catch(Exception $e){
                                    $parentElement->appendChild($node);
                                }
                            endif;
                        endif;
                    endforeach;
                    
                    $lastChild = $x->query($xQuery,$parentElement);
                    
                    if($lastChild):                                               
                        foreach($lastChild as $l):
                            if ( $tagName != 'ProductType' )
                                $l->appendChild($Document->createTextNode($value));
                            else
                                $l->appendChild($Document->createElement(trim($value)));
                            break;
                        endforeach;
                        $details++;
                    endif;                     
                endif;
            endforeach;       
            
            return $root;
        endif;
         
        return false;
    }
            
    private function convertArrayToXmlNode(DOMDocument $Document, $array, DOMElement $root){
        $xPrevQuery="";
        $xQuery="";
        $first = true;
        $x = new DOMXPath($Document);
        $newElement=false;
        $path="";
        
        foreach($array as $tagName=>$tagChild):                
            $xPrevQuery = $xQuery;
            if($first):
                $first=false;                                                       
                $xQuery = $tagName; //assign
            else:
                $xQuery .= "/".$tagName; //concatenate
            endif;
            
            $exists = $x->query($xQuery,$root)->length;                        

            if($exists==0):              
                if($xPrevQuery!=""):                                
                    $result= $x->query($xPrevQuery, $root);                                
                    /**
                     * Before we check if it has text as child, and removes it
                     */
                    foreach($result as $r):
                        if($r->hasChildNodes()):
                           foreach($r->childNodes as $child):
                               if($child->nodeName=='#text'):                                               
                                   $child->parentNode->removeChild($child);
                               endif;
                           endforeach; 
                        endif;
                    endforeach;                                

                    foreach($result as $r):
                        $newElement = $Document->createElement($tagName);
                        $this->setElementAttributes($newElement,$array);
                        $r->appendChild($newElement);
                        break; //only one time
                    endforeach;                                
                else:
                    $newElement = $Document->createElement($tagName);
                    $this->setElementAttributes($newElement,$array);
                    $root->appendChild($newElement);
                endif;
                
                if(is_array($tagChild) && $newElement):
                    $this->convertArrayToXmlNode($Document, $array[$tagChild], $newElement);
                elseif($newElement):
                    echo "<br/> Searches for:".$xQuery." in Node: ".$root->nodeName;
                    $lastChild = $x->query($xQuery,$root);
                    if($lastChild):                                               
                        foreach($lastChild as $l):
                            if ( $tagName != 'ProductType' ):
                                $node = $Document->createTextNode($tagChild);
                                $l->appendChild($node);
                            else:
                                $node = $Document->createElement(trim($tagChild));
                                $this->setElementAttributes($node,$array);
                                $l->appendChild($node);
                            endif;
                            
                            break;
                        endforeach;
                    endif;
                endif;
            endif;
        endforeach;
        return $path;
    }
    
    private function setElementAttributes(DOMElement $node, array $productData){
        if(isset($productData['Attributes'][$node->nodeName])):
            foreach($productData['Attributes'][$node->nodeName] as $attr=>$value):
                $node->setAttribute($attr, $value);
            endforeach;
        endif;
    }
    
    public function setSortedElements(DOMDocument $d, DOMElement $element, array $xsdStructure, $xPath=null){
        $children=array();
        if($element==null):
            return;
        endif;
        $x = new DOMXPath($d);        
        $query = $element->getNodePath()."/*";
        $result = $x->query($query);
        
        //As root element is ProductData, we look for its children like "Computers" or "Shoes"
        foreach($result as $r):
            $children[$r->nodeName] = $r->parentNode->removeChild($r);
        endforeach;
        
        //append child according to structure order
        foreach($xsdStructure as $key=>$value):                    
            if(isset($children[$key])):                
                $element->appendChild($children[$key]);
                if(is_array($value) && count($value)>0):                
                    $children[$key] = $this->setSortedElements($d,$children[$key],$xsdStructure[$key]);
                endif;
            endif;
        endforeach;
                
        return $element;
    }
    
    public function sortProductData(DOMDocument $document, DOMElement $element, array $xsdStructure){        
        $d = new DOMDocument();        
        $newElement = $d->importNode($element->cloneNode(true), true);         
        $d->appendChild($newElement);
        
        $node = $this->setSortedElements($d, $newElement, $xsdStructure,"/");
        
        if($node):                        
            return $document->importNode($node,true);
        else:
            return $element;
        endif;
    }
    
    private function createProductMessage (DOMDocument $Document, $SKU, $ProductIDType, $ProductIDCode, $ConditionType, $ConditionNote, $ProductData, $ProductDescription, $MessageID, $updatingType = null)
    {
        if ($this->_debug) printf("$this->_cr createProductMessage call \$SKU = $SKU \$ProductIDType = $ProductIDType \$ConditionType = $ConditionType \$MessageID = $MessageID \$updatingType = $updatingType $this->_cr");

        //updating or partial updating ?
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
                $updatingType = 'Update' ;
                break ;
            case self::OPERATIONS_UPDATE :
                $updatingType = 'PartialUpdate' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ; 
                
            default:
                echo "$this->_cr partiallyUpdateProducts call. undefined value for updatingType . $this->_cr";
                return(false); 
        }        
        
        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDText = $Document->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $OperationType = $Document->createElement("OperationType");
        $Message->appendChild($OperationType);
        $OperationTypeText = $Document->createTextNode($updatingType);
        $OperationType->appendChild($OperationTypeText);
        $Product = $Document->createElement("Product");
        $Message->appendChild($Product);
        $SKUX = $Document->createElement("SKU");
        $Product->appendChild($SKUX);
        $SKUText = $Document->createTextNode($SKU);
        $SKUX->appendChild($SKUText);
        if ($ProductIDType!=null && $ProductIDCode != null)
        {
            $StandardProductID = $Document->createElement("StandardProductID");
            $Product->appendChild($StandardProductID);
            $Type = $Document->createElement("Type");
            $StandardProductID->appendChild($Type);
            $TypeText = $Document->createTextNode($ProductIDType);
            $Type->appendChild($TypeText);
            $Value = $Document->createElement("Value");
            $StandardProductID->appendChild($Value);
            $ValueText = $Document->createTextNode($ProductIDCode);
            $Value->appendChild($ValueText);
        }
        if ($ConditionType!=null)
        {
            $ConditionX = $Document->createElement("Condition");
            $Product->appendChild($ConditionX);
            $ConditionTypeX = $Document->createElement("ConditionType");
            $ConditionX->appendChild($ConditionTypeX);
            $ConditionTypeText = $Document->createTextNode($ConditionType);
            $ConditionTypeX->appendChild($ConditionTypeText);
            if ($ConditionNote!=null)
            {
                $ConditionNoteX = $Document->createElement("ConditionNote");
                $ConditionX->appendChild($ConditionNoteX);
                $ConditionNoteText = $Document->createTextNode($ConditionNote);
                $ConditionNoteX->appendChild($ConditionNoteText);
            }
        }

        // 2013-03-29 Adding ItemPackageQuantity
        //
        if ( $ProductData && isset($ProductData['ItemPackageQuantity']) )
        {
                $ItemPackageQuantityTag = $Document->createElement('ItemPackageQuantity');
                $ItemPackageQuantityTag->appendChild( $Document->createTextNode($ProductData['ItemPackageQuantity']) );
                $Product->appendChild($ItemPackageQuantityTag);                    
        }
     
        // 2014-02-26 Adding NumberOfItems
        //
        if ( $ProductData && isset($ProductData['NumberOfItems']) )
        {
                $NumberOfItemsTag = $Document->createElement('NumberOfItems');
                $NumberOfItemsTag->appendChild( $Document->createTextNode($ProductData['NumberOfItems']) );
                $Product->appendChild($NumberOfItemsTag);                    
        }
                
        // Send Product Informations
        //
        if ( is_array($ProductDescription) )
        {
            $DescriptionDataTag = $Document->createElement("DescriptionData");
            $Product->appendChild($DescriptionDataTag);

            if ( isset($ProductDescription['Title']) )
            {        
                $TitleTag = $Document->createElement("Title");
                $DescriptionDataTag->appendChild($TitleTag);

                $TitleText = $Document->createTextNode($ProductDescription['Title']);
                $TitleTag->appendChild($TitleText);
            }
            
            if ( isset($ProductDescription['Brand']) && ! empty($ProductDescription['Brand']) )
            {
                $BrandTag = $Document->createElement("Brand");
                $DescriptionDataTag->appendChild($BrandTag);
                $BrandText = $Document->createTextNode($ProductDescription['Brand']);
                $BrandTag->appendChild($BrandText);                    
            }  
            
            if ( isset($ProductDescription['Title']) && isset($ProductDescription['Description']) )
            {        
                $DescriptionTag = $Document->createElement("Description");
                $DescriptionDataTag->appendChild($DescriptionTag);

                $DescriptionText = $Document->createTextNode($ProductDescription['Description']);
                $DescriptionTag->appendChild($DescriptionText);        
            }   
            

            if ( isset($ProductDescription['BulletPoint']) && is_array($ProductDescription['BulletPoint']) )
            {
                $count = 1 ;
                foreach($ProductDescription['BulletPoint'] as $BulletPoint)
                {
                    if ( $count > 5 )
                        break ;
                    $BulletPointTag = $Document->createElement("BulletPoint");
                    $BulletPointTag->appendChild( $Document->createTextNode($BulletPoint) );                 

                    $DescriptionDataTag->appendChild($BulletPointTag);                    
                    $count++ ;
                }
            }
                        
            if ( isset($ProductDescription['PackageWeight']) && ! empty($ProductDescription['PackageWeight']) )
            {
                $PackageWeightTag = $Document->createElement("PackageWeight", $ProductDescription['PackageWeight']);
                $PackageWeightTag->setAttribute("unitOfMeasure", $ProductDescription['PackageWeightUnit']);
                $DescriptionDataTag->appendChild($PackageWeightTag);
            }
            
            if ( isset($ProductDescription['ShippingWeight']) && ! empty($ProductDescription['ShippingWeight']) )
            {
                $PackageWeightTag = $Document->createElement("ShippingWeight", $ProductDescription['ShippingWeight']);
                $PackageWeightTag->setAttribute("unitOfMeasure", $ProductDescription['ShippingWeightUnit']);
                $DescriptionDataTag->appendChild($PackageWeightTag);
            }               

            if ( isset($ProductDescription['MerchantCatalogNumber']) && ! empty($ProductDescription['MerchantCatalogNumber']) )
            {
                $MerchantCatalogNumber = $Document->createElement("MerchantCatalogNumber");
                $MerchantCatalogNumber->appendChild( $Document->createTextNode( mb_substr($ProductDescription['MerchantCatalogNumber'], 0, 40))) ;
                $DescriptionDataTag->appendChild( $MerchantCatalogNumber );
            }
            
            if ( isset($ProductDescription['Manufacturer']) && ! empty($ProductDescription['Manufacturer']) )
            {
                $ManufacturerTag = $Document->createElement("Manufacturer");
                $DescriptionDataTag->appendChild($ManufacturerTag);                    
                $ManufacturerText = $Document->createTextNode($ProductDescription['Manufacturer']);
                $ManufacturerTag->appendChild($ManufacturerText);                    
            } 
            
            if ( isset($ProductDescription['MfrPartNumber']) && ! empty($ProductDescription['MfrPartNumber']) )
            {
                $MfrPartNumberTag = $Document->createElement("MfrPartNumber");
                $DescriptionDataTag->appendChild($MfrPartNumberTag);                    
                $MfrPartNumberText = $Document->createTextNode($ProductDescription['MfrPartNumber']);
                $MfrPartNumberTag->appendChild($MfrPartNumberText);                    
            } 
            
            // Added : 2013/05/15 
            //
            if ( isset($ProductDescription['SearchTerms']) )
            {
                if ( is_array($ProductDescription['SearchTerms']) && count($ProductDescription['SearchTerms']) )
                {
                    foreach($ProductDescription['SearchTerms'] as $searchTerms)
                    {
                        $SearchTermsTag = $Document->createElement("SearchTerms");
                        $DescriptionDataTag->appendChild($SearchTermsTag);                    
                        $SearchTermsText = $Document->createTextNode($searchTerms);
                        $SearchTermsTag->appendChild($SearchTermsText);                           
                    }
                }
                elseif ( is_string($ProductDescription['SearchTerms']) && ! empty($ProductDescription['SearchTerms']) )
                {
                    $SearchTermsTag = $Document->createElement("SearchTerms");
                    $DescriptionDataTag->appendChild($SearchTermsTag);                    
                    $SearchTermsText = $Document->createTextNode($ProductDescription['SearchTerms']);
                    $SearchTermsTag->appendChild($SearchTermsText);                    
                }
            }            

            // Added : 2014/03/13 
            //
            if ( isset($ProductDescription['ItemType']) && ! empty($ProductDescription['ItemType']) )
            {
                $ItemTypeTag = $Document->createElement("ItemType");
                $DescriptionDataTag->appendChild($ItemTypeTag);                    
                $ItemTypeText = $Document->createTextNode($ProductDescription['ItemType']);
                $ItemTypeTag->appendChild($ItemTypeText);                    
            }   
            
            if ( isset($ProductDescription['RecommendedBrowseNode']) && ! empty($ProductDescription['RecommendedBrowseNode']) )
            {
                $result = preg_split('/[,; ]/', $ProductDescription['RecommendedBrowseNode']) ;
                
                if ( is_array($result) )
                {
                    $count = 1 ;
                    foreach($result as $browsenode)
                    {
                        if ( empty($browsenode) || ! is_numeric($browsenode) )  continue ;

                        $RecommendedBrowseNodeTag = $Document->createElement("RecommendedBrowseNode");
                        $DescriptionDataTag->appendChild($RecommendedBrowseNodeTag);                    
                        $RecommendedBrowseNodeText = $Document->createTextNode($browsenode);
                        $RecommendedBrowseNodeTag->appendChild($RecommendedBrowseNodeText);                    
                        
                        if ( $count++ >= 2 )
                            break ;                        
                    }
                }
            }                
        }
        
        // Clothes exception
        if ( isset($ProductData['ClassificationData']) ):
            $productDataNode = $this->clothingToXmlNode($Document, $ProductData,"ClassificationData");
        else: 
            $productDataNode = $this->convertToXmlNode($Document, $ProductData,"ProductData");
        endif;
        
        //ORDER ELEMENTS ACCORDING TO XSD
        if(isset($ProductData['Parameters']) && isset($ProductData['Parameters']['xsd']) && count($ProductData['Parameters']['xsd']) ):                        
            //$productDataNode = $this->setOrderedElements($Document, $productDataNode, $ProductData['Parameters']['xsd']);            
            $productDataNode = $this->sortProductData($Document, $productDataNode, $ProductData['Parameters']['xsd']);
        endif;
        
        if($productDataNode):
            $Product->appendChild($productDataNode);
        endif;

        // 2013-03-23 Adding EAN/UPC Exemption
        //
        if ( $ProductData && isset($ProductData['RegisteredParameter']) )
        {
                $RegisteredParameterTag = $Document->createElement('RegisteredParameter');
                $RegisteredParameterTag->appendChild( $Document->createTextNode($ProductData['RegisteredParameter']) );
                $Product->appendChild($RegisteredParameterTag);                    
        }
        
        return $Message;
    }

    private function createQuantityMessage (DOMDocument $Document, $SKU, $quantity, $options, $MessageID)
    {
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
            case self::OPERATIONS_UPDATE :
                $updatingType = 'Update' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ; 
            default:
                echo "$this->_cr createQuantityMessage call. undefined value for updatingType . $this->_cr";
                return(false); 
        }  
        
        if ($this->_debug) printf("$this->_cr createQuantityMessage call \$SKU = $SKU \$quantity = $quantity \$MessageID = $MessageID $this->_cr");
        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDX->appendChild($Document->createTextNode($MessageID));
        $OperationType = $Document->createElement("OperationType");
        $Message->appendChild($OperationType);
        $OperationType->appendChild($Document->createTextNode($updatingType));

        $Inventory = $Document->createElement("Inventory");
        $Message->appendChild($Inventory);
        $SKUX = $Document->createElement("SKU");
        $Inventory->appendChild($SKUX);
        $SKUX->appendChild($Document->createTextNode($SKU));

        if ( $options && isset($options['FBA']) ) $FBA = true ;
        else $FBA = false ; 
        
        // FBA:  ignore quantities 
        if ( $FBA )
        {
          $FBA = $Document->createElement("FulfillmentCenterID");
          $Inventory->appendChild($FBA);
          $FulfillmentCenterID = $Document->createTextNode($options['FBA']);
          $FBA->appendChild($FulfillmentCenterID);
          
          $Lookup = $Document->createElement("Lookup");
          $Inventory->appendChild($Lookup);
          $Lookup->appendChild( $Document->createTextNode('FulfillmentNetwork') );
        }  
        else 
        {
            $Quantity = $Document->createElement("Quantity");
            $Inventory->appendChild($Quantity);
            $Quantity->appendChild( $Document->createTextNode($quantity) );            
        }

        if ( $options && isset($options['FulfillmentLatency']) ) $fulfillmentLatency = intval($options['FulfillmentLatency']) ;
        else $fulfillmentLatency = false ;
        
        if ( $fulfillmentLatency )
        {
          $FulfillmentLatency = $Document->createElement("FulfillmentLatency");
          $Inventory->appendChild($FulfillmentLatency);
          $FulfillmentLatency->appendChild($Document->createTextNode($fulfillmentLatency));
        }
        
        return $Message;

    }

    private function createShippingOverrideMessage (DOMDocument $Document, $SKU, $shippingPrice, $shippingType, $MessageID)
    {
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
            case self::OPERATIONS_UPDATE :
                $updatingType = 'Update' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ; 
            default:
                echo "$this->_cr createShippingOverrideMessage call. undefined value for updatingType . $this->_cr";
                return(false); 
        }          
        if ($this->_debug) printf("$this->_cr createShippingOverrideMessage call \$SKU = $SKU \$shippingPrice = $shippingPrice \$MessageID = $MessageID $this->_cr");

        if ($this->_debug) $Document->formatOutput = true;

        if ( $shippingPrice === '' ) $delete = 1 ;
        else $delete = 0 ;

        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDText = $Document->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $OperationType = $Document->createElement("OperationType", $delete ? "Delete" : $updatingType);
        $Message->appendChild($OperationType);


        $Override = $Document->createElement("Override");
        $Message->appendChild($Override);
        $SKUX = $Document->createElement("SKU", $SKU);
        $Override->appendChild($SKUX);

        $ShippingOverride = $Document->createElement("ShippingOverride");
        $Override->appendChild($ShippingOverride);


        $ShipOption = $Document->createElement("ShipOption", $shippingType);
        $ShippingOverride->appendChild($ShipOption);

        $Type = $Document->createElement("Type", "Exclusive");
        $ShippingOverride->appendChild($Type);

        $ShipAmount = $Document->createElement("ShipAmount", $delete ? 0 : $shippingPrice);
        $ShipCurrency = $Document->createAttribute('currency');
        $ShipCurrency->value = $this->Currency ;
        $ShipAmount->appendChild($ShipCurrency) ;
        $ShippingOverride->appendChild($ShipAmount);

        $xml = $Document->saveXML($Message);

        if ( $this->_debug )
            echo nl2br(print_r($xml, true)) ;

        return $Message;
    }

    private function createProductImageMessage (DOMDocument $Document, $SKU, $productImage, $MessageID, $index)
    {
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
            case self::OPERATIONS_UPDATE :
                $updatingType = 'Update' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ; 
            default:
                echo "$this->_cr createProductImageMessage call. undefined value for updatingType . $this->_cr";
                return(false); 
        }          
        if ($this->_debug) printf("$this->_cr createProductImageMessage call \$SKU = $SKU \$productImage = %s \$MessageID = $MessageID $this->_cr", print_r($productImage, true));

        if ($this->_debug) $Document->formatOutput = true;

        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDText = $Document->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $OperationType = $Document->createElement("OperationType", $updatingType);
        $Message->appendChild($OperationType);

        $Image = $Document->createElement("ProductImage");
        $Message->appendChild($Image);        

        $SKUX = $Document->createElement("SKU", $SKU);
        $Image->appendChild($SKUX);
            
        if ( $index == 0 )
                $typeOf='Main' ;
        else    $typeOf = 'PT' . $index ;
        $ImageType = $Document->createElement("ImageType");
        $Image->appendChild($ImageType);

        $ImageTypeText = $Document->createTextNode($typeOf);
        $ImageType->appendChild($ImageTypeText); 


        $ImageLocation = $Document->createElement("ImageLocation");
        $Image->appendChild($ImageLocation);

        $ImageLocationURL = $Document->createTextNode($productImage);
        $ImageLocation->appendChild($ImageLocationURL); 

        $xml = $Document->saveXML($Message);

        if ( $this->_debug )
            echo nl2br(print_r($xml, true)) ;

        return $Message;
    }

    private function createProductRelationshipMessage (DOMDocument $Document, $SKU, $ChildrenSKU, $MessageID)
    {
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
            case self::OPERATIONS_UPDATE :
                $updatingType = 'Update' ;
                break ; 
            case self::OPERATIONS_DELETE :
                $updatingType = 'Delete' ;
                break ; 
            default:
                echo "$this->_cr createProductRelationshipMessage call. undefined value for updatingType . $this->_cr";
                return(false); 
        }         
        if ($this->_debug) printf("$this->_cr createProductRelationshipMessage call \$SKU = $SKU \$ChildrenSKU = %s \$MessageID = $MessageID $this->_cr", print_r($ChildrenSKU, true)) ;

        if ($this->_debug) 
            $Document->formatOutput = true;

        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDText = $Document->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $OperationType = $Document->createElement("OperationType", $updatingType);
        $Message->appendChild($OperationType);


        $Relationship = $Document->createElement("Relationship");
        $Message->appendChild($Relationship);
        $SKUX = $Document->createElement("ParentSKU", $SKU);
        $Relationship->appendChild($SKUX);

        foreach($ChildrenSKU as $ChildSKU)
        {
            $Relation = $Document->createElement("Relation");
            $Relationship->appendChild($Relation);
            
            $RelationSKU = $Document->createElement("SKU", $ChildSKU);
            $Relation->appendChild($RelationSKU);        

            $RelationType = $Document->createElement("Type", "Variation");
            $Relation->appendChild($RelationType);                    
        }
        
        $xml = $Document->saveXML($Message);

        if ( $this->_debug )
            echo nl2br(print_r($xml, true)) ;

        return $Message;
    }    
    
    
    private function checkQuantity($Quantity)
    {
        if ($this->_debug) printf("$this->_cr checkQuantity call $this->_cr");
        if ($Quantity === null) return false;
        if ($Quantity == 0 || $Quantity == "0") return true;
        if (!is_numeric($Quantity))
        {
            if ($this->_debug) printf("$this->_cr checkQuantity function. \$Quantity must be numeric You sent incorrect argument \$Quantity = $Quantity . Please verify this and try again. Function is finished with an error. $this->_cr");
            return false;

        }
        $quan = intval($Quantity);

        
        if($quan > 0)
        {
            if ($this->_debug) printf("$this->_cr checkQuantity function is completed successfully $this->_cr");
            return true;
        }
        if ($this->_debug) printf("$this->_cr checkQuantity function is completed with $this->_att an Error. It is incorrect input argument Quantity = $Quantity . Must be not negative integer. $this->_cr");
        return false;
    }

    private function createPriceMessage(DOMDocument $Document, $SKU, $Price, $Sales, $MessageID)
    {
        switch($this->_operationMode)
        {
            case self::OPERATIONS_CREATE :
            case self::OPERATIONS_UPDATE :
                break ; 
            case self::OPERATIONS_DELETE :
                return(null) ;
            default:
                echo "$this->_cr createPriceMessage call. undefined value for updatingType . $this->_cr";
                return(false); 
        }            
        if ($this->_debug) printf("$this->_cr createPriceMessage call. \$SKU = $SKU \$Price = $Price \$MessageID = $MessageID Current currency: $this->Currency $this->_cr");
        $Message = $Document->createElement("Message");
        $MessageIDX = $Document->createElement("MessageID");
        $Message->appendChild($MessageIDX);
        $MessageIDText = $Document->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $PriceX = $Document->createElement("Price");
        $Message->appendChild($PriceX);
        $SKUX = $Document->createElement("SKU");
        $PriceX->appendChild($SKUX);
        $SKUText=$Document->createTextNode($SKU);
        $SKUX->appendChild($SKUText);
        $StandardPrice = $Document->createElement("StandardPrice");
        $StandardPrice->setAttribute("currency", $this->Currency /*"USD"*/);
        
        $PriceX->appendChild($StandardPrice);
        
        if ( $Sales && isset($Sales['dateStart']) && isset($Sales['dateEnd']) && isset($Sales['salePrice'])  )
        {
            $SaleTag    = $Document->createElement("Sale");
            $dateStart  = $Document->createElement("StartDate", $Sales['dateStart']);
            $dateEnd    = $Document->createElement("EndDate", $Sales['dateEnd']);
            $salePrice  = $Document->createElement("SalePrice", str_replace(',', '.', $Sales['salePrice']));
            $salePrice->setAttribute("currency", $this->Currency);
            $SaleTag->appendChild($dateStart) ;
            $SaleTag->appendChild($dateEnd) ;
            $SaleTag->appendChild($salePrice) ;
            $PriceX->appendChild($SaleTag) ;
        }
       
        
        $StandardPriceText = $Document->createTextNode($Price);
        $StandardPrice->appendChild($StandardPriceText);
        return $Message;
    }

    private function checkPrice($price)
    {
        if ($this->_debug) printf("$this->_cr checkPrice call. \$price=$price $this->_cr");

        if (strpos ($price, ',') != false)
        {
            $price = str_replace(",", ".", $price);
        }
        if (is_numeric($price))
            if ($price>=0)
            {
                if ($this->_debug) printf("$this->_cr checkPrice() function is completed successfully. $this->_cr");
                //return true;
                return $price;
            }
        if ($this->_debug) printf("$this->_cr checkPrice() function is completed $this->_att with an error. You sent incorrect input argument \$price = $price $this->_cr");
        return false;
    }



    private function createDelMessage(DOMDocument $Document, $MessageID, $SKU)
    {
        if ($this->_debug) printf("$this->_cr createDelMessage call \$SKU = $SKU \$MessageID = $MessageID $this->_cr");
        $xml = $Document;
        $message = $xml->createElement("Message");
        $MessageIDX = $xml->createElement("MessageID");
        $message->appendChild($MessageIDX);
        $MessageIDText = $xml->createTextNode($MessageID);
        $MessageIDX->appendChild($MessageIDText);
        $OperationType = $xml->createElement("OperationType");
        $message->appendChild($OperationType);
        $OperationTypeText = $xml->createTextNode("Delete");
        $OperationType->appendChild($OperationTypeText);
        $Product = $xml->createElement("Product");
        $message->appendChild($Product);
        $SKUX = $xml->createElement("SKU");
        $Product->appendChild($SKUX);
        $SKUText = $xml->createTextNode($SKU);
        $SKUX->appendChild($SKUText);

        return $message;
    }

	/*
	* 1.request a report
	*/
	public function requestReport($startDate=NULL,$endDate=NULL)
	{
		if ($this->_debug == true) printf("$this->_cr RequestReport call. $this->_cr");

        $params['Action'] = 'RequestReport';
        $params['Marketplace'] = $this->mpid;
        $params['Merchant'] = $this->mid;
        $params['ReportType'] = '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_';
        if($startDate != NULL)
        {
        	$params['StartDate'] = getFormattedTimestamp($startDate);
        }
        if($endDate != NULL)
        {
        	$params['EndDate'] = getFormattedTimestamp($endDate);
        }

        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        if ($this->_debug == true) printf("$this->_cr requestReport function. Start request $this->_cr");

        $response = $this->_callWSs('Reports', $params);

        if($response->RequestReportResult->ReportRequestInfo->ReportProcessingStatus == '_SUBMITTED_')
        {
        	$reportRequestId = $response->RequestReportResult->ReportRequestInfo->ReportRequestId;
        	$submittedDate = $response->RequestReportResult->ReportRequestInfo->SubmittedDate;

        	return $reportRequestId;
        }

         return null;

	}

	/*
	* 2.check on the status of a report
	*/
	private function getReportRequestList($reportRequestId)
	{
		if ($this->_debug == true) printf("$this->_cr getReportRequestList call. $this->_cr");

        $params['Action'] = 'GetReportRequestList';
        $params['Marketplace'] = $this->mpid;
        $params['Merchant'] = $this->mid;
        $params['ReportRequestIdList.Id.1'] = $reportRequestId;

        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        if ($this->_debug == true) printf("$this->_cr getReportRequestList function. Start request $this->_cr");

        $response = $this->_callWSs('Reports', $params);

        if($response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus == '_DONE_')
        {
        	return $response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus;
        }
        elseif($response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus ==  '_PROCESSING_' ||
        		$response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus == '_SUBMITTED_')
        {
        	$sta = $response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus;
        	while($sta != '_DONE_')
        	{
        		unset($params);
        		$params['Action'] = 'GetReportRequestList';
        		$params['Marketplace'] = $this->mpid;
        		$params['Merchant'] = $this->mid;
        		$params['ReportRequestIdList.Id.1'] = $reportRequestId;

        		$params['SignatureVersion'] = '2';
        		$params['SignatureMethod'] = 'HmacSHA256';

        		if ($this->_debug == true) printf("$this->_cr getReportRequestList function. Start request $this->_cr");

        		$response = $this->_callWSs('Reports', $params);

        		if( isset($response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus) && $response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus == '_DONE_')
        		{
        			return $response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus;
        		}
        		elseif ( isset($response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus) ) {

        			$sta = $response->GetReportRequestListResult->ReportRequestInfo[0]->ReportProcessingStatus;
        		}

        	}

        	sleep(5);
        	$this->getReportRequestList($reportRequestId);
        }
	}

	/*
	* 3.get reporst Ids of all reports available
	*/
	private function getReportList($reportRequestId)
	{
		if ($this->_debug == true) printf("$this->_cr getReportList call. $this->_cr");

        $params['Action'] = 'GetReportList';
        $params['Marketplace'] = $this->mpid;
        $params['Merchant'] = $this->mid;
        $params['ReportRequestIdListId.1'] = $reportRequestId;
        $params['Acknowledged'] = 'false';

        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        if ($this->_debug == true) printf("$this->_cr getReportList function. Start request $this->_cr");

        $response = $this->_callWSs('Reports', $params);

        return $response->GetReportListResult->ReportInfo[0]->ReportId;

	}

	/*
	* 4.download a report
	*/
	private function getReport($ReportId)
	{
		if ($this->_debug == true) printf("$this->_cr getReport call. $this->_cr");

        $params['Action'] = 'GetReport';
        $params['Marketplace'] = $this->mpid;
        $params['Merchant'] = $this->mid;
        $params['ReportId'] = $ReportId;

        $params['SignatureVersion'] = '2';
        $params['SignatureMethod'] = 'HmacSHA256';

        if ($this->_debug == true) printf("$this->_cr getReport function. Start request $this->_cr");

        $response = $this->_callWSs('ReportsDownload', $params);

        return $response;
	}


    public function getProducts($reportRequestId)
    {
    	if($reportRequestId != NULL)
    	{
    		sleep(2);
    		//if the reportreqquestid is not null,check the status of the report
    		$status = $this->getReportRequestList($reportRequestId);
    		//$status = '_DONE_';
    		if($status == '_DONE_')
    		{
    			//if the status is _DONE_,that means the report has been ready,we can download it now.
    			//get the report id
    			sleep(1);
    			$reportId = $this->getReportList($reportRequestId);

    			if($reportId != NULL)
    			{
    				sleep(1);
    				$response = $this->getReport($reportId);

    				//parse the $response,and retrieve the details from product advertising API
    				//$products = explode(' ',$response);
    				$products = preg_split("/\s+/",$response);

    				return $response;
    			}
    		}
    	}
    }


	/*
	 * sign request
	 */
	private function aws_signed_request($params, $public_key, $private_key)
	{
	    // some parameters
	    $method = "GET";
	    $host = "ecs.amazonaws.".$this->region;
	    $uri = "/onca/xml";

	    // additional parameters
	    $params["Service"] = "AWSECommerceService";
	    $params["AWSAccessKeyId"] = $public_key;
	    // GMT timestamp
	    $params["Timestamp"] = gmdate("Y-m-d\TH:i:s\Z",time());  //may not be more than 15 minutes out of date!
	    // API version
	    $params["Version"] = "2009-03-31";

	    // sort the parameters
	    ksort($params);

	    // create the canonicalized query
	    $canonicalized_query = array();
	    foreach ($params as $param=>$value)
	    {
	        $param = str_replace("%7E", "~", rawurlencode($param));
	        $value = str_replace("%7E", "~", rawurlencode($value));
	        $canonicalized_query[] = $param."=".$value;
	    }
	    $canonicalized_query = implode("&", $canonicalized_query);

	    // create the string to sign
	    $string_to_sign = $method."\n".$host."\n".$uri."\n".$canonicalized_query;

	    // calculate HMAC with SHA256 and base64-encoding
	    $signature = base64_encode(hash_hmac("sha256", $string_to_sign, $private_key, True));

	    $signature = rawurlencode($signature);

	    // create request
	    $request = "http://".$host.$uri."?".$canonicalized_query."&Signature=".$signature;

	    return $request;
}
	private function getProductDetails($ItemId)
	{
		$parameters=array(
		    'Operation'       => 'ItemLookup',
			//'SearchIndex'     => 'Books',
			//'Condition' => 'All',
			'ItemId' => $ItemId,
		    'ResponseGroup'   =>'ItemAttributes,BrowseNodes,Images,EditorialReview',  //Small, Medium, Large or SellerListing---ItemAttributes,BrowseNodes,Offers
			'MerchantId' => $this->mid,
		  );

		  $A=$this->aws_request($parameters,null);

		  $products = array();

		  if($A != NULL)
		  {
		  	  $ASIN = '';
		  	  $DetailPageURL = '';
		  	  $EAN = '';
		  	  $Manufacturer = '';
		  	  $UPC = '';
		  	  $ProductName = '';
		  	  $Supplier = '';
		  	  $SmallImage = '';
		  	  $MediumImage = '';
		  	  $LargeImage = '';
		  	  $Brand = '';
		  	  $Width = '';
		  	  $Height = '';
		  	  $Weight = '';
		  	  $Length = '';

		      if($A->ItemLookupResponse != NULL && $A->Items[0] != NULL)
		      {
		          for ($i = 0; $i < count($A->Items[0]->Item); $i++) {
		          	  $Productitem = new ProductEntity();

		              $ASIN = $A->Items[0]->Item[$i]->ASIN;
		              $Brand = $A->Items[0]->Item[$i]->ItemAttributes->Brand;
		              $DetailPageURL = $A->Items[0]->Item[$i]->DetailPageURL;
		              $EAN = $A->Items[0]->Item[$i]->ItemAttributes->EAN;
		              $SmallImage = $A->Items[0]->Item[$i]->SmallImage->URL;
		              $MediumImage = $A->Items[0]->Item[$i]->MediumImage->URL;
		              $LargeImage = $A->Items[0]->Item[$i]->LargeImage->URL;
		              $Manufacturer = $A->Items[0]->Item[$i]->ItemAttributes->Manufacturer;
		              $Productitem->Tags = $Manufacturer.' ';
		              $UPC = $A->Items[0]->Item[$i]->ItemAttributes->UPC;
		              $ProductName = $A->Items[0]->Item[$i]->ItemAttributes->Title;
		              $Width = $A->Items[0]->Item[$i]->ItemAttributes->PackageDimensions->Width;
		              $Height = $A->Items[0]->Item[$i]->ItemAttributes->PackageDimensions->Height;
		              $Length = $A->Items[0]->Item[$i]->ItemAttributes->PackageDimensions->Length;
		              $Weight = $A->Items[0]->Item[$i]->ItemAttributes->PackageDimensions->Weight;


		              for($j=0;$j<count($A->Items[0]->Item[$i]->BrowseNodes[0]);$j++)
		              {
		                  if($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->Name != NULL)
		                  {
		                      if(!array_key_exists(strval($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->BrowseNodeId),$Productitem->Categories))
		                      {
		                           $Productitem->Categories[strval($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->BrowseNodeId)] =
		                           							addslashes($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->Name);
		                           $Productitem->CategoryIds[] = $A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->BrowseNodeId;

		                      }

		                  	  if(!array_key_exists(strval($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->BrowseNodeId),$Productitem->Category))
		                      {
		                           $Productitem->Category[strval($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->BrowseNodeId)] =
		                           							addslashes($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->Name);
		                      }

		                      //BrowseNodeId
		                      $Productitem->Tags = $Productitem->Tags.addslashes($A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->Name).' ';
		                      break;
		                  }

		                  //$ancestor = $A->Items[0]->Item[$i]->BrowseNodes[0]->BrowseNode[$j]->Ancestors;

		                  /*while($ancestor != NULL)
		                  {
		                      if($ancestor->BrowseNode != NULL && $ancestor->BrowseNode->Name != NULL)
		                      {
			                      if(!array_key_exists(strval($ancestor->BrowseNode->BrowseNodeId),$Productitem->Categories))
			                      {
			                           //$Productitem->CategoryIds[] = $ancestor->BrowseNode->BrowseNodeId;
			                      }
		                      }

		                      $ancestor = $ancestor->Ancestors;
		                  }*/
		              }

		          	  for($k=0;$k<count($A->Items[0]->Item[$i]->ImageSets[0]);$k++)
		              {
		                  if($A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k] != NULL)
		                  {
		                  	  $isSwatchImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->SwatchImage->URL;
		                  	  $isSmallImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->SmallImage->URL;
		                  	  $isThumbnailImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->ThumbnailImage->URL;
		                  	  $isTinyImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->TinyImage->URL;
		                  	  $isMediumImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->MediumImage->URL;
		                  	  $isLargeImage = $A->Items[0]->Item[$i]->ImageSets[0]->ImageSet[$k]->LargeImage->URL;

		                  	  //array_push($Productitem->Images,$isSwatchImage.','.$isSmallImage.','.$isThumbnailImage.','.$isTinyImage.','.$isMediumImage.','.$isLargeImage);
							  array_push($Productitem->Images,$isLargeImage);

		                  }
		              }

		           	  for($o=0;$o<count($A->Items[0]->Item[$i]->EditorialReviews[0]);$o++)
		              {
		                  if($A->Items[0]->Item[$i]->EditorialReviews[0]->EditorialReview[$o] != NULL)
		                  {
		                  	  if($A->Items[0]->Item[$i]->EditorialReviews[0]->EditorialReview[$o]->Source == 'Product Description');
		                  	  {
		                  	      $Productitem->Description = addslashes($A->Items[0]->Item[$i]->EditorialReviews[0]->EditorialReview[$o]->Content);
		                  	      break;
		                  	  }
		                  }
		              }

		              $Productitem->ASIN = $ASIN;
		              $Productitem->DetailPageURL = $DetailPageURL;
		              $Productitem->EAN = $EAN;
		              $Productitem->Manufacturer = $Manufacturer;
		              $Productitem->UPC = $UPC;
		              $Productitem->ProductName = substr($ProductName,0,128);
		              $Productitem->SmallImage = $SmallImage;
		              $Productitem->MediumImage = $MediumImage;
		              $Productitem->LargeImage = $LargeImage;
		              $Productitem->Supplier = $Brand;
		              $Productitem->Condition = 'New';
		              $Productitem->Width = $Width;
		              $Productitem->Height = $Height;
		              $Productitem->Length = $Length;
		              $Productitem->Weight = $Weight;
		              $Productitem->Tags = $Productitem->Tags.implode(' ',preg_split("/\s+/",$ProductName));

		              $products[] = $Productitem;
		          }
		      }
		  }

		  return $products;
	}
	/*
	 * download data from server
	 */
	private function file_get_contents_curl($servers)
	{
			$session = curl_init($servers);
			curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
			//curl_setopt($session, CURLOPT_PROXY,'http://web-proxy.corp.hp.com:8088');// $_POST["proxy"]);//''
			$response_h = curl_exec($session);
			curl_close($session);
			return $response_h;
	}

	/*
	 * get timestamp
	 */
	private function getFormattedTimestamp($dateTime) {
    	return $dateTime->format(DATE_ISO8601);
  	}

  	/*
  	 * download response callback
  	 */
 	private function responseCallback($ch, $string) {
  		$httpStatusCode = (int) curl_getinfo($this->curlHandle, CURLINFO_HTTP_CODE);
	  	// For unsuccessful responses, i.e. non-200 HTTP responses, we write the response body
	  	// into a separate stream.
	  	if ($httpStatusCode == 200) {
	  		return fwrite($this->responseBodyContents, $string);
	  	} else {
	  		return NULL;
	  	}


    }

    /*
     * header callback
     */
 	private function headerCallback($ch, $string) {
    	$bytesWritten = fwrite($this->headerContents, $string);
    	return $bytesWritten;
    }

    /*
     * parse http header
     */
	private function parseHttpHeader($header) {
	    $parsedHeader = array ();
	    foreach (explode("\n", $header) as $line) {
	      $splitLine = preg_split('/:\s/', $line, 2, PREG_SPLIT_NO_EMPTY);

	      if (sizeof($splitLine) == 2) {
	        $parsedHeader[trim($splitLine[0])] = trim($splitLine[1]);
	      }
	    }

	    return $parsedHeader;
	  }

	/*
	 * construct request to aws
	 */
    private function aws_request($parameters,$type) {

	  ksort($parameters);

	  $file=$this->aws_signed_request($parameters,$this->amAdvKey,$this->amAdvSecret);

	   try {
	   		$filecontents=$this->file_get_contents_curl($file);
	   } catch (Exception $e) {
	   		echo("Caught Exception: " . $e->getMessage() . "\n");
	   }

	  if ($A=simplexml_load_string($filecontents));  //decode the XML to an object
	  else
	  {
	  	echo("can't decode the XML data");
	  }

	  return $A;
	}

}

//PlacedOrder class.
//Items of this class can be generated from GetOrdersList() function of the Service class.
class PlacedOrder
{

    public $AmazonOrderId; //String, This value can be used for order shipment or for order cancelation
    public $OrderStatus;
    public $PurchaseDate; //String, The date when the customer placed the order.
    public $OrderTotalCurrency;
    public $OrderTotalAmount;
    public $ShipServiceLevel; //String.
    public $FulfillmentChannel; //String.
    public $SalesChannel;
    public $NumberOfItemsUnshipped;
    public $NumberOfItemsShipped;
    public $MarketPlaceId;
    public $BuyerEmail;
    public $BuyerName;
    public $Address; // Type: AddressInTheOrder. Instance Of the AddressInTheOrder class. Address where we send our order
    public $Items; // Type: Array of the OrderedItem class instances. Ordered products, array of the OrderedItem class instances.
    public $_debug;

    public function __construct(SimpleXMLElement $order, $Items, $debug = false)
    {
        if ($debug == true) $this->_debug = true;
        else $this->_debug = false;


        $this->AmazonOrderId = (string)$order->AmazonOrderId;
        $this->OrderStatus = (string)$order->OrderStatus;
        $this->PurchaseDate = (string)$order->PurchaseDate;
        $this->OrderTotalCurrency = (string)$order->OrderTotal->CurrencyCode;
        $this->OrderTotalAmount = (string)$order->OrderTotal->Amount;
        $this->ShipServiceLevel = (string)$order->ShipServiceLevel;
        $this->FulfillmentChannel = (string)$order->FulfillmentChannel;
        $this->SalesChannel = (string)$order->SalesChannel;
        $this->NumberOfItemsUnshipped = (string)$order->NumberOfItemsUnshipped;
        $this->NumberOfItemsShipped = (string)$order->NumberOfItemsShipped;
        $this->MarketPlaceId = (string)$order->MarketplaceId ;
        $this->BuyerEmail = (string)$order->BuyerEmail;
        $this->BuyerName = (string)$order->BuyerName;

        //if ($order->ShippingAddress != NULL)
            $this->Address = new AddressInTheOrder($order->ShippingAddress);
        //else
        //    $this->Address = null;

        //Set Ordered items (products)
        if ($Items !== null)
        {
            $this->Items = array();
            for ($i=0; ; $i++)
            {
            if ($Items->OrderItem[$i] !== null)
                $this->Items[$i] = new OrderedItem($Items->OrderItem[$i]);
            else
                break;
            }
        }
        else
            $this->Items = NULL;

        //just for a test

        if ($this->_debug) $this->printing();

    }

    public function printing()
    {
        echo "Order:<br>\n";
        echo "AmazonOrderId: $this->AmazonOrderId, PurchaseDate: $this->PurchaseDate, ShipServiceLevel: $this->ShipServiceLevel, FullFillmentChannel: $this->FulfillmentChannel, NumberOfItemsUnshipped: $this->NumberOfItemsUnshipped <br>";
        //shipping address printing
        $this->Address->printing();
        
        printf('Items: %s' . "<br>\n", nl2br(print_r($this->Items, true))) ;

        for ($i=0; $i<count($this->Items); $i++)
            $this->Items[$i]->printing();
    }
}

class AddressInTheOrder
{
    public $Name;
    public $AddressLine1;
    public $AddressLine2;
    public $City;
    public $StateOrRegion;
    public $PostalCode;
    public $CountryCode;
    public $Phone;

    public function  __construct(SimpleXMLElement $Address) {
        $this->Name = (string)$Address->Name;
        $this->AddressLine1 = (string)$Address->AddressLine1;
        $this->AddressLine2 = (string)$Address->AddressLine2;
        $this->City = (string)$Address->City;
        $this->StateOrRegion = (string)$Address->StateOrRegion;
        $this->PostalCode = (string)$Address->PostalCode;
        $this->CountryCode = (string)$Address->CountryCode;
        $this->Phone = (string)$Address->Phone;
    }

    //just for a test
    public function printing()
    {
        echo "Address:<br>";
        echo ("Name: $this->Name, AddressLine1: $this->AddressLine1, AddressLine2: $this->AddressLine2,
                City: $this->City, StateOrRegion: $this->StateOrRegion, PostalCode: $this->PostalCode,
                CountryCode: $this->CountryCode, Phone: $this->Phone ");
        echo "<br>";
    }
}

class OrderedItem
{
    public $ASIN; //The Amazon Standard Identification Number (ASIN) of the item.
    public $SKU;
    public $Title; //Title of the Item
    public $QuantityOrdered; //Number of products of this type we need to ship
    public $ItemPriceCurrency;
    public $ItemPriceAmount;
    public $ShippingPriceCurrency;
    public $ShippingPriceAmount;
    public $QuantityShipped;
    public $GifWrapPrice;

    public $TaxesInformation;

    public function  __construct(SimpleXMLElement $Item) {
        $this->ASIN = (string)$Item->ASIN;
        $this->SKU = (string)$Item->SellerSKU;
        $this->Title = (string)$Item->Title;
        $this->QuantityOrdered = (string)$Item->QuantityOrdered;
        $this->QuantityShipped = (string)$Item->QuantityShipped;
        $this->ItemPriceCurrency = (string)$Item->ItemPrice->CurrencyCode;
        $this->ItemPriceAmount = (string)$Item->ItemPrice->Amount;
        $this->ShippingPriceCurrency = (string)$Item->ShippingPrice->CurrencyCode;
        $this->ShippingPriceAmount = (string)$Item->ShippingPrice->Amount;
        
        if ( isset($Item->GiftWrapPrice->Amount) && floatval($Item->GiftWrapPrice->Amount) )
             $this->GifWrapPrice = (string)$Item->GiftWrapPrice->Amount;
        else $this->GifWrapPrice = null ;
        
        $this->TaxesInformation = new InfoTaxesItems($Item->ItemTax->CurrencyCode, $Item->ItemTax->Amount,
                $Item->ShippingTax->CurrencyCode, $Item->ShippingTax->Amount,
                $Item->GiftWrapTax->CurrencyCode, $Item->GiftWrapTax->Amount, false);
    }

    public function printing()
    {
        echo ("Item in the order:<br>");
        echo ("ASIN: $this->ASIN, SKU: $this->SKU, Title:
                $this->Title, QuantityOrdered: $this->QuantityOrdered, ItemPriceCurrency: $this->ItemPriceCurrency, ItemPriceAmount: $this->ItemPriceAmount, ShippingPriceCurrency: $this->ShippingPriceCurrency, ShippingPriceAmount: $this->ShippingPriceAmount .");
        echo ("<br>Tax information for this item:");
        $this->TaxesInformation->printing();
        echo ("Item output ends here.<br>");
    }
}

class InfoTaxesItems
{
    public $ItemTaxCurrencyCode;
    public $ItemTaxAmount;
    public $ShippingTaxCurrencyCode;
    public $ShippingTaxAmount;
    public $GiftWrapTaxCurrencyCode;
    public $GiftWrapTaxAmount;

    public $_debug;
    public $_cr;

    public function  __construct($itcc, $ita, $stcc, $sta, $gwtcc, $gwta, $debug = false) {
        if ($debug === true) $this->_debug = true;
        else $this->_debug = false;

        $this->_cr = "<br>";

        if ($this->_debug) printf ("$this->_cr __construct starts to create instance of the Taxes class. $this->_cr");

        $this->ItemTaxCurrencyCode = (string)$itcc;
        $this->ItemTaxAmount = (string)$ita;
        $this->ShippingTaxCurrencyCode = (string)$stcc;
        $this->ShippingTaxAmount = (string)$sta;
        $this->GiftWrapTaxCurrencyCode = (string)$gwtcc;
        $this->GiftWrapTaxAmount = (string)$gwta;

        if ($this->_debug)
        {
            printf("$this->_cr Created object: $this->_cr");
            $this->printing();
            printf("$this->_cr Construct function finishes here $this->_cr");
        }
    }

    public function printing()
    {
        printf ("$this->_cr printing() function output starts here. It writes information, that contain object (NULL if not presentd): $this->_cr
                ItemTaxCurrencyCode: $this->ItemTaxCurrencyCode $this->_cr
                ItemTaxAmount $this->ItemTaxAmount $this->_cr
                ShippingTaxCurrencyCode: $this->ShippingTaxCurrencyCode $this->_cr
                ShippingTaxAmount: $this->ShippingTaxAmount $this->_cr
                GiftWrapTaxCurrencyCode $this->GiftWrapTaxCurrencyCode $this->_cr
                GiftWrapTaxAmount: $this->GiftWrapTaxAmount $this->_cr
                printing() function output finishes here. $this->_cr");
    }
}
?>
