<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

require_once(dirname(__FILE__) . '/../../amazon.php');
require_once(dirname(__FILE__) . '/../../classes/amazon.tools.class.php');


class AdminAmazonProductsController extends ModuleAdminController 
{
        public $module = 'amazon' ;
        public $name = 'amazon' ;
        
	public function __construct()
	{
            $this->path = _PS_MODULE_DIR_ . $this->module . '/' ;

            $this->className = 'amazon';
            $this->display = 'edit' ;
            
            $this->multishop_context = Shop::CONTEXT_ALL ;
            $this->id_lang = (int)Context::getContext()->language->id ;
            
            $this->lang = true;
            $this->deleted = false;
            $this->colorOnBackground = false;

            $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/' ;
            $this->images =  $this->url . 'images/' ;
        
            $this->context = Context::getContext();
            $this->bootstrap = true;

            parent::__construct();
            
            if (version_compare(_PS_VERSION_, '1.6', '>='))
                $this->psIs16x = true;
            else
                $this->psIs16x = false;
	}
	
	public function renderForm()
	{
            $html   = null ;
            $html  .=  $this->tabHeader() ;
            
            $this->context->smarty->assign('psIs16', $this->psIs16x);
            
            $html  .= $this->languageSelector() ;

            if ($this->psIs16x)
                $this->addCSS($this->url.'css/ProductsAmazon16.css', 'screen');
            else
                $this->addCSS($this->url.'css/ProductsAmazon.css', 'screen');

            $this->addJS($this->url . 'js/products.js') ;

            if ( Amazon::enableExperimentalFeatures )
                $this->addJS($this->url . 'js/automaton.js') ;

            $this->context->smarty->assign('path', $this->url) ;
            $this->context->smarty->assign('images', $this->images) ;
            $this->context->smarty->assign('selected_tab', 'informations') ;
            $this->context->smarty->assign('expert_mode', (bool) Amazon::configurationGet('AMAZON_HIDDEN_SETTINGS')) ;
            
            $html  .= $this->context->smarty->fetch($this->path . 'views/AdminCatalogAmazon.tpl');

            return $html . $this->content . parent::renderForm();
	}
	
        public function tabHeader() 
        {
            $this->context->smarty->assign('images', $this->images) ;
            
            $amazonTokens = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CRON_TOKEN')));
            
            $this->context->smarty->assign('tokens', $amazonTokens) ;    
            $this->context->smarty->assign('path', $this->url) ;    
            $this->context->smarty->assign('update_url', $this->url . 'functions/products.php') ;    
            $this->context->smarty->assign('automaton_url', $this->url . 'functions/automaton.php') ;    
            $this->context->smarty->assign('report_url', $this->url . 'functions/products_report.php') ;    

            $this->context->smarty->assign('img_loader', $this->images . 'loading.gif') ;    
            $this->context->smarty->assign('current_date', date('Y-m-d H:i:s')) ;    
            $this->context->smarty->assign('id_lang', $this->id_lang) ;    

            $documentation = Amazon_Tools::documentation($this->id_lang) ;
            $faq = Amazon_Tools::documentation($this->id_lang, 'faq') ;
            
            $this->context->smarty->assign('documentation', $documentation) ;
            $this->context->smarty->assign('faq', $faq) ;            
            
            return( $this->context->smarty->fetch( $this->path . 'views/items/catalog_header.tpl') ) ;
        }
        public function languageSelector()
        {
            $html = null ;
            
            $this->addCSS($this->url.'/css/country_selector.css', 'screen');
            
            $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));
            $regions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
            
            $marketplaces = array() ;
            
            if ( is_array($actives) )
                foreach (Amazon_Tools::languages() as $language)
                {
                    $id_lang = $language['id_lang'];

                    if ( ! isset($actives[$id_lang]) || ! $actives[$id_lang] )          continue ;
                    
                    if ( ! isset($regions[$id_lang]) || empty($regions[$id_lang]) )     continue ;
                    
                    $marketplaces[$id_lang] = array() ;
                    $marketplaces[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                    $marketplaces[$id_lang]['region'] = $regions[$id_lang] ;
                    $marketplaces[$id_lang]['id_lang'] = $id_lang ;
                    $marketplaces[$id_lang]['lang'] = $language['iso_code'] ;
                    $marketplaces[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;
                }
            $this->context->smarty->assign('psIs16', $this->psIs16x);    
            $this->context->smarty->assign('images', $this->images) ;
            $this->context->smarty->assign('marketplaces', $marketplaces) ;
            
            return( $this->context->smarty->fetch( $this->path . 'views/items/country_selector.tpl') ) ;
        }

}