<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    @require_once(dirname(__FILE__) . '/../../../init.php');
}
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonAutomatonProcess
{
    public $requestReportTime ; 
    public $reportTime ; 
    public $requestId ; 
    public $reportProcessingStatus ; 
    public $reportId ;
    public $step ;
    public $title ;
    public $message ;
    public $flag ;
    public $marketplace ;
    public $resubmitTimer ;
    public $completedDate ;
    public $loader ;
}

class AmazonAutomaton extends Amazon
{
    private $_debug = true ;
    
    static protected $errors = array();
    static protected $log = array();
    static protected $xml = null ;
    
    protected $import = null ;
    protected $ws = null ;
    
    protected $file_inventory = null ;
    protected $amazon_id_lang = null ;
    protected $marketplaceId  = null ;
    
    static protected $process = null ;
    
    const MERCHANT_OPEN_LISTINGS_DATA = 'open_listings_data' ;
    
    const STEP_REPORT_REQUEST = 1 ;
    const STEP_GET_REPORT_REQUEST_LIST = 2 ;
    const STEP_GET_REPORT = 3 ;
    const STEP_PROCESS_REPORT = 4 ;
    const STEP_COMPLETED = 5 ;
    const STEP_NOTHING = 9 ;
    
    const ONE_DAY  = 86400 ;
    const ONE_HOUR = 3600 ;
    const TWO_HOURS = 7200 ;

    const ONE_MINUTE = 60 ;
    const TWO_MINUTES = 120 ;
    const FIVE_MINUTES = 300 ;
    const NOW = 1 ;
    
    protected static $steps = array(
        self::STEP_COMPLETED => 'STEP_COMPLETED',
        self::STEP_REPORT_REQUEST => 'REPORT_REQUEST',
        self::STEP_GET_REPORT_REQUEST_LIST => 'GET_REPORT_REQUEST_LIST',
        self::STEP_GET_REPORT => 'GET_REPORT',
        self::STEP_PROCESS_REPORT => 'STEP_PROCESS_REPORT',
        self::STEP_NOTHING => 'NOTHING'
    ) ;
    
    public function __construct()
    {
        if ( ! Amazon::enableExperimentalFeatures )
            die ;

        register_shutdown_function( array('AmazonAutomaton', 'JSON_Display_Exit') ) ;

        parent::__construct();
        
        $this->initImportDirectory() ;
    }
    
    private function initImportDirectory()
    {
        $this->import = $this->path . 'import/' ;

        if ( ! is_dir($this->import) )
        {
            if ( ! @mkdir($this->import) )
            {
                self::$errors[] = sprintf('%s(#%d): %s', $this->l('Unable to create import directory')) ;
                die;
            }
        }
        
        @chmod($this->import, 0777) ;
        
        if ( file_put_contents($this->import . '.htaccess', "deny from all\n") === false )
        {
            self::$errors[] = sprintf('%s(#%d): %s', $this->l('Unable to write into import directory')) ;
            die;
        }
    }
    
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    static public function JSON_Display_Exit()
    {
        if ( $result = ob_get_clean() )
            $output = $result ;
        else
            $output = null ;
        
        $json = Amazon_Tools::jsonEncode(
                    array( 
                            'error' => (count(AmazonAutomaton::$errors) ? true : false), 
                            'errors' => AmazonAutomaton::$errors, 
                            'xml' => AmazonAutomaton::$xml, 
                            'process' => self::$process,
                            'output' => $output 
                        ));
        
        if ( $callback = Tools::getValue('callback') ) // jquery
        {
            if ( $callback == '?' )
                $callback = 'jsonp_' . time() ;
            
            echo strval($callback) . '(' . $json . ')';
            die;
        }
        else // cron
        {
            echo "<pre>" ;
            echo $json;
            echo "</pre>" ;
            die;
        }        
    }
    public function Dispatch()
    {
        ob_start() ;
   
        if (Tools::getValue('debug') == true)
            $this->_debug = true;
        else
            $this->_debug = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG'))) ? true : false;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        
        switch ( Tools::getValue('action') )
        {
            case 'discover-wizard' :
                $this->DiscoverWizard() ;
                break;
            default :
                $this->AsinSynchronization();
                break;
        }
    }

    
    protected static function isExpired($timestamp, $expiration = 3600)
    {
        $now = time() ;
        
        if ( ! $timestamp )
            return(true) ;
        
        if ( $now - $timestamp > $expiration )
            return(true) ;
        
        return(false) ;
    }
    
    public function debugXML($xml)
    {
        $dom = dom_import_simplexml($xml)->ownerDocument;
        $dom->formatOutput = true;

        $output  = "<pre>" ;
        $output .= htmlspecialchars($dom->saveXML()) ;
        $output .= "</pre>" ;    
        
        return($output) ;
    }    
    
    public function DiscoverWizard()
    {
        if ( !($this->amazon_id_lang = Tools::getValue('amazon_lang')) )
        {
            self::$errors[] = sprintf('%s(#%d): %s', basename(__FILE__), __LINE__, $this->l('Required parameter: amazon_lang')) ;
            die ;
        }     
        
        $amazon_synch = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ASIN_SYNCHRONIZATION'))) ;
        
        if ( ! is_array($amazon_synch) )
            $amazon_synch = array() ;
        
        if ( isset($amazon_synch[$this->amazon_id_lang]) )
        {
            self::$process = $amazon_synch[$this->amazon_id_lang] ;
            
            if ( ! self::$process instanceOf AmazonAutomatonProcess )
                self::$process = new AmazonAutomatonProcess() ;            
        }
        else
        {
            self::$process = new AmazonAutomatonProcess() ;
        }
       
        self::$process->resubmitTimer = self::TWO_MINUTES ;
        self::$process->message = null ;
       
        if ( self::$process->completedDate && ! self::isExpired(self::$process->completedDate, self::ONE_DAY) )
        {
            $productsToCreate = Amazon_Product::getProductsToCreate($this->amazon_id_lang) ;

             if ( is_array($productsToCreate) && count($productsToCreate) )
             {
                 $productsToCreateUniq = array();

                foreach ($productsToCreate as $product)
                {
                    $productsToCreateUniq[$product['id_product']] = true;
                }
                foreach ($productsToCreateUniq as $id_product => $is_true)
                {
                    Amazon_Product::marketplaceActionSet(Amazon::Add, (int)$id_product, null, null, $this->amazon_id_lang) ; 
                }
                if (($count = count($productsToCreateUniq)))
                {
                    self::$process->message = sprintf('%d %s', $count, $this->l('products discovered, marked as to be created on Amazon'));
                }
             }            
        }
    }
    
    public function AsinSynchronization()
    {
        if (Tools::getValue('force') == true)
            $forceUpdate = true;
        else
            $forceUpdate = false;

        if ( !($this->amazon_id_lang = Tools::getValue('amazon_lang')) )
        {
            self::$errors[] = sprintf('%s(#%d): %s', basename(__FILE__), __LINE__, $this->l('Required parameter: amazon_lang')) ;
            die ;
        } 

        $amazon = Amazon_Tools::selectPlatforms($this->amazon_id_lang, 0) ;

        if (!($this->ws = new Amazon_WebService($amazon['auth'], $amazon['params'], null, 0)))
        {
            self::$errors[] = sprintf('%s(#%d): %s', $this->l('Unable to init Amazon Service')) ; 
            die;
        }
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));

        if ( ! isset($marketPlaceIds[$this->amazon_id_lang]) || ! $marketPlaceIds[$this->amazon_id_lang] )
        {
            $lang = new Language($this->amazon_id_lang) ;
            self::$errors[] = sprintf('%s(#%d): %s "%s"', $this->l('Marketplace is not yet configured for'), $lang->name) ;
            die ;            
        }
        $this->marketplaceId = trim($marketPlaceIds[$this->amazon_id_lang]);
        
        $region = $amazon['params']['Country'] ;
        $flag   = '<img src="' . $this->images . 'geo_flags/' . $region . '.gif" alt="Amazon ' . strtoupper($region) . '" />' ;
        $title  = sprintf('%s %s', $this->l('Amazon Marketplace Automaton started on'), Amazon_Tools::displayDate(date('Y-m-d h:i:s'), $this->id_lang, true)) ;
        
        $this->file_inventory = sprintf('%s%s_%s.raw', $this->import, self::MERCHANT_OPEN_LISTINGS_DATA, $region) ;

        $amazon_synch = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ASIN_SYNCHRONIZATION'))) ;

        if ( ! is_array($amazon_synch) )
            $amazon_synch = array() ;
        
        if ( isset($amazon_synch[$this->amazon_id_lang]) )
        {
            self::$process = $amazon_synch[$this->amazon_id_lang] ;
            
            if ( ! self::$process instanceOf AmazonAutomatonProcess )
                self::$process = new AmazonAutomatonProcess() ;            
        }
        else
        {
            self::$process = new AmazonAutomatonProcess() ;
        }
            
        if ( self::$process->requestReportTime && self::isExpired(self::$process->requestReportTime, self::ONE_DAY) )
        {
            self::$process = new AmazonAutomatonProcess() ;
        }

        switch( self::$process->step )
        {
            case self::STEP_NOTHING :
                break ;
                
            case self::STEP_COMPLETED :
                if ( self::$process->completedDate && self::isExpired(self::$process->completedDate, self::ONE_DAY) )
                {
                    $message = $this->l('Start next processing now') ;
                    self::$process = new AmazonAutomatonProcess() ;
                    self::$process->resubmitTimer = self::ONE_MINUTE ;
                    self::$process->step = self::STEP_REPORT_REQUEST ;
                    self::$process->loader = 1 ;
                    self::$process->message = $message ;
                }
                else
                {
                    $now = time() ;
                    $elapsed = $now - self::$process->completedDate ;
                    $remaining = self::ONE_DAY - $elapsed ;
                    $message = sprintf('%s: %s', $this->l('Inventory processing completed, next processing'), Amazon_Tools::displayDate(date('Y-m-d H:i:s', $now + $remaining), $this->id_lang, true)) ;
                    self::$process->message = $message ;
                    self::$process->loader = 0 ;
                    self::$process->resubmitTimer = self::FIVE_MINUTES ;                    
                }
                
                break ;
                
            case self::STEP_PROCESS_REPORT :
                if ( $this->ProcessInventory() )
                {
                    self::$process->resubmitTimer = self::ONE_MINUTE ;
                    self::$process->completedDate = time() ;
                    self::$process->step = self::STEP_COMPLETED ;
                    self::$process->message = $this->l('Inventory processing completed') ;
                    self::$process->loader = 1 ;
                }
                else
                {
                    self::$process->resubmitTimer = self::ONE_HOUR ;
                    self::$process->loader = 1 ;
                }
            
                break ;
                
            case self::STEP_GET_REPORT ;
                
                if ( $this->Steps(self::STEP_GET_REPORT) )
                {
                    self::$process->step = self::STEP_PROCESS_REPORT ;
                    self::$process->resubmitTimer = self::NOW ;
                    self::$process->message = $this->l('File downloaded successfully, wait for processing') ;
                }
                else
                {
                    self::$process = new AmazonAutomatonProcess() ;
                    self::$process->resubmitTimer = self::TWO_HOURS ;
                    self::$process->message = $this->l('Unable to find any inventory, the process will restart in 2 hours') ;
                }
                self::$process->loader = 1 ;
                break ;
                
            case self::STEP_GET_REPORT_REQUEST_LIST ;
                
                if ( $this->Steps(self::STEP_GET_REPORT_REQUEST_LIST) )
                {
                    if ( self::$process->reportId )
                    {
                        self::$process->message = $this->l('The inventory is ready, wait for processing') ;
                        self::$process->step = self::STEP_GET_REPORT ; 
                    }
                    else
                    {
                        self::$process->message = $this->l('Wait for the inventory, it should take a while, up to 20 minutes') ;
                    }
                }
                else
                {
                    $message = $this->l('Unable to find any inventory, the process will restart in 2 hours') ; 
                    self::$process = new AmazonAutomatonProcess() ;
                    self::$process->resubmitTimer = self::TWO_HOURS ;                    
                    self::$process->message = $message ;
                }
                self::$process->loader = 1 ;
                break ;
                
            case self::STEP_REPORT_REQUEST ; 
            default :

                self::$process->step = self::STEP_REPORT_REQUEST ;
                self::$process->message = $this->l('Requesting an inventory to Amazon') ;
                
                if ( $this->Steps(self::STEP_REPORT_REQUEST) )
                {
                    if ( self::$process->requestId )
                    {
                        self::$process->step = self::STEP_GET_REPORT_REQUEST_LIST ;   
                        self::$process->message = $this->l('Request has been accepted, wait for processing') ;
                        self::$process->resubmitTimer = self::ONE_MINUTE ;
                    }
                    else
                    {
                        self::$process->message = $this->l('Request failed, the request will be resubmitted in a while') ;
                        self::$process->resubmitTimer = self::TWO_HOURS ;
                    }
                }
                self::$process->loader = 1 ;
                break ;
        }

        self::$process->title = $title ;
        self::$process->flag = $flag ;
        self::$process->marketplace = sprintf('Amazon %s', strtoupper($region)) ;
        
        $amazon_synch[$this->amazon_id_lang] = self::$process ;

        Amazon::configurationUpdateValue('AMAZON_ASIN_SYNCHRONIZATION', base64_encode(serialize($amazon_synch))) ;
    }
    
    /*
     * 
     * PART 1 - Get Asynchronously the Inventory Report From Amazon
     * 
     */
    protected function Steps($step)
    {
        $pass = false ;
        
        self::$process->resubmitTimer = null ;
        
        switch($step)
        {
            // Request Report Generation 
            // 
            case self::STEP_REPORT_REQUEST :
                
                if ( ! $this->reportRequest() )
                {
                    self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
                    return(false);
                }
                $pass = true ;            
                break ;
                
            // Wait for the Report Id
            //
            case self::STEP_GET_REPORT_REQUEST_LIST :
                
                if ( ! $this->reportRequestList() )
                {
                    self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
                    return(false);
                }
                switch(self::$process->reportProcessingStatus)
                {
                    case '_SUBMITTED_' :
                    case '_IN_PROGRESS_' :
                        self::$process->resubmitTimer = self::TWO_MINUTES ;
                        $pass = true ;
                        return(true) ;
                    case '_CANCELLED_' :
                    case '_DONE_NO_DATA_' :
                        self::$process = new AmazonAutomatonProcess() ;
                        $pass = false;                         
                        exit ;

                    case '_DONE_' : 
                        self::$process->resubmitTimer = self::NOW ;
                        $pass = true ;
                        break ;                    
                }
                break ;   
                
            // Download Report
            // 
            case self::STEP_GET_REPORT :
                
                if ( ! $this->getReport() )
                {
                    self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
                    return(false);
                }
                $pass = true ;            
                break ;
                
        }
        return($pass) ;
    }
    /*
    <RequestReportResponse xmlns="http://mws.amazonaws.com/doc/2009-01-01/">
      <RequestReportResult>
        <ReportRequestInfo>
          <ReportRequestId>6859793590</ReportRequestId>
          <ReportType>_GET_MERCHANT_OPEN_LISTINGS_DATA_</ReportType>
          <StartDate>2013-11-15T10:03:30+00:00</StartDate>
          <EndDate>2013-11-15T10:03:30+00:00</EndDate>
          <Scheduled>false</Scheduled>
          <SubmittedDate>2013-11-15T10:03:30+00:00</SubmittedDate>
          <ReportProcessingStatus>_SUBMITTED_</ReportProcessingStatus>
        </ReportRequestInfo>
      </RequestReportResult>
      <ResponseMetadata>
        <RequestId>c9771d62-972f-4a02-8c3e-f19fd066431e</RequestId>
      </ResponseMetadata>
    </RequestReportResponse>     
     */
    protected function reportRequest()
    {
        $params = array() ;
        $params['Action'] = 'RequestReport' ;
        $params['ReportType'] = '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_' ;
        $params['Version'] = '2009-01-01' ;
        $params['MarketplaceIdList.Id.1'] = $this->marketplaceId ;
                
        $xml = $this->ws->simpleCallWS($params, 'Reports') ;
               
        if ( ! $xml instanceOf SimpleXMLElement OR isset($xlm->Error) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
            return(false) ;
        }     
        
        self::$xml = $this->debugXML($xml) ;
        
        if ( ! isset($xml->RequestReportResult->ReportRequestInfo->ReportProcessingStatus) || ! isset($xml->RequestReportResult->ReportRequestInfo->ReportRequestId) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
            return(false) ;
        }
        if ( $xml->RequestReportResult->ReportRequestInfo->ReportProcessingStatus == '_SUBMITTED_' )
        {
            self::$process->requestReportTime = time() ;
            self::$process->requestId = (string)$xml->RequestReportResult->ReportRequestInfo->ReportRequestId ;   
            return(true) ;
        }
        else
            return(false) ;
    }
    /*
    <GetReportRequestListResult>
      <NextToken/>
      <HasNext>false</HasNext>
      <ReportRequestInfo>
        <ReportRequestId>6839626392</ReportRequestId>
        <ReportType>_GET_MERCHANT_OPEN_LISTINGS_DATA_</ReportType>
        <StartDate>2013-11-13T06:21:51+00:00</StartDate>
        <EndDate>2013-11-13T06:21:51+00:00</EndDate>
        <Scheduled>false</Scheduled>
        <SubmittedDate>2013-11-13T06:21:51+00:00</SubmittedDate>
        <ReportProcessingStatus>_DONE_</ReportProcessingStatus>
        <GeneratedReportId>27152286424</GeneratedReportId>
        <StartedProcessingDate>2013-11-13T06:56:01+00:00</StartedProcessingDate>
        <CompletedDate>2013-11-13T06:56:03+00:00</CompletedDate>
      </ReportRequestInfo>
    */    
    protected function reportRequestList()
    {
        $params = array() ;
        $params['Version'] = '2009-01-01' ;
        $params['Action'] = 'GetReportRequestList' ;
        $params['ReportRequestList.Type.1'] = '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_'; 
        $params['ReportRequestIdList.Id.1'] = self::$process->requestId ;
        
        $xml = $this->ws->simpleCallWS($params, 'Reports') ;
        
        if ( ! $xml instanceOf SimpleXMLElement OR isset($xlm->Error) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
            return(false) ;
        }     
        
        self::$xml = $this->debugXML($xml) ;
        
        if ( ! isset($xml->GetReportRequestListResult->ReportRequestInfo->ReportProcessingStatus) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Failed')) ; 
            return(false) ;
        }
        
        self::$process->reportProcessingStatus = (string)$xml->GetReportRequestListResult->ReportRequestInfo->ReportProcessingStatus ;
        
        if ( isset($xml->GetReportRequestListResult->ReportRequestInfo->GeneratedReportId) && (int)$xml->GetReportRequestListResult->ReportRequestInfo->GeneratedReportId )
        {
            self::$process->reportTime = time() ;
            self::$process->reportId = (string)$xml->GetReportRequestListResult->ReportRequestInfo->GeneratedReportId ;
        }
        return(true) ;
    }

    /*
     * Returns raw result ; CSV Tab separated file
     */
    protected function getReport()
    {
        $params = array() ;
        $params['Version'] = '2009-01-01' ;
        $params['Action'] = 'GetReport' ;
        $params['ReportId'] = self::$process->reportId ; 
        
        $result = $this->ws->simpleCallWS($params, 'Reports', false) ;
        
        if ( empty($result) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Inventory is empty')) ; 
            return(false) ;            
        }
        
        if ( file_put_contents($this->file_inventory, $result) === false )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s (%s)', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Unable to write to output file'), $this->file_inventory) ; 
            return(false) ;                        
        }
    
        return(true) ;
    }    
    
    /*
     * 
     * PART 2 - Manage the Inventory
     * 
     */

    protected function ProcessInventory()
    {
        if ( ($result = file_get_contents($this->file_inventory)) === false )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s (%s)', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Unable to read input file'), $this->file_inventory) ; 
            return(false) ;                         
        }
        if ( $result == null or empty($result) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Inventory is empty !')) ; 
            return(false) ;            
        }

        $lines = explode("\n", $result) ;

        if ( ! is_array($lines) || ! count($lines) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Inventory is empty !')) ; 
            return(false) ;     
        }

        $amazonItems = array() ;
        $count = 0 ;
        
        foreach($lines as $line)
        {
            if ( empty($line) ) continue ;
            if ( $count++ < 1 ) continue ;

            $result = explode("\t", $line) ;

            if ( count(array_keys($result)) < 3 )
                continue ;
            
            list($SKU, $ASIN, $Price, $Qty) = $result ;

            $ASIN = trim($ASIN) ;
            $SKU = trim($SKU) ;
            
            if ( Amazon_Tools::ValidateSKU($SKU) && Amazon_Tools::ValidateASIN($ASIN) )
                $amazonItems[trim($SKU)] = $ASIN ; 
        }
        
        if ( ! is_array($amazonItems) || ! count($amazonItems) )
        {
            self::$errors[] = sprintf('%s(#%d): %s - %s', basename(__FILE__), __LINE__, self::$steps[self::$process->step], $this->l('Inventory is empty !')) ; 
            return(false) ;                
        }
        
        Amazon_Product::populateProductOptions() ;
        
        // Set ASIN in product_options
        //
        foreach($amazonItems as $SKU => $ASIN)
        {
            if ( Amazon_Product::getIdByAsin($this->amazon_id_lang, $ASIN) )
                    continue ;
            
            $product = new Amazon_Product($SKU, false, $this->amazon_id_lang) ;
            
            if ( ! Validate::isLoadedObject($product) )
                continue ;
            
            $count++ ;
            Amazon_Product::updateProductOptions($product->id, $this->amazon_id_lang, 'asin1', $ASIN, $product->id_product_attribute) ;
        }

        return(true);
    }
    
}

$amazonAutomaton = new AmazonAutomaton();
$amazonAutomaton->Dispatch();
?>