<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
}

class ModuleEnvCheck extends Module
{
    protected $__callback ;
    
    public function Dispatch()
    {
        $this->__callback = Tools::getValue('callback') ;
        if ( $this->__callback == '?' || empty($this->__callback) )
            $this->__callback = 'jsonp_' . time() ;
        
        switch (Tools::getValue('action'))
        {
            case 'ajax' :
                $this->AjaxCheck();
                break;
            
            case 'miv' :
                $this->maxInputVarsCheck();
                break;
        }
    }
    
    public function maxInputVarsCheck()
    {
        $max_input_vars = ini_get('max_input_vars');
        $pass = true;
        
        if ($max_input_vars && count($_POST, COUNT_RECURSIVE) >= $max_input_vars)
            $pass = false;

        die( strval($this->__callback) . '({"pass": ' . ($pass ? 'true' : 'false') . '})' ) ;
    }

    public function AjaxCheck()
    {
        $callback = Tools::getValue('callback') ;
        
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        die( strval($this->__callback) . '({"pass": true})' ) ;
    }

}

$envCheck = new ModuleEnvCheck();
$envCheck->Dispatch();
?>