<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.multichannel.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.carrier.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonFBAOrder extends Amazon
{
    private $europe = null ;
    private $amazon_id_lang = null ;

    private $_debug = false ;

    static public $errors = array();
    static public $log = array();

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function Dispatch()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        switch (Tools::getValue('action'))
        {
            case 'create' :
                $this->CreateFulfillmentOrder();
                break;
            case 'info' :
                $this->GetFulfillmentOrder();
                break;
            case 'cancel' :
                $this->CancelFulfillmentOrder();
                break;   
            case 'status' :
                $this->FulfillmentOrderStatuses();
                break;                 
        }
        $output = ob_get_clean() ;
        $json = Amazon_Tools::jsonEncode( array('error' => '', 'response' => $this->l('Nothing to do'), 'output' => $output) ) ;
        die(strval($callback) . '(' . $json . ')');
    }
    
    public function Init()
    {
        if ( Tools::getValue('debug') == true )
            $this->_debug = true ;
        else
            $this->_debug = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG'))) ? true : false ;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        // Regions
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketLang2Region = array_flip($marketPlaceRegion);           
        
        if (intval(Tools::getValue('europe')))
        {
            $masterMarketplace = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MASTER')));

            if (isset($marketLang2Region[$masterMarketplace]) && $marketLang2Region[$masterMarketplace])
                $id_lang = $marketLang2Region[$masterMarketplace];
            else
            {
                print('The module is not yet configured for Europe') ;
                return(false) ;
            }
            $this->europe = 1;
            $this->amazon_id_lang = (int)$id_lang ;
        }
        else
        {
            die('Only Europe is implemented at this time, please contact us for more informations') ;
        }
     
        //  Check Access Tokens
        //
        $tokens = Tools::getValue('cron_token') ? Tools::getValue('cron_token') : Tools::getValue('amazon_token') ;
        
        if (!Amazon_Tools::checkToken($tokens, $id_lang, $this->europe))
        {
            die('Wrong token') ;
        }

        return(true) ;        
    }
    
    public function GetFulfillmentOrder()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        ob_start() ;
        
        $this->Init() ;
        
        if ( !($id_order = (int)Tools::getValue('id_order')) )
        {
            print('Missing mandatory parameter, id_order') ;
            return(false) ;
        }        
        
        $amazonMultiChannelOrder = new Amazon_MultiChannel($id_order) ;
        
        $orderInfo = array() ;
        $errorMessage = null;
        $error = false ;
        
        if ( $result = $amazonMultiChannelOrder->GetFulfillmentOrder($id_order, $this->amazon_id_lang) )
        {
            if ( isset($result->Error) )
            {
                $error = true ;
                
                $errorMessage .= 'Error from Amazon:' ;
                
                if ( isset($result->Error->Type) )
                    $errorMessage .= sprintf('Type: %s<br />', $result->Error->Type) ;
                if ( isset($result->Error->Code) )
                    $errorMessage .= sprintf('Code: %s<br />', $result->Error->Code) ;
                if ( isset($result->Error->Message) )
                    $errorMessage .= sprintf('Message: %s<br />', $result->Error->Message) ;
            }
            else
            {
                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->ReceivedDateTime) )
                    $orderInfo['ReceivedDateTime'] = Amazon_Tools::displayDate( date('Y-m-d H:i:s', strtotime((string)$result->GetFulfillmentOrderResult->FulfillmentOrder->ReceivedDateTime)), $this->amazon_id_lang, true) ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->StatusUpdatedDateTime) )
                    $orderInfo['StatusUpdatedDateTime'] = Amazon_Tools::displayDate( date('Y-m-d H:i:s', strtotime((string)$result->GetFulfillmentOrderResult->FulfillmentOrder->StatusUpdatedDateTime)), $this->amazon_id_lang, true) ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->ShippingSpeedCategory) )
                    $orderInfo['ShippingSpeedCategory'] = (string)$result->GetFulfillmentOrderResult->FulfillmentOrder->ShippingSpeedCategory ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->FulfillmentMethod) )
                    $orderInfo['FulfillmentMethod'] = (string)$result->GetFulfillmentOrderResult->FulfillmentOrder->FulfillmentMethod ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->FulfillmentOrderStatus) )
                    $orderInfo['FulfillmentOrderStatus'] = (string)$result->GetFulfillmentOrderResult->FulfillmentOrder->FulfillmentOrderStatus ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrder->DisplayableOrderId) )
                    $orderInfo['DisplayableOrderId'] = (string)$result->GetFulfillmentOrderResult->FulfillmentOrder->DisplayableOrderId ;
                
                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrderItem) )
                    $orderInfo['Items'] = (string)$result->GetFulfillmentOrderResult->FulfillmentOrderItem->count() ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrderItem->member->EstimatedShipDateTime) )
                    $orderInfo['EstimatedShipDateTime'] = Amazon_Tools::displayDate( date('Y-m-d', strtotime((string)$result->GetFulfillmentOrderResult->FulfillmentOrderItem->member->EstimatedShipDateTime)), $this->amazon_id_lang) ;

                if ( isset($result->GetFulfillmentOrderResult->FulfillmentOrderItem->member->EstimatedArrivalDateTime) )
                    $orderInfo['EstimatedArrivalDateTime'] = Amazon_Tools::displayDate( date('Y-m-d', strtotime((string)$result->GetFulfillmentOrderResult->FulfillmentOrderItem->member->EstimatedArrivalDateTime)), $this->amazon_id_lang) ;
            
                $amazonMultiChannelOrder->updateMpChannelStatus($orderInfo['FulfillmentOrderStatus']) ;
            }
        }
        else
        {
            if ($this->_debug)
                printf('GetFulfillmentOrder() failed and returns: %s' . "<br/>\n", nl2br (print_r($result))) ;
            $error = true ;
        }
        $output = ob_get_clean() ;
        
        $json = Amazon_Tools::jsonEncode( array('error' => $error, 'info' => $orderInfo, 'error_message' => $errorMessage, 'output' => $output) ) ;
        
        die(strval($callback) . '(' . $json . ')');
    }
    
    public function CancelFulfillmentOrder()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        $id_employee = Amazon::configurationGet('AMAZON_EMPLOYEE') ;                
        
        ob_start() ;
        
        $this->Init() ;
        
        if ( !($id_order = (int)Tools::getValue('id_order')) )
        {
            print('Missing mandatory parameter, id_order') ;
            return(false) ;
        }        
        
        $amazonMultiChannelOrder = new Amazon_MultiChannel($id_order) ;
        
        $error = false ;
        $errorMessage = null ;
        
        if ( !($result = $amazonMultiChannelOrder->CancelFulfillmentOrder($id_order, $this->amazon_id_lang)) )
        {
            if ($this->_debug)
                printf('GetFulfillmentOrder() failed and returns: %s' . "<br/>\n", nl2br (print_r($result))) ;
            $error = true ;
        }
        else
        {
            if ( isset($result->Error) )
            {            
                $error = true ;
                
                $errorMessage .= 'Error from Amazon:' ;
                
                if ( isset($result->Error->Type) )
                    $errorMessage .= sprintf('Type: %s<br />', $result->Error->Type) ;
                if ( isset($result->Error->Code) )
                    $errorMessage .= sprintf('Code: %s<br />', $result->Error->Code) ;
                if ( isset($result->Error->Message) )
                    $errorMessage .= sprintf('Message: %s<br />', $result->Error->Message) ;            
            }
            else
            {
                $history = new Amazon_OrderHistory();
                $history->id_order = (int)$id_order;
                $history->id_employee = intval($id_employee);
                $history->changeIdOrderState(Configuration::get('PS_OS_CANCELED'), $history->id_order, true);   
                $history->addWithOutEmail(true) ;                
            }
        }

        $output = ob_get_clean() ;
        
        $json = Amazon_Tools::jsonEncode( array('error' => $error, 'error_message' => $errorMessage, 'output' => $output) ) ;
        
        die(strval($callback) . '(' . $json . ')');
    }  
    
    public function CreateFulfillmentOrder()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        ob_start() ;
        
        $this->Init() ;
        
        if ( !($id_order = (int)Tools::getValue('id_order')) )
        {
            print('Missing mandatory parameter, id_order') ;
            return(false) ;
        }        

        if ( !($order = Amazon_MultiChannel::isEligible($id_order)) )
        {
            if ($this->_debug)
                printf('CreateFulfillmentOrder() is not eligible' . "<br/>\n") ;            
            return(false) ;
        }
         
        $amazonMultiChannelOrder = new Amazon_MultiChannel($id_order) ;
        
        if ( ! Validate::isLoadedObject($amazonMultiChannelOrder) )
        {
            if ($this->_debug)
                printf('CreateFulfillmentOrder(): Validate::isLoadedObject() returned false' . "<br/>\n") ;             
            return(false) ;
        }

        // Not already ordered, shipped or canceled 
        //
        if ( strlen($amazonMultiChannelOrder->marketPlaceChannelStatus) )
        {
                if ($this->_debug)
                    printf('CreateFulfillmentOrder() has already a FBA/Multichannel state' . "<br/>\n") ;                 
                return(false) ;
        } 
        
        $error = false ;
        $errorMessage = null ;
        
        if ( !($AmazonFBAOrder = $amazonMultiChannelOrder->CreateFulfillmentOrder($this->_debug)) )
        {
            if ($this->_debug)
                printf('CreateFulfillmentOrder() failed and returns: %s' . "<br/>\n", nl2br (print_r($AmazonFBAOrder))) ;
            $error = true ;
        }
        
        $response = sprintf( $this->l('Response ID: %s'), 
                    $AmazonFBAOrder['Response']
                    ) ;
        
        $output = ob_get_clean() ;
        
        $json = Amazon_Tools::jsonEncode( array('error' => $error, 'response' => $response, 'output' => $output) ) ;
        
        die(strval($callback) . '(' . $json . ')');
    }     
    
    public function FulfillmentOrderStatuses()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        $pending_state = (int)Amazon::configurationGet('AMAZON_FBA_MULTICHANNEL_STATE') ;
        $sent_state = (int)Amazon::configurationGet('AMAZON_FBA_MULTICHANNEL_SENT') ;
        $id_employee = (int)Amazon::configurationGet('AMAZON_EMPLOYEE') ;
        
        if ( ! $pending_state )
        {
            if ($this->_debug)
                printf('FulfillmentOrderStatuses() Order State is not yet configured' . "<br/>\n") ;
            return(false) ;
        }
        #ob_start() ;
        
        $this->Init() ;    
        
        $amazonMultiChannel = new Amazon_MultiChannel() ;

        $result = Amazon_MultiChannel::ordersByStatus($pending_state) ;

        if ( ! $result || ! count($result) )
        {
            if ($this->_debug)
                printf('FulfillmentOrderStatuses() ordersByStatus returned nothing' . "<br/>\n") ;
            return(false) ;            
        }
        $dateStart = $result[0]['date_add'] ;
        
        // Merge as array('id_order' => ..)
        //
        $orders = array() ;
        
        foreach($result as $entry)
            $orders[ $entry['id_order'] ] = $entry ;

        $result = $amazonMultiChannel->ListAllFulfillmentOrders($dateStart, $this->amazon_id_lang, $this->_debug) ;
        
        if ( ! $result || ! is_array($result) )
        {
            if ($this->_debug)
                printf('FulfillmentOrderStatuses() ListAllFulfillmentOrders returns nothing' . "<br/>\n") ;
            return(false) ;                        
        }

        // Merge orders informations
        //
        foreach($result as $fulfillmentOrderss)
            foreach($fulfillmentOrderss as $fulfillmentOrders)
                foreach($fulfillmentOrders as $fulfillmentOrder)
                {
                    if ( isset( $fulfillmentOrder->SellerFulfillmentOrderId ) && $fulfillmentOrder->SellerFulfillmentOrderId && isset( $orders[ (string)$fulfillmentOrder->SellerFulfillmentOrderId ] ) )
                    {
                       $orders[ (string)$fulfillmentOrder->SellerFulfillmentOrderId ]['FulfillmentOrderStatus'] = (string)$fulfillmentOrder->FulfillmentOrderStatus ;
                       $orders[ (string)$fulfillmentOrder->SellerFulfillmentOrderId ]['StatusUpdatedDateTime'] = (string)$fulfillmentOrder->StatusUpdatedDateTime ;
                    }
                }

        foreach($orders as $key => $order)
        {
            $id_order = (int)$order['id_order'] ; 
            
            if ( ! isset($order['FulfillmentOrderStatus']) ) // not listed
            {
                continue ;
            }            
            $amazonMultiChannel = new Amazon_MultiChannel($id_order) ;

            if ( ! Validate::isLoadedObject($amazonMultiChannel) )
            {
                if ($this->_debug)
                    printf('FulfillmentOrderStatuses() unable to load order id: %d' . "<br/>\n", $id_order) ;
                continue ;            
            }            

            if ( $order['mp_channel_status'] != $order['FulfillmentOrderStatus'] )
            {
                $amazonMultiChannel->updateMpChannelStatus($order['FulfillmentOrderStatus']) ;
                $orders[$key]['NewFulfillmentOrderStatus'] = $order['FulfillmentOrderStatus'] ;
            }
            
            switch ( strtolower($order['FulfillmentOrderStatus']) )
            {
                    case Amazon_MultiChannel::AMAZON_FBA_STATUS_COMPLETE :
                    case Amazon_MultiChannel::AMAZON_FBA_STATUS_COMPLETEPARTIALLED :
                            $result = $amazonMultiChannel->GetFulfillmentOrder($order['id_order'], $amazonMultiChannel->id_lang, $this->_debug);

                            if ( isset($result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentStatus) 
                                    && $result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentStatus == 'SHIPPED' )
                            {
                                if ( isset($result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentPackage->member->TrackingNumber) )
                                  $trackingNumber = $result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentPackage->member->TrackingNumber ;
                                else 
                                  $trackingNumber = null ;

                                if ( isset($result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentPackage->member->CarrierCode) )
                                  $carrierCode = $result->GetFulfillmentOrderResult->FulfillmentShipment->member->FulfillmentShipmentPackage->member->CarrierCode ;
                                else 
                                  $carrierCode = null ;

                                if ( $carrierCode && $trackingNumber )
                                {
                                    if ( $this->_debug)
                                        echo "Carrier: $carrierCode Tracking: $trackingNumber \n<br>" ;
                                    
                                    if ( ! ($id_carrier_fba = Amazon_Carrier::FBACarrier($carrierCode, $this->_debug)) )
                                          if ( ! ($id_carrier_fba = Amazon_Carrier::FBACarrierCreate($carrierCode)) )
                                          {
                                                printf('FulfillmentOrderStatuses() unable add carrier: %s' . "<br/>\n", $carrierCode) ;
                                                continue ;
                                          }
                                          
                                    Amazon_Carrier::UpdateTrackingNumber($id_order, $id_carrier_fba, $trackingNumber, $this->_debug) ;
                                }
                              
                                $history = new Amazon_OrderHistory();
                                $history->id_order = $id_order ;
                                $history->id_employee = intval($id_employee);
                                $history->changeIdOrderState($sent_state, $history->id_order, true);   
                                $history->addWithOutEmail(true) ;   
                                $orders[$key]['id_order_state'] = $sent_state ;
                            }
                            break ;
            }

        }
        echo nl2br(print_r($orders, true)) ;
        die ;
    }
}

$amazonFBAOrder = new AmazonFBAOrder();
$amazonFBAOrder->Dispatch();
?>