<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
}

require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.address.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.orderhistory.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.cart.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.payment.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

class AmazonListOrder extends Amazon
{
    private $_amazonApi = null ;
    private $_debug = false;

    static public $errors = array();
    static public $warnings = array() ;
    static public $messages = array() ;
    
    static public $orders = array() ;
    
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function Dispatch($action)
    {
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = $debugMode ? true : false;
        
        if ( Tools::getValue('debug') )
            $this->_debug = true ;
        
        if ( $this->_debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
            
            // Generate a warning to identify which program/module sent the headers previously
            if ( Tools::getValue('debug_header') !== false )
            {
                echo ob_get_clean(); 
                header ("Pragma: no-cache");  
            }            
        } 
        
        switch ($action)
        {
            case 'list' :
                $this->DisplayList();
        }
    }
    
    static public function JSON_Display_Exit()
    {
     
        if ( $result = ob_get_clean() )
            $output = $result ;
        else
            $output = null ;
        
        $json = Amazon_Tools::jsonEncode(
                    array(  'orders' => AmazonListOrder::$orders, 
                            'count'  => count(AmazonListOrder::$orders), 
                            'error' => (count(AmazonListOrder::$errors) ? true : false), 
                            'errors' => AmazonListOrder::$errors, 
                            'output' => $output 
                        ));
        if ( $callback = Tools::getValue('callback') ) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
            die;
        }
        else // cron
        {
            echo $json;
            die;
        }        
    }
    public function DisplayList()
    {
        ob_start() ;
        register_shutdown_function( array('AmazonListOrder', 'JSON_Display_Exit') ) ;
        
        $currentDate = date('Y-m-d H:i:s');

        $cr = "<br />"; // carriage return

        AmazonListOrder::$messages[] = $this->l("Starting Order Query in WS API/Web Mode") . ' - ' . $currentDate . $cr;

        // Identify the order's country
        //
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        $marketPlace2IsoId = array_flip($marketPlaceIds);

        // Regions
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketLang2Region = array_flip($marketPlaceRegion);    
                
        $status = strval(Tools::getValue('statuses'));

        $date1 = str_replace('-', '/', Tools::getValue('datepickerFrom'));
        $date2 = str_replace('-', '/', Tools::getValue('datepickerTo'));

        // Today - 5 minutes de temps de latence afin d'�viter les erreur de synchro dus a l'heure systeme
        //
        if (date('Ymd', strtotime($date2)) >= date('Ymd') || empty($date2))
        {
            $date1 = date('c', strtotime($date1));
            $date2 = date('c', strtotime('now - 5 min'));
        }
        elseif (date('Ymd', strtotime($date1)) >= date('Ymd', strtotime($date2)))
        {
            $date1 = date('c', strtotime($date1 . ' 00:00:00'));
            $date2 = date('c', strtotime($date2 . ' 23:59:59'));
        }
        else
        {
            $date1 = date('c', strtotime($date1 . ' 00:00:00'));
            $date2 = date('c', strtotime($date2 . ' 23:59:59'));
        }

        $id_lang = intval(Tools::getValue('amazon_lang'));
        $tokenOrders = Tools::getValue('token_order');

        if (intval(Tools::getValue('europe')))
        {
            $masterMarketplace = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MASTER')));

            if ( isset($marketLang2Region[$masterMarketplace]) && $marketLang2Region[$masterMarketplace] )
                $id_lang = $marketLang2Region[$masterMarketplace] ;
            else
                $id_lang = (int)Configuration::get('PS_LANG_DEFAULT') ;
            
            $this->europe = 1;
        }
        else
        {
            $this->europe = 0;
        }
        
        if (!intval($id_lang))
        {
            AmazonListOrder::$errors[] = $this->l('No selected language, nothing to do...') ;
            die;
        }

        //  Check Access Tokens
        //
        $tokens = Tools::getValue('amazon_token');

        if (!Amazon_Tools::checkToken($tokens, $id_lang, $this->europe))
            AmazonListOrder::$errors[] = $this->l('Wrong Token');

        // Init
        //
        if ( $this->europe )
        {
            $amazon = Amazon_Tools::selectEuropeanPlatforms($this->_debug);
        }
        else
        {
            $amazon = Amazon_Tools::selectPlatforms($id_lang, $this->_debug);
        }

        if ($this->_debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        if (!($this->_amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $this->_debug)))
        {
            AmazonListOrder::$errors[] = $this->l('Unable to login') ; 
            die;
        }

        // Listing Orders
        //
        $orders = $this->_amazonApi->GetUnshippedOrdersList($date1, $date2, $status);

        if (!$orders || !count($orders))
        {
            AmazonListOrder::$warnings[] = $this->l('No pending order for the selected period') ; 
            die;
        }
        
        $orderCheck = new Amazon_Order();

        foreach ($orders as $key => $order)
        {
            // Langue de la Commande
            //
            if (count($marketPlace2IsoId))
                $id_lang = $marketPlace2IsoId[$order->MarketPlaceId];
            else
                $id_lang = $id_lang;

            $currency = (int) Currency::getIdByIsoCode(strval($order->OrderTotalCurrency));

            $total = floatval($order->OrderTotalAmount);
            $retrieved = $orderCheck->checkByMpId($order->AmazonOrderId);

            $url = '?tab=AdminOrders&id_order=' . $retrieved . '&vieworder&token=' . $tokenOrders;

            $order_link = $retrieved ? ('<a href="' . $url . '" title="" target="_blank" >' . $order->AmazonOrderId . '(' . $retrieved . ')</a>') : $order->AmazonOrderId;

            if (isset($id_lang))
                $flag = '<img src="' . $this->images . 'geo_flags/' . $marketPlaceRegion[$id_lang] . '.jpg" alt="" />';
            else
                $flag = '';
            
            $oID = (string)$order->AmazonOrderId ;
            self::$orders[$oID]['id']           = (string)$order->AmazonOrderId ;
            self::$orders[$oID]['flag']         = $flag ;
            self::$orders[$oID]['date']         = Amazon_Tools::displayDate(date('Y-m-d H:i:s', strtotime($order->PurchaseDate)), $this->id_lang) ;
            self::$orders[$oID]['id_lang']      = $id_lang ;
            self::$orders[$oID]['link']         = $order_link ;
            self::$orders[$oID]['status']       = (string)$order->OrderStatus ;
            self::$orders[$oID]['imported']     = (bool)$retrieved ;
            self::$orders[$oID]['customer']     = (string)$order->Address->Name ;
            self::$orders[$oID]['shipping']     = (string)$order->ShipServiceLevel ;
            self::$orders[$oID]['fulfillment']  = (string)$order->FulfillmentChannel ;
            self::$orders[$oID]['quantity']     = (int)(intval($order->NumberOfItemsUnshipped) + intval($order->NumberOfItemsShipped)) ;
            self::$orders[$oID]['total']        = Tools::displayPrice($total, $currency) ;
        }
    }

}

$amazonOrders = new AmazonListOrder();
$amazonOrders->Dispatch('list');
?>