<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonToolFunction extends Amazon
{
    private $_debug = false ;

    static public $errors = array();
    static public $pass = false ;
    static public $debug = false ;
    static public $file = false ;
    static public $filelink = false ;
    
    public $export = null ;
    
    static public $delimiter = ';' ;
    
    function __construct()
    {
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = intval($debugMode) ? true : (bool) Tools::getValue('debug');

        if (Tools::getValue('debug'))
            $this->_debug = true;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        parent::__construct();

        $this->export = $this->path . 'export/' ;
    }    
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function Dispatch()
    {
        switch (Tools::getValue('action'))
        {
            case 'product-code-export' :
                die($this->ProductFileExport());
                break;
            case 'product-code-download' :
                die($this->ProductFileDownload());
                break;            
            case 'queue-delete' :
                die($this->DeleteActionQueue());
                break;            
        }
    }
    
    public function Init()
    {
        if ( Tools::getValue('debug') == true )
            $this->_debug = true ;
        else
            $this->_debug = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG'))) ? true : false ;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
    
        AmazonToolFunction::$debug = $this->_debug ;  
        //  Check Access Tokens
        //
        $tokens = Tools::getValue('cron_token') ? Tools::getValue('cron_token') : Tools::getValue('amazon_token') ;
        
        if (!Amazon_Tools::checkToken($tokens, $this->id_lang))
        {
            // Ignore token verification, this is not a critical task
            print('Wrong token') ;
            die;
        }

        return(true) ;        
    }
    
    static public function ProductFile_JSON_Display_Exit()
    {
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
                
        $errors = null ;
        $output = null ;
        
        if ( ! AmazonToolFunction::$pass  )
        {
            $result = trim(ob_get_clean()) ;
            if ( $result )
                $errors = $result ;
        }
        else
        {
            $output = trim(ob_get_clean()) ;
        }

        $json = Amazon_Tools::jsonEncode(
                    array( 
                            'error'     => ! AmazonToolFunction::$pass, 
                            'debug'     => AmazonToolFunction::$debug,
                            'errors'    => $errors, 
                            'output'    => $output,
                            'file'      => AmazonToolFunction::$file,
                            'filelink'  => AmazonToolFunction::$filelink
                          )) ;
        
        echo strval($callback) . '(' . $json . ')';
        exit ;
    }   
    public function DeleteActionQueue()
    {
        $pass = false ;
        $count = 0 ;
        $queues = Tools::getValue('queue') ;
        $callback = Tools::getValue('callback') ;

        $this->Init() ;
                
        if ( is_array($queues) && count($queues) )
        {
            foreach($queues as $id_lang => $queue)
            {
                foreach($queue as $action => $value)
                {
                    Amazon_Product::marketplaceActionReset($id_lang, $action) ; 
                    $pass = true ;
                    $count++ ;
                }
            }
        }
        $output = trim(ob_get_clean()) ;
        
        $json = Amazon_Tools::jsonEncode(
                    array( 
                            'error'     => ! $pass, 
                            'count'     => $count,
                            'output'    => $output,
                          )) ;
        
        echo strval($callback) . '(' . $json . ')';
        exit ;        
    }
    public function ProductFileDownload()
    {
        $fn = Tools::getValue('filename') ;
        
        header('Pragma: public');
        header('Cache-Control: no-cache');
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="'.$fn.'"'); 
        echo file_get_contents($this->export . $fn);
        exit;        
    }    
    public function ProductFileExport()
    {
        $id_warehouse = null;
        $id_shop = 1;

        // Shop Configuration (PS 1.5)
        // 
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $id_shop = (int) Amazon::configurationGet('AMAZON_SHOP');
            $id_warehouse = (int) Amazon::configurationGet('AMAZON_WAREHOUSE');

            if (!$id_shop)
                $id_shop = 1;
        }
        
        ob_start() ;
        
        register_shutdown_function( array('AmazonToolFunction', 'ProductFile_JSON_Display_Exit') ) ;
        
        $this->Init() ;

        if ( ! is_dir($this->export) ) 
        {
            if ( ! mkdir($this->export) ) 
            {
               die( sprintf($this->l('Unable to create directory: %s'), $this->export) ) ; 
            }
        }
        $filename = date('Ymd') . "-amazon.csv" ;
        $fileout = $this->export . $filename ; 

        if ( file_exists($fileout) && !is_writable($fileout) ) 
        {
            die( sprintf($this->l('Unable to open file for writing: %s'), $fileout) ) ;
        }        
        
        if (!( $handle = fopen($fileout, 'w') )) {
            die( sprintf($this->l('Unable to open file for writing: %s'), $fileout) ) ; 
        }
        
        // Write header line
        // 
        $CSV = array() ;
        $CSV[0] = $this->l('Prestashop Product ID') ;
        $CSV[1] = 'Reference (SKU)' ;
        $CSV[2] = 'UPC' ;
        $CSV[3] = 'EAN' ;
        $CSV[4] = $this->l('Product Name') ;
        
        fputcsv($handle, $CSV, self::$delimiter);
        
        $active     = Tools::getValue('active') ? true : false ;
        $in_stock   = Tools::getValue('in_stock') ? true : false ;
        
        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $get_combination = 'getAttributeCombinaisons' ;
        else
            $get_combination = 'getAttributeCombinations' ;
        
        $result = Amazon_Product::marketplaceGetAllProducts($this->id_lang, $active) ;
        
        if ( ! is_array($result) || ! count($result) )
        {
            print( $this->l('No products to export, exiting...') ) ;
            die ;
        }
        $count = 0 ;
        
        foreach($result as $product_item)
        {
            $id_product = (int)$product_item['id_product'] ;
            
            $product = new Product($id_product, false, $this->id_lang) ;
            
            if ( ! Validate::isLoadedObject($product) )
            {
                continue ;
            }
            
            // Parent
            $product_combinations = array() ;
            $product_combinations[0]['ean13'] = $product->ean13 ;
            $product_combinations[0]['upc'] = $product->upc ;
            $product_combinations[0]['reference'] = $product->reference ; 
            $product_combinations[0]['attribute_name'] = null ;            
            
            // Children
            if ( $product->hasAttributes() )
            {
                $combinations = $product->{$get_combination}($this->id_lang) ;
                
                foreach ($combinations as $key => $combination)
                {
                    $id_product_attribute = intval($combination['id_product_attribute']);
                    
                    $product_combinations[$id_product_attribute]['ean13'] = $combination['ean13'] ;
                    $product_combinations[$id_product_attribute]['upc'] = $combination['upc'] ;
                    $product_combinations[$id_product_attribute]['reference'] = $combination['reference'] ;
                            
                    if ( ! isset($product_combinations[$id_product_attribute]['attribute_name']) )
                        $product_combinations[$id_product_attribute]['attribute_name'] = null ;
                    if ( $combination['attribute_name'] )
                        $product_combinations[$id_product_attribute]['attribute_name'] .= sprintf('%s - ', $combination['attribute_name']) ;
                } 
            }

            foreach($product_combinations as $id_product_attribute => $product_combination)
            {
                $count++ ;
                if ( $product_combination['attribute_name'] )
                {
                    $attribute_name = rtrim($product_combination['attribute_name'], ' - ') ;
                    $product_name = sprintf('%s (%s)', $product->name, $attribute_name) ;
                }
                else
                    $product_name = $product->name ;
                
                if ( $in_stock )
                {
                    if (version_compare(_PS_VERSION_, '1.5', '<'))
                        $productQuantity = Product::getQuantity((int)$id_product, $id_product_attribute ? (int)$id_product_attribute : null);
                    else
                        $productQuantity = Product::getRealQuantity($id_product, $id_product_attribute ? (int)$id_product_attribute : null, $id_warehouse ? $id_warehouse : null, $id_shop);
                    
                    if ( $productQuantity < 1 )
                        continue ;
                }
                
                $CSV = array() ;
                $CSV[0] = sprintf('%d_%d', (int)$id_product, (int)$id_product_attribute) ;
                $CSV[1] = "'" . $product_combination['reference'] ;
                $CSV[2] = ((int)$product_combination['upc'] ? "'" . $product_combination['upc'] : null) ;  
                $CSV[3] = (int)$product_combination['ean13'] ? "'" . $product_combination['ean13'] : null ; 
                $CSV[4] = $product_name ;

                fputcsv($handle, $CSV, self::$delimiter);
            }

        }
        fclose($handle) ;
        
        if ( $count )
        { 
            AmazonToolFunction::$pass = true ;
            AmazonToolFunction::$file = $filename ;
            AmazonToolFunction::$filelink = sprintf('<a href="%s" target="_blank">%s</a>', $this->url . 'functions/tools.php?action=product-code-download&filename=' . $filename, $filename) ;
        }
    }

}

$amazonToolsFunction = new AmazonToolFunction();
$amazonToolsFunction->Dispatch();
?>