<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @author     Erick Turcios  
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
}

require_once(dirname(__FILE__).'/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__).'/../classes/amazon.webservice.class.php');
require_once(dirname(__FILE__).'/../classes/amazon.specificfield.class.php');

require_once(dirname(__FILE__).'/../amazon.php');

require_once(dirname(__FILE__).'/../validate/Node.php') ;
require_once(dirname(__FILE__).'/../validate/XmlDataType.php') ;
require_once(dirname(__FILE__).'/../validate/XmlRestriction.php') ;
require_once(dirname(__FILE__).'/../validate/AmazonValidator.php') ;
require_once(dirname(__FILE__).'/../validate/AmazonXSD.php') ;

class AmazonXSDOperations extends Module
{
    private $module   = 'amazon';
    public  $name   = 'amazon';

    private $_amazon ;
    private $_debug ;
    
    private static $features    = null ;
 
    private $productType ;
    private $universe ;
    
    private $recommendedPerUniverseFields = array(
        'Shoes'                 => array('Color', 'CollectionName', 'HeelType', 'HeelHeight', 'LeatherType', 'InnerMaterial', 'MaterialComposition', 'MaterialType', 'ModelYear', 'OuterMaterialType', 'Season', 'ShaftHeight', 'ShaftWidth', 'ShaftDiameter', 'ShoeClosureType', 'SoleMaterial', 'StyleKeywords'),
        'ProductClothing'       => array('StyleKeywords', 'Season', 'OuterMaterial', 'InnerMaterial', 'MaterialComposition', 'ModelYear', 'Color', 'CollectionName', 'IsAdultProduct'),
        'Books'                 => array('Author', 'Edition', 'Illustrator', 'Language', 'PublicationDate', 'SignedBy', 'Volume'),
        'Luggage'               => array('Collection', 'Season', 'ModelYear', 'MaterialType', 'InnerMaterialType', 'ShellType', 'ClosureType'),
        'Home'                  => array('MaterialType'),
        'Computers'             => array('SellerWarrantyDescription', 'Color')
    ) ;

    private $recommendedPerTypeFields = array(
        'Watch'                 => array('BandColor', 'BandMaterial', 'BandLength', 'BandWidth', 'DialColor', 'MovementType', 'WaterResistantDepth', 'ModelYear', 'Season', 'TargetGender'),
        'Phone'                 => array('OperatingSystem', 'ScreenSize', 'TelephoneType'),
        'Speakers'              => array('ConnectorType', 'NumberOfSpeakers', 'MaximumWattage'),
        'LightsAndFixtures'     => array('BulbType', 'ColorTemperature', 'DisplayHeight', 'DisplayLength', 'DisplayWeight', 'DisplayWidth', 'Color', 'IncandescentEquivalentWattage', 'Wattage', 'PlugType'),
        'FashionNecklaceBraceletAnklet' => array('MetalType'),
        'FashionRing'                   => array('MetalType'),
        'FashionEarring'                => array('MetalType'),
        'FashionOther'                  => array('MetalType'),
        'FineNecklaceBraceletAnklet'    => array('MetalType'),
        'FineRing'                      => array('MetalType'),
        'FineEarRing'                   => array('MetalType'),
        'FineOther'                     => array('MetalType'),
        'Pants'                         => array('InseamLength', 'WaistSize')
    ) ;
    
    public $id_lang ;
    
    function __construct()
    {
        parent::__construct() ;

        if ( (int)Tools::getValue('id_lang') )
            $this->id_lang = (int)Tools::getValue('id_lang');
        
        $debugMode       = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG'))) ;
        $this->_debug    = intval($debugMode) ? true : false ;

        if ( Tools::getValue('debug') )
            $this->_debug = true ;
        
        if ( $this->_debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        } 
        
        // Load Features Once
        if ( self::$features === null )
        {
            self::$features = Feature::getFeatures($this->id_lang) ;
        }
    }
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }
    
    public function Dispatch()
    {
       ob_start(); 
       $data = array() ;
       switch( Tools::getValue('action'))
       {
         case 'fetch' :
            $data = $this->Fetch() ;
            break ;
         case 'extrafields' :
            $data = $this->ExtraFields() ;
            break ;
         default :
             die($this->l('No action was choose')) ;
       }
    }

    
    public function OptionnalFields(&$specificFields, $productDefinition = null)
    {
        if ( isset($this->recommendedPerUniverseFields[$this->universe]) )
        {
            foreach($this->recommendedPerUniverseFields[$this->universe] as $field)
            {
                $specificFields['field'][$field] = null ;
                $specificFields['characteristic'][$field] = array() ;   
                
                if (isset($productDefinition->$field->attr->unitOfMeasure) && isset($productDefinition->$field->attr->unitOfMeasure->allowedValues) && count($productDefinition->$field->attr->unitOfMeasure->allowedValues))
                {
                    $specificFields['characteristic'][$field]['unitOfMeasure'] = true ; 
                    /*
                     * Serialize possible values for the form
                     * MM, CM, etc...
                     */
                    $specificFields['values'][$field] = base64_encode(serialize($productDefinition->$field->attr->unitOfMeasure->allowedValues)) ;  
                }              
            }
        }  
        if ( isset($this->recommendedPerTypeFields[$this->productType]) )
        {
         
            foreach($this->recommendedPerTypeFields[$this->productType] as $field)
            {
                $specificFields['field'][$field] = null ;
                $specificFields['characteristic'][$field] = array() ;   
         
                if (isset($productDefinition->$field->attr->unitOfMeasure) && isset($productDefinition->$field->attr->unitOfMeasure->allowedValues) && count($productDefinition->$field->attr->unitOfMeasure->allowedValues))
                {
                    $specificFields['characteristic'][$field]['unitOfMeasure'] = true ; 
                    /*
                     * Serialize possible values for the form
                     * MM, CM, etc...
                     */
                    $specificFields['values'][$field] = base64_encode(serialize($productDefinition->$field->attr->unitOfMeasure->allowedValues)) ;  
                } 
            }
        }
        return(true);
    }

  
    /*
     * Amazon specific fields
     */
    public function ExtraFields()
    {
        $profile = Tools::getValue('profile') ;
        $universe = Tools::getValue('universe') ;
        $productType = Tools::getValue('selected') ;
        $callback = Tools::getValue('callback') ;
        if ( $callback == '?' )
            $callback = 'jsonp_' . time() ;
        
        $productFactory = new AmazonXSD($universe.'.xsd');
        $p = $productFactory->getInstance();

        if ( $universe == 'SWVG' ) $universe = 'SoftwareVideoGames' ;
     
        $this->universe = $universe ;
        $this->productType = $productType ;
        
        $required = AmazonXSD::getMandatoryFields($p->ProductData);
  
        $errors = ob_get_contents() ;
        
        if ( $universe == 'Luggage' )
        {
            $specificFields = array() ;
            $specificFields[$profile]['field']['Department'] = null ;
            $specificFields[$profile]['required']['Department'] = true ;
            
            // Optionnal Settings
            //
            $this->OptionnalFields($specificFields[$profile]) ;
            
            echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;               
        }
        // Shoes
        elseif ( isset($p->ProductData->Shoes->ClassificationData->Department) )
        {
            $specificFields = array() ;
            $specificFields[$profile]['field']['Department'] = null ;
            $specificFields[$profile]['required']['Department'] = true ;
            
            // Optionnal Settings
            //
            $this->OptionnalFields($specificFields[$profile]) ;
            
            echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;   
            
        }       
        // Clothes
        elseif ( isset($p->ProductData->Clothing->ClassificationData) )
        {
            $specificFields = array() ;
            $specificFields[$profile]['field']['Department'] = null ;
            $specificFields[$profile]['required']['Department'] = true ;
            
            // Optionnal Settings
            //
            $this->OptionnalFields($specificFields[$profile], $p->ProductData->Clothing->ClassificationData) ;
            
            echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;            
        }
        // Jewelry
        elseif ( isset($p->ProductData->Jewelry) )
        {
            $variationDatas = $p->ProductData->$universe->ProductType->$productType->VariationData->VariationTheme->allowedValues ;

            $specificFields = array() ;
            $specificFields[$profile]['field']['variant'] = 0 ;
            $specificFields[$profile]['variant'] = array() ;

            /*
             * Exploring Variations :
                <xsd:element name="VariationTheme" minOccurs="0">
                <xsd:simpleType>
                        <xsd:restriction base="xsd:string">
                                <xsd:enumeration value="Length"/>
                                <xsd:enumeration value="MetalType"/>
                                <xsd:enumeration value="Length-MetalType"/>
                                <xsd:enumeration value="Color"/>
                                <xsd:enumeration value="StyleName"/>
                        </xsd:restriction>
                </xsd:simpleType>
                </xsd:element>
             */
            foreach($variationDatas as $variationData)
            {
                $variantNames = explode('-', $variationData) ;
                
                /* Split :
                 * <xsd:enumeration value="Length-MetalType"/> => Length and MetalType
                 */
                $specificFields[$profile]['variant'][$variationData] = array() ;
                
                /*
                 * Item has particular attributes :
                 * <xsd:element name="Length" type="LengthDimension" minOccurs="0"/> => LengthDimension
                 * Values => MM, CM, etc...
                 */
                foreach($variantNames as $name)
                {
                    $specificFields[$profile]['variant'][$variationData][$name] = null ;
                    
                    if ( isset($p->ProductData->$universe->ProductType->$productType->VariationData->$name->attr) )
                    {    
                        $tag = $p->ProductData->$universe->ProductType->$productType->VariationData->$name ;
                        
                        if (isset($tag->attr->unitOfMeasure) && isset($tag->attr->unitOfMeasure->allowedValues) && count($tag->attr->unitOfMeasure->allowedValues))
                        {
                            $specificFields[$profile]['attributes'][$variationData][$name]['unitOfMeasure'] = 0 ; 
                            /*
                             * Serialize possible values for the form
                             * MM, CM, etc...
                             */
                            $specificFields[$profile]['values'][$variationData][$name] = base64_encode(serialize($tag->attr->unitOfMeasure->allowedValues)) ;  
                        }                        
                    }
                }
            }
            // Optionnal Settings
            //
            $this->OptionnalFields($specificFields[$profile], $p->ProductData->$universe->ProductType->$productType) ;            
             
            echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;  
        }
        // Other Products
        elseif (isset($p->ProductData->$universe->ProductType->$productType) && $p->ProductData->$universe->ProductType->$productType instanceOf stdClass)
        {
            $specificFields = array() ;
            $f = 0;
            foreach ($p->ProductData->$universe->ProductType->$productType as $name => $tag)
            {
                if ( isset($specificFields[$profile]['field'][$name]) )
                    continue ;
                
                if (AmazonXSD::isMandatoryField($tag) && $tag instanceOf StdClass)
                {
                    if ($tag->type == 'text' || $tag->type == 'number')
                    {
                        
                        $specificFields[$profile]['field'][$name] = null ;
                        $specificFields[$profile]['required'][$name] = true ;                        
                        
                        if (isset($tag->attr->unitOfMeasure) && isset($tag->attr->unitOfMeasure->allowedValues) && count($tag->attr->unitOfMeasure->allowedValues))
                        {
                            $specificFields[$profile]['attributes'][$name] = array() ; 
                            $specificFields[$profile]['attributes'][$name]['unitOfMeasure'] = 0 ; 
                            $specificFields[$profile]['values'][$name] = base64_encode(serialize($tag->attr->unitOfMeasure->allowedValues)) ;  
                        }
                    }
                    $f++;
                }
            }
           
            // Optionnal Settings
            //
            $this->OptionnalFields($specificFields[$profile], $p->ProductData->$universe->ProductType->$productType) ;   

            echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;                   
            
            // Some Cases (eg: Toys - Minimum Age)
            //
            foreach($required as $requirements)
            {
                if ( is_object($requirements) )
                    foreach($requirements as $key => $tag)
                    {
                        if ( $key == 'ProductType' )    continue ;
                        
                        if ( $tag instanceOf StdClass )
                        {
                            if(AmazonXSD::isParentWithChildren($key)):
                                $children = get_object_vars($requirements->$key);
                                foreach($children as $keyName=>$tagValue):
                                    if($tagValue instanceOf StdClass):
                                        
                                        $specificFields = array() ;
                                        $specificFields[$profile]['field'][$keyName] = null ;
                                        $specificFields[$profile]['required'][$keyName] = true ;                        

                                        if (isset($tagValue->attr->unitOfMeasure) && isset($tagValue->attr->unitOfMeasure->allowedValues) && count($tagValue->attr->unitOfMeasure->allowedValues))
                                        {
                                            $specificFields[$profile]['attributes'][$keyName] = array() ; 
                                            $specificFields[$profile]['attributes'][$keyName]['unitOfMeasure'] = 0 ; 
                                            $specificFields[$profile]['values'][$keyName] = base64_encode(serialize($tagValue->attr->unitOfMeasure->allowedValues)) ;  

                                        }
                                        echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;
                                    endif;
                                endforeach;
                            else:
                                $specificFields = array() ;
                                $specificFields[$profile]['field'][$key] = null ;
                                $specificFields[$profile]['required'][$key] = true ;                            
                                
                                echo Amazon_SpecificField::displayFields($profile, $specificFields[$profile]) ;
                            endif;
                        }
                    }
            }
            
        }
        $fields = ob_get_clean() ;
        $data = array('fields' => $fields, 'errors' => $errors) ;
        
        echo $callback . '(' . Amazon_Tools::jsonEncode($data) . ')';
        die ;
    }
    
    /*
     * Fetch categories
     */
    public function Fetch()
    {
        $this->errors[] = array() ;
        $data = array() ;

        if ( ! ($path = Tools::getValue('path')) ) 
        {
            $this->errors[] = sprintf('%s/%d: %s', basename(__FILE__), __LINE__, $this->l('Missing Parameter:') . ' path') ;
            return(false) ;
        }
        
        if ( ! ($selected = Tools::getValue('selected')) ) 
        {
            $this->errors[] = sprintf('%s/%d: %s', basename(__FILE__), __LINE__, $this->l('Missing Parameter: selected')) ; 
            return(false) ;
        }

        $file = $selected . ".xsd" ;

        if ( ! $file )
        {
            $this->errors[] = sprintf('%s/%d: %s', basename(__FILE__), __LINE__, $this->l('Unable to find the XSD file') . ': '.  $selected) ; 
            return(false) ;
        }
            
        $customElements = array(
                "ProductClothing"=>array("ClothingType"=>"Clothing->ClassificationData->ClothingType")
            );

        //get ProductTypes

        $arr = array($selected); 

        foreach($arr as $key=>$category):               
            $productTypes ="";

            try{
                $productFactory = new AmazonXSD($category.'.xsd');                    
                $productInstance = $productFactory->getInstance();

                $item = new stdClass();
                $item->productType = AmazonXSD::getVariationData($productInstance, "ProductType");              

                if ( $item->productType === false )
                    if ( $category == 'Shoes' )
                        $item->productType = AmazonXSD::getVariationData($productInstance, "ClothingType");              
              
                if(isset($customElements[$category])&&$item):                      
                    foreach($customElements[$category] as $keyName=>$el):
                            $e = explode("->", $el);
                            $obj=$productInstance->ProductData;

                            foreach($e as $tag):
                                $obj = $obj->$tag;
                            endforeach;                        
                            # Debug
                            # echo "productInstance->ProductData->$el";
                            $item->$keyName = $obj;
                    endforeach;
                endif;


                if(!$item):                    
                    $item = AmazonXSD::getVariationData($productInstance, "ProductType");
                endif;

                if ( isset($productInstance->ProductData->Shoes->ClothingType->allowedValues) )
                {
                    foreach($productInstance->ProductData->Shoes->ClothingType->allowedValues as $key => $val)
                    {
                        $productTypes[] = strval($val) ;
                    }                    
                }                    
                elseif ( isset($productInstance->ProductData->Clothing->ClassificationData->ClothingType->allowedValues) )
                {
                    foreach($productInstance->ProductData->Clothing->ClassificationData->ClothingType->allowedValues as $key => $val)
                    {
                        $productTypes[] = strval($val) ;
                    }                    
                }        
                // Added 2012-01-04 O.B.
                elseif ( isset($item->productType->allowedValues) )
                {
                    foreach($item->productType->allowedValues as $key => $val)
                    {
                        $productTypes[] = strval($val) ;
                    }                    
                }
                elseif ( isset($item->productType) && ! empty($item->productType) )
                {
 
                    foreach($item->productType as $key => $val)
                    {
                        if ( ! preg_match('/^[A-Z]/', strval($key)) ) continue ;
                       
                        $productTypes[] = strval($key) ;
                    }
                }
                else
                {
                    // No Types
                        $productTypes = null ;
                }

            }
            catch(Exception $e)
            {
                $this->errors[] = sprintf('XML Error:'.  $e->getMessage()) ;
            }              
        endforeach;
     
        
        if ( count($productTypes) )
        {
            echo '<option value="">' . $this->l('Choose') . '</option>' ;
            
            foreach($productTypes as $productType)
            {
                echo '<option value="' . $productType . '" >' . $productType . '</option>' . "\n" ;
            }
        }
        else
        {
            echo '<option value="">' . $this->l('No Data') . '</option>' ;
        }
        die ;
    }
}
$amazonXSDOperations = new AmazonXSDOperations() ;
$amazonXSDOperations->Dispatch() ;

?>