 $(document).ready(function() {
     $('.hint').slideDown() ;

    $('input[name="amazon_lang"]:first').attr('checked', 'checked');
    
    $('li[id^="menu-"]').click(function(){
         result = $(this).attr('id').match('^(.*)-(.*)$') ;
         tab = result[2] ;

         $('input[name=selected_tab]').val(tab) ;

         if ( ! $(this).hasClass('selected') )
         {
              $('li[id^="menu-"]').removeClass() ;
              $(this).addClass('selected active') ;
              $('div[id^="menudiv-"]').hide() ;
              $('div[id^="menudiv-' + tab + '"]').show() ;
         }
    });

    function ManageAjaxError(aCall, data, outdiv)
    {
        if (window.console)
        {
            console.log('Ajax Error') ;
            console.log(aCall)
            console.log(data) ;
        }
        outdiv.show().html( $('#serror').val() )

        if (data.output)
            outdiv.append('<br />' + data.output);

        if (data.responseText)
            outdiv.append('<br />' + data.responseText);
        
        outdiv.append('<hr />') ;
        outdiv.append( $('#sdebug').val() + ':  ') ; 
        
        outdiv.append('<form method="' + aCall.type + '" action="' + aCall.url + '?debug=1&debug_header&' + aCall.data + '" target="_blank">' +
                      '<input type="submit" class="button" id="send-debug" value="Execute in Debug Mode" /></form>') ;
    }
    
    $('#submit-orders-list').click(function() {
        
        if ( ! $('input[name=amazon_lang]:checked').length )
        {
            alert( $('#msg_lang').val() ) ;
            return(false) ;
        }

        if ( $('input[name="amazon_lang"][value="europe"]:checked').length )
            europe = $('input[name="amazon_lang"][value="europe"]:checked').attr('rel') ;
        else 
            europe = '0' ;
        
        $('#amz-loader').fadeIn();
        $('#amazon-import-error').hide();
        $('#amazon-import-error').html('');

        pAjax = new Object() ;
        pAjax.type       = 'POST' ;
        pAjax.url        = $('#orders_url').val() ;
        pAjax.data       = $('#amazonParams').serialize() + '&' + $('#amazonOrderOptions').serialize() + '&amazon_lang=' + $('input[name="amazon_lang"]:checked').val() + '&europe=' + europe + '&rand=' + new Date().valueOf()  ;
        pAjax.data_type  = 'jsonp' ;
        
        $.ajax({
            type: pAjax.type,
            url:  pAjax.url,
            dataType: pAjax.data_type,
            data: pAjax.data,
            success: function(data) {
                if (window.console)
                    console.log(data);
                 $('#amz-loader').fadeOut();
                 
                if ( data.orders && data.count )
                {
                    DisplayOrders(data.orders) ;
                }
                else
                {
                    if ( data.output )
                        $('#amazon-import-error').html(data.output + '<br />') ;
                    $('#amazon-import-error').append( $('#no_orders').val() + '<br />' ).show() ;
                }
            },
            error: function(data) {
                $('#amz-loader').fadeOut();
                
                ManageAjaxError(pAjax, data, $('#amazon-import-error')) ;
            }            
        });         
        
    }) ;

    function DisplayOrders(orders)
    {
        var irow = 0 ;
        $('table.order tbody tr:gt(0)').remove() ;
        
        $.each(orders, function(o,order){
            if ( irow == 0 )
                $('#order-table-heading').show() ;

            if ( window.console )
                console.log(order); 

            if ( order.status == 'Canceled' && $('#statuses').val() != 'Canceled' )
                return ;
            
            if ( order.status == 'Pending' && $('#statuses').val() != 'Pending' )
                return ;            
            
            // Clone Line, Append to the table and fill the order data
            order_line = $('#order-model').clone().appendTo('table.table.order tbody')            
            order_line.attr('id', 'O' + o) ;
            
            // Fill Lines
            //
            order_line.children('[rel=flag]').html(order.flag) ;
            order_line.children('[rel=date]').html(order.date) ;
            order_line.children('[rel=id]').html(order.link) ;
            order_line.children('[rel=status]').html(order.status) ;
            order_line.children('[rel=customer]').html(order.customer) ;
            order_line.children('[rel=shipping]').html(order.shipping) ;
            order_line.children('[rel=fulfillment]').html(order.fulfillment) ;
            order_line.children('[rel=quantity]').html(order.quantity) ;
            order_line.children('[rel=total]').html(order.total) ;
            order_line.addClass(irow++ % 2 ? 'alt_row' : '') ;
            checkbox = order_line.children('td[rel=checkbox]').children('input') ; 
            checkbox.attr('name', 'order_id[' + o + ']').val(o) ;
            
            if ( order.imported )
            {
                // .attr('checked', true)  
                checkbox.attr('disabled', true) ;
                order_line.addClass('imported_row2 success') ;
            }
            
            order_line.show();
        }) ;
    }
    
    // Import Orders
    //
    $('#submit-orders-import').click(function() {
        if ( ! $('.order-check:checked').length )
        {
            alert( $('#msg_select').val() ) ;
            return(false) ;            
        }  
        $('#amazon-import-error').hide() ;
        $('#amazon-import-warning').hide() ;
        
        // Hide Checkboxes, Display Loader
        $.each( $('.order-check:checked').not(':disabled'), function(e,message){
            $(this).hide() ;
            $(this).after( '<img src="' + $('#img_loader_small').val() + '" alt="" class="amz-tmp-loader" />' ) ; 
        }) ;
        
        $.ajax({
            type: 'POST',
            url: $('#import_url').val(),
            dataType: 'jsonp',
            data: $('#amazonParams').serialize() + '&' + $('#amazonOrderOptions').serialize() + '&' + $('#amazonOrders').serialize() + '&amazon_lang=' + $('input[name="amazon_lang"]:checked').val() + '&europe=' + europe + '&rand=' + new Date().valueOf(),
            success: function(data) {
                if (window.console)
                    console.log(data);
                 $('#amz-loader').fadeOut();
                
                // Restore Checkboxes
                $('.order-check:checked').attr('disabled', true).show() ;
                $('.amz-tmp-loader').remove() ;
                 
                $('#amazon-import-error').html('') ;
                $('#amazon-import-warning').html('') ;

                if ( data.error || data.message )
                {
                    $.each(data.errors, function(e,message){
                        $('#amazon-import-error').append(message + '<br />') ;
                    });
                    $.each(data.messages, function(e,message){
                        $('#amazon-import-error').append(message + '<br />') ;
                    });
                    $('#amazon-import-error').show() ;
                }
                if ( data.warning )
                {
                    $.each(data.warnings, function(e,message){
                        $('#amazon-import-warning').append(message + '<br />') ;
                    });
                    $('#amazon-import-warning').show() ;
                }
                
                if ( data.count )
                {
                    DisplayImported(data.orders) ;
                }
                else
                {
                    $('#amazon-import-error').append( $('#no_orders').val() + '<br />' ).show() ;
                }
            },
            error: function(data) {
                $('#amz-loader').fadeOut();
                
                ManageAjaxError(pAjax, data, $('#amazon-import-error')) ;
            }                      
        });          

    }); 
    
    function DisplayImported(orders)
    {
        $.each(orders, function(o,order){
            if ( order.status != true )
            {
                $('#O' + o).removeClass('alt_row').addClass('error_row danger') ;
                return ;
            }
            else
                $('#O' + o).removeClass('alt_row').addClass('imported_row success') ;
                
            $('#O' + o).after('<tr><td colspan="3"> </td><td colspan="7"><table id="OD' + o + '" class="order-line"></table></td></tr>') ;
            $('#O' + o + ' td[rel=id]').html(order.link)
           
            console.log(order) ;
            $.each(order.products, function(p,product){
                
                console.log(product) ;
                product_info = 
                        '<tr>\n' +
                            '<td>' + product.SKU + '</td>' + 
                            '<td>' + product.ASIN + '</td>' + 
                            '<td>' + product.product + '</td>' + 
                            '<td>' + product.quantity + '</td>' + 
                            '<td>' + product.currency + '</td>' + 
                            '<td align="right">' + product.price + '</td>' +
                        '<tr>' + '\n' ;
                
                $('#OD' + o).append(product_info) ;
            });
        });
    }
    
    if ( $.isFunction( $(document).on ) )
    {
        // Misc Functions
        //
        $(document).on('click', 'table.order tbody tr', function(e) {
            if (e.target.type !== 'checkbox') {
              $(':checkbox', this).trigger('click');
            }        
        });

        $('#checkme').on('click', function() {
          $('.order-check').each(function() {
            if( $(this).attr('checked') )
                  $(this).attr('checked', false) ;
            else
                if ( ! $(this).attr('disabled') )
                  $(this).attr('checked', 'checked') ;
          });
        });
    }
    
    if ( $.datepicker.initialized !== 'undefined' )
    {
        $("#datepickerTo").datepicker({
                            prevText:"",
                            nextText:"",
                            dateFormat:"yy-mm-dd"});

        $("#datepickerFrom").datepicker({
                            prevText:"",
                            nextText:"",
                            dateFormat:"yy-mm-dd"});
    }
    
    
 });