<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Erick Turcios
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

/**
 * Description of XsdProperties
 *
 * @author Erick Turcios
 */ 
class AmazonXSD {

    private $mainDom;
    private $baseDom;
    private $productDom;
    private $productInstance;
    private $productName;
    /**
     * Set initial values from XSD files
     * @param type $product
     */
    public function __construct($product, $path) {
        $this->productName=$product;
        $this->productInstance = new stdClass();
        $this->setDomDocuments($product, $path);
        $x = new DOMXPath($this->mainDom);
        $query = '//xsd:schema/xsd:element[@name="Product"]/xsd:complexType/xsd:sequence/*';
        $content = $x->query($query);
        //Set Class Properties
        $this->productInstance = $this->getElements($content);
        
        $this->mainDom = null;
        $this->urlDom = null;
        $this->productDom = null;
    }

    /**
     * Loads Main, Base and Product XSD schemas
     */
    private function setDomDocuments($product, $path) {
        $url = $path ; 
        //$url = 'https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/'; 
        $mainXSD = 'Product.xsd';
        $baseXSD = 'amzn-base.xsd';
        //Load Main XSD
        $this->mainDom = new DOMDocument();
        $this->mainDom->load($url . $mainXSD);
        //Load Base XSD
        $this->urlDom = new DOMDocument();
        $this->urlDom->load($url . $baseXSD);
        //Load Product XSD
        $this->productDom = new DOMDocument();
        $this->productDom->load($url . $product);
        
        
        $delete = $this->mainDom->getElementsByTagName('xsd:annotation');
        foreach($delete as $d):
            $d->parentNode->removeChild($d);
        endforeach;
    }

    /**
     * Analize every child element to obtain its data detail
     * @param DOMNodeList $elements
     */
    private function getElements(DOMNodeList $elements, $ProductData=false) {
        //This will contain the custom Product        
        $result = new stdClass();
        $instance = new stdClass();
        //Evaluates every node from the Node List
        foreach ($elements as $element):
            $name = $element->getAttribute('name');
            $ref = $element->getAttribute('ref');
            $result = $this->getElementStructure($element);
            //deletes unnecesary Tags
            $n='';
            if($ref!=null):
                $n=$ref;
            else:
                $n=$name;
            endif;
            if($result!=null):      
                $instance->mandatory=null;
                $instance->value=null;
                $instance->$n= $result;
            endif;               
            
        endforeach;
        return $instance;
    }
    /**
     * Obtains the structure of an XSD Element
     * @param DOMElement $element
     * @param type $parentNode
     * @return null
     */
    private function getElementStructure(DOMElement $element, $parentNode=null) {
        
        $el = $element;
        
        //These Node Types are omitted by default
        if (Node::hasNoData($element->nodeName) || !Node::isElement($element->nodeName)):            
            return null;
        endif;        
        
        if(!$element->hasChildNodes()&&XmlDataType::isXmlDataType($element->getAttribute('type'))):
            $object = new stdClass();
            $object->mandatory='false';    
            $object->value=null;
            $object->type =  XmlDataType::getHtmlEquivalent($element->getAttribute('type'));            
            $object->limit='';

            $minOccurs = $element->getAttribute('minOccurs');
            
            if(isset($minOccurs)&&$minOccurs>=1){
                $object->mandatory='true';
            }                
            $maxOccurs = $element->getAttribute('maxOccurs');
            if(isset($maxOccurs)&&$maxOccurs>'0'){
                $object->limit=$maxOccurs;
            }
            $this->getRestriction($element->getAttribute('name'), $element, $object);
            
            return $object;
        endif;
        
        $element=$this->getRefElement($element);
        
        if (!$element):            
            return null;
        endif;
        
        $name = $element->getAttribute('name');        
        $type = $element->getAttribute('type');
        
        $elementWithChildren = $element;
        $typeDetail = $this->getTypeStructure($type, $element);
        
        if($typeDetail!=null):      
            $element->removeAttribute('type');
            $element->appendChild($typeDetail);
            $elementWithChildren = $element;            
        endif;
                    
        //
        if(!$elementWithChildren):
            return null;
        endif;
        
        if (Node::isElement($elementWithChildren->nodeName)) :
            $object = new stdClass();
            $object->mandatory=null;
            $object->value=null;
            if ($elementWithChildren->hasChildNodes()) :
                $mandatory = $elementWithChildren->getAttribute('minOccurs');
                $value = 'true';
                
                if($mandatory!=null&&$mandatory==0):
                    $value='false';
                endif;                
                $object = $this->getChildrenProperties($elementWithChildren, $parentNode, $name);
                if($object!=null):
                    $object->mandatory=$value;
                endif;
                
            else:
                $object->mandatory='false';
                $object->type = XmlDataType::getHtmlEquivalent($elementWithChildren->getAttribute('type'));                
                $object->limit='';
                
                $minOccurs = $elementWithChildren->getAttribute('minOccurs');
                if(isset($minOccurs)&&$minOccurs>=1){
                    $object->mandatory='true';
                }                
                $maxOccurs = $elementWithChildren->getAttribute('maxOccurs');
                if(isset($maxOccurs)&&$maxOccurs>0){
                    $object->limit=$maxOccurs;
                }
                
            endif;            
            
            return $object;
        endif;
        
        return null;
    }
    
    
    /**
     * Searches in XSD files related (Base or Product) for the $ref Definition
     * @param type $ref
     */
    private function getRefElement(DOMElement $element) {
        $ref = $element->getAttribute('ref');
        
        if($ref==null){
            return $element;
        }
        $query = 'xsd:element[@name="' . $ref . '"]';        
        $xsd = array('main'=>$this->mainDom, 'base'=>$this->urlDom, 'prod'=>$this->productDom);
        
        foreach($xsd as $schema):
            $x = new DOMXPath($schema);
            $result = $x->query($query);
            foreach ($result as $node):
                return $this->mainDom->importNode($node,true);
            endforeach;
        endforeach;
               
        return false;
        
    }
    
    /**
     * 
     * @param type $type
     * @param DOMElement $element
     * @param type $found
     * @return null|\DOMElement|boolean
     * @throws Exception
     */
    private function getTypeStructure($type, DOMElement $element, $forced=false){
        
        if($type==null||XmlDataType::isXmlDataType($type)):            
            return null;
        endif;
        if((!$forced&&$element->hasChildNodes()&&!XmlDataType::isXmlDataType($type))):
            return null;
        endif;
        
        $arrTags = array('xsd:simpleType','xsd:complexType');
        $domDocuments = array('main'=>$this->mainDom, 'base'=>$this->urlDom, 'prod'=>$this->productDom);
        $arr = array();
        foreach($arrTags as $tag):
            $queryTypeElement = $tag.'[@name="' . $type . '"]';            
            foreach($domDocuments as $dom):
                $x = new DOMXPath($dom);        
                $result = $x->query($queryTypeElement);
                foreach ($result as $node):
                    if(!Node::hasNoData($node->nodeName)):    
                        return $this->mainDom->importNode($node, true);
                    endif;
                endforeach;
            endforeach;        
        endforeach;
        
        return null;
    }
    
    /**
     * Obtains properties from child simpleType/complexType Elements
     * @param DOMElement $element
     * @param type $parentNode
     * @param type $name
     * @return null
     */
    private function getChildrenProperties(DOMElement $element, $parentNode, $name) {
        
        foreach($element->childNodes as $node):            
            $nodeName = str_replace('xsd:', '', $node->nodeName);                    
            if (!Node::hasNoData($nodeName)):
                switch ($nodeName):
                    case 'simpleType':
                        return $this->getSimpleType($name, $node);
                        break;
                    case 'complexType':                        
                        return $this->getComplexType($name, $node, $parentNode);
                        break;
                    case 'simpleContent':
                        return $this->getSimpleContent($name, $node);
                        break;
                    default: return null;
                endswitch;
            endif;
        endforeach;        
    }
    
    private function getSimpleType($name, DOMElement $element) {
        $object = new stdClass();    
        foreach ($element->childNodes as $node) {
            if (!Node::hasNoData($node->nodeName)):
                switch ($node->nodeName):
                    case 'xsd:restriction':
                            $object->mandatory='false';                            
                            $object->value=null;
                            $object->type =  XmlDataType::getHtmlEquivalent($node->getAttribute('base'));                            
                            ////////////////////////////////////////////////////////////////
                            //added on Oct 16th, 2012. Some types are extensions of Custom Types
                            /*
                            if($object->type!=null && !XmlDataType::isHtmlEquivalent($object->type)):                                
                                $typeDetail = $this->getTypeStructure($object->type, $node, true);
                                if($typeDetail!=null):                                     
                                    foreach($typeDetail->childNodes as $det):                                                                                                                        
                                        if($det->hasChildNodes()):
                                            $object->type = XmlDataType::getHtmlEquivalent($det->getAttribute('base'));
                                            foreach($det->childNodes as $toAdd):
                                              if(!Node::hasNoData($toAdd->nodeName)):
                                                  $node->appendChild($toAdd);
                                              endif;
                                            endforeach;                                             
                                        endif;
                                    endforeach;
                                endif;
                            endif;
                             */
                            ////////////////////////////////////////////////////////////////
                            $object->limit='';

                            $minOccurs = $element->getAttribute('minOccurs');
                            if(isset($minOccurs)&&$minOccurs>=1){
                                $object->mandatory='true';
                            }                
                            $maxOccurs = $element->getAttribute('maxOccurs');
                            if(isset($maxOccurs)&&$maxOccurs>'0'){
                                $object->limit=$maxOccurs;
                            }
                            $this->getRestriction($name, $node, $object);
                        return $object;
                        break;
                    default: ;// throw new Exception($node->nodeName . ' was not considered');
                endswitch;
            endif;
        }        
        return null;
    }

    private function getRestriction($name, DOMElement $restriction, $obj) {
        //$obj = new stdClass();
        $allowedValues = array();
        /*
        $obj->maxDigits = '';
        $obj->maxLength = '';
        $obj->minLength = '';
        $obj->pattern = '';
        $obj->minValue = '';        
        $obj->maxValue = '';
        $obj->allowedValues = '';
         */
        if(!isset($obj->maxDigits)):
            $obj->maxDigits='';
        endif;
        if(!isset($obj->maxLength)):
            $obj->maxLength='';
        endif;
        if(!isset($obj->minLength)):
            $obj->minLength='';
        endif;
        if(!isset($obj->pattern)):
            $obj->pattern='';
        endif;
        if(!isset($obj->minValue)):
            $obj->minValue='';
        endif;
        if(!isset($obj->maxValue)):
            $obj->maxValue='';
        endif;
        if(!isset($obj->allowedValues)):
            $obj->allowedValues='';
        endif;
        
        foreach ($restriction->childNodes as $r):
            if (!Node::hasNoData($r->nodeName)):
                $attrValue=null;
                try{
                    $attrValue = $r->getAttribute('value');
                }catch(Exception $e){
                    $attrValue = null;
                }
            
                switch ($r->nodeName):
                    //Defines a list of acceptable values
                    case 'xsd:enumeration':
                        if($attrValue!=null):
                            $allowedValues[] = $attrValue;
                        endif;
                        break;
                    //Specifies the maximum number of decimal places allowed. Must be equal to or greater than zero                  
                    case 'xsd:fractionDigits':
                        if($attrValue!=null):
                            $obj->maxDigits = $attrValue;
                        endif;
                        break;
                    //Specifies the exact number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:length':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Specifies the minimum number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:minLength':
                        if($attrValue!=null):
                            $obj->minLength = $attrValue;
                        endif;
                        break;
                    //Specifies the maximum number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:maxLength':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Defines the exact sequence of characters that are acceptable
                    case 'xsd:pattern':
                        if($attrValue!=null):
                            $obj->pattern = $attrValue;
                        endif;
                        break;
                    //Specifies the lower bounds for numeric values (the value must be greater than or equal to this value)
                    case 'xsd:minInclusive':
                        if($attrValue!=null):
                            $obj->minValue = $attrValue;
                        endif;
                        break;
                    //Specifies the lower bounds for numeric values (the value must be greater than this value)
                    case 'xsd:minExclusive':
                        if($attrValue!=null):
                            $obj->minValue = $attrValue+1;
                        endif;
                        break;
                    //Specifies the upper bounds for numeric values (the value must be less than or equal to this value)
                    case 'xsd:maxInclusive':
                        if($attrValue!=null):
                            $obj->maxValue = $attrValue;
                        endif;
                        break;
                    //Specifies the upper bounds for numeric values (the value must be less than this value)
                    case 'xsd:maxExclusive':
                        if($attrValue!=null):
                            $obj->maxValue = $attrValue-1;
                        endif;
                        break;
                    //Specifies the exact number of digits allowed. Must be greater than zero
                    case 'xsd:totalDigits':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Specifies how white space (line feeds, tabs, spaces, and carriage returns) is handled
                    case 'xsd:whiteSpace':;
                        break;
                    default: ;//throw new Exception($r->nodeName . ' was not considered');
                endswitch;
            endif;
        endforeach;
        if(count($allowedValues)>0):
            $obj->allowedValues = $allowedValues;
        endif;
        return $obj;
    }

    private function getComplexType($name, DOMElement $element, $parentNode) {        
        foreach($element->childNodes as $node):            
            if (!Node::hasNoData($node->nodeName)&&$node->nodeName=='xsd:simpleContent'):                
                $return = $this->getSimpleContent($name, $node);
                if($return !=null){
                    return $return;
                    break;
                }
            endif;
        endforeach;
                
        $x = new DOMXPath($this->mainDom);
        $query = '*/xsd:element';
        //current element defined as context
        $content = $x->query($query,$element);                 
        if($content):
            $complexType= $this->getElements($content);
        endif;
        return $complexType;
        
    }
    private function getSimpleContent($name, DOMElement $element){        
        
        $object = new stdClass();        
        $object->mandatory=null;
        foreach ($element->childNodes as $node) {
            if (!Node::hasNoData($node->nodeName)):
                switch ($node->nodeName):
                    case 'xsd:extension':
                          $arrTags = array('xsd:simpleType','xsd:complexType');
                          $baseType = $node->getAttribute('base');
                          $arrDom = array($this->mainDom, $this->urlDom, $this->productDom);
                          
                          foreach($arrTags as $tag):                              
                                $querySimple = $tag.'[@name="'.$baseType.'"]';
                                foreach($arrDom as $dom):
                                      $x = new DOMXPath($dom);
                                      $e = $x->query($querySimple);
                                      foreach($e as $typeFound){
                                          $object = $this->getSimpleType($name, $typeFound);
                                          break;
                                      }
                                endforeach;
                          endforeach;
                          
                          $attributes;
                          $object->attr=new stdClass();
                                                    
                          foreach($node->childNodes as $attr):
                              if($attr->nodeName=='xsd:attribute'):                                  
                                $attrName = $attr->getAttribute('name');
                                $attribute = $attr->getAttribute('type');
                                $required = 'false';
                                
                                if($attr->getAttribute('use')==='required'):
                                    $required = 'true';
                                endif;
                                
                                if($attrName != null):                                          
                                      foreach($arrTags as $tag):                              
                                        $querySimple = $tag.'[@name="'.$attribute.'"]';  
                                          foreach($arrDom as $dom):
                                                $x = new DOMXPath($dom);
                                                $e = $x->query($querySimple);
                                                foreach($e as $typeFound){                                                  
                                                    $attrClass = $this->getSimpleType($name, $typeFound);
                                                    break;
                                                }
                                          endforeach;                        
                                      endforeach;   
                                      $attrClass->mandatory=$required;
                                      $object->attr->$attrName = $attrClass;
                                endif;
                              endif;
                          endforeach;
                          
                          
                          return $object;
                        break;
                    default: ;//throw new Exception($node->nodeName . ' was not considered');
                endswitch;
            endif;
        }        
        return $object;
    }
    
    public function getInstance(){
       return $this->productInstance;
   }    
        
    public function getArray() {
        $arr = get_object_vars($this);
        return $arr;
    }

}
?>