<?php
require_once(_PS_MODULE_DIR_ . 'amazon/classes/amazon.tools.class.php');

/**
 * Description of XsdProperties
 *
 * @author Erick Turcios
 */ 
class AmazonXSD {

    private $mainDom;
    private $baseDom;
    private $productDom;
    private $productInstance;
    private $productName;

    public static $requireMfrPartNumber = array( 'AutoAccessoryMisc',
							'AutoPart',
							'PowersportsPart',
							'PowersportsVehicle',
							'ProtectiveGear',
							'Helmet',
							'RidingApparel',
							'Tire',
							'Rims',
							'TireAndWheel',
							'Vehicle',
							'Motorcyclepart',
							'Motorcycleaccessory',
							'Ridinggloves',
							'Ridingboots',
                                                        'PaperProducts',
                                                        'PhoneAccessory',
                                                        'Phone',
                                                        'DigitalCamera',
                                                        'Gifts_and_Occasions',
                                                        'ApplianceAccessory',
                                                        'Kitchen',
                                                        'PersonalCareAppliances',
                                                        'EntertainmentMemorabilia',
                                                        'Musical_Instruments',
                                                        'PetSuppliesMisc',
                                                        'PersonalCareAppliances'   
                                            ) ;     
    // Added by Olivier 2012/11/27
    const definitionURL = 'https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/' ;
    const mainUrl = 'https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/Product.xsd' ;
    const baseXSD = 'https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/amzn-base.xsd' ;
    private $attributeTypes =  array( 'type'=>'type',
                                'mandatory'=>'mandatory',
                                'limit'=>'limit',
                                'maxDigits'=>'maxDigits',
                                'maxLength'=>'maxLength',
                                'minLength'=>'minLength',
                                'pattern'=>'pattern',
                                'minValue'=>'minValue',
                                'maxValue'=>'maxValue',
                                'allowedValues'=>'allowedValues',
                                'value'=>'value',
                                'attr'=>'attr'
                              );       
    /**
     * Set initial values from XSD files
     * @param type $product
     */
    public function __construct($product) {
        $this->productName=$product;
        $this->productInstance = new stdClass();
        $this->setDomDocuments($product);        
        $x = new DOMXPath($this->mainDom);
        $query = '//xsd:schema/xsd:element[@name="Product"]/xsd:complexType/xsd:sequence/*';
        $content = $x->query($query);
        //Set Class Properties
        $this->productInstance = $this->getElements($content);
        
        $this->mainDom = null;
        $this->urlDom = null;
        $this->productDom = null;
    }

    /*
     * Added by Olivier 2012/11/27
     */
    
    public static function cache($URL) 
    {
        $dir = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'xsd';  
        
        if ( ! is_dir($dir) )
                if ( ! mkdir($dir) )
                        return(false) ;
        
        if ( ! is_writable($dir) )
                @chmod($dir, 0775) ;
                
        $output_file = $dir . DIRECTORY_SEPARATOR . basename($URL) ;        
        
        if (  file_exists($output_file) && filesize($output_file) > 1024 )
            if ( (time() - filemtime($output_file)) < ((60 * 60 * 24 * 30) + rand(86400, 86400 * 7)) )        
                return(Amazon_Tools::file_get_contents($output_file)) ;

        $contents = Amazon_Tools::file_get_contents($URL);

        if ( file_exists($output_file) && ! ($contents) )
           return(false) ;

        if ( ! is_writable($output_file) )
            @chmod($output_file, 0664) ;
        
        if ( ! file_put_contents($output_file, $contents) )
           return(false) ;
     
        return($contents) ;
    }        
    
    public static function getCategories(){        
        $dom = new DOMDocument();
        $dom->loadXML( self::cache(self::mainUrl) );

        $x = new DOMXPath($dom);
        /*changed on november 16th, 2012 by Erick T.
        $query = '//xsd:schema/xsd:element[@name="Product"]/xsd:complexType/xsd:sequence/xsd:element[@name="ProductData"]/xsd:complexType/xsd:choice/xsd:element';
        $categories = $x->query($query);
        $cat=array();
        foreach($categories as $category):       
            $val = $category->getAttribute('ref');
            if(isset($val)):
                $cat[]=$val;
            endif;
        endforeach;
        */
        
        $xclude = array('AdditionalProductInformation.xsd', 'FBA.xsd', 'amzn-base.xsd', 'Amazon.xsd', 'MaterialHandling.xsd') ;
        
        $query = '//xsd:schema/xsd:include';
        $categories = $x->query($query);
        $cat=array();
        foreach($categories as $category):       
            $val = $category->getAttribute('schemaLocation');
            if(isset($val) && ! in_array($val, $xclude)):                
                $cat[]=  str_replace(".xsd", "", $val);
            endif;
        endforeach;
        return $cat;
    }
    
    /**
     * Loads Main, Base and Product XSD schemas
     */
    private function setDomDocuments($product) {
        
        //Load Main XSD
        $this->mainDom = new DOMDocument();
        $this->mainDom->loadXML(self::cache(self::mainUrl));
        //Load Base XSD
        $this->urlDom = new DOMDocument();
        $this->urlDom->loadXML(self::cache(self::baseXSD));
        //Load Product XSD
        $this->productDom = new DOMDocument();
        $this->productDom->loadXML( self::cache(self::definitionURL . $product) ) ;
        
        
        $delete = $this->mainDom->getElementsByTagName('xsd:annotation');
        foreach($delete as $d):
            $d->parentNode->removeChild($d);
        endforeach;
    }

    /**
     * Analize every child element to obtain its data detail
     * @param DOMNodeList $elements
     */
    private function getElements(DOMNodeList $elements, $ProductData=false) {
        //This will contain the custom Product        
        $result = new stdClass();
        $instance = new stdClass();
        //Evaluates every node from the Node List
        foreach ($elements as $element):
            $name = $element->getAttribute('name');
            $ref = $element->getAttribute('ref');
            $result = $this->getElementStructure($element);
            //deletes unnecesary Tags
            $n='';
            if($ref!=null):
                $n=$ref;
            else:
                $n=$name;
            endif;
            if($result!=null):      
                $instance->mandatory=null;
                $instance->value=null;
                $instance->$n= $result;
            endif;               
            
        endforeach;
        return $instance;
    }
    /**
     * Obtains the structure of an XSD Element
     * @param DOMElement $element
     * @param type $parentNode
     * @return null
     */
    private function getElementStructure(DOMElement $element, $parentNode=null) {
        
        $el = $element;
        
        //These Node Types are omitted by default
        if (Node::hasNoData($element->nodeName) || !Node::isElement($element->nodeName)):            
            return null;
        endif;        
        
        if(!$element->hasChildNodes()&&XmlDataType::isXmlDataType($element->getAttribute('type'))):
            $object = new stdClass();
            $object->mandatory='false';    
            $object->value=null;
            $object->type =  XmlDataType::getHtmlEquivalent($element->getAttribute('type'));            
            $object->limit='';

            $minOccurs = $element->getAttribute('minOccurs');
            
            if(isset($minOccurs)&&$minOccurs>=1){
                $object->mandatory='true';
            }                
            $maxOccurs = $element->getAttribute('maxOccurs');
            if(isset($maxOccurs)&&$maxOccurs>'0'){
                $object->limit=$maxOccurs;
            }
            $this->getRestriction($element->getAttribute('name'), $element, $object);
            
            return $object;
        endif;
        
        $min = $element->getAttribute('minOccurs');        
        $element=$this->getRefElement($element, isset($min)?$min:null);
        
        if (!$element):            
            return null;
        endif;
        
        $name = $element->getAttribute('name');        
        $type = $element->getAttribute('type');
        
        $elementWithChildren = $element;
        $typeDetail = $this->getTypeStructure($type, $element);
        
        if($typeDetail!=null):      
            $element->removeAttribute('type');
            $element->appendChild($typeDetail);
            $elementWithChildren = $element;            
        endif;
                    
        //
        if(!$elementWithChildren):
            return null;
        endif;
        
        if (Node::isElement($elementWithChildren->nodeName)) :
            $object = new stdClass();
            $object->mandatory=null;
            $object->value=null;
            if ($elementWithChildren->hasChildNodes()) :
                $mandatory = $elementWithChildren->getAttribute('minOccurs');
                $value = 'true';
                
                if($mandatory!=null&&$mandatory==0):
                    $value='false';
                endif;                
                $object = $this->getChildrenProperties($elementWithChildren, $parentNode, $name);
                if($object!=null):
                    $object->mandatory=$value;
                endif;
                
            else:
                $object->mandatory='false';
                $object->type = XmlDataType::getHtmlEquivalent($elementWithChildren->getAttribute('type'));                
                $object->limit='';
                
                $minOccurs = $elementWithChildren->getAttribute('minOccurs');
                if(isset($minOccurs)&&$minOccurs>=1){
                    $object->mandatory='true';
                }                
                $maxOccurs = $elementWithChildren->getAttribute('maxOccurs');
                if(isset($maxOccurs)&&$maxOccurs>0){
                    $object->limit=$maxOccurs;
                }
                
            endif;            
            
            return $object;
        endif;
        
        return null;
    }
    
    
    /**
     * Searches in XSD files related (Base or Product) for the $ref Definition
     * @param type $ref
     */
    private function getRefElement(DOMElement $element, $min=null) {
        $ref = $element->getAttribute('ref');
        
        if($ref==null){
            return $element;
        }
        $query = 'xsd:element[@name="' . $ref . '"]';        
        $xsd = array('main'=>$this->mainDom, 'base'=>$this->urlDom, 'prod'=>$this->productDom);
        
        foreach($xsd as $schema):
            $x = new DOMXPath($schema);
            $result = $x->query($query);
            if($result):
                foreach ($result as $node):
                    if($min!=null):
                        $node->setAttribute('minOccurs',$min);        
                    endif;
                    return $this->mainDom->importNode($node->cloneNode(true),true);
                endforeach;
            endif;
        endforeach;
               
        return false;
        
    }
    
    /**
     * 
     * @param type $type
     * @param DOMElement $element
     * @param type $found
     * @return null|\DOMElement|boolean
     * @throws Exception
     */
    private function getTypeStructure($type, DOMElement $element, $forced=false){
        
        if($type==null||XmlDataType::isXmlDataType($type)):            
            return null;
        endif;
        if((!$forced&&$element->hasChildNodes()&&!XmlDataType::isXmlDataType($type))):
            return null;
        endif;
        
        $arrTags = array('xsd:simpleType','xsd:complexType');
        $domDocuments = array('main'=>$this->mainDom, 'base'=>$this->urlDom, 'prod'=>$this->productDom);
        
        foreach($arrTags as $tag):
            $queryTypeElement = $tag.'[@name="' . $type . '"]';            
            foreach($domDocuments as $dom):
                $x = new DOMXPath($dom);        
                $result = $x->query($queryTypeElement);
                foreach ($result as $node):
                    if(!Node::hasNoData($node->nodeName)):    
                        return $this->mainDom->importNode($node->cloneNode(true), true);
                    endif;
                endforeach;
            endforeach;        
        endforeach;
        
        return null;
    }
    
    /**
     * Obtains properties from child simpleType/complexType Elements
     * @param DOMElement $element
     * @param type $parentNode
     * @param type $name
     * @return null
     */
    private function getChildrenProperties(DOMElement $element, $parentNode, $name) {
        
        foreach($element->childNodes as $node):            
            $nodeName = str_replace('xsd:', '', $node->nodeName);                    
            if (!Node::hasNoData($nodeName)):
                switch ($nodeName):
                    case 'simpleType':
                        return $this->getSimpleType($name, $node);
                        break;
                    case 'complexType':                        
                        return $this->getComplexType($name, $node, $parentNode);
                        break;
                    case 'simpleContent':
                        return $this->getSimpleContent($name, $node);
                        break;
                    default: return null;
                endswitch;
            endif;
        endforeach;        
    }
    
    private function getSimpleType($name, DOMElement $element) {
        $object = new stdClass();    
        foreach ($element->childNodes as $node) {
            if (!Node::hasNoData($node->nodeName)):                
                switch ($node->nodeName):
                    case 'xsd:union':
                            $object->mandatory='false';                            
                            $object->value=null;
                            $object->type =  "text";//XmlDataType::getHtmlEquivalent($node->getAttribute('base'));                            
                            $arrTypes = explode(" ",$node->getAttribute('memberTypes'));
                            $el = $this->mainDom->createElement('xsd:element');
                            //$node->parentNode->replaceChild($el,$node);
                            
                            foreach($arrTypes as $t):                                
                                $el->setAttribute('type',$t);
                                $typeDetail = $this->getTypeStructure($t, $el, true);

                                if($typeDetail!=null):                                     
                                    foreach($typeDetail->childNodes as $det):                                                                                                                        
                                        if($det->hasChildNodes()):                                            
                                            foreach($det->childNodes as $toAdd):
                                              if(!Node::hasNoData($toAdd->nodeName)):
                                                  try{
                                                     $el->appendChild($toAdd->cloneNode(true));
                                                  }catch(Exception $ex){
                                                  }
                                              endif;
                                            endforeach;                                             
                                        endif;
                                    endforeach;
                                endif;                            
                            endforeach;
                            
                            ////////////////////////////////////////////////////////////////
                            if(!isset($object->limit)):
                                $object->limit='';
                            endif;

                            $minOccurs = $element->getAttribute('minOccurs');
                            if(isset($minOccurs)&&$minOccurs>=1){
                                $object->mandatory='true';
                            }                
                            $maxOccurs = $element->getAttribute('maxOccurs');
                            if(isset($maxOccurs)&&$maxOccurs>'0'){
                                $object->limit=$maxOccurs;
                            }
                            $this->getRestriction($name, $el, $object);
                            
                            return $object;
                            break;
                    case 'xsd:restriction':
                            $object->mandatory='false';                            
                            $object->value=null;
                            $object->type =  XmlDataType::getHtmlEquivalent($node->getAttribute('base'));                            
                            ////////////////////////////////////////////////////////////////
                            //added on Oct 16th, 2012. Some types are extensions of Custom Types                            
                            if($object->type!=null && !XmlDataType::isHtmlEquivalent($object->type)):                                
                                $typeDetail = $this->getTypeStructure($object->type, $node, true);
                                if($typeDetail!=null):                                     
                                    foreach($typeDetail->childNodes as $det):                                                                                                                        
                                        if($det->hasChildNodes()):
                                            $object->type = XmlDataType::getHtmlEquivalent($det->getAttribute('base'));
                                            foreach($det->childNodes as $toAdd):
                                              if(!Node::hasNoData($toAdd->nodeName)):
                                                  try{
                                                     $node->appendChild($toAdd->cloneNode(true));
                                                  }catch(Exception $ex){
                                                     //$xb = $det->getAttribute('base');
                                                     //echo "</br>ERROR on $name for base $xb: ".$ex->getMessage();
                                                  }
                                              endif;
                                            endforeach;                                             
                                        endif;
                                    endforeach;
                                endif;
                            endif;
                            ////////////////////////////////////////////////////////////////
                            $object->limit='';

                            $minOccurs = $element->getAttribute('minOccurs');
                            if(isset($minOccurs)&&$minOccurs>=1){
                                $object->mandatory='true';
                            }                
                            $maxOccurs = $element->getAttribute('maxOccurs');
                            if(isset($maxOccurs)&&$maxOccurs>'0'){
                                $object->limit=$maxOccurs;
                            }
                            $this->getRestriction($name, $node, $object);
                        return $object;
                        break;
                    default: ;// throw new Exception($node->nodeName . ' was not considered');
                endswitch;
            endif;
        }        
        return null;
    }

    private function getRestriction($name, DOMElement $restriction, $obj) {
        //$obj = new stdClass();
        $allowedValues = array();
        /*
        $obj->maxDigits = '';
        $obj->maxLength = '';
        $obj->minLength = '';
        $obj->pattern = '';
        $obj->minValue = '';        
        $obj->maxValue = '';
        $obj->allowedValues = '';
         */
        if(!isset($obj->maxDigits)):
            $obj->maxDigits='';
        endif;
        if(!isset($obj->maxLength)):
            $obj->maxLength='';
        endif;
        if(!isset($obj->minLength)):
            $obj->minLength='';
        endif;
        if(!isset($obj->pattern)):
            $obj->pattern='';
        endif;
        if(!isset($obj->minValue)):
            $obj->minValue='';
        endif;
        if(!isset($obj->maxValue)):
            $obj->maxValue='';
        endif;
        if(!isset($obj->allowedValues)):
            $obj->allowedValues='';
        endif;
        
        foreach ($restriction->childNodes as $r):
            if (!Node::hasNoData($r->nodeName)):
                $attrValue=null;
                try{
                    $attrValue = $r->getAttribute('value');
                }catch(Exception $e){
                    $attrValue = null;
                }
            
                switch ($r->nodeName):
                    //Defines a list of acceptable values
                    case 'xsd:enumeration':
                        if($attrValue!=null):
                            $allowedValues[] = $attrValue;
                        endif;
                        break;
                    //Specifies the maximum number of decimal places allowed. Must be equal to or greater than zero                  
                    case 'xsd:fractionDigits':
                        if($attrValue!=null):
                            $obj->maxDigits = $attrValue;
                        endif;
                        break;
                    //Specifies the exact number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:length':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Specifies the minimum number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:minLength':
                        if($attrValue!=null):
                            $obj->minLength = $attrValue;
                        endif;
                        break;
                    //Specifies the maximum number of characters or list items allowed. Must be equal to or greater than zero
                    case 'xsd:maxLength':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Defines the exact sequence of characters that are acceptable
                    case 'xsd:pattern':
                        if($attrValue!=null):
                            $obj->pattern = $attrValue;
                        endif;
                        break;
                    //Specifies the lower bounds for numeric values (the value must be greater than or equal to this value)
                    case 'xsd:minInclusive':
                        if($attrValue!=null):
                            $obj->minValue = $attrValue;
                        endif;
                        break;
                    //Specifies the lower bounds for numeric values (the value must be greater than this value)
                    case 'xsd:minExclusive':
                        if($attrValue!=null):
                            $obj->minValue = $attrValue+1;
                        endif;
                        break;
                    //Specifies the upper bounds for numeric values (the value must be less than or equal to this value)
                    case 'xsd:maxInclusive':
                        if($attrValue!=null):
                            $obj->maxValue = $attrValue;
                        endif;
                        break;
                    //Specifies the upper bounds for numeric values (the value must be less than this value)
                    case 'xsd:maxExclusive':
                        if($attrValue!=null):
                            $obj->maxValue = $attrValue-1;
                        endif;
                        break;
                    //Specifies the exact number of digits allowed. Must be greater than zero
                    case 'xsd:totalDigits':
                        if($attrValue!=null):
                            $obj->maxLength = $attrValue;
                        endif;
                        break;
                    //Specifies how white space (line feeds, tabs, spaces, and carriage returns) is handled
                    case 'xsd:whiteSpace':;
                        break;
                    default: ;//throw new Exception($r->nodeName . ' was not considered');
                endswitch;
            endif;
        endforeach;
        if(count($allowedValues)>0):
            $obj->allowedValues = $allowedValues;
        endif;
        return $obj;
    }

    private function getComplexType($name, DOMElement $element, $parentNode) {        
        foreach($element->childNodes as $node):            
            if (!Node::hasNoData($node->nodeName)&&$node->nodeName=='xsd:simpleContent'):                
                $return = $this->getSimpleContent($name, $node);
                if($return !=null){
                    return $return;
                    break;
                }
            endif;
        endforeach;
                
        $x = new DOMXPath($this->mainDom);
        $query = '*/xsd:element';
        //current element defined as context
        $content = $x->query($query,$element);                 
        if($content):
            $complexType= $this->getElements($content);
        endif;
        return $complexType;
        
    }
    private function getSimpleContent($name, DOMElement $element){        
        
        $object = new stdClass();        
        $object->mandatory=null;
        foreach ($element->childNodes as $node) {
            if (!Node::hasNoData($node->nodeName)):
                switch ($node->nodeName):
                    case 'xsd:extension':
                          $arrTags = array('xsd:simpleType','xsd:complexType');
                          $baseType = $node->getAttribute('base');
                          $arrDom = array($this->mainDom, $this->urlDom, $this->productDom);
                          
                          foreach($arrTags as $tag):                              
                                $querySimple = $tag.'[@name="'.$baseType.'"]';
                                foreach($arrDom as $dom):
                                      $x = new DOMXPath($dom);
                                      $e = $x->query($querySimple);
                                      foreach($e as $typeFound){
                                          $object = $this->getSimpleType($name, $typeFound);
                                          break;
                                      }
                                endforeach;
                          endforeach;
                          
                          $attributes;
                          $object->attr=new stdClass();
                                                    
                          foreach($node->childNodes as $attr):
                              if($attr->nodeName=='xsd:attribute'):                                  
                                $attrName = $attr->getAttribute('name');
                                $attribute = $attr->getAttribute('type');
                                $required = 'false';
                                
                                if($attr->getAttribute('use')==='required'):
                                    $required = 'true';
                                endif;
                                
                                if($attrName != null):                                          
                                      foreach($arrTags as $tag):                              
                                        $querySimple = $tag.'[@name="'.$attribute.'"]';  
                                          foreach($arrDom as $dom):
                                                $x = new DOMXPath($dom);
                                                $e = $x->query($querySimple);
                                                foreach($e as $typeFound){                                                  
                                                    $attrClass = $this->getSimpleType($name, $typeFound);
                                                    break;
                                                }
                                          endforeach;                        
                                      endforeach;   
                                      if ( ! isset($attrClass) || ! is_object($attrClass) )
                                          $attrClass = new stdClass () ;
                                      
                                      $attrClass->mandatory=$required ;
                                      $object->attr->$attrName = $attrClass;
                                endif;
                              endif;
                          endforeach;                          
                          
                          return $object;
                        break;
                    default: ;//throw new Exception($node->nodeName . ' was not considered');
                endswitch;
            endif;
        }        
        return $object;
    }
    
    public function getInstance(){
       return $this->productInstance;
   }    
        
    public function getArray() {
        $arr = get_object_vars($this);
        return $arr;
    }
    
    public static function isParentWithChildren($tagName){
        $mandatoryParentsWithChildren = array('AgeRecommendation');
        
        if(in_array($tagName,$mandatoryParentsWithChildren)):
            return true;
        endif;
        
        return false;
    }

    public static function getFields($elements, $mandatoryOnly = false){        
        
        $productInstanceMandatoryFields=new stdClass();
        if($elements instanceof stdClass):
            $var = get_object_vars($elements);
            foreach($var as $key=>$val):
                if(self::isParentWithChildren($key)):
                    $productInstanceMandatoryFields->$key=self::getFieldsChildren($elements->$key, true, $mandatoryOnly);
                else:
                    $productInstanceMandatoryFields->$key=self::getFields($elements->$key, $mandatoryOnly);
                endif;
            endforeach;
        else:
            return $elements;
        endif;
        return $productInstanceMandatoryFields;
    }
    public static function getFieldsChildren($elements, $parentMandatory=false, $mandatoryOnly = false){        
        
        $productInstanceMandatoryFields=new stdClass();
        if($elements instanceof stdClass):
            $var = get_object_vars($elements);
            foreach($var as $key=>$val):
                if($mandatoryOnly && self::isMandatoryField($elements->$key) || $parentMandatory ):
                    $productInstanceMandatoryFields->$key=self::getMandatoryFieldsChildren($elements->$key, true, $mandatoryOnly);
                elseif( ! $mandatoryOnly ):
                    $productInstanceMandatoryFields->$key=self::getFieldsChildren($elements->$key, true, $mandatoryOnly);
                endif;
            endforeach;
        else:
            return $elements;
        endif;
        return $productInstanceMandatoryFields;
    }
    
    
    
    public static function getMandatoryFields($elements){        
        
        $productInstanceMandatoryFields=new stdClass();
        if($elements instanceof stdClass):
            $var = get_object_vars($elements);
            foreach($var as $key=>$val):
                if(self::isMandatoryField($elements->$key)):
                    if(self::isParentWithChildren($key)):
                        $productInstanceMandatoryFields->$key=self::getMandatoryFieldsChildren($elements->$key, true);
                    else:
                        $productInstanceMandatoryFields->$key=self::getMandatoryFields($elements->$key);
                    endif;
                endif;
            endforeach;
        else:
            return $elements;
        endif;
        return $productInstanceMandatoryFields;
    }
    
    
    public static function getMandatoryFieldsChildren($elements, $parentMandatory=false){        
        
        $productInstanceMandatoryFields=new stdClass();
        if($elements instanceof stdClass):
            $var = get_object_vars($elements);
            foreach($var as $key=>$val):
                if(self::isMandatoryField($elements->$key) || $parentMandatory ):
                    $productInstanceMandatoryFields->$key=self::getMandatoryFieldsChildren($elements->$key, true);
                endif;
            endforeach;
        else:
            return $elements;
        endif;
        return $productInstanceMandatoryFields;
    }
    
    public static function isMandatoryField($item){
        if ( isset($item->mandatory) && (! $item->mandatory || $item->mandatory == 'false') ):
            return false;
        endif;
        return true;
    }
    
    public static function getVariationData($productInstance, $type){
        $name=null;
        foreach(get_object_vars($productInstance->ProductData) as $key=>$val):
            if($val instanceof stdClass):
                $name=$key;
                break;
            endif;
        endforeach;
        
        if($name==null):
            return false;
        endif;
        
        $category = self::getProductNameEquivalent($name);
        
        if(isset($productInstance->ProductData->$category->$type)):
            return $productInstance->ProductData->$category->$type;
        elseif(isset($productInstance->ProductData->$category->VariationData->$type)):
            return $productInstance->ProductData->$category->VariationData->$type;
        else:
            //checks if has one only Child
            if(isset($productInstance->ProductData->$category->ProductType)):
                $pt = get_object_vars($productInstance->ProductData->$category->ProductType);
                
                if(count($pt)<=3):
                    foreach($pt as $key=>$val):
                         if(isset($productInstance->ProductData->$category->ProductType->$key->$type)):
                             return $productInstance->ProductData->$category->ProductType->$key->$type;
                         elseif(isset($productInstance->ProductData->$category->ProductType->$key->VariationData->$type)):
                             return $productInstance->ProductData->$category->ProductType->$key->VariationData->$type;
                         endif;
                    endforeach;   
                 endif;
            endif;
            
        endif;
            
        return false;
    }
    
    public static function getProductNameEquivalent($category){
        $arr = array("ProductClothing"=>"Clothing","SWVG"=>"SoftwareVideoGames");
        
        if(isset($arr[$category])):
            return $arr[$category];
        endif;
        
        return $category;
        
    }
    
   public static function getPathToElement($productInstance, $searchedElement, $refElement=null, $recursiveSearch=true, $parentPath=null){
        $arr=array();        
        $path="";
        
        if($refElement!=null):
            $refPath = self::getPathToElement($productInstance, $refElement);
            if(!$refPath):
                return false;
            endif;
            
            $refElements = explode("->",$refPath);
            $product = $productInstance;
            foreach($refElements as $key=>$val):
                $product = $product->$val;
            endforeach;
            
            $complement = self::getPathToElement($product, $searchedElement);
            
            if($complement):
                return $refPath."->".$complement;
            else:
                return false;
            endif; 
        endif;
        
        
        if($parentPath!=null):
            $path=$parentPath."->";
        endif;
        
        if($productInstance instanceof stdClass):
            $arr = get_object_vars($productInstance);
        elseif (is_array($productInstance)):
             $arr = $productInstance;
        else:
            return false;            
        endif;
        
        foreach($arr as $key=>$val):
            if($searchedElement==$key):
                return $path.$key;
            else:
                if(!($val instanceof stdClass) or !$recursiveSearch):
                    continue;
                endif;                                
                
                $childFound = self::getPathToElement($val, $searchedElement,null,true, $path.$key);
                if($childFound):
                    return $childFound;
                endif;
            endif;
        endforeach;
        
        return false;
    }
    
    public function isAttribute($key){
        return array_key_exists($key, $this->attributeTypes);
    }
    
    public function getInstanceElementsArray(array $structure, $object=null, $name="AmazonXSD"){
     
        $arr=array();
        if($object==null && $name=="AmazonXSD"):
            $object=  $this->getInstance();
        endif;
        
        if($object instanceof stdClass):
            $arr = get_object_vars($object);
        elseif(!($object instanceof stdClass) && !(is_array($object)) ):
            //it's a single value            
            return $object;
        elseif(is_array($object)):
            $arr=$object;
        else:
             return null;
        endif;
        
        foreach($arr as $key=>$value):
            //it's not an attribute like value, mandatory, etc
            if(!$this->isAttribute($key)):            
                $structure[$key] = array();
                $structure[$key] = $this->getInstanceElementsArray($structure[$key], $value, $key);
                if($structure[$key]==null):
                    unset($structure[$key]);
                    $structure[$key] = null;
                endif;
            endif;
        endforeach;
        return $structure;
    }
}
?>