<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Erick Turcios
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
/**
 * Contains XML Data Types and is used to compare if values correspond to any of them
 *
 * @author Erick Turcios
 */
class XmlDataType {
    private static $xmlStr = array('string','token', 'normalizedString');                                                      
    private static $xmlNum = array('byte','decimal','int','integer','negativeInteger',
                            'nonNegativeInteger','nonPositiveInteger',
                            'positiveInteger','short', 'unsignedLong','unsignedInt',
                            'unsignedShort','unsignedByte');
    private static $xmlDate = array('date','time','dateTime','duration','gDay','gMonth',
                             'gMonthDay','gYear','gYearMonth');
    private static $xmlBool = array('boolean');
    
    private static $xmlOther = array('anyURI','base64Binary');
    
    private static $prefix = 'xsd:';
    
    /**
     * Check is a value is a Xml String Type
     * @param type $type
     * @return True if the type is found, False otherwise
     */
    public static function isString($type){
        $type = str_ireplace(self::$prefix, '', $type);
        return in_array($type, self::$xmlStr);
    }
    /**
     * Check is a value is a Xml Numeric Type
     * @param type $type
     * @return True if the type is found, False otherwise
     */
    public static function isNumeric($type){
        $type = str_ireplace(self::$prefix, '', $type);
        return in_array($type, self::$xmlNum);
    }
    /**
     * Check is a value is a Xml Date Type
     * @param type $type
     * @return True if the type is found, False otherwise
     */
    public static function isDate($type){
        $type = str_ireplace(self::$prefix, '', $type);
        return in_array($type, self::$xmlDate);
    }
    
    /**
     * Check is a value is a Xml Type not considered in previous functions
     * @param type $type
     * @return True if the type is found, False otherwise
     */
    
    public static function isOther($type){
        $type = str_ireplace(self::$prefix, '', $type);
        return in_array($type, self::$xmlOther);
    }
    
    
    /**
     * Check is a value is a Xml Type Boolean
     * @param type $type
     * @return True if the type is found, False otherwise
     */
    
    public static function isBoolean($type){
        $type = str_ireplace(self::$prefix, '', $type);
        return in_array($type, self::$xmlBool);
    }
    
    /**
     * Check is a value is any of the Xml Data Types
     * @param type $type
     * @return True if the type is found, False otherwise
     */    
    public static function isXmlDataType($type){
        $simple = str_ireplace(self::$prefix, '', $type);
        $arrAll = array_merge(self::$xmlStr,self::$xmlNum, self::$xmlDate,self::$xmlOther);
        return in_array($simple, $arrAll);
    }
    
    public static function isHtmlEquivalent($type){
        $arr=array('text', 'number','date', 'boolean');
        $arrFull = array_merge($arr, self::$xmlDate);
        return in_array($type, $arrFull);
    }
    
    public static function getHtmlEquivalent($type){
        
        if(self::isString($type)):
            return 'text';
        endif;        
        if(self::isNumeric($type)):
            return 'number';
        endif;
        if(self::isDate($type)):
            //return 'date';
            return str_replace('xsd:', '', $type);
        endif;
        if(self::isOther($type)):
            return 'text';
        endif;
        if(self::isBoolean($type)):
            return 'boolean';
        endif;
        //return str_replace('xsd:', '', $type);
        return $type;
    }
    
}

?>
