<?php
require_once _PS_MODULE_DIR_ . 'dbbackup/classes/backup.db.php';
require_once _PS_MODULE_DIR_ . 'dbbackup/classes/restore.db.php';

class dbBackup extends Module
{
	/** @var string filesDir */
	private $filesDir = 'dbcopies';

	/** @var string moduleDir */
	private $moduleDir;

	/** @var string displayName */
  public $displayName;

	/** @var string description */
  public $description;

	public function __construct()
	{
 	 	$this->name = 'dbbackup';
 	 	$this->version = '1.3';
 	 	$this->tab = 'Julien Breux Développement';

		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Database Backup');
		$this->description = $this->l('Save your database');
		$this->moduleDir = realpath(dirname(__FILE__));
	}

  public function install()
  {
	 	if(!parent::install()):
	 		return false;
	 	else:
      $this->registerHook('leftColumn');
      Configuration::updateValue('PS_BACKUP_TIME', time() + 86400);
      Configuration::updateValue('PS_BACKUP_ABOUT', '1');
      Configuration::updateValue('PS_BACKUP_FREQUENCY', 'monthly');
	 	endif;
  }

  public function uninstall()
  {
	 	if(!parent::uninstall()):
      Configuration::deleteByName('PS_BACKUP_TIME');
      Configuration::deleteByName('PS_BACKUP_ABOUT');
      Configuration::deleteByName('PS_BACKUP_FREQUENCY');
	 		return true;
	 	endif;
  }

	public function getContent()
	{
    $return = '<h2>'.$this->displayName.'</h2>';
    if(Tools::isSubmit('Restore')):
      $restore = new RestoreDB(Tools::getValue('r'));
      if(empty($restore->error))
      {
  			$return .= '
  			<div class="conf confirm">
  				<img src="../img/admin/ok.gif" alt="" title="" />
  				'.$this->l('Restore success').'
  			</div>';
      }
      else
      {
  			$return .= '
  			<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				'.$this->l('Restore error').'
  			</div>';
      }
    elseif(Tools::isSubmit('Backup')):
      $backup = new BackupDB;
      if(empty($backup->error))
      {
  			$return .= '
  			<div class="conf confirm">
  				<img src="../img/admin/ok.gif" alt="" title="" />
  				'.$this->l('Success backup').'
  			</div>';
      }
      else
      {
  			$return .= '
  			<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				'.$this->l('Backup error').'
  			</div>';
      }
    elseif(Tools::isSubmit('Setting')):
      Configuration::updateValue('PS_BACKUP_ABOUT', Tools::getValue('a'));
      Configuration::updateValue('PS_BACKUP_FREQUENCY', Tools::getValue('f', Configuration::get('PS_BACKUP_FREQUENCY')));
      $t = time() + intval(str_replace(array('dayly', 'monthly', 'quarterly'), array('86400', '2592000', '7776000'), strval(Tools::getValue('f', Configuration::get('PS_BACKUP_FREQUENCY')))));
      Configuration::updateValue('PS_BACKUP_TIME', $t);
			$return .= '
			<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
    endif;
    $return .= $this->displayForm();
    return $return;
	}

	public function displayForm()
	{
    $frequency = array('dayly'=>'Dayly', 'monthly'=>'Monthly', 'quarterly'=>'Quarterly');
    $return = '';
		$return .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" name="R">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Availables backups').'</legend>
				<div style="margin-bottom: 10px;">
				  <center>
            <select name="r" size="5">
              '.$this->makeSelect(self::copiesList()).'
            </select>
          </center>
				</div>
        <center><input type="submit" name="Restore" value="'.$this->l('Restore').'" class="button" /></center>
			</fieldset>
    </form>
			<div>&nbsp;</div>
    <form action="'.$_SERVER['REQUEST_URI'].'" method="post" name="B">
			<fieldset>
        <legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Make a backup now').'</legend>
        <center><input type="submit" name="Backup" value="'.$this->l('Make a backup now').'" class="button" /></center>
			</fieldset>
    </form>
			<div>&nbsp;</div>
    <form action="'.$_SERVER['REQUEST_URI'].'" method="post" name="S">
			<fieldset>
				<legend><img src="'.$this->_path.'logo-1.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<h3>'.$this->l('Backup frequency').'</h3>
				<div style="margin-bottom: 10px; text-align: center;">
          <select name="f">
            '.$this->makeSelect($frequency, Configuration::get('PS_BACKUP_FREQUENCY')).'
          </select>
				</div>
				<h3>'.$this->l('About author').'</h3>
				<div style="margin-bottom: 10px; text-align: center;">
					<input type="radio" name="a" id="author_show" value="1" '.(Tools::getValue('a', Configuration::get('PS_BACKUP_ABOUT')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="author_show"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="a" id="author_hide" value="0" '.(!Tools::getValue('a', Configuration::get('PS_BACKUP_ABOUT')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="author_hide"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p class="clear"></p>
				</div>
        <center><input type="submit" name="Setting" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
    if(Configuration::get('PS_BACKUP_ABOUT') == '1')
    {
		  $return .= '<fieldset>
				<legend><img src="'.$this->_path.'logo-2.gif" alt="" title="" />'.$this->l('About author').'</legend>
				<div style="margin-bottom: 10px;">
				  <center>
            <a href="http://www.psfrance.org/forums/showthread.php?t=33" target="_blank">Julien Breux - Support</a>
          </center>
				</div>
			</fieldset>';
    }
    $return .= '<!-- '.$this->l('Dayly').' '.$this->l('Monthly').' '.$this->l('Quarterly').' -->';
    return $return;
	}

  private function makeSelect($items, $itemSelected='')
  {
    if(!is_array($items)):
      return false;
    endif;

    $return = '';
    foreach($items as $value=>$label):
      $selected = ($value == $itemSelected) ? ' selected="selected"' : ''; 
      $return .= "<option value=\"".$value."\"$selected>".$this->l($label)."</option>\n";
    endforeach;
    return $return;
  }

  private function copiesList()
  {
    $return = '';
    $files = scandir($this->moduleDir.DIRECTORY_SEPARATOR.$this->filesDir.DIRECTORY_SEPARATOR);
    foreach(array_reverse($files) as $file)
    {
      $version = str_replace('.', '', _PS_VERSION_);
      if($file != '.' && $file != '..' && $file != 'index.php' && $file != '.htaccess' && eregi($version, $file))
      {
        $return[$file] = str_replace(array($version.'_', '_', '.txt'), array('', ' - ', ''), $file);
      }
    }
    return $return;
  }

  function cron($output = false)
  {
    $t1 = intval(Configuration::get('PS_BACKUP_TIME'));
    $t2 = time();
    $t3 = time() + intval(str_replace(array('dayly', 'monthly', 'quarterly'), array('86400', '2592000', '7776000'), strval(Configuration::get('PS_BACKUP_FREQUENCY'))));
    if($t1 < $t2)
    {
      Configuration::updateValue('PS_BACKUP_TIME', $t3);
      $backup = new BackupDB;
      if($output != false)
      {
        if(!empty($backup->error))
        {
          print('Backup success');
        }
        else
        {
          print('Error backup');
        }
      }
    }
    else
    {
      if($output != false)
      {
        print('No backup to perform');
      }
    }
  }

	function hookLeftColumn($params)
	{
    $this->cron();
	}

	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}
}
?>