<?php
/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

class AdminDjvPosOrdersController extends ModuleAdminController
{
    public function __construct()
    {
        $this->context = Context::getContext();

        parent::__construct();

        $this->cashiers = $this->getCashiers();
        $this->payment_methods = array(
            'Efectivo' => $this->l('Efectivo'),
            'Tarjeta' => $this->l('Tarjeta'),
            'Cheque' => $this->l('Cheque')
        );

        $this->generic_shop_customer_id = (int)Configuration::get('DJVPOS_GSCID');
        $this->generic_shop_customer_address_id = (int)Configuration::get('DJVPOS_GSCAID');
        $this->generic_state = (int)Configuration::get('DJVPOS_FOSID');

        $this->context->currency = new Currency((int)Configuration::get('PS_CURRENCY_DEFAULT'));

        $this->context->smarty->assign(array(
            'currencyFormat' => $this->context->currency->format,
            'currencySign' => $this->context->currency->sign,
            'currencyBlank' => $this->context->currency->blank
        ));
    }

    protected function getCashiers()
    {
        $parts = explode(',', Configuration::get('DJVPOS_CASHIERS'));
        $cashiers = array();

        foreach ($parts as $part) {
            $part = trim($part);

            if ($part) {
                // for validator
                $cashiers[] = $part;
            }
        }

        return $cashiers;
    }

    public function setMedia()
    {
        parent::setMedia();

        $js_path = __PS_BASE_URI__.'modules/'.$this->module->name.'/views/js/';
        $css_path = __PS_BASE_URI__.'modules/'.$this->module->name.'/views/css/';

        if (_PS_VERSION_ > '1.5.6.0') {
            // for validator
            $this->addJqueryPlugin('cooki-plugin');
        } else {
            // for validator
            $this->addJqueryPlugin('cookie-plugin');
        }

        $this->addJqueryUI(array(
            'ui.autocomplete',
            'ui.button',
            'ui.dialog',
            'ui.menu',
            'ui.tooltip'
        ));

        $this->addJS(array(
            $js_path.'fullscreen.js',
            $js_path.'common.js',
            $js_path.'orders.js',
            $js_path.'orders-search-product.js',
            $js_path.'orders-product-table.js',
            $js_path.'orders-calc-table.js',
            $js_path.'orders-order-checkedout.js',
            $js_path.'orders-order-returned.js',
            $js_path.'jquery.easing.1.3.js',
            $js_path.'engage.itoggle.1.7.min.js',
            $js_path.'jquery.uniform.min.js'
        ));

        $this->addCSS(array(
            $css_path.'orders.css',
            $css_path.'jquery.qtip.css',
            //$css_path.'/font-awesome.css',
            $css_path.'uniform.light.css',
            $css_path.'custom.css'
        ));
    }

    /**
     * initContent
     */
    public function initContent()
    {
        parent::initContent();

        $task = Tools::getValue('task');

        switch ($task) {
            case 'addCustomer':
            case 'submitAddCustomer':
                $this->setTemplate('add-customer.tpl');
                break;

            default:
                $this->context->smarty->assign(array(
                    'cashiers' => $this->cashiers,
                    'payment_methods' => $this->payment_methods
                ));
                $this->setTemplate('order.tpl');
        }
    }

    /**
    * Admin panel product search
    *
    * @param integer $id_lang Language id
    * @param string $query Search query
    * @return array Matching products
    */
    private static function searchByName($id_lang, $query, Context $context = null)
    {
        if (!$context) {
            $context = Context::getContext();
        }

        $select = 'p.`id_product`, pa.`id_product_attribute`, pl.`name`, p.`active`,';
        $select .= 'p.`reference`, m.`name` AS manufacturer_name, stock.`quantity`,';
        $select .= 'product_shop.advanced_stock_management, p.`customizable`';
        $sql = new DbQuery();
        $sql->select($select);
        $sql->from('category_product', 'cp');
        $sql->leftJoin(
            'product',
            'p',
            'p.`id_product` = cp.`id_product` AND p.`id_category_default` = cp.`id_category`'
        );
        $sql->join(Shop::addSqlAssociation('product', 'p'));
        $sql->leftJoin(
            'product_lang',
            'pl',
            'p.`id_product` = pl.`id_product` AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl')
        );
        $sql->leftJoin('manufacturer', 'm', 'm.`id_manufacturer` = p.`id_manufacturer`');

        $where = 'pl.`name` LIKE \'%'.pSQL($query).'%\'
        OR p.`reference` LIKE \'%'.pSQL($query).'%\'
        OR p.`upc` LIKE \'%'.pSQL($query).'%\'
        OR p.`ean13` LIKE \'%'.pSQL($query).'%\'
        OR p.`supplier_reference` LIKE \'%'.pSQL($query).'%\'
        OR  p.`id_product` IN (
            SELECT id_product
            FROM '._DB_PREFIX_.'product_supplier sp
            WHERE `product_supplier_reference` LIKE \'%'.pSQL($query).'%\'
        )';
        $sql->orderBy('pl.`name` ASC, pa.`id_product_attribute` ASC');

        if (Combination::isFeatureActive()) {
            $sql->leftJoin('product_attribute', 'pa', 'pa.`id_product` = p.`id_product`');
            $sql->join(Shop::addSqlAssociation('product_attribute', 'pa', false));
            $where .= ' OR pa.`reference` LIKE \'%'.pSQL($query).'%\'';
            $where .= ' OR pa.`ean13` LIKE \'%'.pSQL($query).'%\'';
        }

        $sql->where($where);
        $sql->join(Product::sqlStock('p', 'pa', false, $context->shop));
        //error_log(print_r())
        $result = Db::getInstance()->executeS($sql);

        if (!$result) {
            return false;
        }

        $results_array = array();

        foreach ($result as $row) {
            $row['price_tax_incl'] = Product::getPriceStatic($row['id_product'], true, null, 2);
            $row['price_tax_excl'] = Product::getPriceStatic($row['id_product'], false, null, 2);

            $id_product = $row['id_product'];
            $id_product_attribute = (int)$row['id_product_attribute'];

            if (!$id_product_attribute) {
                $product = new Product($id_product);

                $row['price'] = Product::getPriceStatic($id_product, true, null, 6, null, false, false);
                $row['special'] = $product->getPrice(true);
            } else {
                //$product_attribute = new Combination((int)$row['id_product_attribute']);

                $product = new Product($id_product, $id_product_attribute);

                $row['price'] = Product::getPriceStatic(
                    $id_product,
                    true,
                    $id_product_attribute,
                    6,
                    null,
                    false,
                    false
                );
                $row['special'] = Product::getPriceStatic($id_product, true, $id_product_attribute);
            }

            $results_array[] = $row;
        }

        return $results_array;
    }

    private function getCustomers($query)
    {
        $sql = '
            SELECT
                id_customer,
                CONCAT(UPPER(CONCAT(c.firstname, \' \', c.lastname)),
                \' (\' , LOWER(c.email), \')\') AS name
            FROM
                `'._DB_PREFIX_.'customer` AS c
            LEFT JOIN
                `'._DB_PREFIX_.'address` AS a
            USING
                (id_customer)
            WHERE
                (
                    c.`firstname` LIKE \'%'.pSQL($query).'%\'
                        OR
                    c.`lastname` LIKE \'%'.pSQL($query).'%\'
                        OR
                    CONCAT(c.`firstname`, \' \', c.`lastname`) LIKE \'%'.pSQL($query).'%\'
                        OR
                    c.`email` LIKE \'%'.pSQL($query).'%\'
                        OR
                    REPLACE(REPLACE(a.`phone`, \' \', \'\'), \'-\', \'\') LIKE \'%'.pSQL($query).'%\'
                        OR
                    REPLACE(REPLACE(a.`phone_mobile`, \' \', \'\'), \'-\', \'\') LIKE \'%'.pSQL($query).'%\'
                )
                    AND
                c.is_guest = 0
                    AND
                c.active = 1
                    AND
                c.deleted = 0
            GROUP BY
                c.id_customer
            ORDER BY
                c.firstname, c.lastname, c.email
        ';
        //error_log($sql);
        return Db::getInstance()->executeS($sql);
    }

    private function getSourceCustomers()
    {
        $this->query = trim(Tools::getValue('search'));
        //error_log('search: '.$this->query);

        $customers = $this->getCustomers($this->query);

        if (!$customers) {
            // for validator
            $customers = array();
        }

        //error_log(count($products));
        $customers = array_slice($customers, 0, 12);

        //error_log(print_r($customers, true));
        echo Tools::jsonEncode(array('customers' => $customers));
    }

    private function getSourceProducts()
    {
        $this->query = trim(Tools::getValue('search'));

        $products = $this->searchByName($this->context->language->id, $this->query);

        if (!$products) {
            // for validator
            $products = array();
        }

        $products = array_slice($products, 0, 12);

        foreach ($products as &$product) {
            if ($product['id_product_attribute']) {
                $attributes = Product::getAttributesParams($product['id_product'], $product['id_product_attribute']);
                $product['attributes'] = $attributes;
            }
        }

        echo Tools::jsonEncode(array('products' => $products));
    }

    private function getCustomer()
    {
        $id_customer = (int)Tools::getValue('id_customer');

        if ($id_customer) {
            // for validator
            $customer = new Customer($id_customer);
        }

        return $customer;
    }

    private function getCart()
    {
        $id_cart = (int)Tools::getValue('id_cart');
        error_log('id_cart'.$id_cart);
        if ($id_cart) {
            // for validator
            $cart = new Cart($id_cart);
        } else {
            error_log('create new');
            $cart = new Cart();
            $cart->id_customer = $this->generic_shop_customer_id;
            $cart->id_address_delivery = $this->generic_shop_customer_address_id;
            $cart->id_address_invoice = $this->generic_shop_customer_address_id;
            $cart->id_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
            $cart->id_lang = (int)Configuration::get('PS_LANG_DEFAULT');
            $cart->add();
        }

        return $cart;
    }

    private function getDjvorder($id_order)
    {
        $sql = '
            SELECT
                *
            FROM
                `'._DB_PREFIX_.'djvpos_orders`
            WHERE
                id_order = '.(int)$id_order.'
        ';

        return Db::getInstance()->getRow($sql);
    }

    private function addDjvorder($id_order, $dependiente, $entregado, $cambio)
    {
        $sql = '
            INSERT INTO
                `'._DB_PREFIX_.'djvpos_orders`    (`id_order`,`date_add`,`dependiente`,`entregado`,`cambio`)
            VALUES
                ('.$id_order.', \''.date('Y-m-d h:i:s').'\', \''.pSql($dependiente).'\', '.$entregado.','.$cambio.')
        ';

        Db::getInstance()->execute($sql);
    }

    public function cartOrderExists($id_cart)
    {
        $sql = '
            SELECT
                COUNT(id_order)
            FROM
                `'._DB_PREFIX_.'orders`
            WHERE
                id_cart = '.(int)$id_cart.'
        ';

        return Db::getInstance()->getValue($sql);
    }

    public function getCartOrderId($id_cart)
    {
        $sql = '
            SELECT
                id_order
            FROM
                `'._DB_PREFIX_.'orders`
            WHERE
                id_cart = '.(int)$id_cart.'
        ';

        return Db::getInstance()->getValue($sql);
    }
    public function createOrder()
    {
        $cart = $this->getCart();

        if ($this->cartOrderExists($cart->id)) {

            $id_order = $this->getCartOrderId($cart->id);
            $url = $_SERVER['REQUEST_URI'];
            $url = str_replace('createOrder', 'viewCreateOrder', $url).'&id_order='.$id_order;
            Tools::redirectAdmin($url);
            return;
        }

        $customer = new Customer($cart->id_customer);

        $this->context->cart = $cart;
        $this->context->customer = $customer;

        $entregado = (float)Tools::getValue('entregado');
        $dependiente = Tools::getValue('dependiente');
        $cambio = (float)Tools::getValue('cambio');

        $order = $this->addOrder($customer, $cart);

        $this->addDjvorder($order->id, $dependiente, $entregado, $cambio);

        //$products = $cart->getProducts();

        $url = $_SERVER['REQUEST_URI'];
        $url = str_replace('createOrder', 'viewCreateOrder', $url).'&id_order='.$order->id;
        Tools::redirectAdmin($url);
    }

    public function viewCreateOrder()
    {
        $cart = $this->getCart();
        $customer = new Customer($cart->id_customer);

        $this->context->cart = $cart;
        $this->context->customer = $customer;
        $id_order = (int)Tools::getValue('id_order');

        $order = new Order($id_order);

        $entregado = (float)Tools::getValue('entregado');
        $cambio = (float)Tools::getValue('cambio');

        $products = $cart->getProducts();

        $this->context->smarty->assign(array(
            'order' =>  $order,
            'cart' =>  $cart,
            'products' =>  $products,
            'customer' => $customer,
            'entregado' => $entregado,
            'cambio' => $cambio,
            'tokenOrders' => Tools::getAdminTokenLite('AdminOrders'),
            'tokenPdf' => Tools::getAdminTokenLite('AdminPdf')
        ));
    }

    private function applyDiscount()
    {
        $cart = $this->getCart();

        if ($this->cartOrderExists($cart->id)) {
            $url = 'index.php?controller=AdminDjvPosOrders&token=&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
            Tools::redirectAdmin($url);
            return;
        }

        $global_discount = (int)Tools::getValue('global_discount');
        $id_product = (int)Tools::getValue('id_product');
        //$id_product_attribute = (int)Tools::getValue('id_product_attribute');
        $discount = Tools::getValue('discount');
        $is_percentage = (Tools::substr($discount, -1) == '%');

        $cart_rule = new CartRule();
        $cart_rule->partial_use = 1;
        $cart_rule->highlight = 0;
        $cart_rule->active = 1;
        $cart_rule->quantity = 1;
        $cart_rule->quantity_per_user = 1;
        $cart_rule->minimum_amount = 0;
        $cart_rule->minimum_amount_tax = 0;
        $cart_rule->minimum_amount_currency = 0;
        $cart_rule->minimum_amount_shipping = 0;

        $languages = Language::getLanguages();

        foreach ($languages as $l) {
            // for validator
            $cart_rule->name[$l['id_lang']] = 'Descuento en caja';
        }

        if ($is_percentage) {
            $discount = (float)str_replace('%', '', $discount);
            $cart_rule->reduction_amount = 0;
            $cart_rule->reduction_percent = $discount;
        } else {
            $discount = (float)$discount;
            $cart_rule->reduction_amount = $discount;
            $cart_rule->reduction_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
            $cart_rule->reduction_percent = 0;
            $cart_rule->reduction_tax = 1;

            $cart_rule->minimum_amount = 0.1;
            $cart_rule->minimum_amount_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
        }

        $cart_rule->id_customer = $cart->id_customer;

        if (!$global_discount) {
            // for validator
            $cart_rule->reduction_product = $id_product;
        }

        $cart_rule->code = 'djvpos'.date('Ymdhis');

        $cart_rule->date_from = date('Y-m-d h:i:s', microtime(true));
        $cart_rule->date_to = date('Y-m-d h:i:s', microtime(true) + 3000);
        $cart_rule->id = null;
        $cart_rule->add();

        $sql = '
            INSERT INTO
                `'._DB_PREFIX_.'cart_cart_rule`
            VALUES
                ('.$cart->id.','.$cart_rule->id.')
        ';
        Db::getInstance()->execute($sql);

        $url = 'index.php?controller=AdminDjvPosOrders';
        $url .= '&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
        $url .= '&id_cart='.$cart->id;

        Tools::redirectAdmin($url);
    }

    private function updateProductCartQuantity()
    {
        $cart = $this->getCart();

        if ($this->cartOrderExists($cart->id)) {
            $url = 'index.php?controller=AdminDjvPosOrders&token=&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
            Tools::redirectAdmin($url);
            return;
        }

        $id_product = (int)Tools::getValue('id_product');

        $shop = $this->context->shop;

        $product = new Product($id_product, false, Configuration::get('PS_LANG_DEFAULT'), $shop->id);
        $id_product_attribute = (int)Tools::getValue('id_product_attribute');
        $quantity = (int)Tools::getValue('quantity');

        if ($id_product) {
            if ($quantity == 0) {
                // for validator
                $cart->deleteProduct($id_product, $id_product_attribute);
            } elseif ($quantity > 0) {
                $result = $cart->updateQty($quantity, $id_product, $id_product_attribute);

                if ($result === -1) {
                    if (!empty($id_product_attribute)) {
                        // for validator
                        $minimal_quantity = (int)Attribute::getAttributeMinimalQty($id_product_attribute);
                    } else {
                        // for validator
                        $minimal_quantity = (int)$product->minimal_quantity;
                    }

                    $str = $id_product.','.$id_product_attribute.','.$minimal_quantity;

                    $this->context->cookie->__set('djvpos_mustAddMinimalQuantity', $str);
                } elseif (!$result) {
                    // for validator
                    $this->context->cookie->__set(
                        'djvpos_message',
                        'No pudo añadirse el producto al carrito.Verifique el stock disponible.'
                    );
                }
            } else {
                $result = $cart->updateQty($quantity * -1, $id_product, $id_product_attribute, false, 'down');

                if ($result === -1) {
                    if (!empty($id_product_attribute)) {
                        // for validator
                        $minimal_quantity = (int)Attribute::getAttributeMinimalQty($id_product_attribute);
                    } else {
                        // for validator
                        $minimal_quantity = (int)$product->minimal_quantity;
                    }

                    $str = $id_product.','.$id_product_attribute.','.$minimal_quantity;

                    $this->context->cookie->__set('djvpos_mustRemoveAll', $str);
                }
            }
        }

        $url = 'index.php?controller=AdminDjvPosOrders';
        $url .= '&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
        $url .= '&id_cart='.$cart->id;

        Tools::redirectAdmin($url);
    }

    private function displayCart()
    {
        $cart = $this->getCart();

        $products = $cart->getProducts();

        $customer = new Customer($cart->id_customer);
        $this->context->cart = $cart;
        $this->context->customer = $customer;
        $addresses = $customer->getAddresses($this->context->language->id);

        if ($this->context->cookie->__isset('djvpos_message')) {
            $message = $this->context->cookie->djvpos_message;
            $this->context->cookie->__unset('djvpos_message');
            $this->context->smarty->assign(array(
                'message' => $message
            ));
        }

        if ($this->context->cookie->__isset('djvpos_mustAddMinimalQuantity')) {
            $str = explode(',', $this->context->cookie->djvpos_mustAddMinimalQuantity);
            $this->context->cookie->__unset('djvpos_mustAddMinimalQuantity');
            $this->context->smarty->assign(array(
                'mustAddMinimalQuantity' => true,
                'mq_id_product' => $str[0],
                'mq_id_product_attribute' => $str[1],
                'mq_minimal_quantity' => $str[2]
            ));
        }

        if ($this->context->cookie->__isset('djvpos_mustRemoveAll')) {
            $str = explode(',', $this->context->cookie->djvpos_mustRemoveAll);
            $this->context->cookie->__unset('djvpos_mustRemoveAll');
            $this->context->smarty->assign(array(
                'mustRemoveAll' => true,
                'mq_id_product' => $str[0],
                'mq_id_product_attribute' => $str[1],
                'mq_minimal_quantity' => $str[2]
            ));
        }

        $order = null;
        $this->context->smarty->assign(array(
            'order' =>  $order,
            'automaticInsertion' => (int)Configuration::get('DJVPOS_INSAUTO'),
            'cart' =>  $cart,
            'products' =>  $products,
            'customer' => $customer,
            'addresses' => $addresses,
            'entregado' => 0,
            'cambio' => 0,
            'generic_shop_customer_id' => $this->generic_shop_customer_id,
            'tokenCart' => Tools::getAdminTokenLite('AdminCarts'),
            'tokenOrders' => Tools::getAdminTokenLite('AdminOrders')
        ));
    }

    private function checkEmailExists()
    {
        $email = Tools::getValue('email');

        $sql = '
            SELECT
                *
            FROM
                `'._DB_PREFIX_.'customer`
            WHERE
                email = \''.pSql($email).'\'
        ';

        $customer = Db::getInstance()->getRow($sql);

        echo Tools::jsonEncode($customer);
    }

    private function getActiveStates($id_country)
    {
        $sql = '
            SELECT
                *
            FROM
                `'._DB_PREFIX_.'country`
            WHERE
                id_country = '.$id_country.'
                    AND
                contains_states = 1
        ';

        $contains_states = Db::getInstance()->getValue($sql);

        if ($contains_states) {
            $sql = '
                SELECT
                    *
                FROM
                    `'._DB_PREFIX_.'state`
                WHERE
                    id_country = '.$id_country.'
                        AND
                    active = 1
            ';

            $states = Db::getInstance()->executeS($sql);
        } else {
            // for validator
            $states = false;
        }

        return $states;
    }

    private function getStates()
    {
        $id_country = (int)Tools::getValue('id_country');

        $states = $this->getActiveStates($id_country);

        echo Tools::jsonEncode($states);
    }

    private function setCustomer()
    {
        $customer = $this->getCustomer();
        $customer_id_address_default = Address::getFirstCustomerAddressId($customer->id);

        $cart = $this->getCart();
        $cart->id_customer = $customer->id;
        $cart->id_address_delivery = $customer_id_address_default;
        $cart->id_address_invoice = $customer_id_address_default;

        $cart->update();

        $url = 'index.php?controller=AdminDjvPosOrders';
        $url .= '&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
        $url .= '&id_cart='.$cart->id;
        Tools::redirectAdmin($url);
    }

    private function removeCustomer()
    {
        $cart = $this->getCart();
        $cart->id_customer = $this->generic_shop_customer_id;
        $cart->id_address_delivery = $this->generic_shop_customer_address_id;
        $cart->id_address_invoice = $this->generic_shop_customer_address_id;

        $cart->update();

        $url = 'index.php?controller=AdminDjvPosOrders';
        $url .= '&token='.Tools::getAdminTokenLite('AdminDjvPosOrders');
        $url .= '&id_cart='.$cart->id;
        Tools::redirectAdmin($url);
    }

    private function addCustomer()
    {
        $customer = new Customer();
        $address = new Address();
        //Tools::file_get_contents(_PS_ROOT_DIR_.'/log/addCustomer.log',
        // date('Y-m-d H:i:s').' - '.print_r($_REQUEST, true), FILE_APPEND);

        if (Tools::getValue('task') == 'submitAddCustomer') {
            $id_customer = (int)Tools::getValue('id_customer');
            //$id_customer = 33143;
            if (!$id_customer) {
                $customer_email = (string)Tools::getValue('email');

                if (!trim($customer_email)) {
                    // for validator
                    $customer_email = 'sinemail'.date('Ymdhis').'@example.com';
                }

                if (Validate::isEmail($customer_email)) {
                    // for validator
                    $customer->getByEmail($customer_email);
                }

                if ($customer->id) {
                    $this->errors[] = Tools::displayError('An account already exists for this email address:')
                    .' '.$customer_email;
                } else {
                    $customer->email = $customer_email;

                    $customer->id_gender = (int)Tools::getValue('id_gender');
                    $customer->firstname = Tools::getValue('firstname');
                    $customer->lastname = Tools::getValue('lastname');

                    $customer->optin = (int)Tools::getValue('optin');
                    $customer->newsletter = (int)Tools::getValue('newsletter');

                    $customer->passwd = md5(rand());
                    $customer->active = 1;

                    $days = (int)Tools::getValue('days');
                    $months = (int)Tools::getValue('months');
                    $years = (int)Tools::getValue('years');

                    if ($days && $months && $years) {
                        // for validator
                        $customer->birthday = $years.'-'.$months.'-'.$days;
                    }

                    if ($customer->validateField('firstname', $customer->firstname, 1, array(), true) !== true) {
                        // for validator
                        $this->errors[] = Tools::displayError('Debe introducir un nombre válido');
                    }

                    if ($customer->validateField('lastname', $customer->lastname, 1, array(), true) !== true) {
                        // for validator
                        $this->errors[] = Tools::displayError('Debe introducir un apellido válido');
                    }

                    if ($customer->validateField('email', $customer->email, 1, array(), true) !== true) {
                        // for validator
                        $this->errors[] = Tools::displayError('Debe introducir un email válido');
                    }

                    if (!$this->errors) {
                        // for validator
                        $customer->add();
                    }
                }
            } else {
                // for validator
                $customer = new Customer($id_customer);
            }

            if (!$this->errors) {
                $address->id_customer = $customer->id;
                $address->firstname = $customer->firstname;
                $address->lastname = $customer->lastname;
                $address->email = $customer->email;

                $address->alias = 'Mi dirección';
                $address->dni = Tools::getValue('dni');
                $address->company = Tools::getValue('company');
                $address->id_country = (int)Tools::getValue('id_country');
                $address->id_state = (int)Tools::getValue('id_state');

                $address->address1 = Tools::getValue('address1');

                if (!trim($address->address1)) {
                    // for validator
                    $address->address1 = 'Sin direccion';
                }

                $address->address2 = Tools::getValue('address2');

                $address->city = Tools::getValue('city');

                $address->postcode = Tools::getValue('postcode');

                $address->phone = Tools::getValue('phone');

                $address->phone_mobile = Tools::getValue('phone_mobile');

                if (!trim($address->city)) {
                    // for validator
                    $address->city = 'Sin ciudad';
                }

                if (!trim($address->postcode)) {
                    // for validator
                    $address->postcode = '00000';
                }

                if (!trim($address->dni)) {
                    // for validator
                    $address->dni = '12345678Z';
                }

                if (!$address->id_state) {
                    // for validator
                    $address->id_state = 340; // Madrid
                }

                if (!trim($address->phone)) {
                    // for validator
                    $address->phone = '910000000';
                }

                if (!$address->phone_mobile) {
                    // for validator
                    $address->phone_mobile = '600000000';
                }

                $error = $address->validateFields(false, true);

                if ($error !== true) {
                    // for validator
                    $this->errors[] = Tools::displayError($error);
                } else {
                    $country = new Country($address->id_country);

                    if ((int)$country->need_identification_number && !$address->dni) {
                        // for validator
                        $this->errors[] = Tools::displayError('El DNI/NIF/NIE es obligatorio.');
                    } elseif ((int)$country->contains_states && !$address->id_state) {
                        // for validator
                        $this->errors[] = Tools::displayError(
                            'An address located in a country containing states must have a state selected.'
                        );
                    } elseif ($country->need_zip_code && !$address->postcode) {
                        // for validator
                        $this->errors[] = Tools::displayError('El código postal es obligatorio.');
                    } elseif ($country->zip_code_format && !$country->checkZipCode($address->postcode)) {
                        // for validator
                        $zip_code_format = str_replace('L', 'A', $country->zip_code_format);
                        $zip_code_format = str_replace('N', '0', $zip_code_format);
                        $zip_code_format = str_replace('C', $country->iso_code, $zip_code_format);
                        $error_msg = Tools::displayError('Your Postal / Zip Code is incorrect.');
                        $error_msg .= '<br />'.Tools::displayError('It must be entered as follows:');
                        $error_msg .= ' '.$zip_code_format;
                        $this->errors[] = $error_msg;
                    } elseif ($address->postcode && !Validate::isPostCode($address->postcode)) {
                        // for validator
                        $this->errors[] = Tools::displayError('The Zip / Postal code is invalid.');
                    } elseif (!$address->phone && !$address->phone_mobile) {
                        // for validator
                        $this->errors[] = Tools::displayError('Debe indicar al menos un número de telefono.');
                    } else {
                        // for validator
                        $address->add();
                    }
                }
            }
        }

        $genders = array();
        $genders_icon = array();
        $genders_icon[] = array('src' => '../genders/Unknown.jpg', 'alt' => '');

        foreach (Gender::getGenders() as $gender) {
            $gender_file = 'genders/'.$gender->id.'.jpg';

            if (file_exists(_PS_IMG_DIR_.$gender_file)) {
                // for validator
                $genders_icon[$gender->id] = array('src' => '../'.$gender_file, 'alt' => $gender->name);
            } else {
                // for validator
                $genders_icon[$gender->id] = array('src' => '../genders/Unknown.jpg', 'alt' => $gender->name);
            }

            $genders[$gender->id] = $gender->name;
        }

        $id_country = (int)Tools::getValue('id_country');
        $id_state = (int)Tools::getValue('id_state');

        $countries = Country::getCountries($this->context->language->id, true);

        if (!$id_country) {
            // for validator
            $id_country = 6;
        }

        $states = $this->getActiveStates($id_country);

        if (Country::containsStates($id_country) && !$id_state) {
            // for validator
            $id_state = $states[0]['id_state'];
        }

        $this->context->smarty->assign(array(
            'customer' => $customer,
            'automaticInsertion' => (int)Configuration::get('DJVPOS_INSAUTO'),
            'address' => $address,
            'genders' => $genders,
            'genders_icon' => $genders_icon,
            'id_country' => $id_country,
            'id_state' => $id_state,
            'countries' => $countries,
            'states' => $states
        ));
    }

    private function printInvoiceTicket()
    {
        $id_order = (int)Tools::getValue('id_order');

        $order = new Order($id_order);
        $cart = new Cart($order->id_cart);

        if ($order->id_customer != $this->generic_shop_customer_id) {
            $customer = new Customer($order->id_customer);
            $addresses = $customer->getAddresses($this->context->language->id);
        } else {
            $customer = new Customer($this->generic_shop_customer_id);
            $addresses = $customer->getAddresses($this->context->language->id);
        }

        $this->context->customer = $customer;
        $this->context->cart= $cart;

        $djvorder = $this->getDjvorder($order->id);

        $products = $cart->getProducts();

        $this->context->smarty->assign(array(
            'order' =>  $order,
            'cart' =>  $cart,
            'products' =>  $products,
            'customer' => $customer,
            'addresses' => $addresses,
            'djvorder' => $djvorder,
            'tickets_h' => Configuration::get('DJVPOS_TICKETS_H'),
            'tickets_f' => Configuration::get('DJVPOS_TICKETS_F')
        ));

        $tpl = _PS_ROOT_DIR_.'/modules/djvpos/views/templates/admin/djv_pos_orders/ticket_invoice.tpl';
        error_reporting(E_ALL);
        $html = $this->context->smarty->fetch($tpl);

        $output = _PS_ROOT_DIR_
            .'/upload/invoice_ticket'
            .$order->id
            .'_'
            .Tools::substr(
                md5(microtime(true)),
                0,
                8
            )
            .'.html';

        file_put_contents($output, $html);

        echo $html;
    }

    public function postProcess()
    {
        $task = Tools::getValue('task');

        if ($this->ajax) {
            $this->context = Context::getContext();

            switch ($task) {
                case 'checkEmailExists':
                    $this->checkEmailExists();
                    break;

                case 'getStates':
                    $this->getStates();
                    break;

                case 'getSourceCustomers':
                    $this->getSourceCustomers();
                    break;

                case 'getSourceProducts':
                    $this->getSourceProducts();
                    break;
            }
            die;
        } else {
            switch ($task) {
                case 'printInvoiceTicket':
                    $this->printInvoiceTicket();
                    die;

                case 'addCustomer':
                case 'submitAddCustomer':
                    $this->addCustomer();
                    break;

                case 'newCustomerCart':
                case 'setCustomer':
                    $this->setCustomer();
                    break;

                case 'removeCustomer':
                    $this->removeCustomer();
                    break;

                case 'createOrder':
                    $this->createOrder();
                    break;

                case 'viewCreateOrder':
                    $this->viewCreateOrder();
                    break;

                case 'applyDiscount':
                    $this->applyDiscount();
                    break;

                case 'addToCart':
                case 'updateProductCartQuantity':
                    $this->updateProductCartQuantity();
                    break;

                case 'newCart':
                default:
                    $this->displayCart();
            }
        }
    }

    private function addOrder($customer, $cart, $shipping = false)
    {
        $id_lang = Configuration::get('PS_LANG_DEFAULT');

        // Pago en tienda
        $id_order_state = $this->generic_state;
        $order_status = new OrderState((int)$id_order_state, $id_lang);

        $products = $cart->getProducts();

        $order_list = array();
        $order_detail_list = array();
        $order = new Order();
        $order->product_list = $cart->getProducts();

        $message = '';

        if (Configuration::get('PS_TAX_ADDRESS_TYPE') == 'id_address_delivery') {
            $address = new Address($cart->id_address_delivery);
            $this->context->country = new Country($address->id_country, $cart->id_lang);
        }

        if (!$shipping) {
            error_log('aa not shipping'.$shipping);
            $carrier = null;

            $order->id_carrier = 1;
            $id_carrier = 1;
        } else {
            error_log('aa shipping'.$shipping);
            // For each package, generate an order
            $delivery_option_list = $cart->getDeliveryOptionList();
            $package_list = $cart->getPackageList();
            $cart_delivery_option = $cart->getDeliveryOption();

            foreach ($cart_delivery_option as $id_address => $key_carriers) {
                foreach ($delivery_option_list[$id_address][$key_carriers]['carrier_list'] as $id_carrier => $data) {
                    foreach ($data['package_list'] as $id_package) {
                        // Rewrite the id_warehouse
                        $pl_id_package = $package_list[$id_address][$id_package];
                        $id_warehouse = (int)$cart->getPackageIdWarehouse($pl_id_package, (int)$id_carrier);
                        $package_list[$id_address][$id_package]['id_warehouse'] = $id_warehouse;
                        $package_list[$id_address][$id_package]['id_carrier'] = $id_carrier;
                    }
                }
            }

            // Make sure CarRule caches are empty
            CartRule::cleanCache();

            foreach ($package_list as $id_address => $package_by_address) {
                foreach ($package_by_address as $id_package => $package) {
                    $carrier = null;
                    if (!$cart->isVirtualCart() && isset($package['id_carrier'])) {
                        $carrier = new Carrier($package['id_carrier'], $cart->id_lang);
                        $order->id_carrier = (int)$carrier->id;
                        $id_carrier = (int)$carrier->id;
                    } else {
                        $order->id_carrier = 0;
                        $id_carrier = 0;
                    }
                }
            }
        }

        error_log('aa id_carrier'.$id_carrier);

        $order->id_cart = $cart->id;
        $order->reference = T.$cart->id;

        $order->recyclable = $cart->recyclable;
        $order->gift = (int)$cart->gift;
        $order->gift_message = $cart->gift_message;
        $order->mobile_theme = $cart->mobile_theme;

        $order->id_customer = $customer->id;
        $order->secure_key = $customer->secure_key;
        $order->id_address_invoice = $cart->id_address_invoice;
        $order->id_address_delivery = $cart->id_address_delivery;

        /*REVISAR*/
        $order->id_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
        $order->id_lang = 1;
        $order->id_shop = 1;
        $order->id_shop_group = 1;

        /*REVISAR*/
        $order->payment = Tools::getValue('payment');
        $order->module = Tools::getValue('payment');

        $order->conversion_rate = $this->context->currency->conversion_rate;
        $dont_touch_amount = false;
        $amount_paid = !$dont_touch_amount ? Tools::ps_round((float)$amount_paid, 2) : $amount_paid;
        $order->total_paid_real = 0;

        $order->total_products = (float)$cart->getOrderTotal(
            false,
            Cart::ONLY_PRODUCTS,
            $order->product_list,
            $id_carrier
        );
        $order->total_products_wt = (float)$cart->getOrderTotal(
            true,
            Cart::ONLY_PRODUCTS,
            $order->product_list,
            $id_carrier
        );

        $order->total_discounts_tax_excl = (float)abs(
            $cart->getOrderTotal(
                false,
                Cart::ONLY_DISCOUNTS,
                $order->product_list,
                $id_carrier
            )
        );
        $order->total_discounts_tax_incl = (float)abs(
            $cart->getOrderTotal(
                true,
                Cart::ONLY_DISCOUNTS,
                $order->product_list,
                $id_carrier
            )
        );
        $order->total_discounts = $order->total_discounts_tax_incl;

        $order->total_shipping_tax_excl = (float)$cart->getPackageShippingCost(
            (int)$id_carrier,
            false,
            null,
            $order->product_list
        );

        $order->total_shipping_tax_incl = (float)$cart->getPackageShippingCost(
            (int)$id_carrier,
            true,
            null,
            $order->product_list
        );

        $order->total_shipping = $order->total_shipping_tax_incl;

        if (!is_null($carrier) && Validate::isLoadedObject($carrier)) {
            // for validator
            $order->carrier_tax_rate = $carrier->getTaxesRate(
                new Address($cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')})
            );
        }

        $order->total_wrapping_tax_excl = (float)abs(
            $cart->getOrderTotal(
                false,
                Cart::ONLY_WRAPPING,
                $order->product_list,
                $id_carrier
            )
        );

        $order->total_wrapping_tax_incl = (float)abs(
            $cart->getOrderTotal(
                true,
                Cart::ONLY_WRAPPING,
                $order->product_list,
                $id_carrier
            )
        );

        $order->total_wrapping = $order->total_wrapping_tax_incl;

        $order->total_paid_tax_excl = (float)Tools::ps_round(
            (float)$cart->getOrderTotal(
                false,
                Cart::BOTH,
                $order->product_list,
                $id_carrier
            ),
            2
        );
        $order->total_paid_tax_incl = (float)Tools::ps_round(
            (float)$cart->getOrderTotal(
                true,
                Cart::BOTH,
                $order->product_list,
                $id_carrier
            ),
            2
        );

        $order->total_paid = $order->total_paid_tax_incl;
        $order->total_paid_real = $order->total_paid_tax_incl;
        //$order->total_paid = $order->total_paid_tax_excl;

        $order->invoice_date = '0000-00-00 00:00:00';
        $order->delivery_date = '0000-00-00 00:00:00';

        // Creating order
        //echo 'adding';
        $result = $order->add();

        if (!$result) {
            // for validator
            return null;
        }

        $order_list[] = $order;

        // Insert new Order detail list using cart for the current order
        $order_detail = new OrderDetail(null, null, $this->context);
        $order_detail->createList($order, $cart, $id_order_state, $order->product_list, 0, true, 0);
        $order_detail_list[] = $order_detail;

        // Adding an entry in order_carrier table
        if (!is_null($carrier)) {
            $order_carrier = new OrderCarrier();
            $order_carrier->id_order = (int)$order->id;
            $order_carrier->id_carrier = (int)$id_carrier;
            $order_carrier->weight = (float)$order->getTotalWeight();
            $order_carrier->shipping_cost_tax_excl = (float)$order->total_shipping_tax_excl;
            $order_carrier->shipping_cost_tax_incl = (float)$order->total_shipping_tax_incl;
            $order_carrier->add();
        }

        //print_r($order_detail);

        foreach ($order_detail_list as $key => $order_detail) {
            $order = $order_list[$key];
            if (isset($order->id)) {
                $secure_key = $order->secure_key;

                if (!$secure_key) {
                    // for validator
                    $message .= '<br />';
                    $message .= Tools::displayError(
                        'Warning: the secure key is empty, check your payment account before validation'
                    );
                }

                // Optional message to attach to this order
                if (isset($message) & !empty($message)) {
                    $msg = new Message();
                    $message = strip_tags($message, '<br>');

                    if (Validate::isCleanHtml($message)) {
                        $msg->message = $message;
                        $msg->id_order = (int)$order->id;
                        $msg->private = 1;
                        $msg->add();
                    }
                }

                // Insert new Order detail list using cart for the current order
                //$orderDetail = new OrderDetail(null, null, $this->context);
                //$orderDetail->createList($order, $this->context->cart, $id_order_state);

                // Construct order detail table for the email
                $products_list = '';
                $virtual_product = true;
                foreach ($products as $key => $product) {
                    $id_product_attribute = $product['id_product_attribute'] ?
                        (int)$product['id_product_attribute'] :
                        null;
                    $price = Product::getPriceStatic(
                        (int)$product['id_product'],
                        false,
                        $id_product_attribute,
                        6,
                        null,
                        false,
                        true,
                        $product['cart_quantity'],
                        false,
                        (int)$order->id_customer,
                        (int)$order->id_cart,
                        (int)$order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}
                    );
                    $price_wt = Product::getPriceStatic(
                        (int)$product['id_product'],
                        true,
                        $id_product_attribute,
                        2,
                        null,
                        false,
                        true,
                        $product['cart_quantity'],
                        false,
                        (int)$order->id_customer,
                        (int)$order->id_cart,
                        (int)$order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}
                    );

                    $customization_quantity = 0;
                    $customized_datas = Product::getAllCustomizedDatas((int)$order->id_cart);
                    if (isset($customized_datas[$product['id_product']][$product['id_product_attribute']])) {
                        $customization_text = '';
                        $product_id = $product['id_product'];
                        $attr_id = $product['id_product_attribute'];
                        $addr_id = $order->id_address_delivery;
                        $a_p_c_d = $customized_datas[$product_id][$attr_id][$addr_id];
                        foreach ($a_p_c_d as $customization) {
                            if (isset($customization['datas'][Product::CUSTOMIZE_TEXTFIELD])) {
                                foreach ($customization['datas'][Product::CUSTOMIZE_TEXTFIELD] as $text) {
                                    $customization_text .= $text['name'].': '.$text['value'].'<br />';
                                }
                            }

                            if (isset($customization['datas'][Product::CUSTOMIZE_FILE])) {
                                $customization_text .= sprintf(
                                    Tools::displayError('%d image(s)'),
                                    count($customization['datas'][Product::CUSTOMIZE_FILE])
                                ).'<br />';
                            }

                            $customization_text .= '---<br />';
                        }
                        $customization_text = rtrim($customization_text, '---<br />');

                        $customization_quantity = (int)$product['customization_quantity'];
                        $products_list .= '<tr style="background-color: '.($key % 2 ? '#DDE2E6' : '#EBECEE').';">
                            <td style="padding: 0.6em 0.4em;width: 15%;">'.$product['reference'].'</td>
                            <td style="padding: 0.6em 0.4em;width: 30%;"><strong>'
                            .$product['name'].(isset($product['attributes']) ? ' - '.$product['attributes'] : '')
                            .' - '.Tools::displayError('Customized')
                            .(!empty($customization_text) ? ' - '.$customization_text : '')
                            .'</strong></td>
                            <td style="padding: 0.6em 0.4em; width: 20%;">'
                            .Tools::displayPrice(
                                (
                                    Product::getTaxCalculationMethod() == PS_TAX_EXC ?
                                    Tools::ps_round($price, 2) :
                                    $price_wt
                                ),
                                $this->context->currency,
                                false
                            )
                            .'</td>
                            <td style="padding: 0.6em 0.4em; width: 15%;">'
                            .$customization_quantity
                            .'</td>
                            <td style="padding: 0.6em 0.4em; width: 20%;">'
                            .Tools::displayPrice(
                                $customization_quantity * (
                                    (
                                        Product::getTaxCalculationMethod() == PS_TAX_EXC ?
                                        Tools::ps_round($price, 2) :
                                        $price_wt
                                    )
                                ),
                                $this->context->currency,
                                false
                            ).'</td>
                        </tr>';
                    }

                    if (!$customization_quantity || (int)$product['cart_quantity'] > $customization_quantity) {
                        $background_color = $key % 2 ? '#DDE2E6' : '#EBECEE';
                        $products_list .= '<tr style="background-color: '.$background_color.';">
                            <td style="padding: 0.6em 0.4em;width: 15%;">'.$product['reference'].'</td>
                            <td style="padding: 0.6em 0.4em;width: 30%;"><strong>'
                            .$product['name'].
                            (isset($product['attributes']) ? ' - '.$product['attributes'] : '').'</strong></td>
                            <td style="padding: 0.6em 0.4em; width: 20%;">'
                            .Tools::displayPrice(
                                (
                                    Product::getTaxCalculationMethod() == PS_TAX_EXC ?
                                    Tools::ps_round($price, 2) :
                                    $price_wt
                                ),
                                $this->context->currency,
                                false
                            ).'</td>
                            <td style="padding: 0.6em 0.4em; width: 15%;">'
                            .((int)$product['cart_quantity'] - $customization_quantity).'</td>
                            <td style="padding: 0.6em 0.4em; width: 20%;">'
                            .Tools::displayPrice(
                                ((int)$product['cart_quantity'] - $customization_quantity) *
                                (
                                    Product::getTaxCalculationMethod() == PS_TAX_EXC ?
                                    Tools::ps_round($price, 2) :
                                    $price_wt
                                ),
                                $this->context->currency,
                                false
                            )
                            .'</td>
                        </tr>';
                    }

                    // Check if is not a virutal product for the displaying of shipping
                    if (!$product['is_virtual']) {
                        $virtual_product &= false;
                    }

                } // end foreach ($products)

                $cart_rules_list = '';
                $cart_rules = array();
                foreach ($cart_rules as $cart_rule) {
                    $package = array(
                        'id_carrier' => $order->id_carrier,
                        'id_address' => $order->id_address_delivery,
                        'products' => $order->product_list
                    );
                    $values = array(
                        'tax_incl' => $cart_rule['obj']->getContextualValue(
                            true,
                            $this->context,
                            CartRule::FILTER_ACTION_ALL_NOCAP,
                            $package
                        ),
                        'tax_excl' => $cart_rule['obj']->getContextualValue(
                            false,
                            $this->context,
                            CartRule::FILTER_ACTION_ALL_NOCAP,
                            $package
                        )
                    );

                    // If the reduction is not applicable to this order, then continue with the next one
                    if (!$values['tax_excl']) {
                        continue;
                    }

                    /* IF
                    ** - This is not multi-shipping
                    ** - The value of the voucher is greater than the total of the order
                    ** - Partial use is allowed
                    ** - This is an "amount" reduction, not a reduction in % or a gift
                    ** THEN
                    ** The voucher is cloned with a new value corresponding to the remainder
                    */
                    if ((count($order_list) == 1) && ($values['tax_incl'] > $order->total_products_wt)
                        && ($cart_rule['obj']->partial_use == 1) && ($cart_rule['obj']->reduction_amount > 0)) {
                        // Create a new voucher from the original
                        $voucher = new CartRule($cart_rule['obj']->id);
                        // We need to instantiate the CartRule without lang parameter to allow saving it
                        unset($voucher->id);

                        // Set a new voucher code
                        $voucher_code_key = $order->id.'-'.$order->id_customer.'-'.$cart_rule['obj']->id;
                        $voucher_code = Tools::substr(md5($voucher_code_key), 0, 16);

                        $voucher->code = empty($voucher->code) ? $voucher_code : $voucher->code.'-2';

                        if (
                            preg_match(
                                '/\-([0-9]{1,2})\-([0-9]{1,2})$/',
                                $voucher->code,
                                $matches
                            ) &&
                            $matches[1] == $matches[2]
                        ) {
                            $voucher->code = preg_replace(
                                '/'.$matches[0].'$/',
                                '-'.((int)$matches[1]) + 1,
                                $voucher->code
                            );
                        }

                        // Set the new voucher value
                        if ($voucher->reduction_tax) {
                            $voucher->reduction_amount = $values['tax_incl'] -
                                $order->total_products_wt - $order->total_shipping_tax_incl;
                        } else {
                            $voucher->reduction_amount = $values['tax_excl'] -
                                $order->total_products - $order->total_shipping_tax_excl;
                        }

                        $voucher->id_customer = $order->id_customer;
                        $voucher->quantity = 1;
                        $voucher->quantity_per_user = 1;
                        $voucher->free_shipping = 0;
                        if ($voucher->add()) {
                            // If the voucher has conditions, they are now copied to the new voucher
                            CartRule::copyConditions($cart_rule['obj']->id, $voucher->id);

                            $params = array(
                                '{voucher_amount}' => Tools::displayPrice(
                                    $voucher->reduction_amount,
                                    $this->context->currency,
                                    false
                                ),
                                '{voucher_num}' => $voucher->code,
                                '{firstname}' => $this->context->customer->firstname,
                                '{lastname}' => $this->context->customer->lastname,
                                '{id_order}' => $order->reference,
                                '{order_name}' => $order->getUniqReference()
                            );
                            Mail::Send(
                                (int)$order->id_lang,
                                'voucher',
                                sprintf(
                                    Mail::l('New voucher regarding your order %s', (int)$order->id_lang),
                                    $order->reference
                                ),
                                $params,
                                $this->context->customer->email,
                                $this->context->customer->firstname.' '.$this->context->customer->lastname,
                                null,
                                null,
                                null,
                                null,
                                _PS_MAIL_DIR_,
                                false,
                                (int)$order->id_shop
                            );
                        }

                        $values['tax_incl'] -= $values['tax_incl'] - $order->total_products_wt;
                        $values['tax_excl'] -= $values['tax_excl'] - $order->total_products;
                    }

                    $order->addCartRule(
                        $cart_rule['obj']->id,
                        $cart_rule['obj']->name,
                        $values,
                        0,
                        $cart_rule['obj']->free_shipping
                    );

                    $cart_rule_used = array();

                    if ($id_order_state != Configuration::get('PS_OS_ERROR')
                        && $id_order_state != Configuration::get('PS_OS_CANCELED')
                        && !in_array($cart_rule['obj']->id, $cart_rule_used)) {
                        $cart_rule_used[] = $cart_rule['obj']->id;

                        // Create a new instance of Cart Rule without id_lang, in order to update its quantity
                        $cart_rule_to_update = new CartRule($cart_rule['obj']->id);
                        $cart_rule_to_update->quantity = max(0, $cart_rule_to_update->quantity - 1);
                        $cart_rule_to_update->update();
                    }

                    $cart_rules_list .= '
                    <tr>
                        <td colspan="4" style="padding:0.6em 0.4em;text-align:right">'
                        .Tools::displayError('Voucher name:').' '.$cart_rule['obj']->name.'</td>
                        <td style="padding:0.6em 0.4em;text-align:right">'
                        .($values['tax_incl'] != 0.00 ? '-' : '')
                        .Tools::displayPrice($values['tax_incl'], $this->context->currency, false).'</td>
                    </tr>';
                }

                // Specify order id for message
                $old_message = Message::getMessageByCartId((int)$this->context->cart->id);
                if ($old_message) {
                    $update_message = new Message((int)$old_message['id_message']);
                    $update_message->id_order = (int)$order->id;
                    $update_message->update();

                    // Add this message in the customer thread
                    $customer_thread = new CustomerThread();
                    $customer_thread->id_contact = 0;
                    $customer_thread->id_customer = (int)$order->id_customer;
                    $customer_thread->id_shop = (int)$this->context->shop->id;
                    $customer_thread->id_order = (int)$order->id;
                    $customer_thread->id_lang = (int)$this->context->language->id;
                    $customer_thread->email = $this->context->customer->email;
                    $customer_thread->status = 'open';
                    $customer_thread->token = Tools::passwdGen(12);
                    $customer_thread->add();

                    $customer_message = new CustomerMessage();
                    $customer_message->id_customer_thread = $customer_thread->id;
                    $customer_message->id_employee = 0;
                    $customer_message->message = $update_message->message;
                    $customer_message->private = 0;

                    if (!$customer_message->add()) {
                        $this->errors[] = Tools::displayError('An error occurred while saving message');
                    }
                }

                // Hook validate order
                /*
                Hook::exec('actionValidateOrder', array(
                    'cart' => $this->context->cart,
                    'order' => $order,
                    'customer' => $this->context->customer,
                    'currency' => $this->context->currency,
                    'orderStatus' => $order_status
                ));
                */
                if ($this->context->cart) {
                    // for validator
                    foreach ($this->context->cart->getProducts() as $product) {
                        // for validator
                        if ($order_status->logable) {
                            // for validator
                            ProductSale::addProductSale((int)$product['id_product'], (int)$product['cart_quantity']);
                        }
                    }
                }
                /*

                // Duplica el pago;
                if (Configuration::get('PS_STOCK_MANAGEMENT') && $order_detail->getStockState()) {
                    $history = new OrderHistory();
                    $history->id_order = (int)$order->id;
                    $history->changeIdOrderState(Configuration::get('PS_OS_OUTOFSTOCK'), $order, true);
                    $history->addWithemail();
                }
                */

                // Set order state in order history ONLY even if the "out of stock" status has not been yet reached
                // So you migth have two order states
                $new_history = new OrderHistory();
                $new_history->id_order = (int)$order->id;
                $new_history->changeIdOrderState((int)$id_order_state, $order, true);
                $extra_vars = array();
                $new_history->addWithemail(true, $extra_vars);

                unset($order_detail);

                // Order is reloaded because the status just changed
                $order = new Order($order->id);

                // Send an e-mail to customer (one order = one email)
                /*if ($id_order_state != Configuration::get('PS_OS_ERROR') &&
                $id_order_state != Configuration::get('PS_OS_CANCELED') && $this->context->customer->id) {
                    $invoice = new Address($order->id_address_invoice);
                    $delivery = new Address($order->id_address_delivery);
                    $delivery_state = $delivery->id_state ? new State($delivery->id_state) : false;
                    $invoice_state = $invoice->id_state ? new State($invoice->id_state) : false;

                    $data = array(
                    '{firstname}' => $this->context->customer->firstname,
                    '{lastname}' => $this->context->customer->lastname,
                    '{email}' => $this->context->customer->email,
                    '{delivery_block_txt}' => $this->_getFormatedAddress($delivery, "\n"),
                    '{invoice_block_txt}' => $this->_getFormatedAddress($invoice, "\n"),
                    '{delivery_block_html}' => $this->_getFormatedAddress($delivery, '<br />', array(
                        'firstname'    => '<span style="font-weight:bold;">%s</span>',
                        'lastname'    => '<span style="font-weight:bold;">%s</span>'
                    )),
                    '{invoice_block_html}' => $this->_getFormatedAddress($invoice, '<br />', array(
                            'firstname'    => '<span style="font-weight:bold;">%s</span>',
                            'lastname'    => '<span style="font-weight:bold;">%s</span>'
                    )),
                    '{delivery_company}' => $delivery->company,
                    '{delivery_firstname}' => $delivery->firstname,
                    '{delivery_lastname}' => $delivery->lastname,
                    '{delivery_address1}' => $delivery->address1,
                    '{delivery_address2}' => $delivery->address2,
                    '{delivery_city}' => $delivery->city,
                    '{delivery_postal_code}' => $delivery->postcode,
                    '{delivery_country}' => $delivery->country,
                    '{delivery_state}' => $delivery->id_state ? $delivery_state->name : '',
                    '{delivery_phone}' => ($delivery->phone) ? $delivery->phone : $delivery->phone_mobile,
                    '{delivery_other}' => $delivery->other,
                    '{invoice_company}' => $invoice->company,
                    '{invoice_vat_number}' => $invoice->vat_number,
                    '{invoice_firstname}' => $invoice->firstname,
                    '{invoice_lastname}' => $invoice->lastname,
                    '{invoice_address2}' => $invoice->address2,
                    '{invoice_address1}' => $invoice->address1,
                    '{invoice_city}' => $invoice->city,
                    '{invoice_postal_code}' => $invoice->postcode,
                    '{invoice_country}' => $invoice->country,
                    '{invoice_state}' => $invoice->id_state ? $invoice_state->name : '',
                    '{invoice_phone}' => ($invoice->phone) ? $invoice->phone : $invoice->phone_mobile,
                    '{invoice_other}' => $invoice->other,
                    '{order_name}' => $order->getUniqReference(),
                    '{date}' => Tools::displayDate(date('Y-m-d H:i:s'), (int)$order->id_lang, 1),
                    '{carrier}' => $virtual_product ? Tools::displayError('No carrier') : $carrier->name,
                    '{payment}' => Tools::Tools::substr($order->payment, 0, 32),
                    '{products}' => $this->formatProductAndVoucherForEmail($products_list),
                    '{discounts}' => $this->formatProductAndVoucherForEmail($cart_rules_list),
                    '{total_paid}' => Tools::displayPrice($order->total_paid, $this->context->currency, false),
                    '{total_products}' => Tools::displayPrice($order->total_paid -
                    $order->total_shipping - $order->total_wrapping +
                    $order->total_discounts, $this->context->currency, false),
                    '{total_discounts}' =>
                    Tools::displayPrice($order->total_discounts, $this->context->currency, false),
                    '{total_shipping}' => Tools::displayPrice($order->total_shipping, $this->context->currency, false),
                    '{total_wrapping}' => Tools::displayPrice($order->total_wrapping, $this->context->currency, false));

                    if (is_array($extra_vars))
                        $data = array_merge($data, $extra_vars);

                    // Join PDF invoice
                    if ((int)Configuration::get('PS_INVOICE') && $order_status->invoice && $order->invoice_number) {
                        $pdf = new PDF(
                            $order->getInvoicesCollection(),
                            PDF::TEMPLATE_INVOICE,
                            $this->context->smarty
                        );
                        $file_attachement['content'] = $pdf->render(false);
                        $file_attachement['name'] = Configuration::get('PS_INVOICE_PREFIX',
                        (int)$order->id_lang, null, $order->id_shop).sprintf('%06d', $order->invoice_number).'.pdf';
                        $file_attachement['mime'] = 'application/pdf';
                    } else {
                        $file_attachement = null;
                    }

                    if (Validate::isEmail($this->context->customer->email))
                        Mail::Send(
                            (int)$order->id_lang,
                            'order_conf',
                            Mail::l('Order confirmation', (int)$order->id_lang),
                            $data,
                            $this->context->customer->email,
                            $this->context->customer->firstname.' '.$this->context->customer->lastname,
                            null,
                            null,
                            $file_attachement,
                            null, _PS_MAIL_DIR_, false, (int)$order->id_shop
                        );
                }
                */

                // updates stock in shops
                if (Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT')) {
                    $product_list = $order->getProducts();

                    foreach ($product_list as $product) {
                        // if the available quantities depends on the physical stock
                        if (StockAvailable::dependsOnStock($product['product_id'])) {
                            // synchronizes
                            StockAvailable::synchronize($product['product_id'], $order->id_shop);
                        }
                    }
                }
            } else {
                $error = Tools::displayError('Order creation failed');
                Logger::addLog($error, 4, '0000002', 'Cart', (int)$order->id_cart);
                die($error);
            }
        } // End foreach $order_detail_list

        return $order;
    }

    private function updateStockQuantity($id_product, $id_product_attribute, $quantity)
    {
        if ($id_product_attribute) {
            $sql = '
                UPDATE
                    `'._DB_PREFIX_.'stock_available`
                SET
                    quantity = IF(quantity < 0,'.(int)$quantity.', quantity + '.(int)$quantity.')
                WHERE
                    id_product = '.(int)$id_product.'
                        AND
                    id_product_attribute = '.(int)$id_product_attribute.'
            ';

            Db::getInstance()->execute($sql);
        }

        $sql = '
            UPDATE
                `'._DB_PREFIX_.'stock_available`
            SET
                quantity = IF(quantity < 0,'.(int)$quantity.', quantity + '.(int)$quantity.')
            WHERE
                id_product = '.(int)$id_product.'
                    AND
                id_product_attribute = 0
        ';

        //error_log($sql);

        Db::getInstance()->execute($sql);
    }
}
