<?php
/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

class DjvPos extends Module
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->name = 'djvpos';
        $this->tab = 'administration';
        $this->version = '1.1.11';
        $this->module_key = '0ccf34a628a6edc846cf9ee8e002f526';

        $this->author = 'Dejavu Arts S.L.';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.5', 'max' => '1.6');
        $this->dependencies = array();

        parent::__construct();

        $this->displayName = $this->l('Dejavu Point Of Sale module for PrestaShop');
        $this->description = $this->l('Point Of Sale in back office.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall? This will delete all records');
    }

    public function install()
    {
        if (Shop::isFeatureActive()) {
            // for validator
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        $this->createTables();

        $this->addDefaultCustomer();
        $this->addOrderState();
        $this->addTabs();

        return (parent::install() and $this->registerHook('displayBackOfficeHeader'));
    }
    
    public function hookDisplayBackOfficeHeader()
    {
        $this->context->controller->addCss($this->_path.'views/css/back.css', 'all');
    }


    public function addDefaultCustomer()
    {
        $customer = new Customer();
        $customer->firstname = 'Cliente';
        $customer->lastname = 'POS';
        $customer->passwd = md5('ClientePOS'.date('Y-m-d H:i:s'));
        $customer->email = 'clientepos@example.com';
        $customer->active = 1;

        $customer->save();

        Configuration::updateValue('DJVPOS_GSCID', $customer->id);
        //error_log($customer->id);

        $address = new Address();
        $address->id_customer = $customer->id;
        $address->alias = 'Alias';
        $address->firstname = 'Cliente';
        $address->lastname = 'TPV';
        $address->address1 = 'C\ TPV';
        $address->address2 = 1;
        $address->postcode = 28000;
        $address->city = 'Madrid';
        $address->phone = '91 000 00 00';
        $address->phone_mobile = '600 00 00 00';
        $address->dni = '12345678Z';
        $address->active = 1;
        $address->id_country = Configuration::get('PS_COUNTRY_DEFAULT');

        $address->save();

        Configuration::updateValue('DJVPOS_GSCAID', $address->id);
        //error_log($address->id);
    }

    public function addOrderState()
    {
        $languages = Language::getLanguages();

        $order_state = new OrderState();

        $order_state->template = '';
        $order_state->send_email = 0;
        $order_state->module_name = '';
        $order_state->invoice = 1;
        $order_state->delivery = 1;
        $order_state->shipped = 0;
        $order_state->paid = 1;
        $order_state->deleted = 0;
        $order_state->active = 1;

        foreach ($languages as $l) {
            // for validator
            $order_state->name[$l['id_lang']] = 'Pedido en tienda';
        }

        $order_state->save();

        Configuration::updateValue('DJVPOS_FOSID', $order_state->id);
    }

    public function addTabs()
    {
        $languages = Language::getLanguages();
        //$profiles = Profile::getProfiles();

        $djvpos_tab = new Tab();
        $djvpos_tab->id_parent = 0;
        $djvpos_tab->class_name = 'AdminDjvPosOrders';
        $djvpos_tab->module = 'djvpos';
        $djvpos_tab->name = array();
        $djvpos_tab->active = 1;
        $djvpos_tab->position = 1;

        foreach ($languages as $l) {
            // for validator
            $djvpos_tab->name[$l['id_lang']] = 'Dejavu Point of Sale';
        }

        $djvpos_tab->save();

        Configuration::updateValue('DJVPOS_TABID', $djvpos_tab->id);

        $djvpos_orders_tab = new Tab();
        $djvpos_orders_tab->id_parent = $djvpos_tab->id;
        $djvpos_orders_tab->class_name = 'AdminDjvPosOrders';
        $djvpos_orders_tab->module = 'djvpos';
        $djvpos_orders_tab->name = array();
        $djvpos_orders_tab->active = 1;
        $djvpos_orders_tab->position = 1;

        foreach ($languages as $l) {
            // for validator
            $djvpos_orders_tab->name[$l['id_lang']] = 'Pedidos';
        }

        $djvpos_orders_tab->save();

        $djvpos_configuration_tab = new Tab();
        $djvpos_configuration_tab->id_parent = $djvpos_tab->id;
        $djvpos_configuration_tab->class_name = 'AdminDjvPosConfiguration';
        $djvpos_configuration_tab->module = 'djvpos';
        $djvpos_configuration_tab->name = array();
        $djvpos_configuration_tab->active = 1;
        $djvpos_configuration_tab->position = 1;

        foreach ($languages as $l) {
            // for validator
            $djvpos_configuration_tab->name[$l['id_lang']] = 'Configuración';
        }

        $djvpos_configuration_tab->save();
    }

    public function createTables()
    {
        Db::getInstance()->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'djvpos_orders`');

        $sql = '
            CREATE TABLE  `'._DB_PREFIX_.'djvpos_orders` (
                `id_order` int(10) unsigned NOT NULL,
                `date_add` datetime NOT NULL,
                `dependiente` varchar(45) NOT NULL,
                `entregado` decimal(16,5) NOT NULL DEFAULT \'0.00000\',
                `cambio` decimal(16,5) NOT NULL DEFAULT \'0.00000\',
                PRIMARY KEY (`id_order`)
            );
        ';

        Db::getInstance()->Execute($sql);
    }

    public function uninstall()
    {
        $tab_id = (int)Configuration::get('DJVPOS_TABID');

        if ($tab_id) {
            $sql = '
                SELECT
                    id_tab
                FROM
                    `'._DB_PREFIX_.'tabs
                WHERE
                    id_parent = '.$tab_id;

            //error_log($sql);

            $result = Db::getInstance()->ExecuteS($sql);

            foreach ($result as $row) {
                $tab = new Tab((int)$row['id_tab']);
                $tab->delete();
            }

            $tab = new Tab($tab_id);
            $tab->delete();
        }

        Db::getInstance()->Execute('DROP TABLE `'._DB_PREFIX_.'djvpos_orders`');

        return parent::uninstall();
    }

    /*
     *    Debug for 1 & 1
     */
    public function getContent()
    {
        $output = null;

        //$task = Tools::getValue('task');
        if (Tools::isSubmit('checkOAO')) {
            echo 1 . '<br>';
            print_r(scandir(_PS_ROOT_DIR_ . '/override/classes/'));
            echo 2 . '<br>';
            print_r(scandir(_PS_ROOT_DIR_ . '/override/controller/'));

            echo 3 . '<br>';

            echo DJVPOS_GSCID . ' '. (int)Configuration::get('DJVPOS_GSCID');
            echo DJVPOS_GSCAID . ' '. (int)Configuration::get('DJVPOS_GSCAID');
            $cart = new Cart();

            echo 4 . '<br>';
            $cart->id_customer = (int)Configuration::get('DJVPOS_GSCID');
            $cart->id_address_delivery = (int)Configuration::get('DJVPOS_GSCAID');
            $cart->id_address_invoice = (int)Configuration::get('DJVPOS_GSCAID');
            $cart->id_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
            $cart->id_lang = (int)Configuration::get('PS_LANG_DEFAULT');
            $cart->add();
            echo 5 . '<br>';
            $cart->updateQty(1, 4, 0);
            echo 6 . '<br>';
            echo $cart->getOrderTotal(false, Cart::ONLY_PRODUCTS);
            echo 7 . '<br>';
            echo $cart->getOrderTotal(true, Cart::ONLY_PRODUCTS);
            echo 8 . '<br>';
            echo $cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS);
            echo 9 . '<br>';


            $cart_rule = new CartRule();
            $cart_rule->partial_use = 0;
            $cart_rule->highlight = 0;
            $cart_rule->active = 1;
            $cart_rule->quantity = 1;
            $cart_rule->quantity_per_user = 1;
            $cart_rule->minimum_amount = 0;
            $cart_rule->minimum_amount_tax = 0;
            $cart_rule->minimum_amount_currency = 0;
            $cart_rule->minimum_amount_shipping = 0;

            $languages = Language::getLanguages();

            foreach ($languages as $l) {
                // for validator
                $cart_rule->name[$l['id_lang']] = 'Descuento en caja';
            }

            $cart_rule->reduction_amount = 1;
            $cart_rule->reduction_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');
            $cart_rule->reduction_percent = 0;
            $cart_rule->reduction_tax = 1;

            $cart_rule->minimum_amount = 0.1;
            $cart_rule->minimum_amount_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT');


            $cart_rule->id_customer = $cart->id_customer;


            $cart_rule->code = 'djvpos'.date('Ymdhis');

            $cart_rule->date_from = date('Y-m-d h:i:s', microtime(true));
            $cart_rule->date_to = date('Y-m-d h:i:s', microtime(true) + 3000);
            $cart_rule->id = null;
            $cart_rule->add();

            $sql = '
                INSERT INTO
                    `'._DB_PREFIX_.'cart_cart_rule`
                VALUES
                    ('.$cart->id.','.$cart_rule->id.')
            ';
            Db::getInstance()->execute($sql);
            $cart = new Cart($cart->id);
            echo 5 . '<br>';
            $cart->updateQty(1, 4, 0);
            echo 6 . '<br>';
            echo $cart->getOrderTotal(false, Cart::ONLY_PRODUCTS);
            echo 7 . '<br>';
            echo $cart->getOrderTotal(true, Cart::ONLY_PRODUCTS);
            echo 8 . '<br>';
            echo $cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS);
            echo 9 . '<br>';

            //echo file_get_contents(_PS_ROOT_DIR_ . '/classes/CartRule.php');


            die;
        }
        if (Tools::isSubmit('submit'.$this->name)) {
            $cashiers = (string)Tools::getValue('dependientes');

            $tickets_h = (string)Tools::getValue('tickets_h');
            Configuration::updateValue('DJVPOS_TICKETS_H', $tickets_h);

            $tickets_f = (string)Tools::getValue('tickets_f');
            Configuration::updateValue('DJVPOS_TICKETS_F', $tickets_f);

            if (!$cashiers || empty($cashiers) || !Validate::isGenericName($cashiers)) {
                // for validator
                $output .= $this->displayError($this->l('Invalid Configuration value'));
            } else {
                Configuration::updateValue('DJVPOS_CASHIERS', $cashiers);
                $output .= $this->displayConfirmation($this->l('Settings updated'));
            }

            $automatic_insertion = (int)Tools::getValue('insercion_automatica');
            Configuration::updateValue('DJVPOS_INSAUTO', $automatic_insertion);
        }

        $messages = array();
        return $output.$this->displayForm($messages);
    }

    public function displayForm($messages)
    {
        ob_start();
        ?>
        <?php echo join('', $messages)?>
        <br><br>

        <form id="configuration_form" class="defaultForm djvpos form-horizontal" method="post" novalidate="">
            <div class="panel" id="fieldset_0">
                <div class="panel-heading">
                    <i class="icon-asterisk"></i>
                    <?php echo $this->l('Comprobaciones'); ?>
                </div>

                <div class="form-group">
                    <?php
                    if (!is_writable(_PS_ROOT_DIR_.'/log/')) {
                        ?>
                        <img src="../img/admin/cross.png" alt="" title="" />
                        <span style="display: inline-block;">
                        <?php echo $this->l('Debe corregir los permisos de la carpeta')?>
                        <?php echo _PS_ROOT_DIR_.'/log/'?>
                        <?php echo $this->l('para permitir la escritura')?>.</span>
                    <?php
                    } else {
                        ?>
                        <img src="../img/admin/tick.png" alt="" title="" />
                        <span style="display: inline-block;">
                            <?php echo $this->l('Es posible escribir en la carpeta de log')?>.
                        </span>
                    <?php
                    }
                    ?>
                </div>

                <div class="form-group">
                    <?php
                    if ((int)Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) {
                        ?>
                        <img src="../img/admin/cross.png" alt="" title="" />
                        <span style="display: inline-block;">
                            <?php echo $this->l('El módulo no es compatible con la opción de multitienda')?>.
                        </span>
                    <?php
                    } else {
                        ?>
                        <img src="../img/admin/tick.png" alt="" title="" />
                        <span style="display: inline-block;">
                            <?php echo $this->l('Multitienda desactivada')?>.
                        </span>
                    <?php
                    }
                    ?>
                </div>
            </div>
            <br>

            <div class="panel" id="fieldset_3">
                <div class="panel-heading">
                    <i class="icon-magic"></i>
                    <?php echo $this->l('Personalización'); ?>
                </div>

                <form action="<?php echo Tools::safeOutput($_SERVER['REQUEST_URI']);?>" method="post">
                    <label  for="Dependientes">
                        <?php echo $this->l('Tipo de selección de producto:'); ?>
                    </label>
                    <div class="margin-form">
                        <?php
                        $insauto = ((int)Configuration::get('DJVPOS_INSAUTO') == 1);
                        ?>
                        <input type="radio" value="1" <?php echo ($insauto)?'checked="checked"':'';?>
                            id="insercion_automatica_yes" name="insercion_automatica" />
                            <?php echo $this->l('Automática'); ?>
                        <input type="radio" value="0" <?php echo (!$insauto)?'checked="checked"':'';?>
                            id="insercion_automatica_no" name="insercion_automatica" />
                            <?php echo $this->l('Manual'); ?>
                        <p class="clear">
                        <?php echo $this->l('Si usa pistola de infrarrojos 
                        para leer los códigos de barras, escoja'); ?>
                        <em><?php echo $this->l('Automática'); ?></em>.</p>
                    </div>

                    <label  for="Dependientes">
                        <?php echo $this->l('Lista de Dependientes'); ?>:
                    </label>
                    <div class="margin-form">
                        <input type="text" style="width: 200px" 
                        value="<?php echo Configuration::get('DJVPOS_CASHIERS')?>"
                        id="dependientes" name="dependientes" />
                        <p class="clear"><?php echo $this->l('Separados por comas, por ejemplo'); ?>:
                        <em>
                            <?php echo $this->l('Dependiente uno,Dependiente dos'); ?>
                        </em>.</p>
                    </div>

                    <label  for="tickets_h">
                        <?php echo $this->l('Cabecera tickets'); ?>:
                    </label>
                    <div class="margin-form">
                        <?php $tickets_h = Configuration::get('DJVPOS_TICKETS_H');?>
                        <textarea 
                        style="width: 400px; height: 200px" id="tickets_h" 
                        name="tickets_h"><?php echo $tickets_h?></textarea>
                        <p class="clear"></p>
                    </div>

                    <label  for="tickets_f">
                        <?php echo $this->l('Pie tickets'); ?>:
                    </label>
                    <div class="margin-form">
                        <?php $tickets_f = Configuration::get('DJVPOS_TICKETS_F');?>
                        <textarea style="width: 400px; height: 200px" id="tickets_f" 
                        name="tickets_f"><?php echo $tickets_f?></textarea>
                        <p class="clear"></p>
                    </div>

                    <input type="hidden" name="task" value="updateCustomization" id="actionTask" />

                    <div class="panel-footer">
                        <button type="submit" value="1" id="module_form_submit_btn" name="submitdjvpos" 
                        class="btn btn-default pull-right">
                        <i class="process-icon-save"></i> <?php echo $this->l('Guardar');?>
                        </button>
                    </div>
                </div>
            </form>

            <?php

            $old = ob_get_clean();

            // Get default Language
            $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

            $helper = new HelperForm();

            // Module, token and currentIndex
            $helper->module = $this;
            $helper->name_controller = $this->name;
            $helper->token = Tools::getAdminTokenLite('AdminModules');
            $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

            // Language
            $helper->default_form_language = $default_lang;
            $helper->allow_employee_form_lang = $default_lang;

            // Title and toolbar
            $helper->title = $this->displayName;
            $helper->show_toolbar = true;        // false -> remove toolbar
            $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
            $helper->submit_action = 'submit'.$this->name;
            $helper->toolbar_btn = array(
                'help' => array(
                    'desc' => $this->l('Help'),
                    'js' => 'window.open(\'http://www.dejavu.es/ayuda-modulo-erp-tpv-prestashop/\',\'popupwindow\',
                    \'width=500\',\'height=500\',\'scrollbars\',\'resizable\');',
                )
            );

        // Load current value
        $helper->fields_value['MYMODULE_NAME'] = Configuration::get('MYMODULE_NAME');
        $fields_form = array();

        return $helper->generateForm($fields_form).$old;
    }
}
