/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

;(function ($) {
	if ($.type($.dejavu) === 'undefined')
	{
		$.dejavu = {};
	}
		
	$.dejavu.entregadoKeypress = function(e) {
		if (e.which == 13) {
			var v = $('#djvoc_entregado').val();
			
			v = convertAmountToNumber(v);
			
			var change = v - total;
			nchange = change*100;
			nchange = Math.round(nchange);
			nchange = nchange/100.0;
			change = nchange;
			
			if (currencyFormat == 2)
				change = (""+change).replace('.', ',');	
			else
				change = (""+change).replace(',', '');	
			
			$('#djvoc_cambio').val(change);
			$('#djvoc_cambios').val(formatAmount(change) + ' ' + currencySign);
		}
	};
	
	$.dejavu.calcButtonClick = function (e){
		var ov = $('#djvoc_entregado').val();
		var v = $(this).val();
		v = ov + v;
		
		v = convertAmountToNumber(v);
		
		nv = v*100;
		nv = Math.round(nv);
		nv = nv/100.0;
		console.log(nv)
		console.log(v)
		
		if (v != nv)
		{
			v = nv;
		}
		
		if (isNaN(v))
		{
			v = ov;
		}
		else
		{			
			if (currencyFormat == 2)
				v = (""+v).replace('.', ',');
			
			$('#djvoc_entregado').val(formatAmount(v));
		}
	};
	
	$.dejavu.calcChangeClick = function () {
		var v = $('#djvoc_entregado').val();
		console.log('v:' + v)
		v = convertAmountToNumber(v);
		console.log('v:' + v)
		console.log('total:' + total)
		var change = v - total;
		console.log('change:' + change)
		nchange = change*100;
		console.log('nchange:' + nchange)
		nchange = Math.round(nchange);
		console.log('nchange:' + nchange)
		nchange = nchange/100.0;
		console.log('nchange:' + nchange)
		change = nchange;
		console.log('change:' + change)
		
		if (currencyFormat == 2)
			change = (""+change).replace('.', ',');			
		
		$('#djvoc_entregados').text($('#djvoc_entregado').val() + ' ' + currencySign);		
		$('#djvoc_cambio').val(change);
		$('#djvoc_cambios').text(formatAmount(change) + ' ' + currencySign);
	};
	
	$(function () {
		$('#djvoc_clearButton')
			.button()	
			.click(function () {	
				$('#djvoc_entregado').val('');
			});
		
		$('#djvoc_delButton')
			.button()	
			.click(function () {
				var v = $('#djvoc_entregado').val();
				console.log(v.length);
				if (v.length > 1)
				{
					v = v.substr(0, v.length - 1);
				}
				else	
					v = '';
				$('#djvoc_entregado').val(v);
			});
		
		$('#djvoc_entregado')
			.keypress($.dejavu.entregadoKeypress);
		
		$('#djvoc_calcChangeButton')
			.button()	
			.click($.dejavu.calcChangeClick);
		
		$('.calcButton')
			.button()	
			.click($.dejavu.calcButtonClick);
	});
})(jQuery);