/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

;(function ($) {
	if ($.type($.dejavu) === 'undefined')
	{
		$.dejavu = {};
	}
	
	$.dejavu.submitAddToCartClick = function () {
		var id_product = $('#djvoc_id_product').val();
		var id_product_attribute = $('#djvoc_id_product_attribute').val();
		//var quantity = $('#djvoc_quantity').val();
		var quantity = 1;
		
		if (!id_product_attribute)
		{
			id_product_attribute = 0;
		}
		
		var url = link;
		url += '&task=addToCart';
		url += '&id_product=' + id_product;
		url += '&id_product_attribute=' + id_product_attribute;
		url += '&quantity=' + quantity;
		
		window.location = url;
	};
	
	$(function (){
		if (!id_order)
		{
			$('#djvoc_addToCartButton')
				.button()
				.click($.dejavu.submitAddToCartClick);
				
			$('#djvoc_search')
				.focus()
				.bind( "keydown", function(event) {
					if (
						event.keyCode === $.ui.keyCode.TAB &&
						$(this).data("ui-autocomplete").menu.active
					) 
					{
						event.preventDefault();
					}
				})
				.autocomplete({
					delay: 300,
					minLength: 1,
					source: function (request, response) {				
						$.ajax({
							url: link + '&task=getSourceProducts&ajax=1',
							dataType: 'json',
							data: {							
								'search': request.term
							},						
							success: function (data) {
								var products = data['products'];						
								
								if (automaticInsertion && products.length == 1)
								{
									var $el = $("#djvoc_search");
									item = products[0];
									var  name = item.name;
									
									if (item.id_product_attribute)
									{
										var attr = [];
										for (var i = 0; i < item.attributes.length; i++)
										{
											attr.push(item.attributes[i].group + ': ' + item.attributes[i].name); 
										}
										
										attr = attr.join(';');
										name += ' - ' + attr;
									}
									
									priceDisplayPrecision = 2;
									
									if (item.price - item.special > 0.02)								
									{
										name += ' : antes ' + formatCurrency(item.price, currencyFormat, currencySign, currencyBlank) + ' ahora ' + formatCurrency(item.special, currencyFormat, currencySign, currencyBlank);
									}
									else
									{
										name += ' : ' + formatCurrency(item.price, currencyFormat, currencySign, currencyBlank);
									}
								
								
									$el.val(name);
									$('#djvoc_id_product').val(item.id_product);
									$('#djvoc_id_product_attribute').val(item.id_product_attribute);
									//$('#djvoc_quantity').focus();
									$.dejavu.submitAddToCartClick();
									
									return false;								
								}
								
							
								return response($.map(data['products'], function(item) {								
									var  name = item.name;
									if (item.id_product_attribute)
									{
										var attr = [];
										for (var i = 0; i < item.attributes.length; i++)
										{
											attr.push(item.attributes[i].group + ': ' + item.attributes[i].name); 
										}
										
										attr = attr.join(';');
										name += ' - ' + attr;
									}
									
									priceDisplayPrecision = 2;
									
									if (item.price - item.special > 0.02)								
									{
										name += ' : antes ' + formatCurrency(item.price, currencyFormat, currencySign, currencyBlank) + ' ahora ' + formatCurrency(item.special, currencyFormat, currencySign, currencyBlank);
									}
									else
									{
										name += ' : ' + formatCurrency(item.price, currencyFormat, currencySign, currencyBlank);
									}
									
									
									
									
									return {
										label: name,
										value: name,
										id_product: item.id_product,
										id_product_attribute: item.id_product_attribute
									}
								}));
							}
						});
					},
					select: function(event, ui) {
						if (ui.item)
						{
							console.log(ui.item);
							$('#djvoc_id_product').val(ui.item.id_product);
							$('#djvoc_id_product_attribute').val(ui.item.id_product_attribute);
							$.dejavu.submitAddToCartClick();
							//$('#djvoc_quantity').focus();
						}
					}
				});
		}
	});
})(jQuery);