/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

; (function ($){
	if ($.type($.dejavu) === 'undefined')
	{
		$.dejavu = {};
	}
	
	var newOrderClick = function () {				
		window.location = linkNew;
	};
	
	var updateAddresses = function ()
	{
		console.log('called updateAddresses')
		$.ajax({
			type:'POST',
			url: linkCart,
			async: true,
			dataType: 'json',
			data : {
				ajax: '1',
				token: tokenCart,
				tab: 'AdminCarts',
				action: 'updateAddresses',
				id_customer: id_customer,
				id_cart: id_cart,
				id_address_delivery: $('#djvoc_address_delivery option:selected').val(),
				id_address_invoice: $('#djvoc_address_invoice option:selected').val()
				},
			success : function(res)
			{
				console.log('updateAddresses')
				console.log(res)
				updateDeliveryOption();
			}
		});
	}
	
	function updateDeliveryOption()
	{
		console.log('called updateDeliveryOption')
		$.ajax({
			type:"POST",
			url: linkCart,
			async: true,
			dataType: "json",
			data : {
				ajax: "1",
				token: tokenCart,
				tab: "AdminCarts",
				action: "updateDeliveryOption",
				delivery_option: $('#djvoc_delivery option:selected').val(),
				gift: $('#order_gift').is(':checked')?1:0,
				gift_message: $('#gift_message').val(),
				recyclable: $('#carrier_recycled_package').is(':checked')?1:0,
				id_customer: id_customer,
				id_cart: id_cart
				},
			success : function(res)
			{
				console.log('updateDeliveryOption')
				console.log(res)
				displaySummary(res);
			}
		});
	}
	
	function displaySummary(jsonSummary)
	{
		currency_format = jsonSummary.currency.format;
		currency_sign = jsonSummary.currency.sign;
		currency_blank = jsonSummary.currency.blank;
		priceDisplayPrecision = jsonSummary.currency.decimals ? 2 : 0;
		/*
		updateCartProducts(jsonSummary.summary.products, jsonSummary.summary.gift_products, jsonSummary.cart.id_address_delivery);
		updateCartVouchers(jsonSummary.summary.discounts);
		updateAddressesList(jsonSummary.addresses, jsonSummary.cart.id_address_delivery, jsonSummary.cart.id_address_invoice);

		if (!jsonSummary.summary.products.length || !jsonSummary.addresses.length || !jsonSummary.delivery_option_list)
			$('#carriers_part,#summary_part').hide();
		else
			$('#carriers_part,#summary_part').show();
		*/
		
		updateDeliveryOptionList(jsonSummary.delivery_option_list);

		
		/*
		if (jsonSummary.cart.gift == 1)
			$('#order_gift').attr('checked', true);
		else
			$('#carrier_gift').removeAttr('checked');
		
		if (jsonSummary.cart.recyclable == 1)
			$('#carrier_recycled_package').attr('checked', true);
		else
			$('#carrier_recycled_package').removeAttr('checked');
		if (jsonSummary.free_shipping == 1)
			$('#free_shipping').attr('checked', true);
		else
			$('#free_shipping').removeAttr('checked');

		$('#gift_message').html(jsonSummary.cart.gift_message);
		if (!changed_shipping_price)
			$('#shipping_price').html('<b>' + formatCurrency(parseFloat(jsonSummary.summary.total_shipping), currency_format, currency_sign, currency_blank) + '</b>');
		shipping_price_selected_carrier = jsonSummary.summary.total_shipping;
		
		$('#total_vouchers').html(formatCurrency(parseFloat(jsonSummary.summary.total_discounts_tax_exc.replace(',', '.')), currency_format, currency_sign, currency_blank));
		*/
		$('#djvoc_total_shipping').html(formatCurrency(parseFloat(jsonSummary.summary.total_shipping), currency_format, currency_sign, currency_blank));
		/*
		$('#total_taxes').html(formatCurrency(parseFloat(jsonSummary.summary.total_tax.replace(',', '.')), currency_format, currency_sign, currency_blank));
		$('#total_without_taxes').html(formatCurrency(parseFloat(jsonSummary.summary.total_price_without_tax.replace(',', '.')), currency_format, currency_sign, currency_blank));
		*/
		$('.total-row td').html(formatCurrency(parseFloat(jsonSummary.summary.total_price.replace(',', '.')), currency_format, currency_sign, currency_blank));
		total = parseFloat(jsonSummary.summary.total_price.replace(',', '.'));
		/*
		$('#total_products').html(formatCurrency(parseFloat(jsonSummary.summary.total_products.replace(',', '.')), currency_format, currency_sign, currency_blank));
		id_currency = jsonSummary.cart.id_currency;
		$('#id_currency option').removeAttr('selected');
		$('#id_currency option[value="'+id_currency+'"]').attr('selected', true);
		id_lang = jsonSummary.cart.id_lang;
		$('#id_lang option').removeAttr('selected');
		$('#id_lang option[value="'+id_lang+'"]').attr('selected', true);
		$('#send_email_to_customer').attr('rel', jsonSummary.link_order);
		$('#go_order_process').attr('href', jsonSummary.link_order);
		$('#order_message').val(jsonSummary.order_message);
		resetBind();
		*/
	}
	
	function updateDeliveryOptionList(delivery_option_list)
	{
		console.log('called updateDeliveryOptionList');
		console.log(delivery_option_list);
		var html = '';
		if (delivery_option_list.length > 0)
		{
			$.each(delivery_option_list, function() {
				html += '<option value="'+this.key+'" '+(($('#djvoc_delivery').val() == this.key) ? 'selected="selected"' : '')+'>'+this.name+'</option>';
			});
			$('#carrier_form').show();
			$('#djvoc_delivery').html(html);
			$('#carriers_err').hide();
		}
		else
		{
			$('#djvoc_delivery').hide();
			$('#carriers_err').show().html('No se puede aplicar ning&uacute;n transportista a esta orden');
		}
	}
	
	var createOrderClick = function () {
		$.dejavu.calcChangeClick();
		
		var id_customer = $('#djvoc_id_customer').val();
		var payment = $('#djvoc_payment').val();
		var dependiente = $('#djvoc_dependiente').val();
		var withoutTax = $('#djvoc_withoutTax:checked').length;	
		var entregado = $('#djvoc_entregado').val();
		var cambio = $('#djvoc_cambio').val();
		var id_tipodeventa = $('#djvoc_tipodeventa').val();
		
		var notas = $('#djvoc_notas').serialize();
							
		if (!dependiente)
		{
			alert('Es obligatorio indicar el dependiente.');
			return;
		}
		
		entregado = entregado.replace(/\s/g, '');
		
		if (currencyFormat == 2)			
			entregado = entregado.replace(',', '.');
		entregado = entregado.replace(currencySign, '');
		entregado = Number(entregado);
		
		cambio = cambio.replace(/\s/g, '');
		if (currencyFormat == 2)
			cambio = cambio.replace(',', '.');
		cambio = cambio.replace(currencySign, '');
		cambio = Number(cambio);				
		console.log('-'+entregado+'-');
		console.log('-'+cambio+'-');
		
		if (id_tipodeventa == 4)
		{			
			var order_return_numero = $('#djvoc_order_return_numero').val();
			
			cambio = entregado;
			entregado = 0;
			console.log('-'+cambio+'-');
			
			if (cambio <= 0)
			{
				alert('Para realizar una devolución es obligatorio: \n - Indicar la cantidad entregada')
				return;
			}
		}
		else
		{
		
			console.log('-'+entregado+'-');
			console.log('-'+cambio+'-');
			
			if (
				(payment == 'Efectivo') && 
				(
					
					!entregado || (cambio < 0)
				)
			)
			{
				alert('Para realizar un pedido en efectivo es obligatorio: \n - Indicar la cantidad entregada\n- Calcular el cambio\n- Que la cantidad a devolver sea positiva o cero.')
				return;
			}

			
		}
		
		var url = link+'&task=createOrder';					
		url += '&payment=' + payment;
		url += '&dependiente=' + dependiente;
		url += '&entregado=' + entregado;
		url += '&cambio=' + cambio;
		url += '&id_tipodeventa=' + id_tipodeventa;
		
		if (
			(id_tipodeventa == 2) || 
			(id_tipodeventa == 3)
		)
		{
			var id_address_delivery = $('#djvoc_address_delivery option:selected').val();
			var id_address_invoice = $('#djvoc_address_invoice option:selected').val();
			var delivery = $('#djvoc_delivery option:selected').val();
			url += '&id_address_delivery=' + id_address_delivery;
			url += '&id_address_invoice=' + id_address_invoice;
			url += '&delivery=' + delivery;
		}
		else if (id_tipodeventa == 4)
		{
			url += '&order_return_numero=' + order_return_numero;
		}
		
		url += '&'+notas;
		
		$('#djvoc_createOrderButton').attr('disabled', 'disabled');
		
		window.location = url;
	};
	
	$.dejavu.tipodeventaChange = function (e) {

		var el = this;
		var id_tipodeventa = Number($(el).val());
		
		console.log(id_tipodeventa);
		//var tipodeventaValue = $('option:selected', el).data('intvalue');					
		
		switch (id_tipodeventa)
		{
			case 2:
			case 3:
				console.log('2,3');
				$('#djvoc_deliveryBlock').removeClass('pixeden_hidden');
				$('#djvoc_deliveryBlock').addClass('pixeden_block');
				$('#djvoc_orderReturnBlock').removeClass('pixeden_block');
				$('#djvoc_orderReturnBlock').addClass('pixeden_hidden');				
				updateDeliveryOption();
				break;
			
			case 4:
				console.log('4');
				$('#djvoc_deliveryBlock').removeClass('pixeden_block');
				$('#djvoc_deliveryBlock').addClass('pixeden_hidden');
				$('#djvoc_orderReturnBlock').removeClass('pixeden_hidden');
				$('#djvoc_orderReturnBlock').addClass('pixeden_block');
				break;
				
			default:
				console.log('1');
				$('#djvoc_deliveryBlock').removeClass('pixeden_block');
				$('#djvoc_deliveryBlock').addClass('pixeden_hidden');
				$('#djvoc_orderReturnBlock').removeClass('pixeden_block');
				$('#djvoc_orderReturnBlock').addClass('pixeden_hidden');
				break;
		}
	};
	
	var applyGlobalDiscountClick = function (e) {	
		e.preventDefault();
		var discount = $('#djvoc_global_discount').val();
		
		discount = discount.replace(/\s/g, '')
		if (currencyFormat == 2)
			discount = discount.replace(',', '.');
		
		var url = link;
		url += '&task=applyDiscount'; 
		url += '&globalDiscount=1';					
		url += '&discount='+ discount;
		//console.log(url);
		window.location = url;
	};

	$(function (){		
		$('.order-container select')
			.uniform();
		
		if (!id_order)
		{
			$('#djvoc_tipodeventa')
				.change($.dejavu.tipodeventaChange);
				
			$('#djvoc_address_delivery,#djvoc_address_invoice')
				.change(updateAddresses);
			
			$('#djvoc_createOrderButton')
				.button()
				.click(createOrderClick);	
				
			$('#djvoc_applyGlobalDiscountButton')
				.button()
				.click(applyGlobalDiscountClick);
		}		
		
		$('#djvoc_newOrderButton')		
			.button()
			.click(newOrderClick);
		
		$('#djvoc_delivery')
			.change(updateDeliveryOption)
		
		$('#djvoc_entregado').keyup(function () {
			var v = $('#djvoc_entregado').val();
			v = convertAmountToNumber(v);
			
			nv = v*100;
			nv = Math.round(nv);
			nv = nv/100.0;
			console.log(nv)
			console.log(v)
			
			if (v != nv)
			{
				v = nv;
			}
			
			if (isNaN(v))
			{
				v = 0;
			}
			
			v = (''+v).replace('.', ',');			
			$('#djvoc_entregado').val(formatAmount(v));
		});
		

			
		$('#djvoc_showCustomerMenuButton')
			.button({
				icons: {
					primary: 'ui-icon-person',
					secondary: 'ui-icon-triangle-1-s'
				},
				text: false
			})
			.click(function () { $('#djvoc_customerMenu').show(); });
		
		$('#djvoc_showSearchCustomerBoxButton')
			.click(function () { $('#djvoc_showSearchCustomerBox').show(); });
		
		$('#djvoc_customerMenu')
			.menu()
			.click(function () { $('#djvoc_customerMenu').hide(); });
			
		$('#djvoc_addCustomerButton')
			.button()
			.click(function () { 
				var url = link;
				url += '&task=addCustomer';
				window.location = url;
			});

		$('#djvoc_selectCustomerButton')
			.button()
			.click(function () { 
				var id_customer = $('#djvoc_searchCustomer').data('id_customer');
				
				if (
					(!id_customer) ||
					(id_customer == id_customer_generic)
				)
				{
					return;
				}
				
				var url = link;
				
				url += '&task=setCustomer&id_customer=' + id_customer;
				
				window.location = url;	
			});
			
		$('#djvoc_removeCustomerButton')			
			.click(function () { 				
				var url = link;
				
				url += '&task=removeCustomer';
				
				window.location = url;	
			});
		
		$('#djvoc_searchCustomer')
			.bind('keydown', function(event) {
				if (
					event.keyCode === $.ui.keyCode.TAB &&
					$(this).data('ui-autocomplete').menu.active
				) 
				{
					event.preventDefault();
				}
			})
			.autocomplete({
				delay: 300,
				minLength: 3,
				source: function (request, response) {				
					$.ajax({
						url: link + '&task=getSourceCustomers&ajax=1',
						dataType: 'json',
						data: {							
							'search': request.term
						},						
						success: function (data) {
							return response($.map(data['customers'], function(item) {								
								var  name = item.name;								
								
								return {
									label: name,
									value: name,
									id_customer: item.id_customer									
								}
							}));
						}
					});
				},
				select: function(event, ui) {
					if (ui.item)
					{
						//console.log(ui.item);
						//var url = link;
						//url += '&id_customer=' + ui.item.id_customer;
						//window.location = url;			
						$('#djvoc_searchCustomer').data('id_customer', ui.item.id_customer);
						$('#djvoc_selectCustomerButton').click();
					}
				}
			});
			
		
	});
})(jQuery);