{*
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*}
<script type="text/javascript">
var id_cart = {$cart->id|intval};

var id_order = {($order)?$order->id:0|intval};
</script>
<form id="customer_form" class="defaultForm AdminCustomers" action="index.php?controller=AdminDjvPosOrders&token={$token|escape:'htmlall':'UTF-8'}&task=submitAddCustomer" method="post" enctype="multipart/form-data">
	{if (!$customer->id)}
		<fieldset id="fieldset_0">
			<legend>
				<img src="../img/admin/tab-customers.gif" alt="{l s='Cliente' mod='djvpos'}">
				{l s='Cliente' mod='djvpos'}
			</legend>

			<div class="clear"></div>

			<label>{l s='Nombre' mod='djvpos'}: </label>
			<div class="margin-form">
				<input type="text" name="firstname" id="firstname" value="{$customer->firstname|escape:'htmlall':'UTF-8'}" size="33">
				<span class="hint" name="help_box" style="display: none;">Caracteres prohibidos: 0-9!&lt;&gt;,;?=+()@#"�{}_$%:<span class="hint-pointer">&nbsp;</span></span>
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='Apellidos' mod='djvpos'}: </label>
			<div class="margin-form">
				<input type="text" name="lastname" id="lastname" value="{$customer->lastname|escape:'htmlall':'UTF-8'}" size="33">
				<span class="hint" name="help_box" style="display: none;">Caracteres no válidos: 0-9!&lt;&gt;,;?=+()@#"�{}_$%:<span class="hint-pointer">&nbsp;</span></span>
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='E-mail' mod='djvpos'}: </label>
			<div class="margin-form">
				<input type="text" name="email" id="email" value="{$customer->email|escape:'htmlall':'UTF-8'}" class="" size="33">
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='Newsletter' mod='djvpos'}: </label>
			<div class="margin-form">
				<input type="radio" name="newsletter" id="newsletter_on" value="1" {if $customer->newsletter}checked="checked"{/if}/>
				<label class="t" for="newsletter_on">
					<img src="../img/admin/enabled.gif" alt="{l s='Activado' mod='djvpos'}" title="{l s='Activado' mod='djvpos'}">
				</label>

				<input type="radio" name="newsletter" id="newsletter_off" value="0" {if !$customer->newsletter}checked="checked"{/if}/>
				<label class="t" for="newsletter_off">
					<img src="../img/admin/disabled.gif" alt="{l s='Desactivado' mod='djvpos'}" title="{l s='Desactivado' mod='djvpos'}">
				</label>

				<p class="preference_description">
					{l s='Cliente abonado a la newsletter' mod='djvpos'}
				</p>
			</div>

			<div class="clear"></div>

			<input type="hidden" name="active" id="active_on" value="1" />

			{* customer group*}

			<input type="hidden" name="groupBox[]" id="groupBox_3" value="3" />
			<input type="hidden" name="id_default_group" id="id_default_group" value="3" />

			<div class="small"><sup>*</sup> {l s='Campo obligatorio' mod='djvpos'}</div>
		</fieldset>
	{else}
		<fieldset id="fieldset_0">
			<legend>
				<img src="../img/admin/tab-customers.gif" alt="{l s='Cliente' mod='djvpos'}">
				{l s='Cliente' mod='djvpos'}:
			</legend>

			<div>
				{$customer->firstname|escape:'htmlall':'UTF-8'} {$customer->lastname|escape:'htmlall':'UTF-8'}
			</div>
		</fieldset>
	{/if}

	<div class="leadin">
		<br/>
	</div>
	{if (!$address->id)}
		<fieldset id="fieldset_1">
			<legend>
				<img src="../img/admin/contact.gif" alt="Direcciones"> 
				{l s='Dirección' mod='djvpos'}
			</legend>

			<label>{l s='Número de identificación fiscal' mod='djvpos'}</label>
			<div class="margin-form">
				<input type="text" name="dni" id="dni" value="{$address->dni|escape:'htmlall':'UTF-8'}" size="33">
				<p class="preference_description">
					{l s='DNI/NIF/NIE' mod='djvpos'}
				</p>
			</div>

			<div class="clear"></div>

			<label>{l s='Empresa' mod='djvpos'}  </label>
			<div class="margin-form">
				<input type="text" name="company" id="company" value="{$address->company|escape:'htmlall':'UTF-8'}" size="33">
				<span class="hint" name="help_box">{l s='Caracteres no válidos: &lt;&gt;;=#{ }' mod='djvpos'}<span class="hint-pointer">&nbsp;</span><span class="hint-pointer">&nbsp;</span></span>
			</div>

			<div class="clear"></div>

			<div style="display: none;">
				<label>{l s='Número de IVA' mod='djvpos'} </label>
				<div class="margin-form">
					<input type="text" name="vat_number" id="vat_number" value="{$address->vat_number|escape:'htmlall':'UTF-8'}" size="33">
				</div>

				<div class="clear"></div>
			</div>


			<label>{l s='Dirección' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="address1" id="address1" value="{$address->address1|escape:'htmlall':'UTF-8'}" size="33">
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='Dirección (2)' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="address2" id="address2" value="{$address->address2|escape:'htmlall':'UTF-8'}" size="33">
			</div>
			
			<div class="clear"></div>

			<label>{l s='Código Postal' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="postcode" id="postcode" value="{$address->postcode|escape:'htmlall':'UTF-8'}" size="33">
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='Ciudad' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="city" id="city" value="{$address->city|escape:'htmlall':'UTF-8'}" size="33">
				<sup>*</sup>
			</div>

			<div class="clear"></div>

			<label>{l s='País' mod='djvpos'}</label>
			<div class="margin-form">
				<select name="id_country" id="id_country">
					<option value="0">----------</option>
					{foreach $countries as $country}
						<option value="{$country.id_country|intval}" {if ($country.id_country == $id_country)}selected="selected"{/if}>{$country.name|escape:'htmlall':'UTF-8'}</option>
					{/foreach}
				</select>
			</div>

			<div class="clear"></div>

			<div id="contains_states" {if (!$states)}style="display: none"{/if}>
				<label>{l s='Provincia' mod='djvpos'}</label>
				<div class="margin-form">
					<select name="id_state" id="id_state">
						<option value="0">----------</option>
						{foreach $states as $state}
							<option value="{$state.id_state|intval}" {if ($state.id_state == $id_state)}selected="selected"{/if}>{$state.name|escape:'htmlall':'UTF-8'}</option>
						{/foreach}
					</select>
				</div>

				<div class="clear"></div>
			</div>

			<label>{l s='Teléfono domicilio' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="phone" id="phone" value="{$address->phone|escape:'htmlall':'UTF-8'}" size="33">
			</div>

			<div class="clear"></div>

			<label>{l s='Teléfono móvil' mod='djvpos'} </label>
			<div class="margin-form">
				<input type="text" name="phone_mobile" id="phone_mobile" value="{$address->phone_mobile|escape:'htmlall':'UTF-8'}" size="33">
				<p class="preference_description">
					{l s='Tienes que registrar al menos un número de teléfono' mod='djvpos'} <sup>*</sup>
				</p>
			</div>

			<div class="clear"></div>

			<div class="small"><sup>*</sup> {l s='Campo obligatorio' mod='djvpos'}</div>

			<input type="hidden" name="alias" value="{l s='Mi dirección' mod='djvpos'}" />
		</fieldset>
	{else}
		<fieldset>
			<legend>
				<img src="../img/admin/tab-customers.gif" alt="Cliente">
				{l s='Dirección' mod='djvpos'}:
			</legend>

			<div>
				{$address->address1|escape:'htmlall':'UTF-8'} {$address->address2|escape:'htmlall':'UTF-8'}
			</div>
		</fieldset>
	{/if}
	<div class="leadin">
		<br/>
	</div>

	{if (!$address->id)}
		<div>
			<input type="submit" value="{l s='Crear cliente' mod='djvpos'}" class="button"/>
		</div>
	{else}
		<a class="button" href="index.php?controller=AdminDjvPosOrders&token={$token|escape:'htmlall':'UTF-8'}&id_customer={$customer->id|intval}&task=newCustomerCart">Crear un pedido con este cliente</a>
	{/if}
</form>

<script type="text/javascript">
;
var link = 'index.php?controller=AdminDjvPosOrders&token={$token|escape:'htmlall':'UTF-8'}';

(function ($) {
	$(function() {
		$('#id_country').change(function() {
			var data = {};
			data.id_country = $('#id_country').val();
			data.ajax = 1;
			data.task = "getStates";
			data.t = Date.now();
			$.ajax({
				cache: false,
				type: "POST",
				url: link,
				data: data,
				dataType: 'json',
				async : true,
				success: function(states) {
					if (!states.length || states == 'false')
					{
						console.log('no states');
						$('#contains_states').hide();
						$('#id_state').empty();
					}
					else
					{
						$('#contains_states').show();
						$('#id_state')
							.empty()
							.append($('<option>').val(0).text('----------'));
						$(states).each(function () {
							$('#id_state').append($('<option>').val(this.id_state).text(this.name));
						});
					}
				},
				error: function(msg) {
				}
			});
		});

		$('input[name=email]').live('blur', function(e) {
			var email = $(this).val();
			console.log(email);
			if (email.length > 5)
			{
				var data = {};
				data.email = email;
				data.ajax = 1;
				data.task = "checkEmailExists";
				data.t = Date.now();
				$.ajax({
					cache: false,
					type: "POST",
					url: link,
					data: data,
					dataType: 'json',
					async : true,
					success: function(customer) {
						if (customer)
						{
							alert('{l s='El cliente' mod='djvpos'} ' + customer.firstname + ' ' + customer.lastname + ' {l s='ya está utilizando el email' mod='djvpos'}: \'' + email + '\'');
						}
					},
					error: function(msg) {
					}
				});
			}
		});
	});
})(jQuery);

</script>