{*
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*}

<h2>{l s='PEDIDO' mod='djvpos'}</h2>

{if $products}
	<table class="product-table" style="width: 100%">
		<tr>
			<th></th>
			<th>{l s='Producto' mod='djvpos'}</th>
			<th>{l s='Referencia' mod='djvpos'}</th>
			<th style="text-align:center" >{l s='PVP unitario' mod='djvpos'}</th>
			<th style="text-align:center">{l s='Stock' mod='djvpos'}</th>
			<th style="text-align:center">{l s='Cantidad' mod='djvpos'}</th>
			<th style="text-align:center">{l s='Total' mod='djvpos'}</th>
			<th style="text-align:center">{l s='IVA' mod='djvpos'}</th>
			<th style="text-align:center">{l s='Descuento' mod='djvpos'}</th>
			<th style="text-align:center">{l s='Eliminar' mod='djvpos'}</th>
		</tr>

		{foreach $products as $product}
			<tr>
				<td width="50">
					<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small_default')|escape:'htmlall':'UTF-8'}"/>
				</td>

				<td width="30%">
					{$product.name|escape:'htmlall':'UTF-8'}
					{if ($product.attributes)}
						&nbsp;<i><small>{$product.attributes|escape:'htmlall':'UTF-8'}}</small></i>
					{/if}
				</td>

				<td style="width: 6%; text-align: left; min-width: 75px;">
					{$product.reference|escape:'htmlall':'UTF-8'}
				</td>

				<td style="text-align: center; min-width: 110px; width: 8%;">
					{convertPrice price=$product.price_wt|floatval}
				</td>

				<td style="text-align: center; min-width: 50px; width: 5%;">
					{$product.stock_quantity|intval}
				</td>

				<td width="70">
					{if (!$order->id)}
						<input value="{$product.cart_quantity|intval}" disabled="disabled" class="cellInput" />
						<div style="width: 20px; position: relative; top:0; right:-64%; float:left;">
							<button class="djvoc_upProductQuantity mini-btn mini-btn-light" data-id="{$product.id_product|intval}" data-ipa="{$product.id_product_attribute|intval}"><span class="btn-icon-plus">Añadir</span></button>
							<button class="djvoc_downProductQuantity mini-btn mini-btn-light " data-id="{$product.id_product|intval}" data-ipa="{$product.id_product_attribute|intval}"><span class="btn-icon-minus">Quitar</span></button>
						</div>
					{else}
						<div style="width: 100%; text-align: center";>
							{$product.cart_quantity|intval}
						</div>
					{/if}
				</td>

				<td style="text-align: center; min-width: 110px; width: 10%;">
					{convertPrice price=$product.total_wt|floatval}
				</td>
				<td width="40" style="text-align: center">
					{$product.rate|floatval}%
				</td>
				<td class="input-cell" style="padding-left: 35px !important; width: 70px;">
					{if (!$order->id)}
					<input value="" type="text" data-id="{$product.id_product|intval}" data-ipa="{$product.id_product_attribute|intval}" />
					<button class="djvoc_applyProductDiscountButton" class="input-button"><span class="icon-refresh"></span></button>
					{/if}
				</td>
				<td width="20" style="text-align: center;">
					{if (!$order->id)}
						<div class="bluefoose-ui-button-light" >
							<button class="djvoc_remove" data-id="{$product.id_product|intval}" data-ipa="{$product.id_product_attribute|intval}">x</button>
						</div>
					{/if}
				</td>
			</tr>
		{/foreach}
	</table>
{/if}