{*
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*}

{if (!$order)}
	{assign var="products_total" value=$cart->getOrderTotal(false, Cart::ONLY_PRODUCTS)}		
	{assign var="total_wt" value=$cart->getOrderTotal(true, Cart::ONLY_PRODUCTS)}	
	{assign var="discounts" value=$cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS)}	
	{assign var="total_t" value=$total_wt - $products_total}		
	{assign var="total_shipping" value=0}
	{assign var="total" value=$total_wt - $discounts}		
{else}
	{assign var="products_total" value=$cart->getOrderTotal(false, Cart::ONLY_PRODUCTS)}		
	{assign var="total_wt" value=$cart->getOrderTotal(true, Cart::ONLY_PRODUCTS)}	
	{assign var="discounts" value=$cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS)}	
	{assign var="total_t" value=$total_wt - $products_total}		
	{assign var="total_shipping" value=$order->total_shipping}
	{assign var="total" value=$order->total_paid}		
{/if}


<script type="text/javascript">
var currencyFormat = {$currencyFormat|intval};
var currencySign = '{$currencySign|escape:'javascript':'UTF-8'}';
var currencyBlank = '{$currencyBlank|escape:'javascript':'UTF-8'}';

var id_cart = {$cart->id|intval};

var id_order = {($order)?$order->id:0|intval};
var id_customer = {($customer)?$customer->id:0|intval};
var id_customer_generic = {($genericShopCustomerId)?$genericShopCustomerId:0|intval};

var tokenCart = '{$tokenCart|escape:'htmlall':'UTF-8'}';
var linkCart = 'index.php?controller=AdminCarts&token={$tokenCart|escape:'htmlall':'UTF-8'}';

var tokenOrders = '{$tokenOrders|escape:'htmlall':'UTF-8'}';
var linkOrders = 'index.php?controller=AdminOrders&token={$tokenOrders|escape:'htmlall':'UTF-8'}';

var tokenPdf = '{$tokenPdf|escape:'htmlall':'UTF-8'}';
var linkPdf = 'index.php?controller=AdminPdf&token={$tokenPdf|escape:'htmlall':'UTF-8'}';

var linkNew = 'index.php?controller=AdminDjvPosOrders&token={$token|escape:'htmlall':'UTF-8'}';
var link = linkNew + '&id_cart=' + id_cart;

var products_total = {$products_total|floatval};
var total_t = {$total_t|floatval};
var total_wt = {$total_wt|floatval};
var total = {$total|floatval};
var automaticInsertion = {($automaticInsertion>0)?1:0|intval};

{if $message}	
	;
	(function ($){
		$(function() {
			var addMinimalQuantityDialog = $('<div>')
				.attr('title', '{l s='Mensaje' mod='djvpos' js=1}')
				.append(
					$('<p>')					
						.text('{$message|escape:'htmlall':'UTF-8'}')
						.prepend($('<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 50px 0;">'))
				);
				
			addMinimalQuantityDialog
				.dialog({
					resizable: false,
					height:200,
					modal: true,
					buttons: {					
						"{l s='Aceptar' mod='djvpos' js=1}": function() {
							$(this).dialog('close');
						}
					}
				});
		});	
	})(jQuery);	
{/if}

{if $mustAddMinimalQuantity}
	;
	(function ($){
		$(function() {						
			var addMinimalQuantityDialog = $('<div>')
				.attr('title', '{l s='Cantidad mínima' mod='djvpos' js=1}')
				.append(
					$('<p>')					
						.text('{l s='Este producto tiene una cantidad mínima de' mod='djvpos' js=1} ' + {$mq_minimal_quantity|intval} + ' {l s='unidad(es)' mod='djvpos' js=1}.')
						.prepend($('<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 50px 0;">'))
				);
				
			addMinimalQuantityDialog
				.dialog({
					resizable: false,
					height:200,
					modal: true,
					buttons: {
						"{l s='Añadir' mod='djvpos' js=1}": function() {
						  $(this).dialog('close');						
							var url = link;
							url += '&task=updateProductCartQuantity'; 
							url += '&id_product=' + {$mq_id_product|intval}
							url += '&id_product_attribute=' + {$mq_id_product_attribute|intval}
							url += '&quantity=' + {$mq_minimal_quantity|intval}
							//console.log(url);
							window.location = url;
						},
						"{l s='Cancelar' mod='djvpos' js=1}": function() {
							$(this).dialog('close');
						}
					}
				});
		});	
	})(jQuery);
{/if}

{if $mustRemoveAll}
	;
	(function ($){
		$(function() {						
			var removeAllDialog = $('<div>')
				.attr('title', '{l s='Cantidad mínima' mod='djvpos' js=1}')
				.append(
					$('<p>')					
						.text('{l s='Este producto tiene una cantidad mínima de' mod='djvpos' js=1} ' + {$mq_minimal_quantity|intval} + ' {l s='unidad(es)' mod='djvpos' js=1}. {l s='Debe eliminar todas las unidades' mod='djvpos' js=1}.')
						.prepend($('<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 50px 0;">'))
				);
				
			removeAllDialog
				.dialog({
					resizable: false,
					height:200,
					modal: true,
					buttons: {
						"{l s='Eliminar' mod='djvpos' js=1}": function() {
						  $(this).dialog('close');						
							var url = link;
							url += '&task=updateProductCartQuantity'; 
							url += '&id_product=' + {$mq_id_product|intval}
							url += '&id_product_attribute=' + {$mq_id_product_attribute|intval}
							url += '&quantity=0';
							//console.log(url);
							window.location = url;
						},
						"{l s='Cancelar' mod='djvpos' js=1}": function() {
							$(this).dialog('close');
						}
					}
				});
		});	
	})(jQuery);
{/if}
</script>

<div class="control-body">	
	{include './header.tpl'}
	
	<fieldset>  	
		<div class="clear"></div>	
		{include './order-customer.tpl'}
		{include './order-search-product.tpl'}
		<div class="clear"></div>  

		{include './order-products-table.tpl'}		
		<table class="bottom-container">
			<tr>
				<td valign="top" class="calc-cell">
					{include './order-calc-table.tpl'}
				</td>
				<td valign="top" class="middle-cell">
					{include './order-totals-table.tpl'}
				</td>
				<td valign="top" class="order-cell">
					{include './order-order-table.tpl'}
				</td>
			</tr>
		</table>
	</fieldset>
</div>