{*
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*}

<html>
<head>
<meta charset="utf-8">
<script src="//use.edgefonts.net/inconsolata.js"></script>

<style>
.ticket { font-family: inconsolata, sans-serif; }

@media screen
{
	.ticket .detail { width: 100%; }
	.ticket .detail th, .ticket .detail td { font-size: 0.7em; }
	.ticket th.small, .ticket td.small { font-size: 0.7em}
}

@media print
{
	.ticket { width: 100%;}
	.ticket th, .ticket td { font-size: 12px; font-weight: bold}
	.ticket .detail{ width: 100%; border:0; padding:0}
	.ticket .detail th, .ticket .detail td { font-size: 10px; }
	.ticket th.small, .ticket td.small { font-size: 10px}
}
</style>

{assign var="products_total" value=$cart->getOrderTotal(false, Cart::ONLY_PRODUCTS)}
{assign var="total_wt" value=$cart->getOrderTotal(true, Cart::ONLY_PRODUCTS)}
{assign var="discounts" value=$cart->getOrderTotal(true, Cart::ONLY_DISCOUNTS)}
{assign var="total_t" value=$total_wt - $products_total}
{assign var="total" value=$total_wt - $discounts}
</head>
<body>
<table class="ticket" width="300" border="0">
	<tr>
		<th align="center">
			{$tickets_h|escape:'htmlall':'UTF-8'|replace:"\n":'<br/>'}
		</th>
	</tr>

	<tr>
		<td align="center">
			{$order->date_add|escape:'htmlall':'UTF-8'}
		</td>
	</tr>

	<tr>
		<th align="center">
			{l s='Atendido por' mod='djvpos'}: {$djvorder.dependiente|escape:'htmlall':'UTF-8'}
		</th>
	</tr>

	{if $customer}
		<tr>
			<th align="center">
			<br/>
			{l s='Cliente' mod='djvpos'}: {$customer->firstname|escape:'htmlall':'UTF-8'} {$customer->lastname|escape:'htmlall':'UTF-8'}
			{if ($addresses)}
				<br/>
				{l s='NIF' mod='djvpos'}: {$addresses[0].dni|escape:'htmlall':'UTF-8'}
			{/if}
			</th>
		</tr>
	{/if}

	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<th align="center">
			{l s='Factura simplificada' mod='djvpos'}: CU{$order->invoice_number|escape:'htmlall':'UTF-8'}
		</th>
	</tr>

	<tr>
		<th align="center">
			{l s='Pedido' mod='djvpos'}: {$order->id|intval}
		</th>
	</tr>

	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<td>
			<table class="detail" border="0" cellpadding="0" cellspacing="3">
				<tr>
					<th>{l s='CAN' mod='djvpos'}</th>
					<th>{l s='ARTICULO' mod='djvpos'}</th>
					<th>{l s='P. Un.' mod='djvpos'}</th>
					<th>{l s='IMPORTE' mod='djvpos'}</th>
				</tr>
				<tr>
					<td style="white-space: nowrap;">
						<hr style="width: 100%; border: 1px solid black; color: black"/>
					</td>
					<td>
						<hr style="width: 100%; border: 1px solid black; color: black"/>
					</td>
					<td style="white-space: nowrap;">
						<hr style="width: 100%; border: 1px solid black; color: black"/>
					</td>
					<td style="white-space: nowrap;">
						<hr style="width: 100%; border: 1px solid black; color: black"/>
					</td>
				</tr>
				{foreach $products as $product}
				<tr>
					<td style="text-align: right">
						{$product.cart_quantity|intval}
					</td>
					<td>
						{$product.name|escape:'htmlall':'UTF-8'}
						{if ($product.attributes)}
							<br>
							{$product.attributes|escape:'htmlall':'UTF-8'}
						{/if}
						<br>
						{$product.reference|escape:'htmlall':'UTF-8'}
					</td>

					<td style="text-align: right; white-space: nowrap">
						{convertPrice price=$product.price_wt}
					</td>

					<td style="text-align: right;white-space: nowrap">
						{convertPrice price=$product.total_wt}
					</td>
				</tr>
				{/foreach}
			</table>
		</td>
	</tr>

	<tr>
		<td align="center">&nbsp;</td>
	</tr>

	<tr>
		<td>
			<table style="width: 100%; border:0; padding:0" border="0" cellpadding="0" cellspacing="3">
				<tr>
					<th align="right">
						{l s='Subtotal' mod='djvpos'}:
					</th>
					<td style="text-align: right">
						{convertPrice price=$products_total}
					</td>
				</tr>
				<tr>
					<th align="right">
						{l s='IVA' mod='djvpos'}:
					</th>
					<td style="text-align: right">
						+ {convertPrice price=$total_t}
					</td>
				</tr>
				<tr>
					<th align="right">
						{l s='Total' mod='djvpos'}:
					</th>
					<td style="text-align: right;">
						+ {convertPrice price=$total_wt}
					</td>
				</tr>

				<tr>
					<th align="right">
						{l s='Descuentos' mod='djvpos'}:
					</th>
					<td style="text-align: right">
						- {convertPrice price=$discounts}
					</td>
				</tr>
				<tr>
					<th>
					</th>
					<th>
						<hr style="width: 100%; border: 1px solid black; color: black"/>
					</th>
				<tr>
					<th align="right">
						{l s='Total a pagar' mod='djvpos'}:
					</th>
					<td style="text-align: right; ">
						{convertPrice price=$order->total_paid}
					</td>
				</tr>

				{if ($order->payment == 'Efectivo')}
					<tr>
						<td colspan="2">
							&nbsp;
						</td>
					</tr>

					<tr>
						<th align="right">
							{l s='Entregado en efectivo' mod='djvpos'}:
						</th>
						<td style="text-align: right">
							{convertPrice price=$djvorder.entregado}
						</td>
					</tr>
					<tr>
						<th align="right">
							{l s='Cambio' mod='djvpos'}:
						</th>
						<td style="text-align: right">
							{convertPrice price=$djvorder.cambio}
						</td>
					</tr>
				{else if ($order->payment == 'Tarjeta')}
					<tr>
						<td colspan="2">
							&nbsp;
						</td>
					</tr>
					<tr>
						<th align="right">
							{l s='Pagado mediante tarjeta' mod='djvpos'}:
						</th>
						<td style="text-align: right">
							{convertPrice price=$order->total_paid}
						</td>
					</tr>
				{else}
					<tr>
						<td colspan="2">
							&nbsp;
						</td>
					</tr>
					<tr>
						<th align="right">
							{l s='Pagado mediante cheque' mod='djvpos'}:
						</th>
						<td style="text-align: right">
							{convertPrice price=$order->total_paid}
						</td>
					</tr>
				{/if}
			</table>
		</td>
	</tr>
</table>
<table class="ticket" width="300" border="0">
	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<th align="right" class="small">
			{l s='IVA incluido en el precio' mod='djvpos'}
		</th>
	</tr>

	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<th align="center">
			{l s='Gracias por su visita.' mod='djvpos'}
		</th>
	</tr>

	<tr>
		<th align="center">
			&nbsp;
		</th>
	</tr>

	<tr>
		<th align="center" class="small">
			{$tickets_f|escape:'htmlall':'UTF-8'|replace:"\n":'<br/>'}
		</th>
	</tr>
</table>
</body>
</html>