<?php
class updateTools {

	private static $moduleDir;
	public static function init($moduleDir) {
		self::$moduleDir = $moduleDir;
	}

	private static $handle_log;
	/**
	 * write $message to log file
	 * @param  string $message
	 * @return void          
	 */
	public static function log_message($message) {
		if (!isset(self::$handle_log)) {
			// open log file
			$log_file = self::$moduleDir.DS.'log.txt';
			if (file_exists($log_file)
				&& (filesize($log_file) > 1048576 /* 1 Mo */))
				updateTools::rotate_log($log_file);
			self::$handle_log = @fopen($log_file, 'ab');
		}
		if (self::$handle_log)
			@fwrite(self::$handle_log, date('r')."\t".$message."\n");
	}

	/**
	 * rename log.1.txt to log.2.txt and log.txt to log.1.txt
	 * @param  string  $file main log filename
	 * @param  integer $i    current index
	 * @return void
	 */
	public static function rotate_log($file, $i = 0) {
		$basename = dirname($file).DS.basename($file, '.txt');
		if (file_exists($basename.'.'.($i+1).'.txt'))
			updateTools::rotate_log($file, $i+1);
		rename($basename.($i == 0?'':('.'.$i)).'.txt', $basename.'.'.($i+1).'.txt');
	}

	public static function close_log() {
		if (isset(self::$handle_log)) {
			@fclose(self::$handle_log);
			self::$handle_log = null;
		}
	}

	/**
	 * return $text translated
	 * @param  string $text text to translate
	 * @return string       text translated
	 */
	public static function l($text) {
		global $l;
		return isset($l[$text])?$l[$text]:$text;
	}

	/**
	 * return true if the module $name is activated in apache
	 *
	 * @param string $name module name
	 * @return boolean
	 * @author Samdha <contact@samdha.net>
	 **/
	public static function detect_apache_mod($name) {
		$save = ob_get_clean();
		ob_start();
		phpinfo();
		$phpinfo = ob_get_clean();
		if ($save !== false) {
			ob_start();
			echo $save;
		}
		return (strpos($phpinfo, $name) !== false);
	}

}
?>