<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



if (!class_exists('AzcodeCollection')) {

    class AzcodeCollection extends PrestaShopCollection

    {

        protected $associations = false;



        /**

         * @param string $classname

         * @param int $id_lang

         */

        public function __construct($classname, $id_lang = null, $associations = false)

        {

            parent::__construct($classname, $id_lang);

            $this->associations = $associations;

        }



        /**

         * DMConcept - Copy of PrestaShopCollection::getAll

         * @param boolean $display_query

         * @return \DmCollection

         */

        public function getAll($display_query = false)

        {

            if ($this->is_hydrated) {

                return $this;

            }

            $this->is_hydrated = true;



            $alias = $this->generateAlias();

            $this->query->from($this->definition['table'], $alias);



            // If multilang, create association to lang table

            if (!empty($this->definition['multilang'])) {

                $this->join(self::LANG_ALIAS);

                if ($this->id_lang) {

                    $this->where(self::LANG_ALIAS.'.id_lang', '=', $this->id_lang);

                }

            }



            // Add join clause

            foreach ($this->join_list as $data) {

                $on = '('.implode(') AND (', $data['on']).')';

                switch ($data['type']) {

                    case self::LEFT_JOIN:

                        $this->query->leftJoin($data['table'], $data['alias'], $on);

                        break;

                    case self::INNER_JOIN:

                        $this->query->innerJoin($data['table'], $data['alias'], $on);

                        break;

                    case self::LEFT_OUTER_JOIN:

                        $this->query->leftOuterJoin($data['table'], $data['alias'], $on);

                        break;

                }

            }



            // All limit clause

            if ($this->page_size) {

                $this->query->limit($this->page_size, $this->page_number * $this->page_size);

            }



            // Shall we display query for debug ?

            if ($display_query) {

                echo $this->query.'<br />';

            }



            $this->results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($this->query);

            if ($this->results && is_array($this->results)) {

                $this->results = AzcodeObjectModel::hydrateCollection(

                    $this->classname,

                    $this->results,

                    $this->id_lang,

                    $this->associations

                );

            }



            return $this;

        }

    }

}

