<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



if (!class_exists('AzcodeModule')) {

    class AzcodeModule extends Module

    {

        private $addons_id_contributor = 493596;

        protected $html = '';

        protected $addons_id_product;

        protected $hooks = array();

        protected $admin_tabs = array();



        public function __construct()

        {

            $this->tab = 'others';

            $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);

            $this->author = 'Kevin UNFRICHT - AZCODE';

            $this->bootstrap = true;



            parent::__construct();



            $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module ?');

        }



        public function install()

        {

            require_once($this->local_path.'/sql/install.php');

            return parent::install() && $this->installTabs() && $this->registerHooks();

        }



        public function uninstall()

        {

            require_once($this->local_path.'/sql/uninstall.php');

            return parent::uninstall() && $this->uninstallTabs();

        }



        protected function registerHooks()

        {

            foreach ($this->hooks as $hook) {

                if (!$this->registerHook($hook)) {

                    return false;

                }

            }

            return true;

        }



        protected function installTabs()

        {

            foreach ($this->admin_tabs as $class => $params) {

                if (!$this->installTab(

                    $class,

                    $params['names'],

                    (empty($params['parent_class']) ? '' : $params['parent_class']),

                    (empty($params['active']) ? true : $params['active'])

                )) {

                    return false;

                }

            }

            return true;

        }



        protected function uninstallTabs()

        {

            foreach (array_keys($this->admin_tabs) as $class) {

                if (!$this->uninstallTab($class)) {

                    return false;

                }

            }

            return true;

        }



        protected function installTab($class, array $names, $parent_class = '', $active = true)

        {

            $tab = new Tab();

            $tab->class_name = $class;

            $tab->module = $this->name;

            $tab->name = $names;

            $tab->active = $active;



            $parent_tab = new Tab((int)Tab::getIdFromClassName($parent_class));

            if (Validate::isLoadedObject($parent_tab)) {

                $tab->id_parent = (int)$parent_tab->id;

            }



            return $tab->add();

        }



        protected function uninstallTab($class)

        {

            $tab = new Tab((int)Tab::getIdFromClassName($class));

            if (Validate::isLoadedObject($tab)) {

                return $tab->delete();

            }

            return true;

        }



        /**

        * Save form data.

        */

        protected function postProcess()

        {

            $form_values = $this->getConfigFormValues();

            foreach (array_keys($form_values) as $key) {

                Configuration::updateValue($key, Tools::getValue($key, Configuration::get($key)));

            }

        }



        public function getAddonsIdProduct()

        {

            return (int)$this->addons_id_product;

        }



        public function getConfigureUrl()

        {

            return $this->context->link->getAdminLink('AdminModules', true)

                .'&configure='.$this->name.'&module_name='.$this->name.'&tab_module='.$this->tab;

        }



        public function getDocumentationUrl()

        {

            return $this->_path.'docs/module/index.html';

        }



        public function getFaqUrl()

        {

            return $this->_path.'docs/module/en/FAQ.html';

        }



        public function getReleaseNotesUrl()

        {

            return $this->_path.'docs/module/en/Release_notes.html';

        }



        /**

        * Load the configuration form

        */

        public function getContent()

        {

            $this->postProcess();



            /**

            * If values have been submitted in the form, process.

            */

            $this->context->smarty->assign(array(

                'configuration_form' => $this->renderForm(),

                'currentIndex' => $this->context->link->getAdminLink('AdminModules') . '&configure=' . $this->name,

                'doc_url' => $this->getDocumentationUrl(),

                'faq_url' => $this->getFaqUrl(),

                'release_notes_url' => $this->getReleaseNotesUrl(),

                'lang_iso_code' => $this->context->language->iso_code,

                'addons_id_product' => (int)$this->addons_id_product,

                'addons_id_contributor' => (int)$this->addons_id_contributor,

                'module_dir' => $this->_path,

                'logo' => _MODULE_DIR_.$this->name.'/logo.png',

                'module_name' => $this->displayName,

                'version' => $this->version,

                'author' => $this->author,

                'phpversion' => phpversion()

            ));

            $this->html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configure.tpl');

            return $this->html;

        }



        /**

        * Create the form that will be displayed in the configuration of your module.

        */

        protected function renderForm()

        {

            $helper = new HelperForm();



            $helper->show_toolbar = false;

            $helper->table = $this->table;

            $helper->module = $this;

            $helper->default_form_language = $this->context->language->id;

            $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);



            $helper->identifier = $this->identifier;

            $helper->submit_action = "submit{$this->name}Module";

            $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)

                .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;

            $helper->token = Tools::getAdminTokenLite('AdminModules');



            $helper->tpl_vars = array(

                'fields_value' => $this->getConfigFormValues(),

                'languages' => $this->context->controller->getLanguages(),

                'id_language' => $this->context->language->id

            );



            return $helper->generateForm(array($this->getConfigForm()));

        }



        /**

        * Create the structure of your form.

        */

        protected function getConfigForm()

        {

            return array(

                'form' => array()

            );

        }



        /**

        * Set values for the inputs.

        */

        protected function getConfigFormValues()

        {

            return array(

                /* 'CONFIG_NAME' => Configuration::get('CONFIG_NAME', true) */

            );

        }

    }

}

