<?php

/**

* 2007-2018 KU

*

* DISCLAIMER

*

* Do not edit or add to this file if you wish to upgrade this module to newer

* versions in the future.

*

*  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

*  @copyright 2007-2018 Kevin UNFRICHT

*  @license   Commercial license see license.txt

*  Property of Kevin UNFRICHT - AZCODE

*/



if (!class_exists('AzcodeObjectModel')) {

    class AzcodeObjectModel extends ObjectModel

    {

        /**

        * Construct avec récupération des associations

        * Il faut définir une propriété ${assoc} dans votre association

        * @param int $id

        * @param array | boolean $associations

        *  - FALSE => Ne récupère pas les associations

        *  - TRUE => Récupère toutes les associations

        *  - ARRAY => Récupère les associations demandées si existant

        * @param int $id_lang

        * @param int $id_shop

        */

        public function __construct($id = null, $id_lang = null, $associations = false, $id_shop = null)

        {

            parent::__construct($id, $id_lang, $id_shop);

            $this->fillAssociations($associations, $id_lang, $id_shop);

        }



        /**

        * Hydratation avec récupération des associations

        * @param array $data

        * @param array | boolean $associations

        * @param int $id_lang

        * @see AzcodeObjectModel::__construct() pour plus d'infos sur $associations

        */

        public function hydrate(array $data, $id_lang = null, $associations = false)

        {

            parent::hydrate($data, $id_lang);

            $this->fillAssociations($associations, $id_lang);

        }



        /**

        * Azcode - Copy of ObjectModel::hydrateCollection

        * Fill (hydrate) a list of objects in order to get a collection of these objects

        *

        * @since 1.5.0.1

        * @param string    $class   Class of objects to hydrate

        * @param array     $datas   List of data (multi-dimensional array)

        * @param int|null  $id_lang

        *

        * @return array

        * @throws PrestaShopException

        */

        public static function hydrateCollection($class, array $datas, $id_lang = null, $associations = false)

        {

            if (!class_exists($class)) {

                throw new PrestaShopException("Class '$class' not found");

            }



            $collection = array();

            $rows = array();

            if ($datas) {

                $definition = ObjectModel::getDefinition($class);

                if (!array_key_exists($definition['primary'], $datas[0])) {

                    throw new PrestaShopException(

                        "Identifier '{$definition['primary']}' not found for class '$class'"

                    );

                }



                foreach ($datas as $row) {

                    // Get object common properties

                    $id = $row[$definition['primary']];

                    if (!isset($rows[$id])) {

                        $rows[$id] = $row;

                    }



                    // Get object lang properties

                    if (isset($row['id_lang']) && !$id_lang) {

                        foreach ($definition['fields'] as $field => $data) {

                            if (!empty($data['lang'])) {

                                if (!is_array($rows[$id][$field])) {

                                    $rows[$id][$field] = array();

                                }

                                $rows[$id][$field][$row['id_lang']] = $row[$field];

                            }

                        }

                    }

                }

            }



            // Hydrate objects

            foreach ($rows as $row) {

                /** @var AzcodeObjectModel $obj */

                $obj = new $class;

                $obj->hydrate($row, $id_lang, $associations);

                $collection[] = $obj;

            }



            return $collection;

        }



        /**

        * Remplit les différentes associations par rapport à  ce qui est

        * spécifié dans le paramètre $associations

        * @param array | boolean $associations

        * @param int $id_lang

        * @param int $id_shop

        * @TODO

        *   - Gérer l'asso Shop dans le cas de HAS_MANY

        *   - Gérer le HAS_MANY avec table pivot

        *   - Gérer le cas de la classe Product dans une collection...

        *     à cause du 2nd paramètre $full

        */

        public function fillAssociations($associations, $id_lang = null, $id_shop = null)

        {

            if (!Validate::isLoadedObject($this) || $associations === false

            || ($associations !== true && !is_array($associations))) {

                return;

            }



            // Sous-classe courante hérité de AzcodeObjectModel

            $current_class = get_called_class();

            $definition = ObjectModel::getDefinition($current_class);

            $def_assos = isset($definition['associations']) && is_array($definition['associations'])

            ? $definition['associations']

            : array();

            foreach ($def_assos as $asso => $params) {

                // Pour éviter des problèmes avec le multilang qui est un peu spécifique ici

                if ($asso === PrestaShopCollection::LANG_ALIAS || !$this->assoExist($asso, $associations)) {

                    continue;

                }



                // Classe de l'association

                $associated_class = isset($params['object']) ? $params['object'] : Tools::toCamelCase($asso, true);

                $property = $asso;

                $type = (int)$params['type'];

                $foreign_field = isset($params['foreign_field']) ? $params['foreign_field'] : 'id_'.$asso;

                $current_field = isset($params['field']) ? $params['field'] : 'id_'.$asso;

                if ($definition['primary'] === $current_field) {

                    $current_field = 'id';

                }



                if (!class_exists($associated_class)) {

                    throw new PrestaShopException("Class '$associated_class' not found");

                }

                if (!property_exists($current_class, $property)) {

                    throw new PrestaShopException("Property '$property' needed to fill collection was not found");

                }



                $instance_associated_class = new $associated_class();

                $is_typeclass_AzcodeObjectModel = $instance_associated_class instanceof AzcodeObjectModel;

                $is_product_object = $instance_associated_class instanceof  Product;

                switch ($type) {

                    case self::HAS_MANY:

                        if (!property_exists($current_class, $current_field)) {

                            throw new PrestaShopException(

                                "Property '$current_field' not found for class '$current_class'"

                            );

                        }

                        if (!property_exists($associated_class, $foreign_field)) {

                            throw new PrestaShopException(

                                "Foreign field '$foreign_field' not found for class '$associated_class'"

                            );

                        }



                        // Order by

                        $order_by = (isset($params['order_by']) && isset($params['order_by']['field']))

                            ? $params['order_by']['field'] : false;

                        $order_direction = (isset($params['order_by']) && isset($params['order_by']['direction']))

                            ? $params['order_by']['direction'] : 'asc';

                        // Where

                        $where = (isset($params['where']) && is_array($params['where'])) ? $params['where'] : array();



                        $ps_collection = $is_typeclass_AzcodeObjectModel

                        ? new AzcodeCollection(

                            $associated_class,

                            $id_lang,

                            $this->getRecursiveAsso($asso, $associations)

                        )

                        : new PrestashopCollection($associated_class, $id_lang);

                        $ps_collection->where($foreign_field, '=', $this->{$current_field});

                        foreach ($where as $where_params) {

                            $ps_collection->where(

                                $where_params['field'],

                                $where_params['operator'],

                                $where_params['value']

                            );

                        }

                        if ($order_by) {

                            $ps_collection->orderBy($order_by, $order_direction);

                        }

                        $this->{$property} = $ps_collection->getResults();

                        break;

                    case self::HAS_ONE:

                        if (!property_exists($current_class, $foreign_field)) {

                            throw new PrestaShopException(

                                "Foreign field '$foreign_field' not found for class '$current_class'"

                            );

                        }

                        $belongs_to = isset($params['belongs_to']) ? (boolean)$params['belongs_to'] : false;

                        // Dans le cas de product $full est un second paramètre ... et non la langue

                        if (!$is_typeclass_AzcodeObjectModel && $is_product_object) {

                            $this->{$property} = new $associated_class(

                                $this->{$foreign_field},

                                $id_lang,

                                true,

                                $id_shop

                            );

                        } else {

                            /**

                            * Dans le cas ou la clé 'belongs_to' est définie,

                            * reprend l'association sans charger les autres associations

                            * Permet d'éviter des boucles infinies dans le cas d'un $associations = true;

                            */

                            $recur_asso = $this->getRecursiveAsso($asso, $associations);

                            $this->{$property} = $is_typeclass_AzcodeObjectModel

                            ? new $associated_class(

                                $this->{$foreign_field},

                                $id_lang,

                                ($recur_asso === true && $belongs_to)

                                ? false : $recur_asso, $id_shop

                            )

                            : new $associated_class($this->{$foreign_field}, $id_lang, $id_shop);

                        }

                        break;

                }

            }

        }



        /**

        * Retourne $associations d'une

        * association recursive+1

        * @param string $search_asso

        * @param array | boolean $associations

        * @return array | boolean

        */

        protected function getRecursiveAsso($search_asso, $associations)

        {

            if (!$this->assoExist($search_asso, $associations)) {

                return false;

            }

            /**

            * L'association recursive doit reprendre toutes ses associations

            */

            if ($associations === true) {

                return true;

            }

            /**

            * Si nous avons aucune recursion Nous n'allons pas reprendre plus loin dans la recursion

            * Ex. $associations = array('asso1');

            */

            if (in_array($search_asso, $associations)) {

                return false;

            }

            /**

            * Dans le dernier cas nous avons une récursion précise définie

            * Ex. $associations = array('asso1' => array('asso1','asso2');

            * On retourne alors array('asso1','asso2')

            */

            return $associations[$search_asso];

        }



        /**

        * Retourne si l'association est définie

        * dans le tableau des associations demandées

        * @param string $search_asso

        * @param array | boolean $associations

        * @return boolean

        */

        protected function assoExist($search_asso, $associations)

        {

            return $associations === true

            || (is_array($associations) && in_array($search_asso, $associations, true))

            || (is_array($associations) && in_array($search_asso, array_keys($associations), true));

        }

    }

}

