<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



if (!class_exists('AzcodeProduct')) {

    class AzcodeProduct extends Product

    {

        /**

         * MÃ©thode static permettant de retourner le produit comme une ligne produit.

         * Permet la compatibilitÃ© pour listing produit par exemple...

         * @param Product $product

         * @return array $product datas or false

         */

        public static function getProductAsRow(Product $product, $id_product_attribute = null)

        {

            if (!Validate::isLoadedObject($product)) {

                return false;

            }

            $product_row = array_merge(

                (array)$product,

                (is_array(($cover = self::getCover((int)$product->id))) ? $cover : array())

            );

            $product_row['id_product'] = (int)$product->id;

            $product_row['id_product_attribute'] = $id_product_attribute;

            return Product::getProductProperties((int)Context::getContext()->language->id, $product_row);

        }



        /**

         * RÃ©cupÃ¨re l'id produit Ã  partir de id_product_attribute

         * @param int $id_product_attribute

         * @return id_product

         */

        public static function getProductByIdProductAttribute($id_product_attribute)

        {

            $query = new DbQuery();

            $query->select('id_product')

                ->from('product_attribute')

                ->where('id_product_attribute = '.(int)$id_product_attribute);

            return Db::getInstance()->getValue($query->build());

        }





        /**

         * Récupère les combinaisons d'un produit par son ID

         * @param int $id_product

         * @param int $id_product_attribute Filtre sur un id_product_attribute

         * @return array

         */

        public static function getProductCombinationsByIdProduct($id_product, $id_product_attribute = null)

        {

            $combinations_list = array();



            $query = new DbQuery();

            $query->select('pac.`id_product_attribute`, pac.`id_attribute`');

            $query->from('product_attribute', 'pa');

            $query->join(Shop::addSqlAssociation('product_attribute', 'pa'));

            $query->leftJoin(

                'product_attribute_combination',

                'pac',

                'pac.`id_product_attribute` = pa.`id_product_attribute`'

            );

            $query->where('pa.`id_product` = '.(int)$id_product);



            if (!empty($id_product_attribute)) {

                $query->where('pac.`id_product_attribute` = '.(int)$id_product_attribute);

            }



            $results = Db::getInstance()->executeS($query->build());

            foreach ($results as $combination) {

                if (empty($id_product_attribute)) {

                    $combinations_list[(int)$combination['id_product_attribute']][] = (int)$combination['id_attribute'];

                } else {

                    $combinations_list[] = (int)$combination['id_attribute'];

                }

            }



            return $combinations_list;

        }





        /**

         * Retourne l'id attribut d'un produit par rapport à une liste d'attributs données

         * @param int $id_product

         * @param array $attribute_list

         * @return int $id_product_attribute

         */

        public static function getIdProductAttribute($id_product, array $attribute_list)

        {

            $ids_product_attributes = self::getProductCombinationsByIdProduct((int)$id_product);

            foreach ($ids_product_attributes as $id_product_attribute => $attribute_combination_list) {

                if (!count(array_diff($attribute_combination_list, $attribute_list))) {

                    return (int)$id_product_attribute;

                }

            }

            return 0;

        }

    }

}

