<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



require_once(dirname(__FILE__).'/autoload.php');



class Gtrmanager extends AzcodeModule

{



    public function __construct()

    {

        $this->need_instance = 0;

        $this->name = 'gtrmanager';

        $this->tab = 'shipping_logistics';

        $this->version = '1.2.2';

        $this->module_key = 'c5db441a99a726d7b21fb6908d444a2e';

        $this->addons_id_product = 22248;

        $this->hooks = array('actionObjectCarrierAddAfter');

        //$limited_coutries = array('fr', 'en');

        //$this->dependencies = array();

        //$this->controllers = array();



        $lang_ids = Language::getLanguages(true, false, true);

        $names = array();

        foreach ($lang_ids as $id_lang) {

            $names[$id_lang] = $this->l('Import/Export rates');

        }

        $this->admin_tabs = array('AdminGTRM' => array(

            'names' => $names,

            'parent_class' => 'AdminParentShipping'

        ));



        parent::__construct();



        $this->displayName = $this->l('Rates Carrier Manager');

        $this->description = $this->l('This module allows you to easily manage the export/import your rates carrier.');

    }



    /**

     * Load the configuration form

     */

    public function getContent()

    {

        $this->context->smarty->assign(array(

            'link_controller' => $this->context->link->getAdminLink('AdminGTRM')

        ));

        return parent::getContent();

    }



    /**

     * Create the structure of your form.

     */

    protected function getConfigForm()

    {

        return parent::getConfigForm();

    }



    /**

     * Set values for the inputs.

     */

    protected function getConfigFormValues()

    {

        return parent::getConfigFormValues();

    }



    public function hookActionObjectCarrierAddAfter($params)

    {

        // Pour chaque création de Carrier on met à jour la date d'import au jour même

        $carrier = $params['object'];

        if (Validate::isLoadedObject($carrier)) {

            $carrierGTRM = new CarrierGTRM((int)$carrier->id);

            $carrierGTRM->date_import = Date('Y-m-d H:i:s');

            $carrierGTRM->save();

        }

    }

}

