{*

* 2007-2018 KU

*

* NOTICE OF LICENSE

*

* This source file is subject to the Academic Free License (AFL 3.0)

* that is bundled with this package in the file LICENSE.txt.

* It is also available through the world-wide-web at this URL:

* http://opensource.org/licenses/afl-3.0.php

* If you did not receive a copy of the license and are unable to

* obtain it through the world-wide-web, please send an email

* to license@prestashop.com so we can send you a copy immediately.

*

* DISCLAIMER

*

* Do not edit or add to this file if you wish to upgrade PrestaShop to newer

* versions in the future. If you wish to customize PrestaShop for your

* needs please refer to http://www.prestashop.com for more information.

*

*  @author    Kevin UNFRICHT <contact@kevin-unfricht.fr>

*  @copyright 2007-2018 Kevin UNFRICHT

*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

*  International Registered Trademark & Property of PrestaShop SA

*}



{extends file="helpers/form/form.tpl"}



{block name="field"}

    {if $input.type eq 'data_import'}

        {* future previsu... *}

        {$smarty.block.parent}

    {elseif $input.name eq 'id_carrier_export'}

        <div class='col-lg-2'>{$smarty.block.parent}</div>



        <label class="control-label col-lg-1">{l s='Version from' mod='gtrmanager'}</label>

        <div class='col-lg-3'>



            {foreach $carriers_backup as $id_reference => $carrier_backups}

                <select class="id_carrier_backup_export" style="display:none;" data-carrier="{$id_reference|escape:'html':'UTF-8'}" name="id_carrier_backup_export">

                    <option value="">{l s='Current' mod='gtrmanager'}</option>

                    {foreach $carrier_backups as $backup}

                        <option value="{$backup.id_carrier|escape:'html':'UTF-8'}">{$backup.date_import|date_format:$date_format|escape:'html':'UTF-8'}</option>

                    {/foreach}

                </select>

            {/foreach}



        </div>

    {elseif $input.name eq 'id_carrier_backup'}

        <div class='col-lg-2'>{$smarty.block.parent}</div>



        <label class="control-label col-lg-1">{l s='Version from' mod='gtrmanager'}</label>

        <div class='col-lg-3'>



            {foreach $carriers_backup as $id_reference => $carrier_backups}

                <select class="id_carrier_to_backup" style="display:none;" data-carrier="{$id_reference|escape:'html':'UTF-8'}" name="id_carrier_to_backup[{$id_reference|escape:'html':'UTF-8'}]">

                    {if empty($carrier_backups)}

                        <option value="">{l s='Noone backup' mod='gtrmanager'}</option>

                    {else}

                        <option value="">{l s='Choose a version' mod='gtrmanager'}</option>

                        {foreach $carrier_backups as $backup}

                            <option value="{$backup.id_carrier|escape:'html':'UTF-8'}">{$backup.date_import|date_format:$date_format|escape:'html':'UTF-8'}</option>

                        {/foreach}

                    {/if}

                </select>

            {/foreach}



        </div>

    {else}

        {$smarty.block.parent}

    {/if}



{/block}



{block name="after"}

    <script type="text/javascript">

        {literal}



            var BackupWatcher = {

                bind: function(el, watched_element) {

                    var self = this;

                    el.on('change', function() {

                        self.check($(this), watched_element);

                    });

                },

                watch: function(el, watched_element) {

                    this.bind(el, watched_element);

                    this.check(el, watched_element);

                },

                check: function(el, watched_element) {

                    var id_reference = parseInt(el.val());



                    watched_element.hide();

                    watched_element.each(function() {

                        $(this).val("");

                        if (parseInt($(this).data('carrier')) === id_reference) {

                            $(this).show();

                        }

                    });

                }



            };



            $(document).on('ready', function() {



                var carrierExportWatcher = Object.create(BackupWatcher);

                carrierExportWatcher.watch($('#id_carrier_export'), $('select.id_carrier_backup_export'));



                var carrierBackupWatcher = Object.create(BackupWatcher);

                carrierBackupWatcher.watch($('#id_carrier_backup'), $('select.id_carrier_to_backup'));



            });



        {/literal}

    </script>

{/block}