<?php

include_once(dirname(__FILE__).'/../../../config/config.inc.php');

/*
*  2013 Neovis : Michael Jegou & Vasseur Alexandre
*
*  @author VASSEUR ALEXANDRE <tech@neovis.fr>
*  @author MJ <tech@neovis.fr>
*  @copyright  2013 Neovis
*  @license    not free
*  International Registered Trademark & Property of Neovis
*
* Classe appelée selon la version de prestashop
* Elle permet d'accéder à différent type de base de données
* Version de base
*/

class TVAUpdaterBase
{

	const MSG_ERROR = 'ERREUR';
	const MSG_WARNING = 'WARNING';
	const MSG_INFO = 'INFO';
	const MSG_OK = 'OK';

	public static $write_last_log_file = true;
	public static $last_log_file = null;
	public static $last_log_file_name = 'log-lastprocess.txt';

	public static $process_errors_found = array();

	/**
	* this function return admin token for all versions!
	*/
	public static function getAdminTokenLite($admin_page)
	{
		return Tools::getAdminTokenLite($admin_page);
	}

	/**
	* Update needed tables
	*/
	public static function updateDB()
	{
		return true;
	}

	/**
	* Insert Data in DB
	*/
	public static function insertQuery($table, $values)
	{
		return Db::getInstance()->insert($table, $values);
	}

	/**
	* Last inserted ID
	*/
	public static function insertedID()
	{
		return Db::getInstance()->Insert_ID();
	}

	/**
	* Update Data in DB
	*/
	public static function updateQuery($table, $values, $where)
	{
		return Db::getInstance()->update($table, $values, $where);
	}

	/**
	* Get all available taxes
	*
	* @return array Taxes
	*/
	public static function getTaxes($id_lang = false, $active_only = true, $not_deleted_only = true)
	{
		$sql = new DbQuery();
		$sql->select('t.id_tax, t.rate, t.active, t.deleted');
		$sql->from('tax', 't');
		$sql->orderBy('t.deleted ASC, t.active DESC');

		if ($not_deleted_only)
			$sql->where('t.`deleted` != 1');

		if ($id_lang)
		{
			$sql->select('tl.name, tl.id_lang');
			$sql->leftJoin('tax_lang', 'tl', 't.`id_tax` = tl.`id_tax` AND tl.`id_lang` = '.(int)$id_lang);
			$sql->orderBy('t.deleted ASC, t.active DESC, t.`id_tax` ASC');
		}

		if ($active_only)
			$sql->where('t.`active` = 1');

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de produit en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbProductsByTax($tax_id = null)
	{
	//	la requete
		$products = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT p.id_product) as count
			FROM '._DB_PREFIX_.'product p
			WHERE p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

	//	print'<pre>';print_r($products);print'</pre>';
		return $products;
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de produits en base
 ********************************************************************************************/
	public static function getNbProducts()
	{
	//	la requete
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(*) as count
			FROM '._DB_PREFIX_.'product');
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des produits en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getProductsByTaxId($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM '._DB_PREFIX_.'product
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

	}

/********************************************************************************************
 *	Fonction qui met à jour tous les tarifs HT des produits en fonction d'un id tax passé et d'une différence
 ********************************************************************************************/
	public static function updateProductsPriceByTaxId($tax_id = null, $price_difference = 1)
	{
		$res = Db::getInstance()->execute('
			UPDATE '._DB_PREFIX_.'product
			SET price=price*'.$price_difference.'
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

		self::saveRequestForRollback('
			UPDATE '._DB_PREFIX_.'product
			SET price=price/'.$price_difference.'
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');
		return $res;
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des produits des shops en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getProductsShopByTaxId($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM '._DB_PREFIX_.'product_shop
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

	}

/********************************************************************************************
 *	Fonction qui met à jour tous les tarifs HT des produits des shops en fonction d'un id tax passé et d'une différence
 ********************************************************************************************/
	public static function updateProductsShopPriceByTaxId($tax_id = null, $price_difference = 1)
	{
		$res = Db::getInstance()->execute('
			UPDATE '._DB_PREFIX_.'product_shop
			SET price=price*'.$price_difference.'
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');

		self::saveRequestForRollback('
			UPDATE '._DB_PREFIX_.'product_shop
			SET price=price/'.($price_difference).'
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');
		return $res;
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des déclinaisons à partir d'un id tax passé
 *	Ne récupère pas les déclinaison avec un tarif à zéro qui ne doit pas changer!
 ********************************************************************************************/
	public static function getProductsAttributesByTaxId($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT pa.*
			FROM '._DB_PREFIX_.'product_attribute pa
			INNER JOIN '._DB_PREFIX_.'product p
			ON pa.id_product = p.id_product
			WHERE p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND pa.price<>0');

	}

/********************************************************************************************
 *	Fonction qui met à jour tous les tarifs HT des déclinaisons produits d'un id tax passé et d'une différence
 ********************************************************************************************/
	public static function updateProductsAttributesPriceByTaxId($tax_id = null, $price_difference = 1)
	{
		$res = Db::getInstance()->execute('
			UPDATE '._DB_PREFIX_.'product_attribute pa,
			'._DB_PREFIX_.'product p
			SET pa.price=pa.price*'.$price_difference.'
			WHERE pa.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND pa.price<>0');
		self::saveRequestForRollback('
			UPDATE '._DB_PREFIX_.'product_attribute pa,
			'._DB_PREFIX_.'product p
			SET pa.price=pa.price/'.$price_difference.'
			WHERE pa.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND pa.price<>0');
		return $res;
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des déclinaisons des shops à partir d'un id tax passé
 *	Ne récupère pas les déclinaison avec un tarif à zéro qui ne doit pas changer!
 ********************************************************************************************/
	public static function getProductsAttributesShopByTaxId($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT pas.*
			FROM '._DB_PREFIX_.'product_attribute_shop pas
			INNER JOIN '._DB_PREFIX_.'product_attribute pa
			ON pas.id_product_attribute = pa.id_product_attribute
			INNER JOIN '._DB_PREFIX_.'product p
			ON pa.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			WHERE pas.price<>0');

	}

/********************************************************************************************
 *	Fonction qui met à jour tous les tarifs HT des déclinaisons des shops d'un id tax passé et d'une différence
 ********************************************************************************************/
	public static function updateProductsAttributesShopPriceByTaxId($tax_id = null, $price_difference = 1)
	{
		$res = Db::getInstance()->execute('
			UPDATE '._DB_PREFIX_.'product_attribute_shop pas,
			'._DB_PREFIX_.'product_attribute pa,
			'._DB_PREFIX_.'product p
			SET pas.price=pas.price*'.$price_difference.'
			WHERE pas.id_product_attribute = pa.id_product_attribute
			AND pa.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND pas.price<>0');

		self::saveRequestForRollback('
			UPDATE '._DB_PREFIX_.'product_attribute_shop pas,
			'._DB_PREFIX_.'product_attribute pa,
			'._DB_PREFIX_.'product p
			SET pas.price=pas.price/'.$price_difference.'
			WHERE pas.id_product_attribute = pa.id_product_attribute
			AND pa.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND pas.price<>0');
		return $res;
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des prix spécifiques à partir d'un id tax passé
 *	Ne récupère pas les déclinaison avec un tarif à zéro qui ne doit pas changer!
 ********************************************************************************************/
	public static function getProductSpecificsByTaxId($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT sp.*
			FROM '._DB_PREFIX_.'specific_price sp
			INNER JOIN '._DB_PREFIX_.'product p
			ON sp.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			WHERE sp.price>0');

	}

/********************************************************************************************
 *	Fonction qui met à jour tous les tarifs HT des prix spécifiques d'un id tax passé et d'une différence
 *	avec enregistrement du rollback!
 ********************************************************************************************/
	public static function updateProductSpecificsPriceByTaxId($tax_id = null, $price_difference = 1)
	{
		$res = Db::getInstance()->execute('
			UPDATE '._DB_PREFIX_.'specific_price sp,
			'._DB_PREFIX_.'product p
			SET sp.price=sp.price*'.$price_difference.'
			WHERE sp.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND sp.price>0');

		self::saveRequestForRollback('
			UPDATE '._DB_PREFIX_.'specific_price sp,
			'._DB_PREFIX_.'product p
			SET sp.price=sp.price/'.$price_difference.'
			WHERE sp.id_product = p.id_product
			AND p.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')
			AND sp.price>0');
		return $res;
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de transporteurs en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbCarriersByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT id_carrier) as count
			FROM '._DB_PREFIX_.'carrier_tax_rules_group_shop
			WHERE id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des transporteurs en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getCArriersByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM '._DB_PREFIX_.'carrier c
			LEFT JOIN '._DB_PREFIX_.'carrier_tax_rules_group_shop ctrgs
			ON c.id_carrier = ctrgs.id_carrier
			WHERE ctrgs.id_tax_rules_group IN (
				SELECT DISTINCT id_tax_rules_group FROM '._DB_PREFIX_.'tax_rule
				WHERE id_tax='.(int)$tax_id.')');
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de règles de taxe en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbTaxesRulesByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT id_tax_rules_group) as count
			FROM '._DB_PREFIX_.'tax_rule
			WHERE id_tax = '.(int)$tax_id);
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des règles de taxe en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getTaxesRulesByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT *
			FROM '._DB_PREFIX_.'tax_rule tr
			LEFT JOIN '._DB_PREFIX_.'tax_rules_group trg
			ON tr.id_tax_rules_group = trg.id_tax_rules_group
			WHERE id_tax = '.(int)$tax_id);
	}

/********************************************************************************************
 *	Fonction qui récupere la liste des groupes de taxe en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getTaxesRulesGroupByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT DISTINCT trg.*
			FROM '._DB_PREFIX_.'tax_rule tr
			LEFT JOIN '._DB_PREFIX_.'tax_rules_group trg
			ON tr.id_tax_rules_group = trg.id_tax_rules_group
			WHERE id_tax = '.(int)$tax_id);
	}

/********************************************************************************************
 *	Fonction qui récupere le nombre de règles de taxe en fonction d'un id tax passé
 ********************************************************************************************/
	public static function getNbOrdersByTax($tax_id = null)
	{
		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT od.id_order) as count
			FROM '._DB_PREFIX_.'order_detail_tax odt
			INNER JOIN '._DB_PREFIX_.'order_detail od
			ON od.id_order_detail = odt.id_order_detail
			WHERE odt.id_tax = '.(int)$tax_id);
	}

/********************************************************************************************
 *	Fonction qui permet de savoir si une seule taxe est utilisée dans le groupe de règle de taxe
 ********************************************************************************************/
	public static function isUniqueTaxByTaxeRule($tax_rule_id = null)
	{
	//	la requete
		$taxes_rules = Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('
			SELECT count(DISTINCT id_tax)
			FROM '._DB_PREFIX_.'tax_rule
			WHERE id_tax_rules_group = '.(int)$tax_rule_id);

		return ($taxes_rules == 1);
	}

	/**
	* Return the tax id associated to a specific rate and eventually name
	*
	* @param string $tax_rate
	* @param string $tax_name
	* @param boolean $active (true by default)
	*/
	public static function getTaxIdByRate($tax_rate, $tax_name = null, $active = 1, $notdeleted = 1)
	{
		$tax = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
			SELECT t.`id_tax`
			FROM `'._DB_PREFIX_.'tax` t
			LEFT JOIN `'._DB_PREFIX_.'tax_lang` tl ON (tl.id_tax = t.id_tax)
			WHERE t.`rate` = \''.pSQL($tax_rate).'\' '.
			($tax_name != null ? ' AND tl.`name` = \''.pSQL($tax_name).'\' ' : '').
			($active == 1 ? ' AND t.`active` = 1' : '').
			($notdeleted == 1 ? ' AND t.`deleted` != 1' : '').
			' ORDER BY t.`deleted` ASC, t.`active` DESC ' // D'abord les taux pas effacés et actifs en premier

			);
		return $tax ? (int)$tax['id_tax'] : false;
	}

	/*
	 * Renvoi vrai s'il y a un rollback possible, faux sinon
	 */
	public static function rollbackExists()
	{
		$neo_taxes_updater = new NeoTaxesUpdater();
		// @TODO: utiliser une variable à la place du nom de fichier
		return file_exists(_PS_MODULE_DIR_.$neo_taxes_updater->name.DIRECTORY_SEPARATOR.'/backup/tva-backupdb.sql');
	}

/********************************************************************************************
 *	Enregistre la requêtre brute pour le rollback
 ********************************************************************************************/
	public static function saveRequestForRollback($request)
	{
	//	on verifie où se trouve le fichier pour sauvegarder et on le créé eventuellement
		$file = fopen(self::getRollbackFilename(), 'a+');

		fwrite($file, str_replace("\n", '', $request).";\n");

	//	on ferme le fichier
		fclose($file);
	}

/********************************************************************************************
 *	Enregistre les requêtes qui permettent de revenir en arrière sur les modifs faites
 *	table : nom de la table concernée
 *	requestWhere : condition de la requete
 *	requestName : type d'opération DELETE / UPDATE / INSERT
 *	requestValues : champs traités par l'opération en tableau associatifs nom => valeur
 *	@TODO: voir comment l'enregistrer
 ********************************************************************************************/
	public static function saveForRollback($table, $request_name, $request_where, $request_args = null)
	{
	//	on verifie où se trouve le fichier pour sauvegarder et on le créé eventuellement
		$file = fopen(self::getRollbackFilename(), 'a+');

	//	à mettre dans le tout début du lancement du cron.
	//	fwrite($file, "#fichier backup neotaxes updater\n");

	//	variable à mettre dans le fichier
		$file_content = '';

		switch ($request_name)
		{
			case 'DELETE':

				fwrite($file, 'DELETE FROM '._DB_PREFIX_.$table.' where '.$request_where.';'."\n");
				break;

			case 'UPDATE':
			//	tableau des arguments "propre"
				$sql_args = array();
				if (is_array($request_args))
				{
					foreach ($request_args as $key => $value)
					{ // @TODO: do it better :)
						if (is_string($value))
							$sql_args[] = $key.' = "'.pSQL($value).'"';
						else
							$sql_args[] = $key.' = '.pSQL($value);
					}
					$sql_args = implode(', ', $sql_args);
				}
				else
					$sql_args = $request_args; // Allow to do columname = columname * percent

			//	enregistrement de la requette
				fwrite($file, 'UPDATE '._DB_PREFIX_.$table.' set '.$sql_args.' WHERE '.$request_where.';'."\n");
				break;

			default:
				break;
		}

	//	on ferme le fichier
		fclose($file);

	}

/********************************************************************************************
 *	Enregistre les requêtes qui permettent de revenir en arrière sur les modifs faites
 *	table : nom de la table concernée
 *	requestWhere : condition de la requete
 *	requestName : type d'opération DELETE / UPDATE / INSERT
 *	requestValues : champs traités par l'opération en tableau associatifs nom => valeur
 *	@TODO: voir comment l'enregistrer
 ********************************************************************************************/
	public static function doRollback()
	{
	//	on verifie où se trouve le fichier pour sauvegarder et on le créé eventuellement
		$file = new ReverseFile(self::getRollbackFilename());

		$multiple_requests = '';
		$counted_request = 0;
		$res = true;

		while (!$file->sof())
		{ // @TODO: verify infos!
			$sqlline = trim(rtrim( $file->getLine(), ';' ));
			if ($sqlline != '')
				$res &= Db::getInstance()->Execute( $sqlline );
		}

		if ($res)
			rename(self::getRollbackFilename(), self::getRollbackFilename().'.restored'.date('Ymd-His'));
		else
			return false;
		return true;

	}

/********************************************************************************************
 *	Teste si le dossier de rollback est inscriptible
 ********************************************************************************************/
	public static function autoCheckRollbackWritable()
	{
		$test_file = self::getRollbackFilename(true);
		file_put_contents($test_file, 'test');
		if (!file_exists($test_file))
			return false;
		else
			unlink($test_file);
		return true;
	}

/********************************************************************************************
 *	Renvoi le nom du fichier de rollback
 ********************************************************************************************/
	public static function getRollbackFilename($test_mode = false)
	{
		$neo_taxes_updater = new NeoTaxesUpdater();
		return _PS_MODULE_DIR_.$neo_taxes_updater->name.DIRECTORY_SEPARATOR.'backup/tva-backupdb'.(($test_mode)?'-test':'').'.sql';
	}
/********************************************************************************************
 *	Enregistre/affiche les opérations effectuées en français
 ********************************************************************************************/
	public static function logMessage($nature, $message)
	{
		if ($nature == self::MSG_ERROR)
			self::$process_errors_found[] = $message;
		self::writeLog($nature, $message);
	}

/********************************************************************************************
 *	Fonction d'enregistrement des logs
 ********************************************************************************************/

	public static function autoCheckLogWritable()
	{// @TODO: à appeler à l'install du module
		$test_log_file = self::getTestLogFile();
		file_put_contents($test_log_file, 'test');
		if (!file_exists($test_log_file))
			return false;
		else
			unlink($test_log_file);
		return true;
	}

	public static function logFileExists()
	{
		return file_exists(self::getModPath().'log/'.self::$last_log_file_name);
	}

	public static function getModPath($with_trailing_slash = true)
	{
		return dirname(dirname(__FILE__)).($with_trailing_slash ? '/' : '');
	}

	public static function getLogFile($test_mode = false)
	{
		return self::getModPath().'log/log'.($test_mode?'test':'').'-'.date('Y-m-d').'.log';
	}

	public static function getTestLogFile()
	{
		return self::getLogFile(true);
	}

	public static function writeLog($title, $value)
	{
		try
		{
			if ($f = fopen(self::getModPath().'log/log-'.date('Y-m-d').'.txt', 'a'))
				fwrite($f, "\n".date('H:i:s').' '.$title.' : '.$value);

			fclose($f);

			if (self::$write_last_log_file)
			{ // on doit enregistrer un log à part correspondant juste à ce traitement, il sera écrasé à chaque lancement de la cron
				if (self::$last_log_file == null) // on ouvre le log en ecriture depuis le debut
					self::$last_log_file = fopen(self::getModPath().'log/'.self::$last_log_file_name, 'w');

			}

			fwrite(self::$last_log_file, "\n".date('Y-m-d H:i:s').' '.$title.' : '.$value);

		} catch (Exception $e)
		{
			return false;
		}
	}
/********************************************************************************************
 *	fonction pour update Value de configuration sans id shop ni id shop group
 ********************************************************************************************/
	public static function updateConfigurationValue($name, $value = '')
	{
		Configuration::updateValue($name, $value, false, '', '');
	}

}

/* @TODO: do it better!!! */
class ReverseFile
{
	var $file_name;
	var $file_handle;
	var $file_pos;

	public function __construct($file_name)
	{
		$this->file_name = $file_name;
		$this->file_handle = fopen($file_name, 'r');
		if (!$this->file_handle)
			die ('Could not open file '.$this->file_name."\n");

		// Let's search for the EOF
		if (!(fseek($this->file_handle, 0, SEEK_END) == 0))
			die ('Could not find end of file in '.$this->file_name."\n");

		// Store the file position
		$this->file_pos = ftell($this->file_handle);

		// Check that file is not empty or doesn't contain a single newline
		// We could also use PHP's is_resource() and filesize() to check this.
		if ($this->file_pos < 2)
			die ('File is empty'."\n");

		// Position file pointer just before final newline
		// i.e. Skip EOF
		$this->file_pos -= 1;
	}

	public function getLine()
	{
		$pos = $this->file_pos - 1;
		$ch = '';
		$line = '';
		while ($ch != "\n" && $pos >= 0)
		{
			fseek($this->file_handle, $pos);
			$ch = fgetc($this->file_handle);
			// Decrement out pointer and prepend to the line
			// if we have not hit the new line
			if ($ch != "\n")
			{
				$pos = $pos - 1;
				$line = $ch.$line;
			}
		}
		$this->file_pos = $pos;
		return $line;
	}

	public function sof()
	{
		return ($this->file_pos <= 0 );
	}

}
