<?php
// $Id: cur_conf.php 5 2008-12-12 05:55:19Z adgar $

require_once('admincfg.php');
require_once('htmlelements.inc.php');    

$popular_cur = array('USD', 'EUR', 'GBP', 'JPY');

function enable_symbol_prefix($var) {
	return ($var > 0);
}

if (isset($_REQUEST['action'])) {
    //update popular currency
    if ('update_popular' == $_REQUEST['action']) {
        if (!isset($_POST['check']) || !is_array($_POST['check'])) {
            $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=0 WHERE cur_alpha3 in (?@)", $popular_cur);
            $db->query($sql);
        } else {
        	//reset fields
            $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=0, symbol_prefix=0, cur_symbol='' WHERE cur_alpha3 in (?@)", $popular_cur);
            $db->query($sql);
            //update fields
            $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=1 WHERE cur_id in (?@) AND cur_alpha3 in (?@)", $_POST['check'], $popular_cur);
            $db->query($sql);       
    	}
    }
    //update national currency
    elseif ('update_national' == $_REQUEST['action']) {
        if (!isset($_POST['check']) || !is_array($_POST['check'])) {
            $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=0 WHERE cur_alpha3 not in (?@)", $popular_cur);
            $db->query($sql);
        } else {
            //reset fields
        	$sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=0, symbol_prefix=0, cur_symbol='' WHERE cur_alpha3 not in (?@)", $popular_cur);
            $db->query($sql);
            //update fields           
            $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET enabled=1 WHERE cur_id in (?@) AND cur_alpha3 not in (?@)", $_POST['check'], $popular_cur);
            $db->query($sql);     
    	}    
    }
    //update currency symbols     
    if (('update_popular' == $_REQUEST['action']) || ('update_national' == $_REQUEST['action'])) {
        $symbol_prefix = array_filter($_POST['symbol_prefix'], "enable_symbol_prefix");      
        if (is_array($symbol_prefix) && (0 < count($symbol_prefix))) {
	        $sql = sql_placeholder("UPDATE $param[dbprefix]currency SET symbol_prefix=1 WHERE cur_id in (?@)", array_keys($symbol_prefix));
	        $db->query($sql);   
        }
        foreach ($_POST['cur_symbol'] as $k => $v)
            $db->query("UPDATE $param[dbprefix]currency SET cur_symbol=? WHERE cur_id=?", array($v, $k));        
    }  
    updateAllConvertFactors();
    AFFPRO::redirect($base . "/$param[selfname]");    
}

starting(getTranslateText('MMENU_CURRENCY_CONF'));
updateLastviewed($_SESSION['userid'], $param['selfname'], 'MMENU_CURRENCY_CONF');

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"site_conf.php","name"=>getTranslateText(41));
$items[] = array("icon"=>"cases.gif","location"=>"cur_conf.php","name"=>getTranslateText('MMENU_CURRENCY_CONF'));
$items[] = array("icon"=>"cases.gif","location"=>"pay_rates.php","name"=>getTranslateText(43));
$items[] = array("icon"=>"cases.gif","location"=>"admins.php","name"=>getTranslateText(44));
$items[] = array("icon"=>"cases.gif","location"=>"meta_editor.php","name"=>getTranslateText(125));
$items[] = array("icon"=>"cases.gif","location"=>"backups.php","name"=>getTranslateText(46));
submenu($items);

//popular currency
$sql = sql_placeholder("SELECT * FROM $param[dbprefix]currency WHERE cur_alpha3 in (?@) ORDER BY position, cur_alpha3", $popular_cur);
$rs_popular = $db->query($sql);
if (0 < $rs_popular->numRows()) {
    $cnt=0;
    $hidden_data = getHiddenFieldHtmlCode('action', 'update_popular');
    $xtpl->assign('hidden_data', $hidden_data);    
    while($row = $rs_popular->fetchRow(DB_FETCHMODE_ASSOC)) {    
        $row_style = (0 == ($cnt++)%2)? 'row1' : 'row2';
        foreach (array(
            'R'=> (1 == $row['enabled']) ? 'enabled_row' : $row_style,
            //check
            'currency_id' => $row['cur_id'],
            'check_checked' => (1 == $row['enabled']) ? 'checked' : '',
            //iso currency alpha3
            'cur_alpha3' => $row['cur_alpha3'],
            //currency symbol
            'currency_symbol' => $row['cur_symbol'],
            //currency symbol position
            'currency_symbol_prefix' =>  (0 == $row['symbol_prefix']) ? '' : 'checked',
            'currency_symbol_suff' => (0 == $row['symbol_prefix']) ? 'checked' : '',
            //cyrrency information
            'cur_rate' => getConvertFactor($row['cur_id'], DEFAULT_JOIN_CURRENCY),
            'cur_name' => $row['cur_name'],
            'cur_entitiy' => $row['entitiy']
        ) as $k=>$v) {
            $xtpl->assign($k, $v);
        }        
        $xtpl->parse('template.popular_cur.loop');
    }
    $xtpl->parse('template.popular_cur');    
}

//national currency
$sql = sql_placeholder("SELECT * FROM $param[dbprefix]currency WHERE cur_alpha3 not in (?@) ORDER BY position, cur_alpha3", $popular_cur);
$rs_popular = $db->query($sql);
if (0 < $rs_popular->numRows()) {
    $cnt=0;
    $hidden_data = getHiddenFieldHtmlCode('action', 'update_national');
    $xtpl->assign('hidden_data', $hidden_data);    
    while($row = $rs_popular->fetchRow(DB_FETCHMODE_ASSOC)) {    
        $row_style = (0 == ($cnt++)%2)? 'row1' : 'row2';
        foreach (array(
            'R'=> (1 == $row['enabled']) ? 'enabled_row' : $row_style,
            //check
            'currency_id' => $row['cur_id'],
            'check_checked' => (1 == $row['enabled']) ? 'checked' : '',
            //iso currency alpha3
            'cur_alpha3' => $row['cur_alpha3'],
            //currency symbol
            'currency_symbol' => $row['cur_symbol'],
            //currency symbol position
            'currency_symbol_prefix' =>  (0 == $row['symbol_prefix']) ? '' : 'checked',
            'currency_symbol_suff' => (0 == $row['symbol_prefix']) ? 'checked' : '',
            //cyrrency information
            'cur_rate' => getConvertFactor($row['cur_id'], DEFAULT_JOIN_CURRENCY),
            'cur_name' => $row['cur_name'],
            'cur_entitiy' => $row['entitiy']
        ) as $k=>$v) {
            $xtpl->assign($k, $v);
        }        
        $xtpl->parse('template.national_cur.loop');
    }
    $xtpl->parse('template.national_cur');    
}

ending();
?>