﻿<?php
// $Id: quick_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('transactionbuilder.inc.php');

$description1 = getTranslateText('TT_QUICK_STATS', PRIMARY_LANGUAGE);
$tplHeader = array(
    'description' => getTranslateText('TT_QUICK_STATS'),
//    'setNorecordText' =>(getTranslateText('NORECORD_AFFILIATES'))
);

// Creating a workbook
$workbook = new Spreadsheet_Excel_Writer();
$workbook->setVersion(8);


// sending HTTP headers
$description = $tplHeader['description'];
$description1 = getTranslateText('TT_QUICK_STATS', PRIMARY_LANGUAGE);
$pattern = "/[^\w]/";
if ('utf8' == $param['dbcharacter']) $pattern .= 'u';
$export_filename = preg_replace($pattern, "", $description1) . '.xls';
$workbook->send($export_filename);
// set colors
$workbook->setCustomColor(10, 238, 238, 238);

// Creating a worksheet
$worksheet =& $workbook->addWorksheet($description1);
$worksheet->setInputEncoding('UTF-8');

$format_header_description =& $workbook->addFormat();
$format_header_description->setBold();
$format_header_description->setAlign('vcenter');
$format_header_description->setAlign('left');
$format_header_description->setSize(16);

$format_header_left =& $workbook->addFormat();
$format_header_left->setBold();
$format_header_left->setAlign('top');
$format_header_left->setAlign('left');
$format_header_left->setTextWrap();
$format_header_left->setBorder(1);
$format_header_left->setFgColor(10);

$format_header_center =& $workbook->addFormat();
$format_header_center->setBold();
$format_header_center->setAlign('top');
$format_header_center->setAlign('center');
$format_header_center->setTextWrap();
$format_header_center->setBorder(1);
$format_header_center->setFgColor(10);

$format_header_right =& $workbook->addFormat();
$format_header_right->setBold();
$format_header_right->setAlign('top');
$format_header_right->setAlign('right');
$format_header_right->setTextWrap();
$format_header_right->setBorder(1);
$format_header_right->setFgColor(10);

$format_cell_left =& $workbook->addFormat();
$format_cell_left->setAlign('top');
$format_cell_left->setAlign('left');
$format_cell_left->setTextWrap();
$format_cell_left->setBorder(1);

$format_cell_center =& $workbook->addFormat();
$format_cell_center->setAlign('top');
$format_cell_center->setAlign('center');
$format_cell_center->setTextWrap();
$format_cell_center->setBorder(1);

$format_cell_right =& $workbook->addFormat();
$format_cell_right->setAlign('top');
$format_cell_right->setAlign('right');
$format_cell_right->setTextWrap();
$format_cell_right->setBorder(1);

$format_cell_left_bold =& $workbook->addFormat();
$format_cell_left_bold->setBold();
$format_cell_left_bold->setAlign('top');
$format_cell_left_bold->setAlign('left');
$format_cell_left_bold->setTextWrap();
$format_cell_left_bold->setBorder(1);

$format_cell_center_bold =& $workbook->addFormat();
$format_cell_center_bold->setBold();
$format_cell_center_bold->setAlign('top');
$format_cell_center_bold->setAlign('center');
$format_cell_center_bold->setTextWrap();
$format_cell_center_bold->setBorder(1);

$format_cell_right_bold =& $workbook->addFormat();
$format_cell_right_bold->setBold();
$format_cell_right_bold->setAlign('top');
$format_cell_right_bold->setAlign('right');
$format_cell_right_bold->setTextWrap();
$format_cell_right_bold->setBorder(1);

$i=0;
$worksheet->write($i, 0, getTranslateText('PERORT_HEADER1') . ': ' . $description, $format_header_description);
$i++;
// header
$worksheet->write($i, 0, getTranslateText('REP_H_DATE'), $format_header_left);
$worksheet->setColumn(0,0,30);
$worksheet->write($i, 1, getTranslateText('TXNTYPE_SALESCOMISSION'), $format_header_left);
$worksheet->setColumn(1,1,30);
$worksheet->write($i, 2, getTranslateText('TXNTYPE_TIERCOMISSION'), $format_header_left);
$worksheet->setColumn(2,2,30);
$worksheet->write($i, 3, getTranslateText('TXNTYPE_INITIALBONUS'), $format_header_left);
$worksheet->setColumn(3,3,30);
$worksheet->write($i, 4, getTranslateText('TXNTYPE_CHARGEBACK'), $format_header_left);
$worksheet->setColumn(4,4,30);
$worksheet->write($i, 5, getTranslateText('TXNTYPE_PAYOUT'), $format_header_left);
$worksheet->setColumn(5,5,30);
$worksheet->write($i, 6, getTranslateText('TXNTYPE_TRAFFIC'), $format_header_left);
$worksheet->setColumn(6,6,30);
$worksheet->setRow($i, 30);

$rs = $db->query("SELECT t1.txn_type, sum(t1.orig_amount) as orig_amount, sum(t1.amount) as amount, t1.orig_cur_index, t1.daily_number, t1.weekly_number, t1.bi_weekly_number, t1.monthly_number, t1.half_monthly_number FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 $sql_q ORDER BY t1.create_date DESC", null, DB_FETCHMODE_ASSOC);

if (0 != $rs->numRows()) {
    $report_data1 = array();
    switch (intval($_REQUEST['filter_txn_period'])) {
        case $date_period_types['daily_number']: 
        $period_key = 0;
        break;        
        case $date_period_types['weekly_number']: 
        $period_key = 1;
        break;        
        case $date_period_types['bi_weekly_number']: 
        $period_key = 2;
        break;        
        case $date_period_types['half_monthly_number']: 
        $period_key = 4;
        break;        
        default: 
        $period_key = 3;        
        break;
    }
    
    $cell_name = array_search($period_key, $date_period_types);
    while($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $key_one = $row[$cell_name];
        $key_two = $row['txn_type']; 
        $report_data1[$key_one][$key_two] = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    }
   $total = array();
    
//    $report_data1
    $interval_keys = array_keys($report_data1);   
    $interval_str = getFormatStrInterval($period_key, $interval_keys);
    
    //print data
    foreach ($report_data1 as $period_key => $data) {
        $i++;
        $worksheet->write($i,0, $interval_str[$period_key], $format_cell_left);
        
        $worksheet->write($i,1, moneytextformat($data[0], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[0] += floatval($data[0]);
        $worksheet->write($i,2, moneytextformat($data[1], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[1] += floatval($data[1]);
        $worksheet->write($i,3, moneytextformat($data[2], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[2] += floatval($data[2]);
        $worksheet->write($i,4, moneytextformat($data[5], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[5] += floatval($data[5]);
        $worksheet->write($i,5, moneytextformat($data[7], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[7] += floatval($data[7]);
        $worksheet->write($i,6, moneytextformat($data[9], DEFAULT_JOIN_CURRENCY), $format_cell_right);
        $total[9] += floatval($data[9]);          
    }
    //total
    if (0 != count($total)) {
        $i++;         
        $worksheet->write($i,0, getTranslateText('REP_H_TOTAL'), $format_cell_left_bold);                    
        $worksheet->write($i,1, moneytextformat($total[0], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
        $worksheet->write($i,2, moneytextformat($total[1], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
        $worksheet->write($i,3, moneytextformat($total[2], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
        $worksheet->write($i,4, moneytextformat($total[5], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
        $worksheet->write($i,5, moneytextformat($total[7], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
        $worksheet->write($i,6, moneytextformat($total[9], DEFAULT_JOIN_CURRENCY), $format_cell_right_bold);
           
    }          
}
// Let's send the file
$workbook->close();

?>