<?php
// $Id: quick_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('transactionbuilder.inc.php');

$tplHeader = array(
    'description' => getTranslateText('TT_QUICK_STATS'),
//    'setNorecordText' =>(getTranslateText('NORECORD_AFFILIATES'))
);


$rs = $db->query("SELECT t1.txn_type, sum(t1.orig_amount) as orig_amount, sum(t1.amount) as amount, t1.orig_cur_index, t1.daily_number, t1.weekly_number, t1.bi_weekly_number, t1.monthly_number, t1.half_monthly_number FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 $sql_q ORDER BY t1.create_date DESC", null, DB_FETCHMODE_ASSOC);

if (0 == $rs->numRows()) {
    $xtpl->parse('template.no_records');        
} else {
    $report_data1 = array();
    switch (intval($_REQUEST['filter_txn_period'])) {
        case $date_period_types['daily_number']: 
        $period_key = 0;
        break;        
        case $date_period_types['weekly_number']: 
        $period_key = 1;
        break;        
        case $date_period_types['bi_weekly_number']: 
        $period_key = 2;
        break;        
        case $date_period_types['half_monthly_number']: 
        $period_key = 4;
        break;        
        default: 
        $period_key = 3;        
        break;
    }
    
    $cell_name = array_search($period_key, $date_period_types);
    while($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $key_one = $row[$cell_name];
        $key_two = $row['txn_type']; 
        $report_data1[$key_one][$key_two] = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    }
   $total = array();
    
//    $report_data1
    $interval_keys = array_keys($report_data1);   
    $interval_str = getFormatStrInterval($period_key, $interval_keys);
    
    //print data
    foreach ($report_data1 as $period_key => $data) {
        $xtpl->assign("date_period", $interval_str[$period_key]);
        foreach ($transaction_types as $k => $v) {            
            $xtpl->assign("col_$v", moneytextformat($data[$v], DEFAULT_JOIN_CURRENCY));
            $total["total_col_$v"] += floatval($data[$v]);
        }
        $xtpl->parse('template.quickstat.loop');            
    }
    //total
    if (0 != count($total)) {
        foreach ($total as $k => $v)          
            $xtpl->assign($k, moneytextformat($v, DEFAULT_JOIN_CURRENCY));
        $xtpl->parse('template.quickstat.total');
    }

    $xtpl->parse('template.quickstat');        
}

?>