<?php
// $Id: translation.php 17 2009-10-23 11:03:04Z adgar $

require_once('admincfg.php');
require_once('htmlelements.inc.php'); 
require_once('translator.inc.php');

if (isset($_REQUEST['action'])) {
    $headertext =  getTranslateText('TRANSLATION_IMPORT');        
    if (isset($_REQUEST['subaction']) &&  ('edit' == $_REQUEST['action'])) {
         /**
         * Import text in current language
         */        
        if ('import' == $_REQUEST['subaction']) {
            require_once('fileuploader.inc.php');            
            $savefilename = AFFPRO::getResourcePath() . 'translation.xml';
            $fu = new FileUploader($_FILES['xls_file'], $savefilename, AFFPRO_UPLOAD_TRANSLATION);
            $res = $fu->upload();
            if (!AFFPRO::isError($res)) {
                importTranslateExcelFile($savefilename, $_POST['lng_id2']);
                unlink($savefilename);
            }
            AFFPRO::redirect("$param[selfname]?action=edit&lng_id2=$_POST[lng_id2]");        
        } 
        /**
         * Export text in current language
         */
        elseif ('export' == $_REQUEST['subaction']) {
            $lng_id2 = $_POST['lng_id2'];
            $foo = getTranslationXMLFileContent($lng_id2, $_POST['translate_text']);
            ob_clean();
            ob_start();    
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"affpro_{$lng_id2}_translate.xls\"");
            header("Expires: 0");
            header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
            header("Pragma: public");
            echo $foo;
            ob_end_flush();
            exit();
        }
        /**
         * Delete text in current language
         */        
        elseif ('delete' == $_REQUEST['subaction']) {            
            deleteTextFromCurTranslation($_POST['translate_text'], $_POST['lng_id2']);
            AFFPRO::redirect("$param[selfname]?action=edit&lng_id2=$_POST[lng_id2]");
        }
        /**
         * Add text in current language
         */         
        elseif ('add' == $_REQUEST['subaction']) {
            $pattern = "/[^\w]/";
            if ('utf8' == $param['dbcharacter']) $pattern .= 'u';                           
            $key = strtoupper(preg_replace($pattern, "", $_POST['word_code']));
            addTextToTranslation($key, $_POST['translate_new_text'], $_POST['add_to_lng']);
            AFFPRO::redirect("$param[selfname]?action=edit&lng_id2=$_POST[lng_id2]");          
        }     
        /**
         * Edit date format in current language
         */         
        elseif ('editdate' == $_REQUEST['subaction']) {
            editLanguageDateFormat($_POST['lng_id2'], strip_tags($_POST['long_date_format']), strip_tags($_POST['short_date_format']));
            AFFPRO::redirect("$param[selfname]?action=edit&lng_id2=$_POST[lng_id2]");        
        }                     
    } 
    /**
     * Add new language
     */      
    elseif ('add_language' == $_REQUEST['action']) {
        addLanguage($_POST['lng_id2']);
        AFFPRO::redirect("$param[selfname]?action=edit&lng_id2=$_POST[lng_id2]");      
    } 
    /**
     * Change language status
     */          
    elseif ('change_status' == $_REQUEST['action']) {        
        changeStatusLanguage($_POST['lng_id2']);               
        AFFPRO::redirect("$param[selfname]" . (($_POST['lng_id2'] == getLanguageId()) ? ('?language=' . PRIMARY_LANGUAGE) : '' ));                      
    } 
    /**
     * Delete new language
     */      
    elseif ('delete' == $_REQUEST['action']) {
        removeLanguage($_POST['lng_id2']);
        AFFPRO::redirect("$param[selfname]" . (($_POST['lng_id2'] == getLanguageId()) ? ('?language=' . DEFAULT_LANGUAGE) : '' ));      
    }    
} else {
    $headertext =  getTranslateText('TRANSLATION_EXIST');
}

starting($headertext);
updateLastviewed($_SESSION['userid'], $param['selfname'], 'TRANSLATION');
$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"translation.php","name"=>getTranslateText('TRANSLATION'));
submenu($items);
/**
 * Current language form
 */ 
if ( isset($_REQUEST['action']) && ('edit' == $_REQUEST['action'])) {
    $lng_id2 = $_REQUEST['lng_id2'];
    $language_row = $db->getRow("SELECT * FROM $param[dbprefix]languages  WHERE installed=1 AND alpha2=? LIMIT 0,1", array($lng_id2), DB_FETCHMODE_ASSOC);        
    //existing languages
    $lng_list = $db->getAssoc("SELECT alpha2, lng_name FROM $param[dbprefix]languages WHERE installed=1", false, null, DB_FETCHMODE_ORDERED);       
    array_unshift($lng_list, getTranslateText('TT_ALL_LNGS'));    
    //translated words and translated country name
    $translate_text = getDataFromTranslation($lng_id2);
    foreach ($translate_text as $k => $v) {
        $translate_text[$k] = $k . ' | ' . $v;
    }   
    //generate hidden data
    $hidden_data = getHiddenFieldHtmlCode('action', $_REQUEST['action']);        
    $hidden_data .= getHiddenFieldHtmlCode('subaction');
    $hidden_data .= getHiddenFieldHtmlCode('lng_id2', $lng_id2);
    //    
    foreach (array(
    'hidden_data' => $hidden_data, 
    'selected_translations_name'=> $language_row['lng_name'],
    'max_file_size' => getHiddenFieldHtmlCode('MAX_FILE_SIZE', 1048576), // max file size = 1 Mb
    'flong_date_format' => getInputFieldHtmlCode('long_date_format', $language_row['long_date_format'], "maxlength=\"20\" class=\"text data\" style=\"width:150px;\""),
    'fshort_date_format' => getInputFieldHtmlCode('short_date_format', $language_row['short_date_format'], "maxlength=\"20\" class=\"text data\" style=\"width:150px;\""),
    'word_code' => getInputFieldHtmlCode('word_code', null, "maxlength=\"30\" class=\"text data\" style=\"width:100px;\" onKeyUp=\"onKeyUpWordCode(this)\""),
    'language_list' => getSelectFieldHtmlCode('add_to_lng', $lng_list, $lng_id2, "style=\"width:80px;\""),    
    'translate_new_text' => getInputFieldHtmlCode('translate_new_text', null, "maxlength=\"200\" class=\"text data\" style=\"width:250px;\""),
    'words_cnt' => count($translate_text),
    'translate_text' => getSelectFieldHtmlCode('translate_text', $translate_text, null,  "multiple class=\"multiple data\" dataindex=\"1\" style=\"width:580px; height:150px;\" onChange=\"onChangeTrText()\""),    
    'xls_file' => getFileHtmlCode('xls_file', "class=\"file data\" style=\"width:300px;\"")
    ) as $k => $v) {
        $xtpl->assign($k, $v);
    }    
    $xtpl->parse('template.edit_lng');
} 
/**
 * Languages list
 */  
else {
    $rs = $db->query("SELECT * FROM $param[dbprefix]languages  WHERE installed=1 ORDER BY weight DESC");
    $cnt = $rs->numRows();    
    while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $hidden_data = getHiddenFieldHtmlCode('action');
        $hidden_data .= getHiddenFieldHtmlCode('lng_id2', $row['alpha2']);
        $locales = split(' ', $row['locale'], 2);
        $pattern = "/^\w+_(\w+)\.\w+$/i";
        if ('utf8' == $param['dbcharacter']) $pattern .= 'u';    
        preg_match($pattern, $locales[0], $matches);        
        $flagfile = SCRIPT_REALPATH . "/templates/images/flags/$matches[1].gif";        
        foreach (array(
        'R'=> (0 == ($cnt++)%2)? '1' : '2',
        'hidden_data' => $hidden_data, 
        'lng_flag' => (file_exists($flagfile)) ? "<img src=\"$base1/templates/images/flags/$matches[1].gif\" border=\"0\" alt=\"$row[lng_name]\" />" : '&nbsp',
        'lng_name' => $row['lng_name'],
        'lng_id' => $row['alpha2']
        ) as $k => $v) {
            $xtpl->assign($k, $v);
        }
        if ($row['alpha2'] == DEFAULT_LANGUAGE) {
            $xtpl->assign('primary_lng', "<span class=\"note\">(" . getTranslateText('TT_DEFAULT_LANGUAGE') .")</span>");
        } elseif ($row['alpha2'] == PRIMARY_LANGUAGE) {
            $xtpl->assign('primary_lng', "<span class=\"note\">(" . getTranslateText('PRIMARY_LNG') .")</span>");            
        } else {
            $xtpl->assign('primary_lng', '');
            $xtpl->assign('btn_value', ($row['enable'] == 1) ? getTranslateText('DISABLE') : getTranslateText('ENABLE') );
            $xtpl->parse('template.create_lng.loop.change_status_btn');
            $xtpl->parse('template.create_lng.loop.delete_btn');
        }
        $xtpl->parse('template.create_lng.loop');
    }
    
    $hidden_data = getHiddenFieldHtmlCode('action', 'add_language');
    $lng_list = $db->getAssoc("SELECT alpha2, lng_name FROM $param[dbprefix]languages WHERE installed=0", false, null, DB_FETCHMODE_ORDERED);       
    foreach (array(
    'hidden_data' => $hidden_data,
    'languages_select' => getSelectFieldHtmlCode('lng_id2', $lng_list, null, "style=\"width:160px;\""),
    ) as $k => $v) {
        $xtpl->assign($k, $v);
    }
    $xtpl->parse('template.create_lng');
}
ending();
?>