<?php
// $Id: transaction_info.php 251 2008-01-21 09:45:22Z adgar $

require_once('cfg.php');
require_once('lib/geoip.lib.php');
require_once('htmlelements.inc.php');
checkAccess('AFF');

if (!isset($_REQUEST['txn_id']) ||  !is_numeric($_REQUEST['txn_id'])) {
    AFFPRO::redirect($base . '/statistics.php');
}

$geoip = new GeoIP_Wrapper();

starting(getTranslateText('TXN_DETAILINFO'));
updateLastviewed($_SESSION['userid'], $param['selfname'], '28');

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"account.php","name"=>getTranslateText(7));
$items[] = array("icon"=>"cases.gif","location"=>"statistics.php","name"=>getTranslateText(9));
$items[] = array("icon"=>"cases.gif","location"=>"traffic.php","name"=>getTranslateText(8));
$items[] = array("icon"=>"cases.gif","location"=>"payout_history.php", "name"=>getTranslateText(38));
submenu($items);

$rs = $db->query("SELECT t1.*, t3.txn_id as chargeback_id FROM $param[dbprefix]transactions as t1 LEFT JOIN affiliate_transactions as t3 ON (t1.txn_id=t3.key_one AND t3.txn_type=?)  WHERE t1.user_id=? AND t1.txn_id=?", array($transaction_types['debit_chargeback'], $_SESSION['userid'], (int)$_REQUEST['txn_id']));
$row = $rs->fetchRow(DB_FETCHMODE_ASSOC);

$items = array();
$from_ip = long2ip($row['ip_long']);
$country_name = $geoip->country_name_by_addr($from_ip);
$from_ip_txt = (!empty($country_name)) ? "$from_ip  -  $country_name" : $from_ip ;

$commission = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
$txn_data = array(
    'uid'=>$row['user_id'],
//    'txn_type'=> getTransactionTextType($row['txn_type']),
//BEGIN TEMPORARY CODE
    'txn_type'=> getTransactionTextType($row['is_recurring'] == 1 ? $transaction_types['credit_recurring']  : $row['txn_type']),
//END TEMPORARY CODE
    'orig_order_id'=> $row['orig_order_id'],
    'amount'=> moneytextformat($row['orig_amount'], $row['orig_cur_index'], false, true),
    'commission'=> moneytextformat($commission, DEFAULT_JOIN_CURRENCY, false, true),
    'exchange_rate' => '1 ' . getCurrencyTextType($row['orig_cur_index'], true) . ' = ' . getConvertFactor($row['orig_cur_index'], DEFAULT_JOIN_CURRENCY) . ' '. getCurrencyTextType(DEFAULT_JOIN_CURRENCY, true),
    'date'=> strftime($param['long_date_format'], strtotime($row['create_date'])),
    'from_ip'=> $from_ip_txt,
);
foreach ($txn_data as $k=>$v) {
    $xtpl->assign($k, $v);
}

if ($row['txn_type'] == $transaction_types['credit_tfaffic']) {
    $xtpl->parse('template.commission');
    $foo = "<a href=\"traffic_info.php?tr_id={$row['key_one']}\" target=\"_blank\">" . getTranslateText('TT_VIEW') . "</a>";
    $xtpl->assign('traffic', $foo);
    $xtpl->parse('template.traffic');
}
else if ($row['txn_type'] == $transaction_types['debit_payout']) {
    $xtpl->parse('template.commission');
}
else {
    $xtpl->parse('template.amount');
    $xtpl->parse('template.commission');
    if ($row['orig_cur_index'] != DEFAULT_JOIN_CURRENCY) $xtpl->parse('template.exchange');
}
//Additional Information
if (!empty($row['addition_info'])) {
    $xtpl->assign('add_info', $row['addition_info']);
    $xtpl->parse('template.add_info');
}
//Chargeback
if (!empty($row['chargeback_id'])) {
    $foo = "<a href=\"transaction_info.php?txn_id=$row[chargeback_id]\">" . getTranslateText('TT_YES') . "</a>";
    $xtpl->assign('chargeback', $foo);
    $xtpl->parse('template.chargeback');
}

$xtpl->parse('template.transaction');

unset($geoip);
ending();
?>