<?php
// $Id: adscontainer.php 13 2009-08-06 04:54:25Z adgar $

require_once('../affiliate/cfg.php');
require_once('banner_counter.inc.php');

function load_ads($src, $view_link, $title, $description) {
$instext = array(
    'src' => php2js($src),
    'view_link' => php2js($view_link),
    'title' => php2js($title),
    'description' => php2js(nl2br($description))
);

if ((bool)getParamByName('use_additional_encodings') && isset($_GET['cp'])) {
    if (function_exists('mb_convert_encoding')) {
        $instext['title'] = mb_convert_encoding($instext['title'], $_GET['cp'], "UTF-8");
        $instext['description'] = mb_convert_encoding($instext['description'], $_GET['cp'], "UTF-8");
    } else if (function_exists('iconv')) {
        $instext['title'] = iconv("UTF-8", $_GET['cp'], $instext['title']);
        $instext['description'] = iconv("UTF-8", $_GET['cp'], $instext['description']);
    }
    header("Content-Type: application/x-javascript; charset={$_GET['cp']}");
} else {
    header("Content-Type: application/x-javascript");
}

print<<<SCRIPT
document.write('<style type="text/css">');
document.write('td.ad{font-size: 8pt;font-family: Arial, Helvetica, sans-serif;}');
document.write('</style>');
document.write('<div><table border="0" cellspacing="0" bgcolor="' + OutlineColor + '">');
document.write('<tr><td class="ad"><div align="center"><center><div align="center">');
document.write('<table border="0" cellspacing="0" width="' + BoxWidth + '" cellpadding="2" height="' + BoxHeight + '" bgcolor="' + TextBackgroundColor + '">');
document.write('<tr><td class="ad" width="100%" height="5%" bgcolor="' + OutlineColor + '">');
document.write('<font color="' + TitleTextColor + '"><b>{$instext['title']}</b></font></td></tr>');
document.write('<tr><td class="ad" width="100%" height="95%" valign="top">');
document.write('<a href="{$instext['src']}" target="_blank">');
document.write('<font color="' + LinkColor + '"><u>{$instext['view_link']}</u></font><br /><font color="' + TextColor + '">');
document.write('{$instext['description']}');
document.write('</font></a></td></tr></table></div></td></tr></table></center></div>');
SCRIPT;
    exit();
}

$error = false;
$testmode = isset($_GET['testmode']) ? true : false;

//for compatibility  with old versions
if (isset($_GET['id']) || is_numeric($_GET['id'])) {
    $_GET['aff_id'] = $_GET['id'];
}
if (isset($_GET['ad']) || is_numeric($_GET['ad'])) {
    $_GET['ad_id'] = $_GET['ad'];
}
if (isset($_GET['group_id']) || is_numeric($_GET['group_id'])) {
    $_GET['ad_id'] = $_GET['group_id'];
}
//

for ($i=0; $i<=1; $i++) {
    //validation GET variables
    if (!isset($_GET['aff_id']) || !is_numeric($_GET['aff_id'])|| !isset($_GET['ad_id']) || !is_numeric($_GET['ad_id'])) {
        $error = true;
        break;
    }
    //aff_id validation
    if ($testmode)  $user_rs = $db->query("SELECT * FROM $param[dbprefix]users WHERE id=? AND approved=1", array($_GET['aff_id']));
    else  $user_rs = $db->query("SELECT * FROM $param[dbprefix]users WHERE id=? AND usertype=? AND approved=1", array($_GET['aff_id'], $users_types['affiliater']));
    if (!($user_row = $user_rs->fetchRow(DB_FETCHMODE_ASSOC))) {
        $error = true;
        break;
    }
    //banner_id and group_id validation
    $ad_rs = $db->query("SELECT * FROM $param[dbprefix]textads WHERE textad_id=?", array($_GET['ad_id']));
    if (!($ad_row = $ad_rs->fetchRow(DB_FETCHMODE_ASSOC))) {
        $error = true;
        break;
    }
    //validate product
    $product_rs = $db->query("SELECT traffic_page FROM $param[dbprefix]groups WHERE group_id=?", array($ad_row['group_id']));
    if (!($product_row = $product_rs->fetchRow(DB_FETCHMODE_ASSOC))) {
        $error = true;
        break;
    }
}

if ($error) {
    $description = getParamByName('meta_description');
    $title = getParamByName('sitename');
    load_ads(HTTP_ADDR, HTTP_ADDR, $title, $description);
    exit();
}

$src = rtrim(HTTP_ADDR, '/') . "/affiliate/affiliate.php?id=$user_row[id]&group=$ad_row[group_id]";
if ($testmode) {
    $src .= '&testmode=1';
}

//calculation of banners shows
/*
if (!$testmode) {
    count_ads_impression($_GET['aff_id'], $_GET['ad_id']);
}
*/
$view_link = (strlen($product_row['traffic_page']) > 43) ? (substr($product_row['traffic_page'], 0, 40) . '...') :  $product_row['traffic_page'];
load_ads($src, $view_link, $ad_row['title'], $ad_row['addesc']);
exit();

?>