<?php
// $Id: callback_2co.php 5 2008-12-12 05:55:19Z adgar $

require_once('callback.class.php');

class TWO_CO_Callback extends Callback {    
    var $affiliater_id;
    var $product_id;    
    var $txn_id;
    var $amount;
    var $curreny_id;    
    var $is_recurring=false;
    var $country_id = 0;
    
    function TWO_CO_Callback() {
        parent::start(); 
        
        //Check Referer
        $check_referer = false;
        $allow_referers = array('www.2checkout.com', '2checkout.com', 'www2.2checkout.com' );  
        if (preg_match("/^https?:\/\/([^\/]*)/i", $_SERVER['HTTP_REFERER'], $referer_url))
            if (in_array($referer_url[1], $allow_referers)) $check_referer = true;                   
        
        if (!$check_referer) {
            $return = 'Referer URL faild';                      
        } else if (isset($_REQUEST['demo'])) {
            $return = 'DEMO purchase';      
        } else if (!isset($_REQUEST['order_number']) || !isset($_REQUEST['total'])) {
            $return = 'Bad parameters';
        } else if (!isset($_COOKIE['user_id']) || !isset($_COOKIE['group_id'])) {
            $return = 'Bad COOKIE parameters';
        } else {
            //Product ID and Affiliater ID
            global $db, $param, $users_types;
                             
            $aff_id = $_COOKIE['user_id'];
            $productid = $_COOKIE['group_id'];
            $this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($_COOKIE['country_code']));
                
            //Affiliater ID validation
            $rs = $db->query("SELECT id FROM $param[dbprefix]users WHERE (usertype=?) AND (id=?)", array($users_types['affiliater'], $aff_id));
            if($row = $rs->fetchRow(DB_FETCHMODE_ASSOC))
            {
                $this->affiliater_id = intval($row['id']);
                $this->product_id = $productid;
            } else {
                $return = "Not Valid Affiliate Information";    
            }
            //Transaction ID
            if (isset($_REQUEST['order_number'])) {
                $this->txn_id = $_REQUEST['order_number'];
            } else {
                $this->txn_id = transaction_create_unique_id();
            }
            //Transaction Curreny           
            $this->curreny_id = DEFAULT_JOIN_CURRENCY;
            //Transaction Amount
            $this->amount = abs($_REQUEST['total']);   
            
        }
        
        if (!empty($return)) { 
            $this->finish($return);
        }
        return;
    }
    
    function deposit() {
        $approved = (int)getParamByName('auto_approve_new_transaction'); 
        transaction_log($this->txn_id);
        $addition_info = "Card holder's email: $_REQUEST[email] \n";       
        if ('K' == $_REQUEST['credit_card_processed']) $addition_info .= "waiting for approval";
        
        $credit_result = transaction_credit_primary($this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'], $this->product_id, 0, $this->country_id, $addition_info, $approved, false, $this->is_recurring);
        if (true == $credit_result[0]) {
            $mail_template_param = array(
                'TransactionAmount'=> moneytextformat($credit_result[2], $credit_result[3])
            );            
            sendAdminMailFromTemplate('admtransaction', $this->affiliater_id, $mail_template_param);
            $record_id = $credit_result[1];
            $return = 'Transaction is successfully added';
            if (1 == $approved) {
                sendUserMailFromTemplate('transaction', $this->affiliater_id, $mail_template_param);
                $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
                $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, 0);
                if (false == $credit_result[0]) $return .=  "\n".get_transaction_error($credit_result[1]);
            }            
        } else $return = get_transaction_error($credit_result[1]);       
        
    	return $return;
    }
    
    function refund() {
        $addition_info = "Chargeback";
//        transaction_log($this->txn_id);
//        $refund_result = transaction_refund($_REQUEST['orig_id'], $this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'],  $addition_info);
//        if (true == $refund_result[0]) $return = 'Chargeback transaction is successfully added';  
//        else $return =  get_transaction_error($refund_result[1]);         
        return $return;
    }
    
    function finish($str_status) {
        parent::finish($str_status);        
        echo "OK\n" . $str_status;    
        exit();
    }    
}

$TWO_CO_Callback = new TWO_CO_Callback();

$return = $TWO_CO_Callback->deposit();

$TWO_CO_Callback->finish($return);
  
?>