<?php
// $Id: callback_paycom.php 5 2008-12-12 05:55:19Z adgar $

require_once('callback.class.php');

class PAYCOM_Callback extends Callback {    
    var $affiliater_id;
    var $product_id;    
    var $txn_id;
    var $amount;
    var $curreny_id;       
    var $is_recurring;
    var $country_id = 0;
    
    function PAYCOM_Callback() {
        parent::start();      
        if (!isset($_REQUEST['order_id']) || !isset($_REQUEST['x_amount']) || !isset($_REQUEST['x_affproinfo'])) {
            $return = 'Bad parameters';
        }else if (empty($_REQUEST['x_amount'])) {
            $return="Amount zero";
        }else if (empty($_REQUEST['x_affproinfo'])) {
            $return="Affiliater ID is empty";
        } else {          
            global $db, $param, $users_types;
            preg_match("/(\d+):(\d+):?(\w{2})?/",$_REQUEST['x_affproinfo'], $matches);          
            $rs = $db->query("SELECT id FROM $param[dbprefix]users WHERE (usertype=?) AND (id=?)", array($users_types['affiliater'], $matches[1]));
            if (0 != $rs->numRows()) {
                $this->affiliater_id = $matches[1];
                $this->product_id = $matches[2];            
            	if (isset($matches[3]))
                	$this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($matches[3]));                 
            } else {
                $return="Not Valid Affiliate Information";    
            }       
        
            //Transaction ID
            $this->txn_id = $_REQUEST['order_id']; 
            //Transaction Curreny
            $this->curreny_id = DEFAULT_JOIN_CURRENCY;
            //Transaction Amount
            $this->amount = abs($_REQUEST['x_amount']);  
        }        
 
        if (!empty($return)) { 
            $this->finish($return);
        }
        return;
    }

    function deposit() {
        $approved = (int)getParamByName('auto_approve_new_transaction'); 
        transaction_log($this->txn_id);
        $credit_result = transaction_credit_primary($this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'], $this->product_id, 0, $this->country_id, null, $approved, false, $this->is_recurring);
        if (true == $credit_result[0]) {
            $mail_template_param = array(
                'TransactionAmount'=> moneytextformat($credit_result[2], $credit_result[3])
            );            
            sendAdminMailFromTemplate('admtransaction', $this->affiliater_id, $mail_template_param);
            $record_id = $credit_result[1];
            $return = 'Transaction is successfully added';
            if (1 == $approved) {
                sendUserMailFromTemplate('transaction', $this->affiliater_id, $mail_template_param);
                $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
                $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, 0);
                if (false == $credit_result[0]) $return .=  "\n".get_transaction_error($credit_result[1]);
            }            
        } else $return = get_transaction_error($credit_result[1]);       
        
    	return $return;
    }
    
    function finish($str_status) {
        parent::finish($str_status);        
        echo "OK\n" . $str_status;    
        exit();
    }    
}

$PAYCOM_Callback = new PAYCOM_Callback();

$return = $PAYCOM_Callback->deposit();

$PAYCOM_Callback->finish($return);  

?>