<?php
// $Id: callback_webmoney.php 5 2008-12-12 05:55:19Z adgar $

require_once('callback.class.php');

class WEBMONEY_Callback extends Callback {    
    var $affiliater_id;
    var $product_id;    
    var $txn_id;
    var $amount;
    var $curreny_id;
    var $is_recurring = false;
    var $country_id = 0;
    var $add_info;
        
    function WEBMONEY_Callback() {
        parent::start();   
        
        $data_verifited = $this->verified();
        if ((0 == count($_POST)) || (isset($_POST['LMI_PREREQUEST']) && (1 == $_POST['LMI_PREREQUEST']))) {
            $this->finish('Webmoney Prerequest');  
        }        
        else if (!$data_verifited)  {
            $this->finish('Data not verifited');  
        }       
        else if (isset($_POST['LMI_MODE']) && (1 == $_POST['LMI_MODE'])) {
            $this->finish('Demo purchase');  
        }         
        else {
            //Product ID and Affiliater ID
            global $db, $param, $users_types;
            if (preg_match("/(\d+):(\d+):?(\w{2})?/", $_POST['AFPRO_TRACKING_CODE'], $matches)) {
                $aff_id = $matches[1];
                $productid = $matches[2]; 
                //country id
                if (isset($matches[3])) {
                    $this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($matches[3]));
                }
                //validate affiliate id    
                $rs = $db->query("SELECT id FROM $param[dbprefix]users WHERE usertype=? AND id=?", array($users_types['affiliater'], $aff_id));
                if($row = $rs->fetchRow(DB_FETCHMODE_ASSOC))
                {
                    $this->affiliater_id = intval($row['id']);
                    $this->product_id = $productid;
                } else {
                    $this->finish('Not Valid Affiliate Information');
                }                    
            } else {
                $this->finish('Not Valid Affiliate Param');              
            }            
            //Transaction Curreny
            $wm_cur_id = substr($_POST['LMI_PAYER_PURSE'], 0, 1);
            switch ($wm_cur_id) {
               case 'Z':            
                 $this->curreny_id = 840; //USD
                 break;
               case 'R':            
                 $this->curreny_id = 643; //RUB
                 break;
               case 'E':            
                 $this->curreny_id = 978; //EUR               
                 break;
               case 'U':            
                 $this->curreny_id = 980; //UAH
                 break;
               case 'B':            
                 $this->curreny_id = 974; //BYR
                 break;                 
               case 'Y':            
                 $this->curreny_id = 860; //UZS
                 break;                                                                        
               default:
                 $this->curreny_id = DEFAULT_JOIN_CURRENCY;
                 break;  
            }
            //Transaction Amount && Transaction ID
            $this->amount = abs($_POST['LMI_PAYMENT_AMOUNT']);
            $this->txn_id = $_POST['LMI_SYS_TRANS_NO'];         
        }

    }
    
    function verified() {        
        if ('POST' != $_SERVER['REQUEST_METHOD']) {
            return false;
        }                       
        $verified = false;
        $str = $_POST['LMI_PAYEE_PURSE'] . $_POST['LMI_PAYMENT_AMOUNT'] . $_POST['LMI_PAYMENT_NO'] . $_POST['LMI_MODE'] . $_POST['LMI_SYS_INVS_NO'] . $_POST['LMI_SYS_TRANS_NO'] . $_POST['LMI_SYS_TRANS_DATE'] . $_POST['LMI_SECRET_KEY'] . $_POST['LMI_PAYER_PURSE'] . $_POST['LMI_PAYER_WM'];
        if ($_POST['LMI_HASH'] == strtoupper(md5($str))) {
            $verified = true;
        }
        return $verified;        
    }
    
    function deposit() {       
        $approved = (int)getParamByName('auto_approve_new_transaction'); 
        transaction_log($this->txn_id);
        $credit_result = transaction_credit_primary($this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'], $this->product_id, 0, $this->country_id,  $this->add_info, $approved, false, $this->is_recurring);
        if (true == $credit_result[0]) {
            $mail_template_param = array(
                'TransactionAmount'=> moneytextformat($credit_result[2], $credit_result[3])
            );            
            sendAdminMailFromTemplate('admtransaction', $this->affiliater_id, $mail_template_param);
            $record_id = $credit_result[1];
            $return = 'Transaction is successfully added';
            if (1 == $approved) {
                sendUserMailFromTemplate('transaction', $this->affiliater_id, $mail_template_param);
                $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
                $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, 0);
                if (false == $credit_result[0]) $return .=  "\n".get_transaction_error($credit_result[1]);
            }            
        } else $return = get_transaction_error($credit_result[1]);       
        
        return $return;

    }
    
    
    function refund() {
     
    }
        
    function finish($str_status) {       
        parent::finish($str_status);        
        echo "OK\n" . $str_status;    
        exit();        
    }    
}

$WEBMONEY_Callback = new WEBMONEY_Callback();
$WEBMONEY_Callback->add_info = "LMI_PAYER_WM=$_POST[LMI_PAYER_WM]";
$return = $WEBMONEY_Callback->deposit();
$WEBMONEY_Callback->finish($return);

?>