<?php
// $Id: admin_aff_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');

//source data
$sum_sales_multicurrency = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 AND t1.txn_type IN (?, ?) GROUP BY t1.user_id, t1.orig_cur_index", false, array($transaction_types['credit_primary'], $transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$sum_sales = array();
$users_rs = $db->query("SELECT id, name FROM $param[dbprefix]users WHERE usertype=? AND approved=1", array($users_types['affiliater']));
$top_data = array();

if (0 != $users_rs->NumRows()) {

    while ($users_row = $users_rs->fetchRow(DB_FETCHMODE_ASSOC) ) {          
        $key_one = $users_row['id'];
        $key_two = $users_row['name'];
        $sum_sales[$key_one] = 0;
        //convert to default cyrrency
        if (isset($sum_sales_multicurrency[$key_one])) {
            $transactions =& $sum_sales_multicurrency[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $sum_sales[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            }
        }    
        //top date
        $top_data[$key_two] = $sum_sales[$key_one];                
    }
    
    arsort($top_data);
    
    $dataX = $dataY0 = array();
    $i=0;
    foreach ($top_data as $username => $ppc) {
        $dataX[] = $username;
        $dataY0[] = $ppc;
        if ($i>=12) break;
        $i++;    
    }

} else {
    $dataY0 = array(0);    
    $dataX = array('');    
}

// Create the graph. These two calls are always required
$graph = new Graph(600,220,'');
$graph->img->SetMargin(60,180,30,80);       

//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.35,"right","center");   

// Create the bar plots
$b0plot = new BarPlot($dataY0);
$b0plot->SetFillColor("orange");
$b0plot->SetLegend(getTranslateText('TT_SUM_SUMBOL') . getTranslateText('TT_FLAT_SALES'));  
   
$gbplot = new GroupBarPlot(array($b0plot));
$graph->Add($gbplot);

$graph->SetScale("textlin");
//title
$title = getTranslateText('TT_AFF_STATS');
$graph->title->Set($title);
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);
//x
if (count($dataX) > 5) $graph->xaxis->SetLabelAngle(90);
$graph->xaxis->SetTickLabels($dataX);    
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);
//y
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? ($currency['cur_symbol'] . ' - ' . $currency['cur_alpha3']) : $currency['cur_alpha3'];
$graph->yaxis->title->Set($currency_text);
$graph->yaxis->title->SetMargin(20); 
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();

?>