<?php
// $Id: admin_country_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');

//source data
$sum_sales_multicurrency = $db->getAssoc("SELECT t1.country_id, sum(t1.orig_amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['credit_primary']), DB_FETCHMODE_ASSOC, true);
$sum_sales_multicurrency_chargeback = $db->getAssoc("SELECT t1.country_id, ABS(sum(t1.orig_amount)) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$top_data0 = $top_data1 = array();
if (count($sum_sales_multicurrency) > 0) {
    //sales
    foreach ($sum_sales_multicurrency as $key_one => $transactions) {
        $top_data1[$key_one] = 0;
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            $top_data0[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
        }   
    }
    //chargeback
    foreach ($sum_sales_multicurrency_chargeback as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            $top_data1[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
        }   
    }
    //sort 
    arsort($top_data0);
    
    $dataX = $dataY0 = $dataY1 = array();
    $i=0;
    $country_keys = '0,' . implode(',', array_keys($top_data0));
    $countrylist = $db->getAssoc("SELECT cnumber, cname FROM $param[dbprefix]countries WHERE cnumber IN ($country_keys) AND (lang_id=?)", false, array(getLanguageId()), DB_FETCHMODE_ORDERED);       
    $undef_country_sales = $undef_country_chargback= 0;
    foreach ($top_data0 as $country_id => $v) {
   
        if (isset($countrylist[$country_id]) && (0 != $country_id)) {
            $dataX[] = $countrylist[$country_id];
            $dataY0[] = $v;
            $dataY1[] = $top_data1[$country_id];
            $i++;                
        } else {
            $undef_country_sales += $v;
            $undef_country_chargback += $top_data1[$country_id];
        }
        if ($i>=5) break;
    }

    if (($undef_country_sales != 0) || ($undef_country_chargback != 0)) {
        $dataX[] = $countrylist[0];
        $dataY0[] = $undef_country_sales;
        $dataY1[] = $undef_country_chargback;
    }

} else {
    
        $dataX  = array(''); 
        $dataY0 = $dataY1 = array(0);
    
}
    
// Create the graph. These two calls are always required
$graph = new Graph(600,220,'');
$graph->img->SetMargin(60,180,30,80);       

//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.35,"right","center");   

// Create the bar plots
$b0plot = new BarPlot($dataY0);
$b0plot->SetFillColor("orange");
$b0plot->SetLegend(getTranslateText('TT_FLAT_SALES'));  

$b1plot = new BarPlot($dataY1);
$b1plot->SetFillColor("red");
$b1plot->SetLegend(getTranslateText('REP_H_CHARGEBACK'));  

$gbplot = new GroupBarPlot(array($b0plot, $b1plot));
$graph->Add($gbplot);

$graph->SetScale("textlin");
//title
$title = getTranslateText('TT_COUNTRY_STATS');
$graph->title->Set($title);
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);

//x
//$graph->xaxis->SetLabelAngle(90);
$graph->xaxis->SetTickLabels($dataX);    
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);

//y
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? ($currency['cur_symbol'] . ' - ' . $currency['cur_alpha3']) : $currency['cur_alpha3'];
$graph->yaxis->title->Set($currency_text);
$graph->yaxis->title->SetMargin(20); 
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();

?>